/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.lra.tck.participant.nonjaxrs.valid;

import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.ParticipantStatus;
import org.eclipse.microprofile.lra.annotation.Status;
import org.eclipse.microprofile.lra.annotation.ws.rs.LRA;
import org.eclipse.microprofile.lra.tck.service.LRAMetricService;
import org.eclipse.microprofile.lra.tck.service.LRAMetricType;

@ApplicationScoped
@Path(value="valid-cs-participant1")
public class ValidLRACSParticipant {
    public static final String ROOT_PATH = "valid-cs-participant1";
    public static final String ENLIST_WITH_COMPLETE = "enlist-complete";
    public static final String ENLIST_WITH_COMPENSATE = "enlist-compensate";
    private int recoveryPasses;
    @Inject
    private LRAMetricService lraMetricService;

    @GET
    @Path(value="enlist-complete")
    @LRA(value=LRA.Type.REQUIRED)
    public Response enlistWithComplete(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.ok((Object)lraId).build();
    }

    @GET
    @Path(value="enlist-compensate")
    @LRA(value=LRA.Type.REQUIRED, cancelOn={Response.Status.INTERNAL_SERVER_ERROR})
    public Response enlistWithCompensate(@HeaderParam(value="Long-Running-Action") URI lraId) {
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)lraId).build();
    }

    @Compensate
    public CompletionStage<Void> compensate(URI lraId) {
        assert (lraId != null);
        return CompletableFuture.runAsync(() -> this.lraMetricService.incrementMetric(LRAMetricType.Compensated, lraId, ValidLRACSParticipant.class));
    }

    @Complete
    public CompletionStage<Response> complete(URI lraId) {
        assert (lraId != null);
        return CompletableFuture.supplyAsync(() -> {
            this.lraMetricService.incrementMetric(LRAMetricType.Completed, lraId, ValidLRACSParticipant.class);
            return Response.accepted().build();
        });
    }

    @Status
    public CompletionStage<ParticipantStatus> status(URI lraId) {
        assert (lraId != null);
        return CompletableFuture.supplyAsync(() -> {
            this.lraMetricService.incrementMetric(LRAMetricType.Status, lraId, ValidLRACSParticipant.class);
            return ParticipantStatus.Completed;
        });
    }

    @PUT
    @Path(value="/accept")
    @LRA(value=LRA.Type.REQUIRES_NEW)
    public Response acceptLRA(@QueryParam(value="recoveryCount") @DefaultValue(value="0") Integer recoveryPasses) {
        this.recoveryPasses = recoveryPasses;
        return Response.ok().build();
    }

    @GET
    @Path(value="/accept")
    public Response getAcceptLRA() {
        return Response.ok((Object)this.recoveryPasses).build();
    }
}

