/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmt.tcs.injector;

import java.io.IOException;
import java.io.InputStream;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.gmt.tcs.injector.ASMModelHandler;
import org.eclipse.gmt.tcs.injector.ModelHandler;
import org.eclipse.gmt.tcs.injector.wrappers.ParserWrapper;
import org.eclipse.m2m.atl.engine.injectors.Injector;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMEnumLiteral;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclType;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class TCSInjector
implements Injector {
    private static final int DEFAULT_TAB_SIZE = 8;
    private static final boolean debug = false;
    private static Map parameterTypes = new HashMap();
    private Object root = null;
    private Map hyperlinks = null;
    private Map locationByElement = new HashMap();
    private Object lastToken = null;
    ASMModel extent;
    private ASMModel problems;
    private List refSettings;
    boolean buildModel;
    private boolean setLocation;
    private ParserWrapper parserWrapper = null;
    private Context currentContext;
    private Map contextByElement;
    public boolean keepNL = false;
    public Object lastTokenAfterFirst = null;
    public boolean keepComments;
    public Stack previousElement = new Stack();
    public boolean lastWasCreation = true;
    public boolean lastWasExit = false;
    public Map supertypesMap = null;
    public ModelHandler modelHandler = new ASMModelHandler(this);

    static {
        parameterTypes.put("name", "String");
        parameterTypes.put("keepNL", "String");
        parameterTypes.put("tabSize", "String");
        parameterTypes.put("parserGenerator", "String");
        parameterTypes.put("hyperlinks", "Map");
        parameterTypes.put("locationByElement", "Map");
        parameterTypes.put("problems", "Model:Problem");
        parameterTypes.put("lexerClass", "Class");
        parameterTypes.put("parserClass", "Class");
    }

    private void debug(String msg) {
    }

    public Map getParameterTypes() {
        return parameterTypes;
    }

    public ASMModelElement inject(ASMModel target, InputStream source, Map params) throws IOException {
        String ts;
        String pg;
        int tabSize = 8;
        if ("true".equals(params.get("keepNL"))) {
            this.keepNL = true;
        }
        if ((pg = (String)params.get("parserGenerator")) != null) {
            try {
                this.parserWrapper = (ParserWrapper)Class.forName("org.eclipse.gmt.tcs.injector.wrappers." + pg + ".ParserWrapper", true, Thread.currentThread().getContextClassLoader()).newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            this.parserWrapper = new org.eclipse.gmt.tcs.injector.wrappers.antlr3.ParserWrapper();
        }
        this.parserWrapper.setInjector(this);
        this.hyperlinks = (Map)params.get("hyperlinks");
        Map lByE = (Map)params.get("locationByElement");
        if (lByE != null) {
            this.locationByElement = lByE;
        }
        if ((ts = (String)params.get("tabSize")) != null) {
            tabSize = Integer.parseInt(ts);
        }
        String name = (String)params.get("name");
        ASMModel problems = (ASMModel)params.get("problems");
        Class lexer_ = (Class)params.get("lexerClass");
        Class parser_ = (Class)params.get("parserClass");
        if (lexer_ == null || parser_ == null) {
            this.performImportation(null, target, source, name, problems, tabSize);
        } else {
            this.performImportation(null, target, source, name, lexer_, parser_, problems, tabSize);
        }
        return (ASMModelElement)this.root;
    }

    public String getPrefix() {
        return "ebnf2";
    }

    public String getFormatMMName() {
        return "EBNF";
    }

    public void performImportation(ASMModel format, ASMModel extent, InputStream in, String other) throws IOException {
        this.performImportation(format, extent, in, other, null);
    }

    public void performImportation(ASMModel format, ASMModel extent, InputStream in, String other, int tabSize) throws IOException {
        this.performImportation(format, extent, in, other, null, tabSize);
    }

    public void performImportation(ASMModel format, ASMModel extent, InputStream in, String other, ASMModel problems) throws IOException {
        this.performImportation(format, extent, in, other, problems, 8);
    }

    public void performImportation(ASMModel format, ASMModel extent, InputStream in, String other, ASMModel problems, int tabSize) throws IOException {
        String name = other.split("-")[0];
        try {
            Class lexer = this.parserWrapper.getLexerClass(name);
            Class parser = this.parserWrapper.getParserClass(name);
            this.performImportation(format, extent, in, other, lexer, parser, problems, tabSize);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void performImportation(ASMModel format, ASMModel extent, InputStream in, String other, Class lexer_, Class parser_) throws IOException {
        this.performImportation(format, extent, in, other, lexer_, parser_, null, 8);
    }

    public void performImportation(ASMModel format, ASMModel extent, InputStream in, String other, Class lexer_, Class parser_, ASMModel problems) throws IOException {
        this.performImportation(format, extent, in, other, lexer_, parser_, problems, 8);
    }

    public void performImportation(ASMModel format, ASMModel extent, InputStream in, String other, Class lexer_, Class parser_, ASMModel problems, int tabSize) throws IOException {
        this.performImportation(format, extent, in, other, lexer_, parser_, problems, tabSize, null);
    }

    public void performImportation(ASMModel format, ASMModel extent, InputStream in, String other, Class lexer_, Class parser_, ASMModel problems, int tabSize, Map hyperlinks) throws IOException {
        this.extent = extent;
        this.problems = problems;
        if (hyperlinks != null) {
            this.hyperlinks = hyperlinks;
        }
        this.refSettings = new ArrayList();
        this.buildModel = true;
        this.setLocation = true;
        this.keepComments = true;
        this.currentContext = new Context();
        this.contextByElement = new HashMap();
        try {
            String[] ss = other.split("-");
            String productionRule = "main";
            if (ss.length > 1) {
                productionRule = ss[1];
            }
            this.root = this.parserWrapper.parse(lexer_, parser_, tabSize, productionRule, in);
            Collections.sort(this.refSettings, new Comparator(){

                public int compare(Object o1, Object o2) {
                    RefSetting rs1 = (RefSetting)o1;
                    RefSetting rs2 = (RefSetting)o2;
                    if (rs1.importContext && !rs2.importContext) {
                        return -1;
                    }
                    if (rs2.importContext && !rs1.importContext) {
                        return 1;
                    }
                    return 0;
                }
            });
            Iterator i = this.refSettings.iterator();
            while (i.hasNext()) {
                RefSetting rs = (RefSetting)i.next();
                try {
                    rs.doIt();
                }
                catch (Exception e) {
                    System.out.println("Warning: one refSetting crashed:");
                    e.printStackTrace(System.out);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace(System.out);
        }
    }

    public ASMEnumLiteral createEnumLiteral(String name) {
        ASMEnumLiteral ret = new ASMEnumLiteral(name);
        return ret;
    }

    public Object create(String name, boolean context, boolean addToContext) {
        Object ret = null;
        this.debug("creating " + name);
        ret = this.modelHandler.createElement(name);
        if (addToContext) {
            this.currentContext.add(ret);
        }
        if (context) {
            this.currentContext = this.currentContext.enterContext(ret);
        }
        if (this.lastWasCreation) {
            this.previousElement.push(null);
        }
        this.lastWasCreation = true;
        this.lastWasExit = false;
        return ret;
    }

    public void leaveContext(boolean leave) {
        if (leave) {
            this.currentContext = this.currentContext.parent();
        }
    }

    public void addToContext(Object ame, boolean addToContext) {
        if (addToContext) {
            this.currentContext.add(ame);
        }
    }

    public void setLocation(Object ame, String location) {
        this.locationByElement.put(ame, location);
        if (this.setLocation) {
            try {
                this.modelHandler.actualSet(ame, "location", new ASMString(location));
            }
            catch (Exception e) {
                this.reportProblem("Warning", "could not set location of " + ame + ", disabling further location settings", location);
                this.setLocation = false;
            }
        }
    }

    public void setCommentsBefore(Object ame, Object token) {
        this.parserWrapper.setCommentsBefore(ame, token);
    }

    public void setCommentsAfter(Object ame, Object token) {
        this.parserWrapper.setCommentsAfter(ame, token);
    }

    public void set(Object ame, String prop, Object value) {
        this.modelHandler.set(ame, prop, value);
    }

    public void setRef(Object object, String propertyName, String valueTypeName, String keyName, Object keyValue, String lookIn, String autoCreate, String createAs, boolean importContext, String createIn) {
        if (keyValue == null) {
            return;
        }
        new RefSetting(this.currentContext, object, propertyName, valueTypeName, keyName, keyValue, lookIn, autoCreate, createAs, importContext, createIn, this.lastToken);
    }

    public void reportProblem(String severity, String msg, Object ame) {
        String location = "<unknown location>";
        if (this.locationByElement.containsKey(ame)) {
            location = (String)this.locationByElement.get(ame);
        }
        this.reportProblem(severity, msg, location);
    }

    public void reportProblem(String severity, String msg, String location) {
        if (this.problems == null) {
            System.err.println(String.valueOf(severity) + ": " + location + ": " + msg + ".");
        } else {
            ASMModelElement ame = this.problems.newModelElement("Problem");
            ame.set(null, "severity", (ASMOclAny)new ASMEnumLiteral(severity.toLowerCase()));
            ame.set(null, "location", (ASMOclAny)new ASMString(location));
            ame.set(null, "description", (ASMOclAny)new ASMString(msg));
        }
    }

    public void reportError(Exception re) {
        this.parserWrapper.reportError(re);
    }

    public void reportError(String msg) {
        this.reportProblem("Error", msg, "?");
    }

    public void reportWarning(String msg) {
        this.reportProblem("Warning", msg, "?");
    }

    public void setToken(Object token) {
        this.lastToken = token;
    }

    public String unescapeString(String s, int delimLength) {
        StringBuffer ret = new StringBuffer();
        s = s.substring(delimLength, s.length() - (delimLength * 2 - 1));
        StringCharacterIterator ci = new StringCharacterIterator(s);
        int c = ci.first();
        while (c != 65535) {
            int tc = 0;
            block0 : switch (c) {
                case 92: {
                    c = ci.next();
                    switch (c) {
                        case 110: {
                            tc = 10;
                            break block0;
                        }
                        case 114: {
                            tc = 13;
                            break block0;
                        }
                        case 116: {
                            tc = 9;
                            break block0;
                        }
                        case 98: {
                            tc = 8;
                            break block0;
                        }
                        case 102: {
                            tc = 12;
                            break block0;
                        }
                        case 34: {
                            tc = 34;
                            break block0;
                        }
                        case 39: {
                            tc = 39;
                            break block0;
                        }
                        case 92: {
                            tc = 92;
                            break block0;
                        }
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: {
                            throw new RuntimeException("octal escape sequences not supported yet");
                        }
                    }
                    tc = c;
                    break;
                }
                default: {
                    tc = c;
                }
            }
            ret.append((char)tc);
            c = ci.next();
        }
        return ret.toString();
    }

    private class Context {
        private Object element;
        private Context parent;
        private Set contents = new HashSet();
        private Set importedContexts = new HashSet();

        public Context enterContext(Object element) {
            Context ret = new Context(element, this);
            TCSInjector.this.contextByElement.put(element, ret);
            return ret;
        }

        public Context() {
            this.parent = null;
        }

        private Context(Object element, Context parent) {
            this.parent = parent;
            this.element = element;
        }

        public void add(Object e) {
            TCSInjector.this.debug("adding " + e + "to context");
            this.contents.add(e);
        }

        public ContextIterator iterator() {
            return new ContextIterator(this, this.contents.iterator(), this.importedContexts);
        }

        public ContextIterator iterator(Set traversed) {
            return new ContextIterator(traversed, this, this.contents.iterator(), this.importedContexts);
        }

        public Context parent() {
            return this.parent;
        }

        public void importContext(Context c) {
            this.importedContexts.add(c);
        }

        public Object getElement() {
            return this.element;
        }
    }

    private class ContextIterator
    implements Iterator {
        private Iterator i;
        private ContextIterator currentIterator = null;
        private Iterator importedContexts;
        private Set traversed;
        private boolean finishCurrent = false;

        public void finishCurrent() {
            this.finishCurrent = true;
            if (this.currentIterator != null) {
                this.currentIterator.finishCurrent();
            }
        }

        public ContextIterator(Context c, Iterator i, Set imported) {
            this(new HashSet(), c, i, imported);
        }

        public ContextIterator(Set traversed, Context c, Iterator i, Set imported) {
            this.traversed = traversed;
            traversed.add(c);
            this.i = i;
            this.importedContexts = imported.iterator();
        }

        public boolean hasNext() {
            while (this.importedContexts.hasNext() && !this.i.hasNext() && !this.finishCurrent) {
                Context c = (Context)this.importedContexts.next();
                if (!this.traversed.contains(c)) {
                    this.traversed.add(c);
                    this.currentIterator = c.iterator(this.traversed);
                    this.i = this.currentIterator;
                    continue;
                }
                System.out.println("ERROR: recursive contexts");
            }
            return this.i.hasNext();
        }

        public Object next() {
            return this.i.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class RefSetting {
        private Context currentContext;
        private ASMModelElement object;
        private String propertyName;
        private String valueTypeName;
        private String keyName;
        private Object keyValue;
        private String lookIn;
        private String autoCreate;
        private String createAs;
        private boolean importContext;
        private String createIn;
        private Object token;
        private Object realValue = null;

        public RefSetting(Context currentContext, Object object, String propertyName, String valueTypeName, String keyName, Object keyValue, String lookIn, String autoCreate, String createAs, boolean importContext, String createIn, Object token) {
            this.currentContext = currentContext;
            this.object = (ASMModelElement)object;
            this.propertyName = propertyName;
            this.valueTypeName = valueTypeName;
            this.keyName = keyName;
            this.keyValue = keyValue;
            this.lookIn = lookIn;
            this.autoCreate = autoCreate;
            this.createAs = createAs;
            this.importContext = importContext;
            this.createIn = createIn;
            this.token = token;
            TCSInjector.this.refSettings.add(this);
        }

        private boolean doItForContext(Context context) {
            boolean done = false;
            ASMString keyVal = new ASMString((String)this.keyValue);
            ContextIterator i = context.iterator();
            while (i.hasNext()) {
                ASMModelElement ame = (ASMModelElement)i.next();
                TCSInjector.this.debug("\t" + ame + " : " + ame.getType().getName());
                if (!this.isCandidate(ame) || !keyVal.equals(TCSInjector.this.modelHandler.get(ame, this.keyName))) continue;
                if (!done) {
                    this.realValue = ame;
                    TCSInjector.this.modelHandler.actualSet(this.object, this.propertyName, ame);
                    if (TCSInjector.this.hyperlinks != null) {
                        String location = TCSInjector.this.parserWrapper.getLocation(this.token);
                        TCSInjector.this.hyperlinks.put(location, TCSInjector.this.locationByElement.get(ame));
                    }
                    done = true;
                    i.finishCurrent();
                    continue;
                }
                TCSInjector.this.reportProblem("Error", "found several " + this.valueTypeName + " with the same " + this.keyName + " equals to " + keyVal, this.object);
                break;
            }
            if (!done && (context = context.parent()) != null) {
                done = this.doItForContext(context);
            }
            return done;
        }

        private boolean isCandidate(ASMModelElement ame) {
            boolean ret = false;
            ASMModelElement valueType = TCSInjector.this.extent.getMetamodel().findModelElement(this.valueTypeName);
            ret = ame.getType().conformsTo((ASMOclType)valueType).getSymbol();
            return ret;
        }

        private void create() {
            Object e;
            String[] path;
            Object ro = null;
            ro = this.createAs != null ? TCSInjector.this.modelHandler.createElement(this.createAs) : TCSInjector.this.modelHandler.createElement(this.valueTypeName);
            this.realValue = ro;
            Object realKeyValue = null;
            realKeyValue = this.keyValue instanceof String ? new ASMString((String)this.keyValue) : (ASMOclAny)this.keyValue;
            TCSInjector.this.modelHandler.actualSet(ro, this.keyName, realKeyValue);
            TCSInjector.this.modelHandler.actualSet(this.object, this.propertyName, ro);
            try {
                String location = TCSInjector.this.parserWrapper.getLocation(this.token);
                TCSInjector.this.setLocation(ro, location);
            }
            catch (Exception location) {
                // empty catch block
            }
            if (this.createIn != null) {
                path = this.createIn.split("\\.");
                Object e2 = this.navigateLookIn(path, false);
                if (e2 != null) {
                    TCSInjector.this.modelHandler.actualSet(e2, path[path.length - 1], ro);
                    this.currentContext.add(ro);
                }
            } else if (this.lookIn != null && !this.lookIn.equals("#all") && (e = this.navigateLookIn(path = this.lookIn.split("\\."), false)) != null) {
                TCSInjector.this.modelHandler.actualSet(e, path[path.length - 1], ro);
                this.currentContext.add(ro);
            }
        }

        private Object navigateLookIn(String[] path, boolean navigateLast) {
            Object ret = this.object;
            int i = 0;
            while (i < path.length - (navigateLast ? 0 : 1) && ret != null) {
                Object v;
                ret = path[i].equals("#context") ? this.currentContext.getElement() : ((v = TCSInjector.this.modelHandler.get(ret, path[i])) instanceof ASMModelElement ? (ASMModelElement)v : null);
                ++i;
            }
            return ret;
        }

        public void doIt() {
            Context context;
            boolean done = false;
            TCSInjector.this.debug("setRef(" + this.currentContext + ", " + this.object + ", " + this.propertyName + ", " + this.valueTypeName + ", " + this.keyName + ", " + this.keyValue + ", " + this.lookIn + ", " + this.autoCreate + ") : ");
            if (this.autoCreate.equals("always")) {
                this.create();
                done = true;
            } else {
                context = this.currentContext;
                if ("#all".equals(this.lookIn)) {
                    ASMModelElement val = null;
                    Iterator i = TCSInjector.this.modelHandler.getElementsByType(this.valueTypeName).iterator();
                    while (i.hasNext() && val == null) {
                        ASMModelElement ame = (ASMModelElement)i.next();
                        TCSInjector.this.debug("\t" + ame + " : " + ame.getType().getName());
                        if (!TCSInjector.this.modelHandler.get(ame, this.keyName).equals(new ASMString((String)this.keyValue))) continue;
                        val = ame;
                    }
                    if (val != null) {
                        this.realValue = val;
                        TCSInjector.this.modelHandler.actualSet(this.object, this.propertyName, val);
                        done = true;
                    }
                } else if (this.lookIn != null && !this.lookIn.equals("#all")) {
                    String[] path = this.lookIn.split("\\.");
                    Object e = this.navigateLookIn(path, true);
                    if (e != null) {
                        context = (Context)TCSInjector.this.contextByElement.get(e);
                        done = this.doItForContext(context);
                    }
                } else {
                    done = this.doItForContext(context);
                }
            }
            if (!done) {
                TCSInjector.this.debug("not found");
                if (!this.autoCreate.equals("never")) {
                    this.create();
                } else {
                    TCSInjector.this.reportProblem("Error", String.valueOf(this.valueTypeName) + " with " + this.keyName + " = " + this.keyValue + " was not found for " + this.propertyName + " of " + this.object.getType(), this.object);
                }
            }
            if (this.realValue != null) {
                context = (Context)TCSInjector.this.contextByElement.get(this.realValue);
                if (this.importContext && context != null) {
                    ((Context)TCSInjector.this.contextByElement.get(this.object)).importContext(context);
                }
            }
        }
    }
}

