/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.CharacterIterator;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.m2m.atl.engine.emfvm.ASMOperation;
import org.eclipse.m2m.atl.engine.emfvm.StackFrame;
import org.eclipse.m2m.atl.engine.emfvm.lib.ASMModule;
import org.eclipse.m2m.atl.engine.emfvm.lib.ExecEnv;
import org.eclipse.m2m.atl.engine.emfvm.lib.Extension;
import org.eclipse.m2m.atl.engine.emfvm.lib.ReferenceModel;

public class ASM {
    private String name;
    private List operations = new ArrayList();
    private List fields = new ArrayList();
    private ASMOperation mainOperation = null;

    public void setName(String name) {
        this.name = name;
    }

    public void addField(String name, String type) {
        this.fields.add(name);
    }

    public void addOperation(ASMOperation operation) {
        this.operations.add(operation);
        if (operation.getName().equals("main") && operation.getContext().equals("A")) {
            this.mainOperation = operation;
        }
    }

    public Object run(Map models, Map libraries, Map options) {
        String ext;
        Object ret = null;
        boolean printExecutionTime = "true".equals(options.get("printExecutionTime"));
        long startTime = System.currentTimeMillis();
        ExecEnv execEnv = new ExecEnv(models);
        if ("true".equals(options.get("step"))) {
            execEnv.step = true;
        }
        if ("true".equals(options.get("supportUML2Stereotypes"))) {
            execEnv.supportUML2Stereotypes = true;
        }
        if ((ext = (String)options.get("extensions")) != null) {
            ClassLoader cl = this.getClass().getClassLoader();
            String extraClasspath = (String)options.get("extraClasspath");
            if (extraClasspath != null) {
                String[] paths = extraClasspath.split(",");
                URL[] urls = new URL[paths.length];
                String userDir = (String)options.get("user.dir");
                if (userDir == null) {
                    userDir = System.getProperty("user.dir");
                }
                int i = 0;
                while (i < paths.length) {
                    try {
                        urls[i] = new File(userDir, paths[i]).toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException("error while loading extra classpath entry: \"" + paths[i] + "\"", e);
                    }
                    ++i;
                }
                cl = new URLClassLoader(urls, cl);
            }
            String[] extensions = ext.split(",");
            int i = 0;
            while (i < extensions.length) {
                try {
                    Extension extension = (Extension)cl.loadClass(extensions[i]).newInstance();
                    extension.apply(execEnv, options);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("error while loading extension class: \"" + extensions[i] + "\"", e);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException("error while instantiating extension class: \"" + extensions[i] + "\"", e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException("error while instantiating extension class: \"" + extensions[i] + "\"", e);
                }
                ++i;
            }
        }
        this.registerOperations(execEnv, this.operations);
        ASMModule asmModule = new ASMModule();
        StackFrame frame = new StackFrame(execEnv, asmModule, this.mainOperation);
        for (ASM library : libraries.values()) {
            this.registerOperations(execEnv, library.operations);
            if (library.mainOperation == null) continue;
            library.mainOperation.exec(new StackFrame(execEnv, asmModule, library.mainOperation));
        }
        ret = this.mainOperation.exec(frame);
        long endTime = System.currentTimeMillis();
        if (printExecutionTime) {
            System.out.println("Executed " + this.name + " in " + (double)(endTime - startTime) / 1000.0 + "s.");
        }
        if ("true".equals(options.get("showSummary"))) {
            System.out.println("Number of instructions executed: " + execEnv.nbExecutedBytecodes);
        }
        return ret;
    }

    public void registerOperations(ExecEnv execEnv, List operations) {
        for (ASMOperation op : operations) {
            String signature = op.getContext();
            if (signature.matches("^(Q|G|C|E|O|N).*$")) {
                System.out.println("Unsupported registration: " + signature);
                continue;
            }
            try {
                Object type = this.parseType(execEnv, new StringCharacterIterator(signature));
                execEnv.registerOperation(type, op, op.getName());
            }
            catch (SignatureParsingException spe) {
                spe.printStackTrace(System.out);
            }
        }
    }

    private String readUntil(CharacterIterator ci, char c) throws SignatureParsingException {
        StringBuffer ret = new StringBuffer();
        while (ci.current() != c) {
            ret.append(ci.current());
            ci.next();
        }
        this.read(ci, c);
        return ret.toString();
    }

    private void read(CharacterIterator ci, char c) throws SignatureParsingException {
        if (ci.current() != c) {
            throw new SignatureParsingException("Expected '" + c + "', found '" + ci.current() + "' at position " + ci.getIndex() + ".");
        }
        ci.next();
    }

    private Object parseType(ExecEnv execEnv, CharacterIterator ci) throws SignatureParsingException {
        Object ret = this.parseTypeInternal(execEnv, ci);
        if (ci.next() != '\uffff') {
            throw new SignatureParsingException("End of type signature expected at position " + ci.getIndex() + ".");
        }
        return ret;
    }

    private Object parseTypeInternal(ExecEnv execEnv, CharacterIterator ci) throws SignatureParsingException {
        EClass ret = null;
        switch (ci.current()) {
            case 'M': {
                ci.next();
                String mname = this.readUntil(ci, '!');
                String name = this.readUntil(ci, ';');
                ReferenceModel model = (ReferenceModel)execEnv.getModel(mname);
                if (model != null) {
                    EClass ec = model.getMetaElementByName(name);
                    if (ec == null) {
                        throw new SignatureParsingException("ERROR: could not find model element " + name + " from " + mname);
                    }
                    ret = ec;
                    break;
                }
                System.out.println("WARNING: could not find model " + mname + ".");
                break;
            }
            case 'A': {
                ret = ASMModule.class;
                ci.next();
                break;
            }
            case 'J': {
                ret = Object.class;
                ci.next();
                break;
            }
            case 'I': {
                ret = Integer.class;
                ci.next();
                break;
            }
            case 'B': {
                ret = Boolean.class;
                ci.next();
                break;
            }
            case 'S': {
                ret = String.class;
                ci.next();
                break;
            }
            case 'D': {
                ret = Double.class;
                ci.next();
                break;
            }
            case '\uffff': {
                throw new SignatureParsingException("End of type signature unexpected at position " + ci.getIndex() + ".");
            }
            default: {
                throw new SignatureParsingException("Unknown type code : " + ci.current() + ".");
            }
        }
        return ret;
    }

    private class SignatureParsingException
    extends Exception {
        private static final long serialVersionUID = 7488097967558841786L;

        public SignatureParsingException(String msg) {
            super(msg);
        }
    }
}

