/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.vm.adwp;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.m2m.atl.engine.vm.adwp.ADWP;
import org.eclipse.m2m.atl.engine.vm.adwp.ADWPCommand;
import org.eclipse.m2m.atl.engine.vm.adwp.ObjectReference;
import org.eclipse.m2m.atl.engine.vm.adwp.RemoteObjectReference;
import org.eclipse.m2m.atl.engine.vm.adwp.Value;

public class ADWPDebugger
extends ADWP {
    protected static Logger logger = Logger.getLogger("org.eclipse.m2m.atl");
    private int msgId = 1;
    private List nonAnswers = new ArrayList();
    private List answers = new ArrayList();

    public ADWPDebugger(InputStream in, OutputStream out) {
        super(in, out);
    }

    public void sendCommand(int cmd, List args) {
        this.realSendCommand(cmd, args);
    }

    private void realSendCommand(int cmd, List args) {
        try {
            this.out.writeByte(cmd);
            this.out.writeByte(this.msgId++);
            this.out.writeInt(args.size());
            Iterator i = args.iterator();
            while (i.hasNext()) {
                this.writeValue((Value)i.next());
            }
            this.out.flush();
            if (cmd == 13 || cmd == 14) {
                logger.info("sent : " + cmd + " - " + args);
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, ioe.getLocalizedMessage(), ioe);
        }
    }

    public ADWPCommand readMessage() {
        ADWPCommand ret = null;
        ret = this.getMessageFrom(this.nonAnswers);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ADWPCommand getMessageFrom(List list) {
        ADWPCommand ret = null;
        List list2 = list;
        synchronized (list2) {
            if (list.size() == 0) {
                try {
                    do {
                        list.wait();
                    } while (list.size() == 0);
                }
                catch (InterruptedException ie) {
                    logger.log(Level.SEVERE, ie.getLocalizedMessage(), ie);
                }
            }
        }
        ret = (ADWPCommand)list.remove(0);
        return ret;
    }

    public synchronized ADWPCommand requestMessage(int cmd, List args) {
        ADWPCommand ret = null;
        this.realSendCommand(cmd, args);
        ret = this.getMessageFrom(this.answers);
        return ret;
    }

    public synchronized Value request(int cmd, List args) {
        Value ret = null;
        ADWPCommand acmd = this.requestMessage(cmd, args);
        ret = (Value)acmd.getArgs().get(0);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        this.setName("ADWPDebugger receiver");
        try {
            while (true) lbl-1000:
            // 2 sources

            {
                msgs = null;
                msg = null;
                type = this.in.readByte() & 255;
                ack = this.in.readByte() & 255;
                length = this.in.readInt();
                switch (type) {
                    case 103: {
                        msg = new ADWPCommand(type, ack, Collections.EMPTY_LIST);
                        msgs = this.nonAnswers;
                        break;
                    }
                    case 101: {
                        msg = new ADWPCommand(type, ack, Arrays.asList(new Object[]{this.readValue()}));
                        msgs = this.answers;
                        break;
                    }
                    case 100: {
                        msg = new ADWPCommand(type, ack, Arrays.asList(new Object[]{this.readValue(), this.readValue(), this.readValue(), this.readValue(), this.readValue()}));
                        msgs = this.nonAnswers;
                        break;
                    }
                    case 102: {
                        args = new ArrayList<Value>();
                        i = 0;
                        while (i < length) {
                            args.add(this.readValue());
                            ++i;
                        }
                        msg = new ADWPCommand(type, ack, args);
                        msgs = this.answers;
                    }
                }
                var6_6 = msgs;
                synchronized (var6_6) {
                    msgs.add(msg);
                    msgs.notifyAll();
                    continue;
                }
                break;
            }
        }
        catch (IOException v1) {
            return;
        }
        {
            ** while (true)
        }
    }

    protected ObjectReference readObjectReference(int id) {
        return RemoteObjectReference.valueOf(this, id);
    }
}

