/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.preferences;

import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.MarginPainter;
import org.eclipse.jface.text.WhitespaceCharacterPainter;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.m2m.atl.adt.ui.AtlUIPlugin;
import org.eclipse.m2m.atl.adt.ui.editor.AtlEditor;
import org.eclipse.m2m.atl.adt.ui.editor.formatter.AtlCodeFormatter;
import org.eclipse.m2m.atl.adt.ui.preferences.ProfileManager;
import org.eclipse.m2m.atl.adt.ui.text.AtlSourceViewerConfiguration;
import org.eclipse.m2m.atl.adt.ui.text.AtlTextTools;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionDataSource;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlCompletionHelper;
import org.eclipse.m2m.atl.adt.ui.text.atl.AtlModelAnalyser;
import org.eclipse.m2m.atl.engine.parser.AtlSourceManager;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.texteditor.ITextEditor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlPreview
implements Observer {
    private Document document;
    private SourceViewer fSourceViewer;
    private AtlSourceViewerConfiguration fViewerConfiguration;
    private final IPreferenceStore fPreferenceStore;
    private final MarginPainter fMarginPainter;
    private AtlModelAnalyser modelAnalyser;
    private WhitespaceCharacterPainter fWhitespaceCharacterPainter;
    private Map<String, String> fWorkingValues;

    public AtlPreview(Map<String, String> workingValues, Composite parent) {
        AtlTextTools tools = AtlUIPlugin.getDefault().getTextTools();
        this.document = new Document();
        AtlEditor editor = new AtlEditor();
        this.fViewerConfiguration = new AtlSourceViewerConfiguration(tools, (ITextEditor)editor);
        this.fWorkingValues = workingValues;
        int styles = 68354;
        this.fSourceViewer = new SourceViewer(parent, null, null, false, styles);
        this.fSourceViewer.configure((SourceViewerConfiguration)this.fViewerConfiguration);
        this.fSourceViewer.setEditable(false);
        Cursor arrowCursor = this.fSourceViewer.getTextWidget().getDisplay().getSystemCursor(0);
        this.fSourceViewer.getTextWidget().setCursor(arrowCursor);
        this.fSourceViewer.getTextWidget().setCaret(null);
        this.fSourceViewer.getTextWidget().setFont(JFaceResources.getTextFont());
        this.fSourceViewer.setDocument((IDocument)this.document);
        this.fPreferenceStore = this.fViewerConfiguration.getPreferenceStore();
        this.fMarginPainter = new MarginPainter((ITextViewer)this.fSourceViewer);
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.fPreferenceStore, (String)"printMarginColor");
        this.fMarginPainter.setMarginRulerColor(tools.getColorManager().getColor(rgb));
        this.fSourceViewer.addPainter((IPainter)this.fMarginPainter);
    }

    public void setText(String text) {
        this.document.set(text);
        this.updateEditor();
    }

    public void updateEditor() {
        StyledText widget = (StyledText)this.fSourceViewer.getControl();
        int height = widget.getClientArea().height;
        int top0 = widget.getTopPixel();
        int totalPixels0 = this.getHeightOfAllLines(widget);
        int topPixelRange0 = totalPixels0 > height ? totalPixels0 - height : 0;
        widget.setRedraw(false);
        AtlSourceManager sourceManager = new AtlSourceManager();
        sourceManager.updateDataSource(this.document.get());
        this.modelAnalyser = new AtlModelAnalyser(new AtlCompletionHelper(this.document.get()), sourceManager.getModel(), 0, AtlCompletionDataSource.getATLFileContext(sourceManager));
        try {
            new AtlCodeFormatter().format((IDocument)this.document, this.fWorkingValues, this.modelAnalyser);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.fSourceViewer.setSelection(null);
        int totalPixels1 = this.getHeightOfAllLines(widget);
        int topPixelRange1 = totalPixels1 > height ? totalPixels1 - height : 0;
        int top1 = topPixelRange0 > 0 ? (int)((double)(topPixelRange1 * top0) / (double)topPixelRange0) : 0;
        widget.setTopPixel(top1);
        widget.setRedraw(true);
    }

    private int getHeightOfAllLines(StyledText styledText) {
        int height = 0;
        int lineCount = styledText.getLineCount();
        int i = 0;
        while (i < lineCount) {
            height += styledText.getLineHeight(styledText.getOffsetAtLine(i));
            ++i;
        }
        return height;
    }

    public Control getControl() {
        return this.fSourceViewer.getControl();
    }

    public void showInvisibleCharacters(boolean enable) {
        if (enable) {
            if (this.fWhitespaceCharacterPainter == null) {
                this.fWhitespaceCharacterPainter = new WhitespaceCharacterPainter((ITextViewer)this.fSourceViewer);
                this.fSourceViewer.addPainter((IPainter)this.fWhitespaceCharacterPainter);
            }
        } else {
            this.fSourceViewer.removePainter((IPainter)this.fWhitespaceCharacterPainter);
            this.fWhitespaceCharacterPainter = null;
        }
    }

    public boolean isShowInvisible() {
        return this.fWhitespaceCharacterPainter != null;
    }

    public Map<String, String> getWorkingValues() {
        return this.fWorkingValues;
    }

    public void setWorkingValues(Map<String, String> workingValues) {
        this.fWorkingValues = workingValues;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o instanceof ProfileManager) {
            ProfileManager manager = (ProfileManager)o;
            this.fWorkingValues = manager.getSelected().getSettings();
            this.updateEditor();
        }
    }
}

