/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt;

import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2m.atl.adt.AtlResourceVisitor;
import org.eclipse.m2m.atl.adt.Messages;
import org.eclipse.m2m.atl.common.ATLLogger;

public class AtlCleanVisitor
extends AtlResourceVisitor {
    private IProgressMonitor monitor;

    public AtlCleanVisitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public boolean visit(IResource resource) throws CoreException {
        boolean result = true;
        String extension = resource.getFileExtension();
        if ("atl".equals(extension) && resource instanceof IFile && ((IFile)resource).getLocation().toFile().length() > 0L && this.getBytecodeFile(resource).exists()) {
            this.monitor.subTask(Messages.getString("AtlCleanVisitor.CLEANTASK", new Object[]{resource.getName()}));
            result &= this.deleteFile(this.getAsmFile(resource));
            result &= this.deleteFile(this.getEmftvmFile(resource));
        }
        return result;
    }

    private boolean deleteFile(IFile file) {
        try {
            if (file.exists()) {
                file.delete(true, this.monitor);
            }
        }
        catch (CoreException ce) {
            ATLLogger.log((Level)Level.SEVERE, (String)ce.getLocalizedMessage(), (Throwable)ce);
            return false;
        }
        return true;
    }
}

