/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.handlers;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.EcoreResourceFactoryImpl;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.m2m.atl.adt.ui.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisterMetamodel
extends AbstractHandler {
    private Shell shell;

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection iss = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        this.shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IFile currentFile = (IFile)iss.getFirstElement();
        String artifactUri = currentFile.getLocation().toString();
        this.init(artifactUri);
        return null;
    }

    private Set<EObject> getElementsByType(Resource extent, String type) {
        HashSet<EObject> ret = new HashSet<EObject>();
        TreeIterator i = extent.getAllContents();
        while (i.hasNext()) {
            EObject eo = (EObject)i.next();
            if (!eo.eClass().getName().equals(type)) continue;
            ret.add(eo);
        }
        return ret;
    }

    private void init(String metamodelURL) {
        EcoreResourceFactoryImpl myEcoreFactory = new EcoreResourceFactoryImpl();
        Resource mmExtent = myEcoreFactory.createResource(URI.createURI((String)metamodelURL));
        try {
            mmExtent.load((InputStream)new FileInputStream(metamodelURL), Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            MessageDialog.openError((Shell)this.shell, (String)Messages.getString("RegisterMetamodel.REGISTER_FAIL"), (String)e.getMessage());
        }
        for (EPackage ePackage : this.getElementsByType(mmExtent, "EPackage")) {
            String nsURI = ePackage.getNsURI();
            if (nsURI == null) {
                nsURI = ePackage.getName();
                ePackage.setNsURI(nsURI);
            }
            EPackage.Registry.INSTANCE.put((Object)nsURI, (Object)ePackage);
        }
        for (EObject eObject : this.getElementsByType(mmExtent, "EDataType")) {
            EStructuralFeature sf = eObject.eClass().getEStructuralFeature("name");
            EStructuralFeature isf = eObject.eClass().getEStructuralFeature("instanceClassName");
            String tname = (String)eObject.eGet(sf);
            String icn = (String)eObject.eGet(isf);
            if (icn != null) continue;
            if (tname.equals("Boolean")) {
                icn = "boolean";
            } else if (tname.equals("Double") || tname.equals("Real")) {
                icn = "java.lang.Double";
            } else if (tname.equals("Float")) {
                icn = "java.lang.Float";
            } else if (tname.equals("Integer")) {
                icn = "java.lang.Integer";
            } else if (tname.equals("String")) {
                icn = "java.lang.String";
            }
            if (icn == null) continue;
            sf = eObject.eClass().getEStructuralFeature("instanceClassName");
            eObject.eSet(sf, (Object)icn);
        }
    }
}

