/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.util;

import java.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MethodSignature {
    private final String context;
    private final String name;
    private final String[] argumentTypes;
    private final boolean isStatic;

    public MethodSignature(Class<?> context, String name, Class<?>[] argumentTypes, boolean isStatic) {
        this.context = context.getName();
        this.name = name;
        if (argumentTypes != null) {
            this.argumentTypes = new String[argumentTypes.length];
            int i = 0;
            while (i < argumentTypes.length) {
                this.argumentTypes[i] = argumentTypes[i].getName();
                ++i;
            }
        } else {
            this.argumentTypes = null;
        }
        this.isStatic = isStatic;
    }

    public String getContext() {
        return this.context;
    }

    public String getName() {
        return this.name;
    }

    public String[] getArgumentTypes() {
        return this.argumentTypes;
    }

    public boolean isStatic() {
        return this.isStatic;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.context == null ? 0 : this.context.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.isStatic ? 1231 : 1237);
        result = 31 * result + Arrays.hashCode(this.argumentTypes);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MethodSignature other = (MethodSignature)obj;
        if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.isStatic != other.isStatic) {
            return false;
        }
        return Arrays.equals(this.argumentTypes, other.argumentTypes);
    }

    public String toString() {
        return "MethodSignature [context=" + this.context + ", name=" + this.name + ", argumentTypes=" + Arrays.toString(this.argumentTypes) + ", isStatic=" + this.isStatic + "]";
    }
}

