/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.ui.launch;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.m2m.atl.common.ATLExecutionException;
import org.eclipse.m2m.atl.common.ATLLogger;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.launch.ILauncher;
import org.eclipse.m2m.atl.core.service.CoreService;
import org.eclipse.m2m.atl.core.service.LauncherService;
import org.eclipse.m2m.atl.core.ui.ATLCoreUIPlugin;
import org.eclipse.m2m.atl.core.ui.Messages;
import org.eclipse.m2m.atl.debug.core.AtlDebugTarget;
import org.eclipse.m2m.atl.debug.core.AtlRunTarget;
import org.eclipse.m2m.atl.debug.core.AtlSourceLocator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtlLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    private static Map<String, IFile> moduleFilesByModuleName;
    private static final String[] PROFILER_VM_IDS;

    static {
        PROFILER_VM_IDS = new String[]{"EMF-specific VM Profiler", "Regular VM Profiler"};
    }

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        moduleFilesByModuleName = new HashMap<String, IFile>();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String launcherName = configuration.getAttribute("ATL VM", "");
        String atlCompiler = configuration.getAttribute("ATL_COMPILER", "");
        boolean isRefining = configuration.getAttribute("IS_REFINING", false);
        HashMap<String, Object> options = new HashMap<String, Object>();
        boolean isRefiningTraceMode = ("atl2006".equals(atlCompiler) || "atl2010".equals(atlCompiler)) && isRefining;
        options.put("isRefiningTraceMode", isRefiningTraceMode);
        options.put("launch", launch);
        options.put("monitor", monitor);
        String fileName = configuration.getAttribute("ATL File Name", "<null>");
        Map<String, String> unsortedSourceModels = configuration.getAttribute("Input", Collections.emptyMap());
        Map<String, String> unsortedTargetModels = configuration.getAttribute("Output", Collections.emptyMap());
        Map launchConfigModelPaths = configuration.getAttribute("Path", Collections.emptyMap());
        Map<String, String> modelPaths = AtlLaunchConfigurationDelegate.convertPaths(launchConfigModelPaths);
        Map libs = configuration.getAttribute("Libs", Collections.emptyMap());
        List superimps = configuration.getAttribute("Superimpose", Collections.emptyList());
        options.putAll(configuration.getAttribute("Options", Collections.emptyMap()));
        Map modelHandlers = configuration.getAttribute("Model Handler", Collections.emptyMap());
        options.put("modelHandlers", modelHandlers);
        if (LauncherService.getBooleanOption(options.get("OPTION_CLEAR"), (boolean)false)) {
            ATLCoreUIPlugin.clearConsole();
        }
        ILauncher launcher = null;
        try {
            this.showViewsForProfiler(launcherName);
            launcher = CoreService.getLauncher((String)launcherName);
        }
        catch (ATLCoreException e) {
            ATLLogger.log((Level)Level.SEVERE, (String)e.getMessage(), (Throwable)e);
        }
        if (launcher == null) {
            String[] registeredLaunchers = CoreService.getLaunchersNames();
            ATLLogger.severe((String)Messages.getString("AtlLaunchConfigurationDelegate.LAUNCHER_NOT_FOUND", launcherName, Arrays.asList(registeredLaunchers)));
            return;
        }
        IFile currentAtlFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getBytecodePath(fileName, launcher));
        String currentExtension = currentAtlFile.getFileExtension().toLowerCase();
        if (currentExtension.equals("atl")) {
            options.put("ATL_FILE", fileName);
            String currentAsmPath = String.valueOf(currentAtlFile.getFullPath().toString().substring(0, currentAtlFile.getFullPath().toString().length() - currentExtension.length())) + "asm";
            currentAtlFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(currentAsmPath));
        }
        if (!AtlLaunchConfigurationDelegate.addLaunchedModule(currentAtlFile)) {
            return;
        }
        InputStream asmInputStream = currentAtlFile.getContents();
        InputStream[] modules = new InputStream[superimps.size() + 1];
        modules[0] = asmInputStream;
        int i = 1;
        while (i < modules.length) {
            String moduleFileName = (String)superimps.get(i - 1);
            IFile moduleFile = ResourcesPlugin.getWorkspace().getRoot().getFile(this.getBytecodePath(moduleFileName, launcher));
            if (!AtlLaunchConfigurationDelegate.addLaunchedModule(moduleFile)) {
                return;
            }
            modules[i] = moduleFile.getContents();
            ++i;
        }
        HashMap<String, InputStream> libraries = new HashMap<String, InputStream>();
        for (String libName : libs.keySet()) {
            IFile libFile = ResourcesPlugin.getWorkspace().getRoot().getFile(Path.fromOSString((String)((String)libs.get(libName))));
            if (!AtlLaunchConfigurationDelegate.addLaunchedModule(libFile)) {
                return;
            }
            libraries.put(libName, libFile.getContents());
        }
        if (monitor.isCanceled()) {
            return;
        }
        Map<String, String> sourceModels = unsortedSourceModels;
        List orderedInput = configuration.getAttribute("OrderedInput", Collections.emptyList());
        if (!orderedInput.isEmpty()) {
            sourceModels = AtlLaunchConfigurationDelegate.sort(unsortedSourceModels, orderedInput);
        }
        Map<String, String> targetModels = unsortedTargetModels;
        List orderedOutput = configuration.getAttribute("OrderedOutput", Collections.emptyList());
        if (!orderedOutput.isEmpty()) {
            targetModels = AtlLaunchConfigurationDelegate.sort(unsortedTargetModels, orderedOutput);
        }
        if (isRefiningTraceMode) {
            Iterator<String> sourceIterator = sourceModels.keySet().iterator();
            Iterator<String> targetIterator = targetModels.keySet().iterator();
            HashMap<String, String> newTargetModels = new HashMap<String, String>();
            newTargetModels.putAll(targetModels);
            ArrayList<String> targetToRemove = new ArrayList<String>();
            block4: while (sourceIterator.hasNext()) {
                String sourceModelName = sourceIterator.next();
                String sourceMetamodelName = sourceModels.get(sourceModelName);
                while (targetIterator.hasNext()) {
                    String targetModelName = targetIterator.next();
                    String targetMetamodelName = targetModels.get(targetModelName);
                    if (!targetMetamodelName.equals(sourceMetamodelName) || targetToRemove.contains(targetModelName)) continue;
                    String targetModelPath = modelPaths.get(targetModelName);
                    String refinedModelPathName = LauncherService.getRefinedModelName((String)sourceModelName);
                    modelPaths.put(refinedModelPathName, targetModelPath);
                    targetToRemove.add(targetModelName);
                    continue block4;
                }
            }
            for (String key : targetToRemove) {
                newTargetModels.remove(key);
            }
            AtlLaunchConfigurationDelegate.launchOrDebug(mode, monitor, launcher, Collections.<String, String>emptyMap(), sourceModels, newTargetModels, modelPaths, options, libraries, launch, modules);
        } else {
            AtlLaunchConfigurationDelegate.launchOrDebug(mode, monitor, launcher, sourceModels, Collections.<String, String>emptyMap(), targetModels, modelPaths, options, libraries, launch, modules);
        }
        if (LauncherService.getBooleanOption(options.get("OPTION_DERIVED"), (boolean)false)) {
            for (String targetModel : targetModels.keySet()) {
                String path = (String)launchConfigModelPaths.get(targetModel);
                this.setDerived(path, monitor);
            }
        }
    }

    private IPath getBytecodePath(String fileName, ILauncher launcher) {
        if (launcher != null && launcher.getClass().getSimpleName().startsWith("EMFTVM")) {
            fileName = fileName.replaceAll("\\.(atl|asm)$", ".emftvm");
        }
        return Path.fromOSString((String)fileName);
    }

    /*
     * Loose catch block
     */
    private static Object launchOrDebug(String mode, final IProgressMonitor monitor, final ILauncher launcher, final Map<String, String> sourceModels, final Map<String, String> sourceTargetModels, final Map<String, String> targetModels, final Map<String, String> modelPaths, final Map<String, Object> options, final Map<String, InputStream> libraries, ILaunch launchParam, final InputStream ... modules) {
        String realMode;
        if (!Arrays.asList(launcher.getModes()).contains(mode)) {
            ATLLogger.info((String)Messages.getString("AtlLaunchConfigurationDelegate.UNSUPPORTED_MODE", mode, launcher.getName()));
            realMode = "run";
        } else {
            realMode = mode;
        }
        if (realMode.equals("debug")) {
            launchParam.setSourceLocator((ISourceLocator)new AtlSourceLocator());
            AtlDebugTarget mTarget = new AtlDebugTarget(launchParam);
            Thread th = new Thread(){

                public void run() {
                    try {
                        try {
                            LauncherService.launch((String)realMode, (IProgressMonitor)monitor, (ILauncher)launcher, (Map)sourceModels, (Map)sourceTargetModels, (Map)targetModels, (Map)modelPaths, (Map)options, (Map)libraries, (InputStream[])modules);
                        }
                        catch (ATLCoreException e) {
                            ATLLogger.severe((String)e.getMessage());
                            monitor.done();
                            return;
                        }
                        catch (ATLExecutionException e) {
                            ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                            monitor.done();
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            th.start();
            mTarget.setStopInMain(LauncherService.getBooleanOption((Object)options.get("stopInMain"), (boolean)false));
            mTarget.start();
            launchParam.addDebugTarget((IDebugTarget)mTarget);
        } else {
            launchParam.setSourceLocator((ISourceLocator)new AtlSourceLocator());
            AtlRunTarget mTarget = new AtlRunTarget(launchParam);
            launchParam.addDebugTarget((IDebugTarget)mTarget);
            try {
                try {
                    LauncherService.launch((String)realMode, (IProgressMonitor)monitor, (ILauncher)launcher, sourceModels, sourceTargetModels, targetModels, modelPaths, options, libraries, (InputStream[])modules);
                    mTarget.terminate();
                }
                catch (ATLCoreException e) {
                    ATLLogger.severe((String)e.getMessage());
                    monitor.done();
                    return null;
                }
                catch (DebugException e) {
                    ATLLogger.severe((String)e.getMessage());
                    monitor.done();
                    return null;
                }
                catch (ATLExecutionException e) {
                    ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
        }
        return null;
    }

    private static Map<String, String> sort(Map<String, String> mapToSort, List<String> orderedKeys) {
        LinkedHashMap<String, String> res = new LinkedHashMap<String, String>();
        for (String key : orderedKeys) {
            res.put(key, mapToSort.get(key));
        }
        return res;
    }

    private static boolean addLaunchedModule(IFile file) {
        if (!file.exists()) {
            ATLLogger.severe((String)Messages.getString("AtlLaunchConfigurationDelegate.FILE_NOT_EXIST", file.getFullPath()));
            return false;
        }
        IFile atlFile = file;
        String ext = atlFile.getFileExtension().toLowerCase();
        if (ext.equals("asm")) {
            String path = String.valueOf(atlFile.getFullPath().toString().substring(0, atlFile.getFullPath().toString().length() - ext.length())) + "atl";
            atlFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path));
        }
        if (atlFile.isAccessible()) {
            moduleFilesByModuleName.put(AtlLaunchConfigurationDelegate.computeModuleName(file), atlFile);
        }
        return true;
    }

    public static IFile getFileFromModuleName(String moduleName) {
        if (moduleFilesByModuleName != null) {
            return moduleFilesByModuleName.get(moduleName);
        }
        return null;
    }

    private static String computeModuleName(IFile file) {
        String res = file.getName();
        try {
            InputStreamReader streamReader = new InputStreamReader(file.getContents());
            BufferedReader buffer = new BufferedReader(streamReader);
            String line = "";
            while ((line = buffer.readLine()) != null) {
                if (!line.contains("<constant value=")) continue;
                res = line.split("\\\"")[1];
                buffer.close();
                streamReader.close();
                return res;
            }
            buffer.close();
            streamReader.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return res;
    }

    public static Map<String, String> convertPaths(Map<String, String> modelPaths) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String modelName : modelPaths.keySet()) {
            String modelPath = modelPaths.get(modelName);
            result.put(modelName, AtlLaunchConfigurationDelegate.convertPath(modelPath));
        }
        return result;
    }

    public static String convertPath(String path) {
        if (path.startsWith("ext:")) {
            return path.replaceFirst("ext:", "file:/");
        }
        if (path.startsWith("uri:")) {
            return path.substring(4);
        }
        if (path.startsWith("#") || path.startsWith("platform:") || path.startsWith("pathmap")) {
            return path;
        }
        return "platform:/resource" + path;
    }

    private void setDerived(String filePath, IProgressMonitor monitor) {
        if (Platform.isRunning()) {
            try {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(filePath));
                if (file.exists()) {
                    file.setDerived(true, monitor);
                }
            }
            catch (IllegalStateException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CoreException e) {
                ATLLogger.log((Level)Level.SEVERE, (String)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    private void showViewsForProfiler(String launcherName) {
        boolean isProfilerVm = false;
        String[] stringArray = PROFILER_VM_IDS;
        int n = PROFILER_VM_IDS.length;
        int n2 = 0;
        while (n2 < n) {
            String profilerVMId = stringArray[n2];
            if (launcherName.equals(profilerVMId)) {
                isProfilerVm = true;
            }
            ++n2;
        }
        if (!isProfilerVm) {
            return;
        }
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                String rulesViewId = "org.eclipse.m2m.atl.profiler.ui.profilingdatatable.ProfilingDataTableView";
                String executionViewId = "org.eclipse.m2m.atl.profiler.ui.executionviewer.view.ExecutionView";
                if (window != null) {
                    MessageDialog dialog;
                    int result;
                    if ((window.getActivePage().findView(rulesViewId) == null || window.getActivePage().findView(executionViewId) == null) && (result = (dialog = new MessageDialog(null, Messages.getString("AtlLaunchConfigurationDelegate.PROFILER_WINDOW_TITLE"), null, Messages.getString("AtlLaunchConfigurationDelegate.PROFILER_WINDOW_MSG"), 3, new String[]{Messages.getString("AtlLaunchConfigurationDelegate.PROFILER_WINDOW_YES"), Messages.getString("AtlLaunchConfigurationDelegate.PROFILER_WINDOW_NO")}, 0)).open()) == 1) {
                        return;
                    }
                    try {
                        if (window.getActivePage().findView(rulesViewId) == null) {
                            window.getActivePage().showView(rulesViewId);
                        }
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                    try {
                        if (window.getActivePage().findView(executionViewId) == null) {
                            window.getActivePage().showView(executionViewId);
                        }
                    }
                    catch (PartInitException partInitException) {
                        // empty catch block
                    }
                }
            }
        });
    }
}

