/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvti.analysis;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.CompilerProblem;
import org.eclipse.qvtd.compiler.CompilerStep;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.MappingProblem;
import org.eclipse.qvtd.compiler.internal.qvti.analysis.QVTimperativeDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.Transformation;
import org.eclipse.qvtd.pivot.qvtbase.utilities.StandardLibraryHelper;
import org.eclipse.qvtd.pivot.qvtimperative.DeclareStatement;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameter;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.NewStatement;
import org.eclipse.qvtd.pivot.qvtimperative.ObservableStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SetStatement;
import org.eclipse.qvtd.pivot.qvtimperative.Statement;
import org.eclipse.qvtd.pivot.qvtimperative.util.AbstractExtendingQVTimperativeVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class QVTiProductionConsumption
extends AbstractExtendingQVTimperativeVisitor<Object, Resource> {
    public static final @NonNull TracingOption SUMMARY = new TracingOption(CompilerConstants.PLUGIN_ID, "qvti/check/summary");
    protected final @NonNull EnvironmentFactory environmentFactory;
    protected final @NonNull CompilerStep compilerStep;
    protected final @NonNull QVTimperativeDomainUsageAnalysis domainUsageAnalysis;
    protected final @NonNull Map<@NonNull Property, @NonNull BasePropertyAnalysis> property2basePropertyAnalysis = new HashMap<Property, BasePropertyAnalysis>();
    protected final @NonNull CompleteModel completeModel;

    public QVTiProductionConsumption(@NonNull CompilerStep compilerStep, @NonNull Resource iResource) {
        super((Object)iResource);
        this.environmentFactory = compilerStep.getEnvironmentFactory();
        this.compilerStep = compilerStep;
        this.domainUsageAnalysis = new QVTimperativeDomainUsageAnalysis(this.environmentFactory);
        this.completeModel = this.environmentFactory.getCompleteModel();
    }

    public void analyze() {
        for (EObject eObject : new TreeIterable((Resource)this.context)) {
            if (!(eObject instanceof Visitable)) continue;
            ((Visitable)eObject).accept((Visitor)this);
        }
        StandardLibraryHelper standardLibraryHelper = new StandardLibraryHelper(this.environmentFactory.getStandardLibrary());
        Property oclContainerProperty = standardLibraryHelper.getOclContainerProperty();
        BasePropertyAnalysis oclContainerPropertyAnalysis = this.property2basePropertyAnalysis.get(oclContainerProperty);
        if (oclContainerPropertyAnalysis != null) {
            for (BasePropertyAnalysis basePropertyAnalysis : this.property2basePropertyAnalysis.values()) {
                Property baseOppositeProperty;
                if (basePropertyAnalysis == oclContainerPropertyAnalysis || (baseOppositeProperty = basePropertyAnalysis.baseProperty.getOpposite()) == null || !baseOppositeProperty.isIsComposite()) continue;
                oclContainerPropertyAnalysis.accumulate(basePropertyAnalysis);
            }
        }
        for (BasePropertyAnalysis basePropertyAnalysis : this.property2basePropertyAnalysis.values()) {
            basePropertyAnalysis.analyze();
        }
    }

    protected BasePropertyAnalysis getBasePropertyAnalysis(@NonNull Property property) {
        Property baseProperty = QVTscheduleUtil.getPrimaryProperty((Property)property);
        BasePropertyAnalysis basePropertyAnalysis = this.property2basePropertyAnalysis.get(baseProperty);
        if (basePropertyAnalysis == null) {
            basePropertyAnalysis = new BasePropertyAnalysis(baseProperty);
            this.property2basePropertyAnalysis.put(baseProperty, basePropertyAnalysis);
        }
        return basePropertyAnalysis;
    }

    protected @NonNull CompleteClass getCompleteClass(@NonNull Type type) {
        return this.completeModel.getCompleteClass(type);
    }

    protected @NonNull CompleteClass getCompleteClass(@NonNull TypedElement typedElement) {
        return this.getCompleteClass(QVTimperativeUtil.getType((TypedElement)typedElement));
    }

    public void validate() {
        ArrayList<@NonNull BasePropertyAnalysis> sortedBasePropertyAnalyses = new ArrayList<BasePropertyAnalysis>(this.property2basePropertyAnalysis.values());
        Collections.sort(sortedBasePropertyAnalyses, NameUtil.NAMEABLE_COMPARATOR);
        StringBuilder s = SUMMARY.isActive() ? new StringBuilder() : null;
        for (BasePropertyAnalysis basePropertyAnalysis : sortedBasePropertyAnalyses) {
            basePropertyAnalysis.validate(s);
        }
        if (s != null) {
            SUMMARY.println(s.toString());
        }
    }

    public @Nullable Object visiting(@NonNull Visitable visitable) {
        throw new UnsupportedOperationException("Unimplemented " + ((Object)((Object)this)).getClass().getName() + " for " + visitable.eClass().getName());
    }

    public @Nullable Object visitElement(@NonNull Element object) {
        return null;
    }

    public @Nullable Object visitGuardParameter(@NonNull GuardParameter guardParameter) {
        Property successProperty = guardParameter.getSuccessProperty();
        if (successProperty != null) {
            CompleteClass sourceClass = this.getCompleteClass((Type)QVTimperativeUtil.getOwningClass((Property)successProperty));
            CompleteClass targetClass = this.getCompleteClass((TypedElement)successProperty);
            BasePropertyAnalysis basePropertyAnalysis = this.getBasePropertyAnalysis(successProperty);
            basePropertyAnalysis.addProducer((NamedElement)guardParameter, sourceClass, successProperty, targetClass);
        }
        return null;
    }

    public @Nullable Object visitNavigationCallExp(@NonNull NavigationCallExp navigationCallExp) {
        Mapping mapping = QVTimperativeUtil.basicGetContainingMapping((EObject)navigationCallExp);
        if (mapping != null) {
            OCLExpression ownedSource = QVTimperativeUtil.getOwnedSource((CallExp)navigationCallExp);
            DomainUsage usage = this.domainUsageAnalysis.getUsage((Element)(navigationCallExp instanceof OppositePropertyCallExp ? navigationCallExp : ownedSource));
            if (!usage.isInput() && !usage.isPrimitive()) {
                Property getProperty = QVTimperativeUtil.getReferredProperty((NavigationCallExp)navigationCallExp);
                BasePropertyAnalysis basePropertyAnalysis = this.getBasePropertyAnalysis(getProperty);
                CompleteClass sourceClass = this.getCompleteClass((TypedElement)ownedSource);
                EObject eContainer = navigationCallExp.eContainer();
                CompleteClass targetClass = eContainer instanceof DeclareStatement ? this.getCompleteClass(QVTimperativeUtil.getType((TypedElement)((DeclareStatement)eContainer))) : this.getCompleteClass((TypedElement)navigationCallExp);
                if (getProperty.isIsMany()) {
                    targetClass = this.getCompleteClass(((CollectionType)targetClass.getPrimaryClass()).getElementType());
                }
                basePropertyAnalysis.addConsumer(navigationCallExp, sourceClass, getProperty, targetClass);
            }
        }
        return null;
    }

    public @Nullable Object visitNewStatement(@NonNull NewStatement newStatement) {
        return null;
    }

    public @Nullable Object visitSetStatement(@NonNull SetStatement setStatement) {
        Property setProperty = QVTimperativeUtil.getTargetProperty((SetStatement)setStatement);
        BasePropertyAnalysis basePropertyAnalysis = this.getBasePropertyAnalysis(setProperty);
        CompleteClass sourceClass = this.getCompleteClass((TypedElement)QVTimperativeUtil.getTargetVariable((SetStatement)setStatement));
        CompleteClass targetClass = this.getCompleteClass((TypedElement)QVTimperativeUtil.getOwnedExpression((SetStatement)setStatement));
        if (!setStatement.isIsPartial() && setProperty.isIsMany()) {
            targetClass = this.getCompleteClass(((CollectionType)targetClass.getPrimaryClass()).getElementType());
        }
        basePropertyAnalysis.addProducer((NamedElement)setStatement, sourceClass, setProperty, targetClass);
        return null;
    }

    public @Nullable Object visitTransformation(@NonNull Transformation transformation) {
        this.domainUsageAnalysis.analyzeTransformation(transformation);
        return null;
    }

    private class AccessAnalysis
    implements Nameable {
        protected final @NonNull CompleteClass sourceClass;
        protected final @NonNull Property property;
        protected final @NonNull CompleteClass targetClass;
        protected final @NonNull String name;
        private final @NonNull List<@NonNull NamedElement> producers = new ArrayList<NamedElement>();
        private final @NonNull List<@NonNull NavigationCallExp> consumers = new ArrayList<NavigationCallExp>();
        private @Nullable PassRange consumptionPassRange = null;
        private @Nullable PassRange productionPassRange = null;

        public AccessAnalysis(@NonNull QVTiProductionConsumption.BasePropertyAnalysis basePropertyAnalysis, @NonNull CompleteClass sourceClass, @NonNull Property property, CompleteClass targetClass) {
            this.sourceClass = sourceClass;
            this.property = property;
            this.targetClass = targetClass;
            StringBuilder s = new StringBuilder();
            s.append(sourceClass.getName());
            s.append("::");
            s.append(property.getName());
            s.append(" : ");
            s.append(targetClass.getName());
            this.name = s.toString();
        }

        public void addConsumer(@NonNull NavigationCallExp consumer) {
            assert (this.consumptionPassRange == null);
            this.consumers.add(consumer);
        }

        public void addProducer(@NonNull NamedElement producer) {
            assert (this.productionPassRange == null);
            this.producers.add(producer);
        }

        public @NonNull PassRange getConsumptionPassRange() {
            PassRange consumptionPassRange2 = this.consumptionPassRange;
            if (consumptionPassRange2 == null) {
                this.consumptionPassRange = consumptionPassRange2 = PassRange.create(this.consumers);
            }
            return consumptionPassRange2;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public @NonNull PassRange getProductionPassRange() {
            PassRange productionPassRange2 = this.productionPassRange;
            if (productionPassRange2 == null) {
                this.productionPassRange = productionPassRange2 = PassRange.create(this.producers);
            }
            return productionPassRange2;
        }

        public @NonNull String toString() {
            return this.name;
        }
    }

    private class BasePropertyAnalysis
    implements Nameable {
        protected final @NonNull Property baseProperty;
        protected final @NonNull String name;
        protected final @NonNull Map<@NonNull CompleteClass, @NonNull Map<@NonNull CompleteClass, @NonNull AccessAnalysis>> sourceClass2targetClass2accessAnalysis = new HashMap<CompleteClass, Map<CompleteClass, AccessAnalysis>>();
        protected final @NonNull Map<@NonNull Set<@NonNull AccessAnalysis>, @NonNull ConnectionAnalysis> producingAnalyses2connectionAnalysis = new HashMap<Set<AccessAnalysis>, ConnectionAnalysis>();
        protected final @NonNull Map<@NonNull AccessAnalysis, @Nullable List<@NonNull ConnectionAnalysis>> producingAnalysis2connectionAnalyses = new HashMap<AccessAnalysis, List<ConnectionAnalysis>>();
        protected final @NonNull Map<@NonNull AccessAnalysis, @Nullable ConnectionAnalysis> consumingAnalysis2connectionAnalysis = new HashMap<AccessAnalysis, ConnectionAnalysis>();

        public BasePropertyAnalysis(Property baseProperty) {
            this.baseProperty = baseProperty;
            StringBuilder s = new StringBuilder();
            s.append(baseProperty.getOwningClass().getName());
            s.append("::");
            s.append(baseProperty.getName());
            if (baseProperty.isIsMany()) {
                s.append("[*]");
            } else {
                s.append(baseProperty.isIsRequired() ? "[1]" : "[?]");
            }
            Property oppositeProperty = baseProperty.getOpposite();
            if (oppositeProperty != null) {
                s.append(" <=> ");
                s.append(oppositeProperty.getOwningClass().getName());
                s.append("::");
                s.append(oppositeProperty.getName());
                if (baseProperty.isIsMany()) {
                    s.append("[*]");
                } else {
                    s.append(oppositeProperty.isIsRequired() ? "[1]" : "[?]");
                }
            }
            this.name = s.toString();
            assert (baseProperty == QVTscheduleUtil.getPrimaryProperty((Property)baseProperty));
        }

        public void accumulate(@NonNull BasePropertyAnalysis basePropertyAnalysis) {
            for (AccessAnalysis producingAnalysis : basePropertyAnalysis.producingAnalysis2connectionAnalyses.keySet()) {
                for (NamedElement producer : producingAnalysis.producers) {
                    this.addProducer(producer, producingAnalysis.sourceClass, producingAnalysis.property, producingAnalysis.targetClass);
                }
            }
            for (AccessAnalysis consumingAnalysis : basePropertyAnalysis.consumingAnalysis2connectionAnalysis.keySet()) {
                for (NavigationCallExp consumer : consumingAnalysis.consumers) {
                    this.addConsumer(consumer, consumingAnalysis.sourceClass, consumingAnalysis.property, consumingAnalysis.targetClass);
                }
            }
        }

        public void addConsumer(@NonNull NavigationCallExp navigationCallExp, @NonNull CompleteClass sourceClass, @NonNull Property property, @NonNull CompleteClass targetClass) {
            AccessAnalysis accessAnalysis = this.getAccessAnalysis(sourceClass, property, targetClass);
            accessAnalysis.addConsumer(navigationCallExp);
            if (!this.consumingAnalysis2connectionAnalysis.containsKey(accessAnalysis)) {
                this.consumingAnalysis2connectionAnalysis.put(accessAnalysis, null);
            }
        }

        public void addProducer(@NonNull NamedElement producer, @NonNull CompleteClass sourceClass, @NonNull Property property, @NonNull CompleteClass targetClass) {
            AccessAnalysis accessAnalysis = this.getAccessAnalysis(sourceClass, property, targetClass);
            accessAnalysis.addProducer(producer);
            if (!this.producingAnalysis2connectionAnalyses.containsKey(accessAnalysis)) {
                this.producingAnalysis2connectionAnalyses.put(accessAnalysis, null);
            }
        }

        public void analyze() {
            for (AccessAnalysis consumingAnalysis : this.consumingAnalysis2connectionAnalysis.keySet()) {
                HashSet<@NonNull AccessAnalysis> conformingProducingAnalyses = null;
                for (AccessAnalysis producingAnalysis : this.producingAnalysis2connectionAnalyses.keySet()) {
                    if (!this.isConforming(producingAnalysis, consumingAnalysis)) continue;
                    if (conformingProducingAnalyses == null) {
                        conformingProducingAnalyses = new HashSet<AccessAnalysis>();
                    }
                    conformingProducingAnalyses.add(producingAnalysis);
                }
                if (conformingProducingAnalyses == null) continue;
                ConnectionAnalysis connectionAnalysis = this.getConnectionAnalysis(conformingProducingAnalyses);
                connectionAnalysis.addConsumingAnalysis(consumingAnalysis);
                this.consumingAnalysis2connectionAnalysis.put(consumingAnalysis, connectionAnalysis);
            }
        }

        public @NonNull AccessAnalysis getAccessAnalysis(@NonNull CompleteClass sourceClass, @NonNull Property property, @NonNull CompleteClass targetClass) {
            AccessAnalysis accessAnalysis;
            Map<@NonNull CompleteClass, @NonNull AccessAnalysis> targetClass2accessAnalysis = this.sourceClass2targetClass2accessAnalysis.get(sourceClass);
            if (targetClass2accessAnalysis == null) {
                targetClass2accessAnalysis = new HashMap<CompleteClass, AccessAnalysis>();
                this.sourceClass2targetClass2accessAnalysis.put(sourceClass, targetClass2accessAnalysis);
            }
            if ((accessAnalysis = targetClass2accessAnalysis.get(targetClass)) == null) {
                accessAnalysis = new AccessAnalysis(this, sourceClass, property, targetClass);
                targetClass2accessAnalysis.put(targetClass, accessAnalysis);
            }
            return accessAnalysis;
        }

        protected @NonNull ConnectionAnalysis getConnectionAnalysis(@NonNull Set<@NonNull AccessAnalysis> producingAnalyses) {
            ConnectionAnalysis connectionAnalysis = this.producingAnalyses2connectionAnalysis.get(producingAnalyses);
            if (connectionAnalysis == null) {
                connectionAnalysis = new ConnectionAnalysis(this, producingAnalyses);
                this.producingAnalyses2connectionAnalysis.put(producingAnalyses, connectionAnalysis);
                for (AccessAnalysis producingAnalysis : producingAnalyses) {
                    List<@NonNull ConnectionAnalysis> connectionAnalyses = this.producingAnalysis2connectionAnalyses.get(producingAnalysis);
                    if (connectionAnalyses == null) {
                        connectionAnalyses = new ArrayList<ConnectionAnalysis>();
                        this.producingAnalysis2connectionAnalyses.put(producingAnalysis, connectionAnalyses);
                    }
                    connectionAnalyses.add(connectionAnalysis);
                }
            }
            return connectionAnalysis;
        }

        public @NonNull String getName() {
            return this.name;
        }

        private @NonNull StringBuilder initProblem(@Nullable String prefix, @NonNull NamedElement element, @Nullable String suffix) {
            StringBuilder s = new StringBuilder();
            if (prefix != null) {
                s.append(prefix);
            }
            Mapping mapping = QVTimperativeUtil.getContainingMapping((EObject)element);
            s.append(mapping.getName());
            s.append(" ");
            s.append(PassRange.create((Element)mapping));
            s.append(" ");
            s.append(element);
            if (suffix != null) {
                s.append(suffix);
            }
            return s;
        }

        private boolean isConforming(@NonNull CompleteClass producingSourceClass, @NonNull Property producingProperty, @NonNull CompleteClass producingTargetClass, @NonNull CompleteClass consumingSourceClass, @NonNull Property consumingProperty, @NonNull CompleteClass consumingTargetClass) {
            boolean conformingTarget;
            boolean conformingSource = QVTscheduleUtil.conformsToClassOrBehavioralClass((CompleteClass)producingSourceClass, (CompleteClass)consumingSourceClass) || QVTscheduleUtil.conformsToClassOrBehavioralClass((CompleteClass)consumingSourceClass, (CompleteClass)producingSourceClass);
            boolean bl = conformingTarget = QVTscheduleUtil.conformsToClassOrBehavioralClass((CompleteClass)producingTargetClass, (CompleteClass)consumingTargetClass) || QVTscheduleUtil.conformsToClassOrBehavioralClass((CompleteClass)consumingTargetClass, (CompleteClass)producingTargetClass);
            return conformingSource && conformingTarget;
        }

        protected boolean isConforming(@NonNull AccessAnalysis producingAnalysis, @NonNull AccessAnalysis consumingAnalysis) {
            CompleteClass producingTargetClass;
            CompleteClass producingSourceClass;
            CompleteClass consumingTargetClass;
            CompleteClass consumingSourceClass;
            Property consumingProperty = consumingAnalysis.property;
            if (consumingProperty == this.baseProperty) {
                consumingSourceClass = consumingAnalysis.sourceClass;
                consumingTargetClass = consumingAnalysis.targetClass;
            } else {
                consumingSourceClass = consumingAnalysis.targetClass;
                consumingTargetClass = consumingAnalysis.sourceClass;
            }
            Property producingProperty = producingAnalysis.property;
            if (producingProperty == this.baseProperty) {
                producingSourceClass = producingAnalysis.sourceClass;
                producingTargetClass = producingAnalysis.targetClass;
            } else {
                producingSourceClass = producingAnalysis.targetClass;
                producingTargetClass = producingAnalysis.sourceClass;
            }
            return this.isConforming(producingSourceClass, producingProperty, producingTargetClass, consumingSourceClass, consumingProperty, consumingTargetClass);
        }

        private boolean isNotify(@NonNull NamedElement producer) {
            if (producer instanceof SetStatement) {
                return ((SetStatement)producer).isIsNotify();
            }
            return false;
        }

        private boolean isObserve(@NonNull NavigationCallExp callExp) {
            List observedProperties;
            Statement statement = QVTimperativeUtil.getContainingStatement((EObject)callExp);
            if (statement instanceof ObservableStatement && (observedProperties = ((ObservableStatement)statement).basicGetObservedProperties()) != null) {
                boolean contains1 = observedProperties.contains(this.baseProperty);
                boolean contains2 = observedProperties.contains(this.baseProperty.getOpposite());
                if (contains1) {
                    return true;
                }
                return contains2;
            }
            return false;
        }

        public @NonNull String toString() {
            return this.name;
        }

        public void validate(@Nullable StringBuilder s) {
            if (s != null) {
                s.append("\n  " + this.name);
                for (AccessAnalysis producingAnalysis : this.producingAnalysis2connectionAnalyses.keySet()) {
                    List<@NonNull ConnectionAnalysis> connectionAnalyses = this.producingAnalysis2connectionAnalyses.get(producingAnalysis);
                    if (connectionAnalyses != null) continue;
                    for (NamedElement producer : producingAnalysis.producers) {
                        Mapping mapping = QVTimperativeUtil.getContainingMapping((EObject)producer);
                        s.append("\n    unconnected " + mapping.getName() + " " + PassRange.create((Element)mapping) + " " + producer);
                    }
                }
                for (ConnectionAnalysis connectionAnalysis : this.producingAnalyses2connectionAnalysis.values()) {
                    boolean needsNotify = connectionAnalysis.needsNotify();
                    s.append("\n    connect produce " + connectionAnalysis.productionPassRange + " consume " + connectionAnalysis.consumptionPassRange + (needsNotify ? " needsNotify" : " not-needsNotify"));
                    for (AccessAnalysis producingAnalysis : connectionAnalysis.producingAnalyses) {
                        boolean needsNotify2 = false;
                        List<@NonNull ConnectionAnalysis> connectionAnalyses2 = this.producingAnalysis2connectionAnalyses.get(producingAnalysis);
                        assert (connectionAnalyses2 != null);
                        for (ConnectionAnalysis connectionAnalysis2 : connectionAnalyses2) {
                            if (!connectionAnalysis2.needsNotify()) continue;
                            needsNotify2 = true;
                        }
                        s.append("\n      produce " + producingAnalysis.name + " " + producingAnalysis.getProductionPassRange() + (needsNotify2 ? " needsNotify" : " not-needsNotify"));
                        for (NamedElement producer : producingAnalysis.producers) {
                            Mapping mapping = QVTimperativeUtil.getContainingMapping((EObject)producer);
                            s.append("\n        in " + mapping.getName() + " " + PassRange.create((Element)mapping) + " " + producer);
                        }
                    }
                    for (AccessAnalysis consumingAnalysis : connectionAnalysis.consumingAnalyses) {
                        boolean needsObserve = !connectionAnalysis.getProductionPassRange().precedes(consumingAnalysis.getConsumptionPassRange());
                        s.append("\n      consume " + consumingAnalysis.name + " " + consumingAnalysis.getConsumptionPassRange() + (needsObserve ? " needsObserve" : " not-needsObserve"));
                        for (NavigationCallExp consumer : consumingAnalysis.consumers) {
                            Mapping mapping = QVTimperativeUtil.getContainingMapping((EObject)consumer);
                            s.append("\n        in " + mapping.getName() + " " + PassRange.create((Element)mapping) + " " + consumer);
                        }
                    }
                }
            }
            ArrayList<@NonNull AccessAnalysis> producingAnalyses = new ArrayList<AccessAnalysis>(this.producingAnalysis2connectionAnalyses.keySet());
            Collections.sort(producingAnalyses, NameUtil.NAMEABLE_COMPARATOR);
            for (AccessAnalysis producingAnalysis : producingAnalyses) {
                this.validateNotifies(s, producingAnalysis);
            }
            ArrayList<@NonNull AccessAnalysis> consumingAnalyses = new ArrayList<AccessAnalysis>(this.consumingAnalysis2connectionAnalysis.keySet());
            Collections.sort(producingAnalyses, NameUtil.NAMEABLE_COMPARATOR);
            for (AccessAnalysis consumingAnalysis : consumingAnalyses) {
                this.validateObserves(s, consumingAnalysis);
            }
        }

        private void validateNotifies(@Nullable StringBuilder s, @NonNull AccessAnalysis producingAnalysis) {
            List<@NonNull ConnectionAnalysis> connectionAnalyses = this.producingAnalysis2connectionAnalyses.get(producingAnalysis);
            if (connectionAnalyses != null) {
                boolean needsNotify = false;
                for (ConnectionAnalysis connectionAnalysis : connectionAnalyses) {
                    if (!connectionAnalysis.needsNotify()) continue;
                    needsNotify = true;
                }
                for (NamedElement producer : producingAnalysis.producers) {
                    boolean isNotify;
                    if (producer instanceof GuardParameter || (isNotify = this.isNotify(producer)) == needsNotify) continue;
                    StringBuilder sProblem = this.initProblem("", producer, isNotify ? " should not be notified" : " should be notified");
                    Mapping mapping = QVTimperativeUtil.getContainingMapping((EObject)producer);
                    QVTiProductionConsumption.this.compilerStep.addProblem(new MappingProblem(CompilerProblem.Severity.WARNING, mapping, sProblem.toString()));
                    if (s == null) continue;
                    s.append("\n      BAD " + sProblem);
                }
            }
        }

        private void validateObserves(@Nullable StringBuilder s, @NonNull AccessAnalysis consumingAnalysis) {
            ConnectionAnalysis connectionAnalysis = this.consumingAnalysis2connectionAnalysis.get(consumingAnalysis);
            PassRange productionRange = connectionAnalysis != null ? connectionAnalysis.getProductionPassRange() : null;
            for (NavigationCallExp consumer : consumingAnalysis.consumers) {
                if (productionRange == null) {
                    StringBuilder sProblem = this.initProblem("", (NamedElement)consumer, " is not produced");
                    Mapping mapping = QVTimperativeUtil.getContainingMapping((EObject)consumer);
                    QVTiProductionConsumption.this.compilerStep.addProblem(new MappingProblem(CompilerProblem.Severity.WARNING, mapping, sProblem.toString()));
                    if (s == null) continue;
                    s.append("\n      BAD " + sProblem);
                    continue;
                }
                PassRange consumerPassRange = PassRange.create((Element)consumer);
                boolean needsObserve = !productionRange.precedes(consumerPassRange);
                boolean isObserve = this.isObserve(consumer);
                if (isObserve == needsObserve) continue;
                StringBuilder sProblem = this.initProblem("", (NamedElement)consumer, isObserve ? " should not be observed" : " should be observed");
                Mapping mapping = QVTimperativeUtil.getContainingMapping((EObject)consumer);
                QVTiProductionConsumption.this.compilerStep.addProblem(new MappingProblem(CompilerProblem.Severity.WARNING, mapping, sProblem.toString()));
                if (s == null) continue;
                s.append("\n      BAD " + sProblem);
            }
        }
    }

    private class ConnectionAnalysis {
        protected final @NonNull BasePropertyAnalysis basePropertyAnalysis;
        protected final @NonNull Set<@NonNull AccessAnalysis> producingAnalyses;
        protected final @NonNull PassRange productionPassRange;
        protected final @NonNull List<@NonNull AccessAnalysis> consumingAnalyses = new ArrayList<AccessAnalysis>();
        private @NonNull PassRange consumptionPassRange = new PassRange();

        public ConnectionAnalysis(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NonNull QVTiProductionConsumption. @NonNull BasePropertyAnalysis basePropertyAnalysis, Set<AccessAnalysis> producingAnalyses) {
            this.basePropertyAnalysis = basePropertyAnalysis;
            this.producingAnalyses = producingAnalyses;
            PassRange productionPassRange = new PassRange();
            for (AccessAnalysis producingAnalysis : producingAnalyses) {
                productionPassRange = productionPassRange.max(producingAnalysis.getProductionPassRange());
            }
            this.productionPassRange = productionPassRange;
        }

        public @NonNull PassRange getProductionPassRange() {
            return this.productionPassRange;
        }

        public void addConsumingAnalysis(@NonNull AccessAnalysis consumingAnalysis) {
            assert (!this.consumingAnalyses.contains(consumingAnalysis));
            this.consumingAnalyses.add(consumingAnalysis);
            this.consumptionPassRange = this.consumptionPassRange.max(consumingAnalysis.getConsumptionPassRange());
        }

        public boolean needsNotify() {
            return !this.productionPassRange.precedes(this.consumptionPassRange);
        }

        public @NonNull String toString() {
            return String.valueOf(this.basePropertyAnalysis.toString()) + " " + this.productionPassRange + " " + this.consumptionPassRange;
        }
    }

    private static class PassRange {
        private final int first;
        private final int last;

        public static @NonNull PassRange create(@NonNull Element element) {
            Mapping mapping = QVTimperativeUtil.getContainingMapping((EObject)element);
            int firstPass = mapping.getFirstPass();
            Integer lastPass = mapping.getLastPass();
            return new PassRange(firstPass, lastPass == null ? firstPass : lastPass);
        }

        public static @NonNull PassRange create(@NonNull List<? extends @NonNull Element> elements) {
            PassRange passRange = new PassRange();
            for (Element element : elements) {
                passRange = PassRange.create(element).max(passRange);
            }
            return passRange;
        }

        public PassRange() {
            this(Integer.MAX_VALUE, Integer.MIN_VALUE);
        }

        public PassRange(int first, int last) {
            this.first = first;
            this.last = last;
        }

        public boolean equals(Object obj) {
            PassRange that = (PassRange)obj;
            return this.first == that.first && this.last == that.last;
        }

        public int hashCode() {
            return this.first * 7 + this.last * 97;
        }

        public @NonNull PassRange max(@NonNull PassRange passRange) {
            if (this.equals(passRange)) {
                return this;
            }
            return new PassRange(Math.min(this.first, passRange.first), Math.max(this.last, passRange.last));
        }

        public boolean precedes(@NonNull PassRange passRange) {
            return this.last < passRange.first;
        }

        public @NonNull String toString() {
            return this.first <= this.last ? "[" + this.first + ".." + this.last + "]" : "[]";
        }
    }
}

