/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.HeadNodeGroup;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Element2MiddleProperty;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.RuleAnalysis2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.OverrideableVariableDeclaration2TraceProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2InheritedProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2ResultProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2SuccessProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationAnalysis2TraceGroup;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.RelationalTransformationAnalysis2TracePackage;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.VariableDeclaration2TraceProperty;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.Domain;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.RelationDomain;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;

abstract class AbstractRelationAnalysis2MiddleType
implements RelationAnalysis2MiddleType {
    protected final @NonNull RelationAnalysis2TraceGroup relationAnalysis2traceGroup;
    protected final @NonNull RelationAnalysis relationAnalysis;
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull RelationalTransformationAnalysis2TracePackage transformationAnalysis2tracePackage;
    protected final @NonNull Relation relation;
    protected final @NonNull Class middleClass;
    private @Nullable Class bagOfMiddleClass = null;
    private final @NonNull Map<@NonNull VariableDeclaration, @NonNull VariableDeclaration2TraceProperty> variable2variableDeclaration2traceProperty = new HashMap<VariableDeclaration, VariableDeclaration2TraceProperty>();
    private @Nullable Element2MiddleProperty relation2globalSuccessProperty = null;
    private @Nullable Element2MiddleProperty relation2localSuccessProperty = null;
    private @Nullable Relation2ResultProperty relation2resultProperty = null;

    protected AbstractRelationAnalysis2MiddleType(@NonNull RelationAnalysis2TraceGroup relationAnalysis2traceGroup, @NonNull String middleClassName) {
        this.relationAnalysis2traceGroup = relationAnalysis2traceGroup;
        this.relationAnalysis = relationAnalysis2traceGroup.getRuleAnalysis();
        this.scheduleManager = this.relationAnalysis.getScheduleManager();
        this.transformationAnalysis2tracePackage = this.relationAnalysis.getTransformationAnalysis2TracePackage();
        this.relation = this.relationAnalysis.getRule();
        this.middleClass = this.transformationAnalysis2tracePackage.createClass(this, middleClassName);
    }

    @Override
    public void analyzeTraceElements(@NonNull List<@NonNull HeadNodeGroup> headNodeGroups) throws CompilerChainException {
    }

    protected void analyzeRootTemplateVariables(@NonNull List<@NonNull HeadNodeGroup> headNodeGroups) {
        boolean manyTracesPerHead = headNodeGroups.size() > 2;
        for (Domain domain : QVTbaseUtil.getOwnedDomains((Rule)this.relation)) {
            TypedModel typedModel = QVTbaseUtil.getTypedModel((Domain)domain);
            for (VariableDeclaration rootVariable : QVTrelationUtil.getRootVariables((RelationDomain)((RelationDomain)domain))) {
                this.createRootVariableDeclaration2TraceProperty(typedModel, rootVariable, manyTracesPerHead);
            }
        }
    }

    @Override
    public @Nullable Element2MiddleProperty basicGetRelation2GlobalSuccessProperty() {
        return this.relation2globalSuccessProperty;
    }

    @Override
    public @Nullable Element2MiddleProperty basicGetRelation2LocalSuccessProperty() {
        return this.relation2localSuccessProperty;
    }

    @Override
    public @Nullable Relation2ResultProperty basicGetRelation2ResultProperty() {
        return this.relation2resultProperty;
    }

    @Override
    public @Nullable Property basicGetTraceProperty(@NonNull VariableDeclaration rVariable) {
        VariableDeclaration2TraceProperty variableDeclaration2traceProperty = this.basicGetVariableDeclaration2TraceProperty(rVariable);
        if (variableDeclaration2traceProperty == null) {
            return null;
        }
        return variableDeclaration2traceProperty.getTraceProperty();
    }

    @Override
    public @Nullable VariableDeclaration2TraceProperty basicGetVariableDeclaration2TraceProperty(@NonNull VariableDeclaration variable) {
        return this.variable2variableDeclaration2traceProperty.get(variable);
    }

    @Override
    public int compareTo(@NonNull RuleAnalysis2MiddleType that) {
        return ClassUtil.safeCompareTo((Comparable)((Object)this.middleClass.getName()), (Comparable)((Object)that.getMiddleClass().getName()));
    }

    public void createRelation2ResultProperty(@NonNull String nameHint) {
        assert (this.relation2resultProperty == null);
        this.relation2resultProperty = new Relation2ResultProperty(this, nameHint, this.getRuleAnalysis2TraceGroup().getTraceInterface());
    }

    public @NonNull Element2MiddleProperty createRelation2GlobalSuccessProperty(@NonNull String nameHint) {
        assert (this.relation2globalSuccessProperty == null);
        this.relation2globalSuccessProperty = new Relation2SuccessProperty(this, nameHint);
        return this.relation2globalSuccessProperty;
    }

    public @NonNull Element2MiddleProperty createRelation2GlobalSuccessProperty(@NonNull Property property) {
        assert (this.relation2globalSuccessProperty == null);
        this.relation2globalSuccessProperty = new Relation2InheritedProperty(this, property);
        return this.relation2globalSuccessProperty;
    }

    public @NonNull Element2MiddleProperty createRelation2LocalSuccessProperty(@NonNull String nameHint) {
        assert (this.relation2localSuccessProperty == null);
        this.relation2localSuccessProperty = new Relation2SuccessProperty(this, nameHint);
        return this.relation2localSuccessProperty;
    }

    public @NonNull Element2MiddleProperty createRelation2LocalSuccessProperty(@NonNull Property property) {
        assert (this.relation2localSuccessProperty == null);
        this.relation2localSuccessProperty = new Relation2InheritedProperty(this, property);
        return this.relation2localSuccessProperty;
    }

    @Override
    public void createRootVariableDeclaration2TraceProperty(@NonNull TypedModel typedModel, @NonNull VariableDeclaration variable, boolean manyTraces) {
        this.createVariableDeclaration2TraceProperty(typedModel, variable, !manyTraces);
    }

    protected abstract @NonNull String createTracePropertyName(@NonNull TypedModel var1, @NonNull VariableDeclaration var2);

    protected @NonNull VariableDeclaration2TraceProperty createVariableDeclaration2TraceProperty(@NonNull TypedModel typedModel, @NonNull VariableDeclaration variable, boolean unitOpposite) {
        String nameHint = this.createTracePropertyName(typedModel, variable);
        OverrideableVariableDeclaration2TraceProperty variableDeclaration2TraceProperty = new OverrideableVariableDeclaration2TraceProperty(this, nameHint, typedModel, variable, unitOpposite);
        VariableDeclaration2TraceProperty oldVariableDeclaration2TraceProperty = this.variable2variableDeclaration2traceProperty.put(variable, variableDeclaration2TraceProperty);
        assert (oldVariableDeclaration2TraceProperty == null);
        return variableDeclaration2TraceProperty;
    }

    @Override
    public @NonNull Class getBagOfMiddleClass() {
        Class bagOfMiddleClass2 = this.bagOfMiddleClass;
        if (bagOfMiddleClass2 == null) {
            this.bagOfMiddleClass = bagOfMiddleClass2 = this.transformationAnalysis2tracePackage.getBagType(this.middleClass);
        }
        return bagOfMiddleClass2;
    }

    @Override
    public @NonNull Property getGlobalSuccessProperty() {
        return ((Element2MiddleProperty)ClassUtil.nonNullState((Object)this.basicGetRelation2GlobalSuccessProperty())).getTraceProperty();
    }

    @Override
    public @NonNull Class getMiddleClass() {
        return this.middleClass;
    }

    @Override
    public @NonNull String getName() {
        return QVTrelationUtil.getName((NamedElement)this.relation);
    }

    public @NonNull Relation2ResultProperty getRelation2ResultProperty() {
        return (Relation2ResultProperty)ClassUtil.nonNullState((Object)this.relation2resultProperty);
    }

    public @NonNull Element2MiddleProperty getRelation2GlobalSuccessProperty() {
        return (Element2MiddleProperty)ClassUtil.nonNullState((Object)this.relation2globalSuccessProperty);
    }

    public @NonNull Element2MiddleProperty getRelation2LocalSuccessProperty() {
        return (Element2MiddleProperty)ClassUtil.nonNullState((Object)this.relation2localSuccessProperty);
    }

    @Override
    public @NonNull Property getResultProperty() {
        return ((Relation2ResultProperty)ClassUtil.nonNullState((Object)this.relation2resultProperty)).getTraceProperty();
    }

    @Override
    public @NonNull Relation getRule() {
        return this.relation;
    }

    public @NonNull RelationAnalysis2MiddleType getRule2TraceInterface() {
        return this;
    }

    @Override
    public @NonNull RelationAnalysis getRuleAnalysis() {
        return this.relationAnalysis;
    }

    @Override
    public @NonNull RelationAnalysis2TraceGroup getRuleAnalysis2TraceGroup() {
        return this.relationAnalysis2traceGroup;
    }

    @Override
    public @NonNull Property getTraceProperty(@NonNull VariableDeclaration rVariable) {
        VariableDeclaration2TraceProperty variableDeclaration2traceProperty = this.getVariableDeclaration2TraceProperty(rVariable);
        return variableDeclaration2traceProperty.getTraceProperty();
    }

    @Override
    public @NonNull RelationalTransformationAnalysis2TracePackage getTransformation2TracePackage() {
        return this.transformationAnalysis2tracePackage;
    }

    public @NonNull TypedModel getTraceTypedModel() {
        return this.scheduleManager.getTraceTypedModel();
    }

    public @NonNull Iterable<@NonNull VariableDeclaration2TraceProperty> getVariableDeclaration2TraceProperties() {
        return this.variable2variableDeclaration2traceProperty.values();
    }

    @Override
    public final @NonNull VariableDeclaration2TraceProperty getVariableDeclaration2TraceProperty(@NonNull VariableDeclaration variable) {
        VariableDeclaration2TraceProperty variableDeclaration2TraceProperty = this.basicGetVariableDeclaration2TraceProperty(variable);
        return (VariableDeclaration2TraceProperty)ClassUtil.nonNullState((Object)variableDeclaration2TraceProperty);
    }

    @Override
    public void synthesizeTraceModel() {
        if (this.relation2localSuccessProperty != null) {
            this.relation2localSuccessProperty.getTraceProperty();
        }
        if (this.relation2globalSuccessProperty != null) {
            this.relation2globalSuccessProperty.getTraceProperty();
        }
        if (this.relation2resultProperty != null) {
            this.relation2resultProperty.getTraceProperty();
        }
        for (VariableDeclaration2TraceProperty variableDeclaration2traceProperty : this.variable2variableDeclaration2traceProperty.values()) {
            Property property = variableDeclaration2traceProperty.synthesizeTraceModel();
        }
        CompilerUtil.normalizeNameables(QVTrelationUtil.Internal.getOwnedPropertiesList((Class)this.middleClass));
    }

    public @NonNull String toString() {
        return String.valueOf(this.middleClass.getName());
    }
}

