/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.debug.ui;

import java.net.URL;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.qvtd.runtime.utilities.QVTruntimeUtil;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class QVTdDebugUIPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.qvtd.debug.ui";
    public static final String DEBUG_EDITOR_ID = "org.eclipse.qvtd.xtext.qvtimperative.QVTimperative";
    private static QVTdDebugUIPlugin plugin;
    private static final Logger logger;
    protected ImageRegistry imageDescriptorRegistry;

    static {
        logger = Logger.getLogger(QVTdDebugUIPlugin.class);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        if (this.imageDescriptorRegistry != null) {
            this.imageDescriptorRegistry.dispose();
            this.imageDescriptorRegistry = null;
        }
        super.stop(context);
    }

    public static QVTdDebugUIPlugin getDefault() {
        return plugin;
    }

    public Image createImage(String path) {
        Image image = this.getImageRegistry().get(path);
        if (image == null) {
            try {
                ImageDescriptor imageDescriptor = this.getImageDescriptor(path);
                if (imageDescriptor != null && (image = this.getImageDescriptor(path).createImage()) != null) {
                    this.getImageRegistry().put(path, image);
                }
            }
            catch (Exception e) {
                logger.error((Object)("Failed to createImage '" + path + "'"), (Throwable)e);
            }
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String path) {
        URL url;
        ImageDescriptor imageDescriptor = this.getImageDescriptorRegistry().getDescriptor(path);
        if (imageDescriptor == null && (url = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path(path), Collections.emptyMap())) != null && (imageDescriptor = ImageDescriptor.createFromURL((URL)url)) != null) {
            this.getImageDescriptorRegistry().put(path, imageDescriptor);
        }
        return imageDescriptor;
    }

    protected ImageRegistry getImageDescriptorRegistry() {
        if (this.imageDescriptorRegistry == null) {
            this.imageDescriptorRegistry = this.createImageRegistry();
        }
        return this.imageDescriptorRegistry;
    }

    public static BasicDiagnostic createDiagnostic(String message) {
        return new BasicDiagnostic(0, PLUGIN_ID, 0, message, null);
    }

    public static Diagnostic createErrorDiagnostic(String message, Throwable throwable) {
        Object[] objectArray;
        if (throwable == null) {
            objectArray = null;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = throwable;
        }
        Object[] data = objectArray;
        return new BasicDiagnostic(4, PLUGIN_ID, 0, message, data);
    }

    public static Diagnostic createWarnDiagnostic(String message) {
        return new BasicDiagnostic(4, PLUGIN_ID, 0, message, null);
    }

    public static boolean isSuccess(Diagnostic diagnostic) {
        int severity = diagnostic.getSeverity();
        return severity != 4 && severity != 8;
    }

    public static void log(int severity, int code, String message, Throwable throwable) {
        String msg = message == null ? "" : message;
        try {
            if (QVTdDebugUIPlugin.getDefault() != null) {
                QVTdDebugUIPlugin.log((IStatus)new Status(severity, PLUGIN_ID, code, msg, throwable));
            } else {
                switch (code) {
                    case 2: {
                        System.err.print("WARNING ");
                        break;
                    }
                    case 4: 
                    case 8: {
                        System.err.print("ERROR ");
                        break;
                    }
                    default: {
                        return;
                    }
                }
                System.err.print(code);
                System.err.print(": ");
                QVTruntimeUtil.errPrintln((String)message);
                if (throwable != null) {
                    throwable.printStackTrace(System.err);
                }
            }
        }
        catch (IllegalArgumentException iae) {
            iae.printStackTrace();
        }
    }

    public static void log(IStatus status) {
        QVTdDebugUIPlugin debugPlugin = QVTdDebugUIPlugin.getDefault();
        if (debugPlugin != null) {
            debugPlugin.getLog().log(status);
        }
    }

    public static void log(Throwable e) {
        QVTdDebugUIPlugin.log((IStatus)new Status(4, PLUGIN_ID, "Exception caught", e));
    }

    public static final Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return QVTdDebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = QVTdDebugUIPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IStatus createStatus(int severity, String message) {
        return new Status(severity, PLUGIN_ID, 0, message, null);
    }

    public static IStatus createErrorStatus(String message) {
        return QVTdDebugUIPlugin.createStatus(4, message);
    }

    public static @NonNull CoreException newCoreExceptionError(@NonNull String message, @Nullable Throwable e) {
        return new CoreException(QVTdDebugUIPlugin.newCoreStatusError(message, e));
    }

    public static @NonNull IStatus newCoreStatusError(@NonNull String message, @Nullable Throwable e) {
        return new Status(4, PLUGIN_ID, 0, message, e);
    }

    protected ImageRegistry createImageRegistry() {
        ImageRegistry imageRegistry = super.createImageRegistry();
        imageRegistry.put("localVariable", QVTdDebugUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ocl.examples.debug.vm.ui", (String)"localvar_obj.gif"));
        imageRegistry.put("modelParameter", QVTdDebugUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ocl.examples.debug.vm.ui", (String)"modelpar_obj.gif"));
        imageRegistry.put("attribute", QVTdDebugUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ocl.examples.debug.vm.ui", (String)"attribute_obj.gif"));
        imageRegistry.put("reference", QVTdDebugUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ocl.examples.debug.vm.ui", (String)"reference_obj.gif"));
        imageRegistry.put("Mapping", this.imageDescriptor("Mapping.gif"));
        imageRegistry.put("Transformation", this.imageDescriptor("Transformation.gif"));
        return imageRegistry;
    }

    private ImageDescriptor imageDescriptor(String imagePath) {
        return QVTdDebugUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)("icons/" + imagePath));
    }
}

