/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.BasePartialRegionPropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionPropertyAnalysis;
import org.eclipse.qvtd.pivot.qvtschedule.PropertyDatum;

public class CyclicRegionAnalysis
implements Comparable<CyclicRegionAnalysis> {
    protected final @NonNull Set<@NonNull PartialRegionAnalysis<@NonNull RegionsAnalysis>> regionAnalyses;
    protected final @NonNull String name;
    private final @NonNull Set<@NonNull PartialRegionClassAnalysis<@NonNull RegionsAnalysis>> consumedClassAnalyses = new HashSet<PartialRegionClassAnalysis<RegionsAnalysis>>();
    private final @NonNull Set<@NonNull PartialRegionClassAnalysis<@NonNull RegionsAnalysis>> superProducedClassAnalyses = new HashSet<PartialRegionClassAnalysis<RegionsAnalysis>>();
    private final @NonNull Set<@NonNull PartialRegionPropertyAnalysis<@NonNull RegionsAnalysis>> consumedPropertyAnalyses = new HashSet<PartialRegionPropertyAnalysis<RegionsAnalysis>>();
    private final @NonNull Set<@NonNull PartialRegionPropertyAnalysis<@NonNull RegionsAnalysis>> producedPropertyAnalyses = new HashSet<PartialRegionPropertyAnalysis<RegionsAnalysis>>();
    private final @NonNull Set<@NonNull PartialRegionClassAnalysis<@NonNull RegionsAnalysis>> cyclicClassAnalyses = new HashSet<PartialRegionClassAnalysis<RegionsAnalysis>>();
    private final @NonNull Set<@NonNull PartialRegionPropertyAnalysis<@NonNull RegionsAnalysis>> cyclicPropertyAnalyses = new HashSet<PartialRegionPropertyAnalysis<RegionsAnalysis>>();
    private final @NonNull Map<@NonNull PropertyDatum, @NonNull PartialRegionPropertyAnalysis<@NonNull RegionsAnalysis>> propertyDatum2cyclicPropertyAnalysis = new HashMap<PropertyDatum, PartialRegionPropertyAnalysis<RegionsAnalysis>>();

    public CyclicRegionAnalysis(@NonNull Set<@NonNull PartialRegionAnalysis<@NonNull RegionsAnalysis>> regionAnalyses) {
        this.regionAnalyses = regionAnalyses;
        ArrayList<String> names = new ArrayList<String>();
        for (PartialRegionAnalysis<RegionsAnalysis> regionAnalysis : regionAnalyses) {
            names.add(regionAnalysis.getName());
        }
        Collections.sort(names);
        StringBuilder s = new StringBuilder();
        boolean isFirst = true;
        for (String string : names) {
            if (!isFirst) {
                s.append("+");
            } else {
                isFirst = false;
            }
            s.append(string);
        }
        this.name = s.toString();
        for (PartialRegionAnalysis partialRegionAnalysis : regionAnalyses) {
            Iterable producedPropertyAnalyses2;
            Iterable consumedPropertyAnalyses2;
            Iterable superProducedClassAnalyses2;
            Iterable<@NonNull PartialRegionClassAnalysis<@NonNull PRA>> consumedClassAnalyses2 = partialRegionAnalysis.getConsumedClassAnalyses();
            if (consumedClassAnalyses2 != null) {
                Iterables.addAll(this.consumedClassAnalyses, consumedClassAnalyses2);
            }
            if ((superProducedClassAnalyses2 = partialRegionAnalysis.getSuperProducedClassAnalyses()) != null) {
                Iterables.addAll(this.superProducedClassAnalyses, superProducedClassAnalyses2);
            }
            if ((consumedPropertyAnalyses2 = partialRegionAnalysis.getConsumedPropertyAnalyses()) != null) {
                Iterables.addAll(this.consumedPropertyAnalyses, consumedPropertyAnalyses2);
            }
            if ((producedPropertyAnalyses2 = partialRegionAnalysis.getProducedPropertyAnalyses()) == null) continue;
            Iterables.addAll(this.producedPropertyAnalyses, producedPropertyAnalyses2);
        }
        this.cyclicClassAnalyses.addAll(this.consumedClassAnalyses);
        this.cyclicClassAnalyses.retainAll(this.superProducedClassAnalyses);
        this.consumedClassAnalyses.removeAll(this.cyclicClassAnalyses);
        this.superProducedClassAnalyses.removeAll(this.cyclicClassAnalyses);
        this.cyclicPropertyAnalyses.addAll(this.consumedPropertyAnalyses);
        this.cyclicPropertyAnalyses.retainAll(this.producedPropertyAnalyses);
        this.consumedPropertyAnalyses.removeAll(this.cyclicPropertyAnalyses);
        this.producedPropertyAnalyses.removeAll(this.cyclicPropertyAnalyses);
        for (PartialRegionPropertyAnalysis partialRegionPropertyAnalysis : this.cyclicPropertyAnalyses) {
            PropertyDatum propertyDatum = partialRegionPropertyAnalysis.getPropertyDatum();
            this.propertyDatum2cyclicPropertyAnalysis.put(propertyDatum, partialRegionPropertyAnalysis);
        }
    }

    @Override
    public int compareTo(@NonNull CyclicRegionAnalysis that) {
        return this.name.compareTo(that.name);
    }

    public boolean isCyclic(@NonNull PropertyDatum propertyDatum) {
        PartialRegionPropertyAnalysis<@NonNull RegionsAnalysis> cyclicPropertyAnalysis = this.propertyDatum2cyclicPropertyAnalysis.get(propertyDatum);
        return cyclicPropertyAnalysis != null;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void showCycle(@NonNull TracingOption cyclesTracingOption) {
        StringBuilder s = new StringBuilder();
        s.append(this.name);
        s.append("\n  ConsumedClassAnalyses:");
        @NonNull @NonNull ArrayList sortedConsumedClassAnalyses = Lists.newArrayList(this.consumedClassAnalyses);
        Collections.sort(sortedConsumedClassAnalyses, NameUtil.NAMEABLE_COMPARATOR);
        for (PartialRegionClassAnalysis consumedClassAnalysis : sortedConsumedClassAnalyses) {
            s.append("\n\t" + consumedClassAnalysis);
        }
        s.append("\n  CyclicClassAnalyses:");
        @NonNull @NonNull ArrayList sortedCyclicClassAnalyses = Lists.newArrayList(this.cyclicClassAnalyses);
        Collections.sort(sortedCyclicClassAnalyses, NameUtil.NAMEABLE_COMPARATOR);
        for (PartialRegionClassAnalysis cyclicClassAnalysis : sortedCyclicClassAnalyses) {
            s.append("\n\t" + cyclicClassAnalysis);
        }
        s.append("\n  ProducedClassAnalyses:");
        @NonNull @NonNull ArrayList sortedSuperProducedClassAnalyses = Lists.newArrayList(this.superProducedClassAnalyses);
        Collections.sort(sortedSuperProducedClassAnalyses, NameUtil.NAMEABLE_COMPARATOR);
        for (PartialRegionClassAnalysis producedClassAnalysis : sortedSuperProducedClassAnalyses) {
            s.append("\n\t" + producedClassAnalysis);
        }
        s.append("\n  ConsumedPropertyAnalyses:");
        @NonNull @NonNull ArrayList sortedConsumedPropertyAnalyses = Lists.newArrayList(this.consumedPropertyAnalyses);
        Collections.sort(sortedConsumedPropertyAnalyses, NameUtil.NAMEABLE_COMPARATOR);
        for (PartialRegionPropertyAnalysis consumedPropertyAnalysis : sortedConsumedPropertyAnalyses) {
            s.append("\n\t" + consumedPropertyAnalysis);
            BasePartialRegionPropertyAnalysis baseConsumedPropertyAnalysis = consumedPropertyAnalysis.getBasePropertyAnalysis();
            if (consumedPropertyAnalysis.getPropertyDatum() == baseConsumedPropertyAnalysis.getPropertyDatum()) continue;
            s.append("(" + baseConsumedPropertyAnalysis + ")");
        }
        s.append("\n  CyclicPropertyAnalyses:");
        @NonNull @NonNull ArrayList sortedCyclicPropertyAnalyses = Lists.newArrayList(this.cyclicPropertyAnalyses);
        Collections.sort(sortedCyclicPropertyAnalyses, NameUtil.NAMEABLE_COMPARATOR);
        for (PartialRegionPropertyAnalysis cyclicPropertyAnalysis : sortedCyclicPropertyAnalyses) {
            s.append("\n\t" + cyclicPropertyAnalysis);
            BasePartialRegionPropertyAnalysis<@NonNull PRA> baseCyclicPropertyAnalysis = cyclicPropertyAnalysis.getBasePropertyAnalysis();
            if (cyclicPropertyAnalysis.getPropertyDatum() == baseCyclicPropertyAnalysis.getPropertyDatum()) continue;
            s.append("(" + baseCyclicPropertyAnalysis + ")");
        }
        s.append("\n  ProducedPropertyAnalyses:");
        @NonNull @NonNull ArrayList sortedProducedPropertyAnalyses = Lists.newArrayList(this.producedPropertyAnalyses);
        Collections.sort(sortedProducedPropertyAnalyses, NameUtil.NAMEABLE_COMPARATOR);
        for (PartialRegionPropertyAnalysis producedPropertyAnalysis : sortedProducedPropertyAnalyses) {
            s.append("\n\t" + producedPropertyAnalysis);
            BasePartialRegionPropertyAnalysis<@NonNull PRA> baseProducedPropertyAnalysis = producedPropertyAnalysis.getBasePropertyAnalysis();
            if (producedPropertyAnalysis.getPropertyDatum() == baseProducedPropertyAnalysis.getPropertyDatum()) continue;
            s.append("(" + baseProducedPropertyAnalysis + ")");
        }
        cyclesTracingOption.println(s.toString());
    }

    public String toString() {
        return this.name;
    }
}

