/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.umlx.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.internal.messages.PivotMessagesInternal;
import org.eclipse.ocl.pivot.utilities.StringUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.umlx.UMLXElement;
import org.eclipse.qvtd.umlx.resource.UMLX2XMIidVisitor;
import org.eclipse.qvtd.umlx.resource.UMLXResourceImpl;

public class UMLX2XMIid {
    protected final @NonNull Map<@NonNull String, @NonNull String> moniker2id;

    public UMLX2XMIid() {
        this.moniker2id = new HashMap<String, String>();
    }

    protected UMLX2XMIid(@NonNull Map<@NonNull String, @NonNull String> moniker2id) {
        this.moniker2id = moniker2id;
    }

    public void assignIds(@NonNull UMLXResourceImpl asResource, @Nullable Map<@NonNull String, @Nullable Object> options) {
        StringBuilder s = null;
        HashMap<@NonNull String, @NonNull UMLXElement> allIds = new HashMap<String, UMLXElement>();
        boolean internalUUIDs = false;
        for (EObject eObject : new TreeIterable((Resource)asResource)) {
            boolean changedId;
            String idNew;
            if (!(eObject instanceof UMLXElement)) continue;
            UMLXElement element = (UMLXElement)eObject;
            String idOld = asResource.getID(element);
            UMLX2XMIidVisitor idVisitor = new UMLX2XMIidVisitor(this);
            String idAuto = idVisitor.getID(element, internalUUIDs);
            String string = idNew = idOld != null ? idOld : idAuto;
            if (idNew == null) continue;
            EObject oldElement = (EObject)allIds.get(idNew);
            boolean badId = idNew.length() <= 0 || oldElement != null;
            boolean bl = changedId = idAuto != null && !idNew.equals(idAuto);
            if (badId) {
                idNew = EcoreUtil.generateUUID();
            } else if (changedId) {
                idNew = idAuto;
            }
            assert (idNew != null);
            if (badId || changedId) {
                if (s == null) {
                    s = new StringBuilder();
                }
                s.append("\n " + element.eClass().getName() + " '" + idAuto + "'");
            }
            assert (element != null);
            allIds.put(idNew, element);
            if (idNew == idOld) continue;
            asResource.setID(element, idNew);
        }
        if (s != null) {
            String message = StringUtil.bind((String)PivotMessagesInternal.UnstableXMIid_ERROR_, (Object[])new Object[]{s.toString()});
            asResource.getErrors().add((Object)new UnstableXMIidDiagnostics(message));
        }
    }

    public void assignIds(@NonNull ResourceSet asResourceSet, @Nullable Map<@NonNull String, @Nullable Object> options) {
        EcoreUtil.resolveAll((ResourceSet)asResourceSet);
        for (Resource resource : asResourceSet.getResources()) {
            if (!(resource instanceof UMLXResourceImpl)) continue;
            this.assignIds((UMLXResourceImpl)resource, options);
        }
    }

    public static final class UnstableXMIidDiagnostics
    implements Resource.Diagnostic {
        protected final @NonNull String message;

        public UnstableXMIidDiagnostics(@NonNull String message) {
            this.message = message;
        }

        public String getMessage() {
            return this.message.replace("\n", "\\n");
        }

        public String getLocation() {
            return null;
        }

        public int getLine() {
            return 0;
        }

        public int getColumn() {
            return 0;
        }

        public String toString() {
            return this.message;
        }
    }
}

