/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.umlx.ui.launching;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.CompilerChain;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.CompilerOptions;
import org.eclipse.qvtd.compiler.DefaultCompilerOptions;
import org.eclipse.qvtd.debug.ui.QVTdDebugUIPlugin;
import org.eclipse.qvtd.debug.ui.launching.DirectionalMainTab;
import org.eclipse.qvtd.pivot.qvtimperative.evaluation.QVTiEnvironmentFactory;
import org.eclipse.qvtd.umlx.TxDiagram;
import org.eclipse.qvtd.umlx.TxTypedModelNode;
import org.eclipse.qvtd.umlx.compiler.UMLXCompilerChain;
import org.eclipse.qvtd.umlx.ui.launching.UMLXLaunchConfigurationDelegate;
import org.eclipse.qvtd.xtext.qvtcore.QVTcoreStandaloneSetup;
import org.eclipse.swt.graphics.Image;

public class UMLXMainTab
extends DirectionalMainTab<TxDiagram> {
    protected @NonNull CompilerChain createCompilerChain(@NonNull QVTiEnvironmentFactory environmentFactory, @NonNull URI txURI, @NonNull CompilerOptions compilerOptions) {
        QVTcoreStandaloneSetup.class.getName();
        return new UMLXCompilerChain(environmentFactory, txURI, txURI, compilerOptions);
    }

    private void gatherOutputModels(@NonNull List<TxTypedModelNode> outputModels, @NonNull TxTypedModelNode typedModel) {
        if (!outputModels.contains(typedModel)) {
            outputModels.add(typedModel);
        }
    }

    public Image getImage() {
        return QVTdDebugUIPlugin.getDefault().createImage("icons/UMLXModelFile.gif");
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected @NonNull List<@NonNull String> getIntermediateKeys() {
        @NonNull ArrayList asList = Lists.newArrayList((Object[])UMLXLaunchConfigurationDelegate.compileStepKeys);
        if (!this.isInterpreted()) {
            String[] stringArray = UMLXLaunchConfigurationDelegate.generateStepKeys;
            int n = UMLXLaunchConfigurationDelegate.generateStepKeys.length;
            int n2 = 0;
            while (n2 < n) {
                @NonNull String stepKey = stringArray[n2];
                asList.add(stepKey);
                ++n2;
            }
        }
        return asList;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected void initializeOptions(@NonNull DefaultCompilerOptions compilerOptions) throws IOException {
        @NonNull @NonNull Map intermediatesMap = this.getIntermediatesMap(UMLXLaunchConfigurationDelegate.compileStepKeys);
        compilerOptions.setURIs2(UMLXLaunchConfigurationDelegate.compileStepKeys, intermediatesMap);
        compilerOptions.setDebugGraphs(this.doDotGraphs(), this.doYedGraphs());
        if (!this.isInterpreted()) {
            URI txURI = this.getTxURI();
            URI genModelURI = this.getResolvedCompilerStep("GenModel");
            URI javaURI = this.getResolvedCompilerStep("Java");
            URI classURI = this.getResolvedCompilerStep("Class");
            compilerOptions.setQVTrGenerateOptions(this.getProjectName(), txURI, genModelURI, javaURI, classURI);
        }
    }

    protected void updateDirection(@NonNull TxDiagram txDiagram) {
        HashSet<@NonNull String> enforceableDirectionNames = new HashSet<String>();
        for (TxTypedModelNode txTypedModelNode : txDiagram.getOwnedTxTypedModelNodes()) {
            String name;
            if (!txTypedModelNode.isEnforce() || (name = txTypedModelNode.getName()) == null) continue;
            enforceableDirectionNames.add(name);
        }
        this.setDirections(enforceableDirectionNames);
    }

    protected void updateGroups(@NonNull TxDiagram txDiagram, @NonNull Map<@NonNull String, @Nullable String> oldInputsMap, @NonNull Map<@NonNull String, @Nullable String> newInputsMap, @NonNull Map<@NonNull String, @Nullable String> oldOutputsMap, @NonNull Map<@NonNull String, @Nullable String> newOutputsMap, @NonNull Map<@NonNull String, @Nullable String> intermediateMap) {
        String name;
        super.updateGroups((Object)txDiagram, oldInputsMap, newInputsMap, oldOutputsMap, newOutputsMap, intermediateMap);
        HashSet<@NonNull TxTypedModelNode> inputs = new HashSet<TxTypedModelNode>();
        HashSet<@NonNull TxTypedModelNode> outputs = new HashSet<TxTypedModelNode>();
        String directionName = this.directionCombo.getText();
        ArrayList<@NonNull TxTypedModelNode> inputModels = new ArrayList<TxTypedModelNode>();
        ArrayList<@NonNull TxTypedModelNode> outputModels = new ArrayList<TxTypedModelNode>();
        for (TxTypedModelNode typedModel : ClassUtil.nullFree((EList)txDiagram.getOwnedTxTypedModelNodes())) {
            if (!ClassUtil.safeEquals((Object)typedModel.getName(), (Object)directionName)) continue;
            this.gatherOutputModels(outputModels, typedModel);
        }
        for (TxTypedModelNode inputModel : ClassUtil.nullFree((EList)txDiagram.getOwnedTxTypedModelNodes())) {
            if (inputModel.getName() == null) continue;
            inputModels.add(inputModel);
        }
        inputModels.removeAll(outputModels);
        String modeName = this.modeCombo.getText();
        if ("CHECK".equals(modeName)) {
            for (TxTypedModelNode inputModel : inputModels) {
                if (!inputs.add(inputModel) || (name = inputModel.getName()) == null) continue;
                newInputsMap.put(name, null);
            }
            for (TxTypedModelNode outputModel : outputModels) {
                if (!outputs.add(outputModel) || (name = outputModel.getName()) == null) continue;
                oldOutputsMap.put(name, null);
            }
            newOutputsMap.put("middle", null);
        } else if ("ENFORCE - CREATE".equals(modeName)) {
            for (TxTypedModelNode inputModel : inputModels) {
                if (!inputs.add(inputModel) || (name = inputModel.getName()) == null) continue;
                newInputsMap.put(name, null);
            }
            for (TxTypedModelNode outputModel : outputModels) {
                if (!outputs.add(outputModel) || (name = outputModel.getName()) == null) continue;
                newOutputsMap.put(name, null);
            }
            newOutputsMap.put("middle", null);
        }
        if ("ENFORCE - UPDATE".equals(modeName)) {
            for (TxTypedModelNode inputModel : inputModels) {
                if (!inputs.add(inputModel) || (name = inputModel.getName()) == null) continue;
                oldInputsMap.put(name, null);
                newInputsMap.put(name, null);
            }
            for (TxTypedModelNode outputModel : outputModels) {
                if (!outputs.add(outputModel) || (name = outputModel.getName()) == null) continue;
                oldOutputsMap.put(name, null);
                newOutputsMap.put(name, null);
            }
            oldInputsMap.put("middle", null);
            newOutputsMap.put("middle", null);
        }
    }

    protected @NonNull TxDiagram updateTransformation(@NonNull URI umlxURI) throws IOException {
        String message;
        QVTiEnvironmentFactory environmentFactory = this.getEnvironmentFactory();
        Resource umlxResource = environmentFactory.getResourceSet().getResource(umlxURI, true);
        if (umlxResource.getErrors().size() > 0 && (message = PivotUtil.formatResourceDiagnostics((List)umlxResource.getErrors(), (String)"", (String)"\n")) != null) {
            throw new CompilerChainException(message, new Object[0]);
        }
        for (EObject eObject : new TreeIterable(umlxResource)) {
            if (!(eObject instanceof TxDiagram)) continue;
            return (TxDiagram)eObject;
        }
        throw new IllegalStateException();
    }
}

