/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.common.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFolder;
import org.eclipse.m2m.internal.qvt.oml.common.io.CResource;
import org.eclipse.m2m.internal.qvt.oml.common.io.IOFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.IOResource;

public class IOFolder
extends IOResource
implements CFolder {
    public IOFolder(String folder) {
        this(new File(folder));
    }

    public IOFolder(File folder) {
        super(folder);
        if (folder.exists() && !folder.isDirectory()) {
            throw new IllegalArgumentException("Not a directory: " + folder);
        }
    }

    public CFile getFile(String name) {
        return new IOFile(new File(this.myFile, name));
    }

    public void create() {
        this.myFile.mkdirs();
    }

    public CFolder getFolder(String name) {
        return new IOFolder(new File(this.myFile, name));
    }

    public CResource[] members() {
        ArrayList<IOFolder> members = new ArrayList<IOFolder>();
        File[] children = this.myFile.listFiles();
        int i = 0;
        while (i < children.length) {
            File child = children[i];
            IOResource member = child.isDirectory() ? new IOFolder(child) : new IOFile(child);
            members.add((IOFolder)member);
            ++i;
        }
        return members.toArray(new CResource[members.size()]);
    }

    public String getDefaultCharset() throws IOException {
        return IOFolder.getWorkspaceCharset();
    }
}

