/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.stdlib;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.emf.util.StatusUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtInterruptedExecutionException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtOperationalEvaluationVisitorImpl;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TransformationInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractContextualOperations;
import org.eclipse.m2m.internal.qvt.oml.stdlib.AbstractQVTStdlib;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandlerAdapter;
import org.eclipse.m2m.internal.qvt.oml.stdlib.model.ExceptionInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.model.StatusInstance;
import org.eclipse.m2m.internal.qvt.oml.stdlib.model.StdlibFactory;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListType;
import org.eclipse.ocl.types.OCLStandardLibrary;

public class TransformationOperations
extends AbstractContextualOperations {
    private static final String TRANSFORM_NAME = "transform";
    private static final String PARALLEL_TRANSFORM_NAME = "parallelTransform";
    private static final String WAIT_NAME = "wait";

    public TransformationOperations(AbstractQVTStdlib library) {
        super(library, (EClassifier)library.getTransformationClass());
    }

    protected AbstractContextualOperations.OperationProvider[] getOperations() {
        OCLStandardLibrary<EClassifier> oclStdlib = this.getStdlib().getOCLStdLib();
        ListType listOfStatus = this.getStdlib().getEnvironment().getTypeResolver().resolveListType((EClassifier)this.getStdlib().getStatusClass());
        return new AbstractContextualOperations.OwnedOperationProvider[]{new AbstractContextualOperations.OwnedOperationProvider((AbstractContextualOperations)this, TransformationOperations.createTransformHandler(this.getStdlib()), TRANSFORM_NAME, (EClassifier)this.getStdlib().getStatusClass(), new EClassifier[0]), new AbstractContextualOperations.OwnedOperationProvider((AbstractContextualOperations)this, UNSUPPORTED_OPER, PARALLEL_TRANSFORM_NAME, (EClassifier)this.getStdlib().getStatusClass(), new EClassifier[0]), new AbstractContextualOperations.OwnedOperationProvider((AbstractContextualOperations)this, UNSUPPORTED_OPER, WAIT_NAME, new String[]{"statusList"}, (EClassifier)oclStdlib.getOclVoid(), new EClassifier[]{listOfStatus})};
    }

    private static CallHandler createTransformHandler(AbstractQVTStdlib stdlib) {
        return new CallHandler(){

            public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
                ModuleInstance moduleInstance = (ModuleInstance)source;
                CallHandler mainHandler = moduleInstance.getAdapter(TransformationInstance.InternalTransformation.class).getTransformationHandler();
                if (mainHandler == null) {
                    return CallHandlerAdapter.getInvalidResult(evalEnv);
                }
                StdlibFactory stdlibFactory = QvtOperationalStdLibrary.INSTANCE.getStdlibFactory();
                try {
                    Object result = mainHandler.invoke(moduleInstance, source, args, evalEnv);
                    if (result instanceof QvtOperationalEvaluationVisitorImpl.OperationCallResult) {
                        QvtOperationalEvaluationVisitorImpl.OperationCallResult callResult = (QvtOperationalEvaluationVisitorImpl.OperationCallResult)result;
                        ExecutionDiagnostic diagnostic = callResult.myEvalEnv.getContext().getExecutionDiagnostic();
                        IStatus status = BasicDiagnostic.toIStatus((Diagnostic)diagnostic);
                        if (StatusUtil.isError((IStatus)status)) {
                            return stdlibFactory.createFailure(null);
                        }
                    }
                }
                catch (QvtInterruptedExecutionException e) {
                    throw e;
                }
                catch (QvtRuntimeException e) {
                    ExceptionInstance raisedException = stdlibFactory.createException(QvtOperationalStdLibrary.INSTANCE.getExceptionClass(), e.getLocalizedMessage(), e.getQvtStackTrace());
                    StatusInstance status = stdlibFactory.createFailure(raisedException);
                    return status;
                }
                return stdlibFactory.createSuccess();
            }
        };
    }
}

