/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.m2m.internal.qvt.oml.NLS;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.IModuleSourceInfo;
import org.eclipse.m2m.internal.qvt.oml.ast.env.IVirtualOperationTable;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtEvaluationResult;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalModuleEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalStdLibrary;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ConstructorOperationAdapter;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.IntermediateClassFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalUtil;
import org.eclipse.m2m.internal.qvt.oml.blackbox.BlackboxRegistry;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.DeferredAssignmentListener;
import org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationMessages;
import org.eclipse.m2m.internal.qvt.oml.evaluator.EvaluationUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ImportToNonTransformCtxHelper;
import org.eclipse.m2m.internal.qvt.oml.evaluator.IntermediatePropertyModelAdapter;
import org.eclipse.m2m.internal.qvt.oml.evaluator.InternalEvaluator;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelParameterHelper;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModuleInstanceFactory;
import org.eclipse.m2m.internal.qvt.oml.evaluator.NumberConversions;
import org.eclipse.m2m.internal.qvt.oml.evaluator.OCLAnnotationSupport;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtAssertionFailed;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtGenericVisitorDecorator;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtInterruptedExecutionException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtOperationalEvaluationVisitor;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtStackTraceBuilder;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtTransitionReachedException;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ThisInstanceResolver;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TraceUtil;
import org.eclipse.m2m.internal.qvt.oml.evaluator.TransformationInstance;
import org.eclipse.m2m.internal.qvt.oml.evaluator.iterators.QvtIterationTemplateCollectSelect;
import org.eclipse.m2m.internal.qvt.oml.evaluator.iterators.QvtIterationTemplateForExp;
import org.eclipse.m2m.internal.qvt.oml.evaluator.iterators.QvtIterationTemplateXCollect;
import org.eclipse.m2m.internal.qvt.oml.evaluator.iterators.QvtIterationTemplateXSelect;
import org.eclipse.m2m.internal.qvt.oml.expressions.Constructor;
import org.eclipse.m2m.internal.qvt.oml.expressions.ConstructorBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.EntryOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ExpressionsPackage;
import org.eclipse.m2m.internal.qvt.oml.expressions.Helper;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeCallExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingCallExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.m2m.internal.qvt.oml.expressions.ObjectExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveInExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.impl.OperationBodyImpl;
import org.eclipse.m2m.internal.qvt.oml.library.Context;
import org.eclipse.m2m.internal.qvt.oml.library.EObjectEStructuralFeaturePair;
import org.eclipse.m2m.internal.qvt.oml.library.LateResolveInTask;
import org.eclipse.m2m.internal.qvt.oml.library.LateResolveTask;
import org.eclipse.m2m.internal.qvt.oml.library.QvtResolveUtil;
import org.eclipse.m2m.internal.qvt.oml.stdlib.CallHandler;
import org.eclipse.m2m.internal.qvt.oml.stdlib.ConversionUtils;
import org.eclipse.m2m.internal.qvt.oml.stdlib.DictionaryImpl;
import org.eclipse.m2m.internal.qvt.oml.stdlib.MutableListImpl;
import org.eclipse.m2m.internal.qvt.oml.stdlib.model.ExceptionInstance;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.m2m.internal.qvt.oml.trace.TraceRecord;
import org.eclipse.m2m.qvt.oml.blackbox.java.JavaModelExtent;
import org.eclipse.m2m.qvt.oml.blackbox.java.JavaModelInstance;
import org.eclipse.m2m.qvt.oml.blackbox.java.JavaModelType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AltExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AssertExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AssignExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.BlockExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.BreakExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.CatchExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ComputeExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ContinueExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictLiteralExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictLiteralPart;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ForExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeIterateExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeLoopExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeOCLPackage;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.InstantiationExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.LogExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.OrderedTupleLiteralExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.OrderedTupleLiteralPart;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.RaiseExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ReturnExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.SeverityKind;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.SwitchExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.TryExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.UnlinkExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.UnpackExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.VariableInitExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.WhileExp;
import org.eclipse.m2m.qvt.oml.util.Dictionary;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.MutableList;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.EvaluationVisitorImpl;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreEnvironment;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.EcorePackage;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionLiteralExp;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.EnumLiteralExp;
import org.eclipse.ocl.expressions.IfExp;
import org.eclipse.ocl.expressions.OperationCallExp;
import org.eclipse.ocl.expressions.PropertyCallExp;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.CollectionType;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.types.SetType;
import org.eclipse.ocl.types.TupleType;
import org.eclipse.ocl.types.VoidType;
import org.eclipse.ocl.util.Bag;
import org.eclipse.ocl.util.CollectionUtil;
import org.eclipse.ocl.util.Tuple;
import org.eclipse.ocl.utilities.ASTNode;
import org.eclipse.ocl.utilities.PredefinedType;
import org.eclipse.ocl.utilities.UMLReflection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalEvaluationVisitorImpl
extends EvaluationVisitorImpl<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>
implements QvtOperationalEvaluationVisitor,
InternalEvaluator,
DeferredAssignmentListener {
    private static int tempCounter = 0;
    private QvtOperationalEvaluationEnv myEvalEnv;
    private OCLAnnotationSupport oclAnnotationSupport;

    public QvtOperationalEvaluationVisitorImpl(QvtOperationalEnv env, QvtOperationalEvaluationEnv evalEnv) {
        super((Environment)env, (EvaluationEnvironment)evalEnv, evalEnv.createExtentMap(null));
        this.myEvalEnv = evalEnv;
    }

    protected QvtOperationalEvaluationVisitorImpl(QvtOperationalEvaluationVisitorImpl parent, QvtOperationalEvaluationEnv nestedEvalEnv) {
        this(parent.getOperationalEnv(), nestedEvalEnv);
        this.oclAnnotationSupport = parent.getOCLAnnotationSupport();
    }

    protected InternalEvaluator createNestedEvaluationVisitor(QvtOperationalEvaluationVisitorImpl parent, QvtOperationalEvaluationEnv nestedEvalEnv) {
        InternalEvaluator evalVisitor = (InternalEvaluator)this.getOperationalEnv().getFactory().createEvaluationVisitor(parent.getOperationalEnv(), (EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject>)nestedEvalEnv, nestedEvalEnv.createExtentMap(null));
        if (evalVisitor instanceof QvtOperationalEvaluationVisitorImpl) {
            ((QvtOperationalEvaluationVisitorImpl)evalVisitor).oclAnnotationSupport = this.getOCLAnnotationSupport();
        }
        return evalVisitor;
    }

    public Object visitDictLiteralExp(DictLiteralExp dictLiteralExp) {
        DictionaryImpl<Object, Object> result = new DictionaryImpl<Object, Object>();
        for (DictLiteralPart part : dictLiteralExp.getPart()) {
            Object key = this.visitExpression((org.eclipse.ocl.expressions.OCLExpression)part.getKey());
            Object value = this.visitExpression((org.eclipse.ocl.expressions.OCLExpression)part.getValue());
            if (key == this.getInvalid() || value == this.getInvalid()) continue;
            result.put(key, value);
        }
        return result;
    }

    public Object visitVariableExp(VariableExp<EClassifier, EParameter> v) {
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        Object vd = v.getReferredVariable();
        String varName = vd.getName();
        Object value = evalEnv.getValueOf(varName);
        if ("this".equals(varName)) {
            Module referredThisModule;
            ModuleInstance thisObj;
            EClassifier varType = (EClassifier)v.getType();
            if (varType instanceof Module && (thisObj = evalEnv.getThisOfType(referredThisModule = (Module)varType)) != null) {
                return thisObj;
            }
        } else if (vd instanceof ModelParameter || value instanceof ModelParameter) {
            if (value instanceof ModelParameter) {
                vd = (ModelParameter)value;
            }
            OperationalTransformation transformation = (OperationalTransformation)vd.eContainer();
            TransformationInstance transformationInstance = (TransformationInstance)evalEnv.getThisOfType(transformation);
            assert (transformationInstance != null);
            ModelInstance model = transformationInstance.getModel((ModelParameter)vd);
            assert (model != null);
            return model;
        }
        return value;
    }

    public static QvtOperationalEvaluationVisitorImpl createNonTransformationExecutionContextVisitor(Context context, ImportToNonTransformCtxHelper importProvider) {
        QvtOperationalEnv env = QvtOperationalEnvFactory.INSTANCE.createEnvironment();
        QvtOperationalEvaluationEnv evalEnv = QvtOperationalEnvFactory.INSTANCE.createEvaluationEnvironment(context, null);
        return QvtOperationalEvaluationVisitorImpl.createNonTransformationExecutionContextVisitor(env, evalEnv, importProvider);
    }

    public static QvtOperationalEvaluationVisitorImpl createNonTransformationExecutionContextVisitor(QvtOperationalEnv env, QvtOperationalEvaluationEnv evalEnv, ImportToNonTransformCtxHelper importsProvider) {
        QvtOperationalEvaluationVisitorImpl visitor = new QvtOperationalEvaluationVisitorImpl(env, evalEnv);
        InternalEvaluationEnv internalEvalEnv = evalEnv.getAdapter(InternalEvaluationEnv.class);
        ThisInstanceResolver importsByAccess = importsProvider.createImportedInstanceResolver();
        internalEvalEnv.setThisResolver(importsByAccess);
        for (ModuleInstance nextModuleToInit : importsProvider.getModuleInstances(false)) {
            ModuleInstance.Internal internalModule = nextModuleToInit.getAdapter(ModuleInstance.Internal.class);
            if (internalModule.isInitialized()) continue;
            visitor.initModule(nextModuleToInit, null);
        }
        return visitor;
    }

    public static QvtOperationalEvaluationVisitor createVisitor(QvtOperationalEnv env, QvtOperationalEvaluationEnv evalEnv) {
        return new QvtOperationalEvaluationVisitorImpl(env, evalEnv).createInterruptibleVisitor();
    }

    public EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> getEvaluationEnvironment() {
        return this.myEvalEnv;
    }

    @Override
    public void setOperationalEvaluationEnv(QvtOperationalEvaluationEnv evalEnv) {
        this.myEvalEnv = evalEnv;
    }

    protected void pushedStack(QvtOperationalEvaluationEnv env) {
    }

    protected void poppedStack() {
    }

    @Override
    public IContext getContext() {
        return this.getOperationalEvaluationEnv().getContext();
    }

    @Override
    public void notifyAfterDeferredAssign(AssignExp assignExp, Object leftValue) {
    }

    public Object visitIfExp(IfExp<EClassifier> ie) {
        org.eclipse.ocl.expressions.OCLExpression condition = ie.getCondition();
        Object condVal = this.visitExpression(condition);
        if (this.isUndefined(condVal)) {
            return this.getInvalid();
        }
        Boolean condValBool = (Boolean)condVal;
        if (condValBool.booleanValue()) {
            return this.visitExpression(ie.getThenExpression());
        }
        if (ie.getElseExpression() != null) {
            return this.visitExpression(ie.getElseExpression());
        }
        return null;
    }

    public Object visitAssignExp(AssignExp assignExp) {
        Object ownerObj;
        QvtOperationalEvaluationEnv env = this.getOperationalEvaluationEnv();
        InternalEvaluationEnv internEnv = env.getAdapter(InternalEvaluationEnv.class);
        boolean isDeferred = false;
        OCLExpression lValue = assignExp.getLeft();
        if (assignExp.getValue().size() == 1 && (isDeferred = QvtResolveUtil.hasDeferredRightSideValue(assignExp)) && (ownerObj = this.getAssignExpLValueOwner((org.eclipse.ocl.expressions.OCLExpression<EClassifier>)lValue)) instanceof EObject) {
            PropertyCallExp lvalueExp = (PropertyCallExp)assignExp.getLeft();
            Iterator referredProperty = (EStructuralFeature)lvalueExp.getReferredProperty();
            internEnv.setLastAssignmentLvalueEval(new EObjectEStructuralFeaturePair((EObject)ownerObj, (EStructuralFeature)referredProperty));
        }
        Object exprValue = null;
        for (org.eclipse.ocl.expressions.OCLExpression exp : assignExp.getValue()) {
            exprValue = this.visitExpression(exp);
        }
        if (isDeferred) {
            return null;
        }
        if (lValue instanceof VariableExp) {
            VariableExp varExp = (VariableExp)lValue;
            org.eclipse.ocl.expressions.Variable referredVariable = varExp.getReferredVariable();
            if (referredVariable != null) {
                String varName = referredVariable.getName();
                Object oldValue = this.getRuntimeValue(varName);
                Object newValue = null;
                EClassifier variableType = (EClassifier)lValue.getType();
                if (variableType instanceof CollectionType && exprValue != this.getInvalid()) {
                    if (assignExp.isIsReset()) {
                        if (exprValue instanceof MutableList || exprValue instanceof Dictionary || this.isUndefined(exprValue)) {
                            newValue = exprValue;
                        } else if (exprValue instanceof Collection) {
                            Collection exprValueCollection = (Collection)exprValue;
                            newValue = CollectionUtil.createNewCollection((Collection)exprValueCollection);
                        }
                    } else {
                        Collection newOclCollection = null;
                        if (oldValue instanceof Collection) {
                            Collection oldOclCollection = (Collection)oldValue;
                            newOclCollection = oldOclCollection instanceof MutableList || oldOclCollection instanceof Dictionary ? oldOclCollection : CollectionUtil.createNewCollection(oldOclCollection);
                        } else if (this.isUndefined(oldValue)) {
                            newOclCollection = EvaluationUtil.createNewCollection((CollectionType<EClassifier, EOperation>)((CollectionType)variableType));
                        }
                        if (exprValue instanceof Collection) {
                            newOclCollection.addAll((Collection)exprValue);
                        } else {
                            newOclCollection.add(exprValue);
                        }
                        newValue = newOclCollection;
                    }
                } else {
                    newValue = exprValue;
                }
                this.replaceInEnv(varName, newValue, variableType);
            }
        } else if (lValue instanceof PropertyCallExp) {
            Object ownerObj2 = this.getAssignExpLValueOwner((org.eclipse.ocl.expressions.OCLExpression<EClassifier>)lValue);
            if (ownerObj2 instanceof EObject) {
                EObject oldIP = this.setCurrentEnvInstructionPointer((EObject)assignExp);
                env.callSetter((EObject)ownerObj2, (EStructuralFeature)((PropertyCallExp)lValue).getReferredProperty(), exprValue, this.isUndefined(exprValue), assignExp.isIsReset());
                this.setCurrentEnvInstructionPointer(oldIP);
            }
        } else {
            throw new UnsupportedOperationException("Unsupported LValue type: " + (lValue == null ? null : (EClassifier)lValue.getType()));
        }
        return exprValue;
    }

    private Object getAssignExpLValueOwner(org.eclipse.ocl.expressions.OCLExpression<EClassifier> lValue) {
        if (lValue instanceof PropertyCallExp) {
            PropertyCallExp propertyCallExp = (PropertyCallExp)lValue;
            org.eclipse.ocl.expressions.OCLExpression sourceExp = propertyCallExp.getSource();
            Object owner = this.visitExpression(sourceExp);
            if (owner instanceof ModuleInstance) {
                ModuleInstance moduleInstance = (ModuleInstance)owner;
                Object property = ((PropertyCallExp)lValue).getReferredProperty();
                EClassifier containingClassifier = (EClassifier)this.getUMLReflection().getOwningClassifier(property);
                if (containingClassifier instanceof Module) {
                    owner = moduleInstance.getThisInstanceOf((Module)containingClassifier);
                }
            }
            return owner;
        }
        return null;
    }

    private Object visitConfigProperty(EStructuralFeature configProperty) {
        this.setCurrentEnvInstructionPointer((EObject)configProperty);
        IContext context = this.getOperationalEvaluationEnv().getContext();
        Object rawValue = context.getConfigProperty(configProperty.getName());
        EClassifier propertyType = configProperty.getEType();
        Object value = rawValue;
        if (context.getConfigProperties().containsKey(configProperty.getName()) && rawValue instanceof String && propertyType != this.getEnvironment().getOCLStandardLibrary().getString()) {
            try {
                value = ConversionUtils.createFromString(propertyType, (String)rawValue);
            }
            catch (IllegalArgumentException e) {
                value = this.getInvalid();
            }
        }
        if (value == this.getInvalid()) {
            this.throwQVTException(new QvtRuntimeException(NLS.bind(EvaluationMessages.QvtOperationalEvaluationVisitorImpl_invalidConfigPropertyValue, configProperty.getName(), rawValue)));
        }
        return value;
    }

    @Override
    public Object visitEntryOperation(EntryOperation entryOperation) {
        this.visitImperativeOperation(entryOperation);
        return new OperationCallResult(this.visitOperationBody(entryOperation.getBody()), this.getOperationalEvaluationEnv());
    }

    @Override
    public Object visitHelper(Helper helper) {
        this.visitImperativeOperation(helper);
        if (helper.isIsBlackbox()) {
            Object result = this.doVisitBlackboxOperation(helper);
            return new OperationCallResult(result, this.getOperationalEvaluationEnv());
        }
        return new OperationCallResult(this.visitOperationBody(helper.getBody()), this.getOperationalEvaluationEnv());
    }

    @Override
    public Object visitImperativeOperation(ImperativeOperation imperativeOperation) {
        List<Object> args = this.getOperationalEvaluationEnv().getOperationArgs();
        Iterator<Object> argIt = args.iterator();
        QvtOperationalEvaluationEnv env = this.getOperationalEvaluationEnv();
        for (EParameter nextParam : imperativeOperation.getEParameters()) {
            if (!argIt.hasNext()) {
                throw new IllegalArgumentException("arguments mismatch: got" + args + ", expected " + imperativeOperation.getEParameters());
            }
            VarParameter param = (VarParameter)nextParam;
            Object arg = argIt.next();
            if (param.getKind() == DirectionKind.OUT) continue;
            this.addToEnv(param.getName(), arg, param.getEType());
        }
        EClassifier contextType = QvtOperationalParserUtil.getContextualType(imperativeOperation);
        if (contextType != null) {
            this.addToEnv("self", env.getOperationSelf(), contextType);
        }
        this.pushedStack(this.getOperationalEvaluationEnv());
        return null;
    }

    private Object doVisitBlackboxOperation(ImperativeOperation operation) {
        Collection<CallHandler> handlers;
        assert (operation.isIsBlackbox()) : "Blackbox operation expected";
        EcoreEnvironment moduleEnv = ASTBindingHelper.resolveEnvironment((ASTNode)operation.eContainer());
        if (!(moduleEnv instanceof QvtOperationalModuleEnv)) {
            moduleEnv = ASTBindingHelper.getEnvironment(operation.eContainer(), QvtOperationalModuleEnv.class);
        }
        if ((handlers = BlackboxRegistry.INSTANCE.getBlackboxCallHandler(operation, (QvtOperationalModuleEnv)moduleEnv)).isEmpty()) {
            this.throwQVTException(new QvtRuntimeException(NLS.bind(EvaluationMessages.NoBlackboxOperationFound, QvtOperationalParserUtil.safeGetMappingQualifiedName(this.getOperationalEnv(), operation))));
        }
        if (handlers.size() > 1) {
            this.throwQVTException(new QvtRuntimeException(NLS.bind(EvaluationMessages.AmbiguousBlackboxOperationFound, QvtOperationalParserUtil.safeGetMappingQualifiedName(this.getOperationalEnv(), operation))));
        }
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        return handlers.iterator().next().invoke(evalEnv.getThisOfType(QvtOperationalParserUtil.getOwningModule(operation)), evalEnv.getOperationSelf(), evalEnv.getOperationArgs().toArray(), evalEnv);
    }

    @Override
    public Object visitLibrary(Library library) {
        return null;
    }

    public Object visitLocalProperty(EStructuralFeature property) {
        org.eclipse.ocl.expressions.OCLExpression<EClassifier> initExp = QvtOperationalParserUtil.getInitExpression(property);
        if (initExp != null) {
            return this.visitExpression(initExp);
        }
        return null;
    }

    @Override
    public Object visitContextualProperty(ContextualProperty contextualProperty) {
        if (contextualProperty.getInitExpression() != null) {
            return this.visitExpression((org.eclipse.ocl.expressions.OCLExpression)contextualProperty.getInitExpression());
        }
        return null;
    }

    private boolean isWhenPreconditionSatisfied(MappingOperation mappingOperation) {
        for (org.eclipse.ocl.expressions.OCLExpression nextCond : mappingOperation.getWhen()) {
            if (Boolean.TRUE.equals(this.visitExpression(nextCond))) continue;
            return false;
        }
        return true;
    }

    private boolean isWherePreconditionSatisfied(MappingOperation mappingOperation) {
        if (!(mappingOperation.getWhere() instanceof BlockExp)) {
            return true;
        }
        for (org.eclipse.ocl.expressions.OCLExpression nextCond : ((BlockExp)mappingOperation.getWhere()).getBody()) {
            if (Boolean.TRUE.equals(this.visitExpression(nextCond))) continue;
            return false;
        }
        return true;
    }

    private void setupInitialResultValue(MappingBody mappingBody) {
        ImperativeOperation operation = mappingBody.getOperation();
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        for (VarParameter resultParam : operation.getResult()) {
            if (evalEnv.getValueOf(resultParam.getName()) != null) continue;
            Object initialValue = EvaluationUtil.createInitialValue(resultParam.getEType(), (OCLStandardLibrary<EClassifier>)this.getStandardLibrary(), (EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject>)evalEnv);
            this.replaceInEnv(resultParam.getName(), initialValue, resultParam.getEType());
        }
        if (operation.getResult().size() > 1 && evalEnv.getValueOf("result") == null) {
            Object initialValue = EvaluationUtil.createInitialValue(operation.getEType(), (OCLStandardLibrary<EClassifier>)this.getStandardLibrary(), (EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject>)evalEnv);
            this.replaceInEnv("result", initialValue, operation.getEType());
        }
    }

    @Override
    public Object visitMappingBody(MappingBody mappingBody) {
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        MappingOperation currentMappingCalled = (MappingOperation)mappingBody.getOperation();
        this.setupInitialResultValue(mappingBody);
        for (org.eclipse.ocl.expressions.OCLExpression initExp : mappingBody.getInitSection()) {
            this.visitExpression(initExp);
        }
        if (!mappingBody.getInitSection().isEmpty()) {
            this.setCurrentEnvInstructionPointer((EObject)currentMappingCalled);
        }
        Object result = this.createOrGetResult(currentMappingCalled);
        this.createOutParams(currentMappingCalled);
        this.setOutParamsValues(currentMappingCalled, this.myEvalEnv.getOperationArgs());
        TraceUtil.addTraceRecord(this.getOperationalEvaluationEnv(), currentMappingCalled);
        if (!currentMappingCalled.getInherited().isEmpty()) {
            for (MappingOperation extendedMapping : currentMappingCalled.getInherited()) {
                ImperativeOperation overridingOper = EvaluationUtil.getOverridingOperation(this.getOperationalEvaluationEnv(), extendedMapping);
                if (overridingOper instanceof MappingOperation) {
                    extendedMapping = (MappingOperation)overridingOper;
                }
                this.executeImperativeOperation(extendedMapping, evalEnv.getOperationSelf(), evalEnv.getOperationArgs(), true);
            }
        }
        this.visitOperationBody(mappingBody);
        for (org.eclipse.ocl.expressions.OCLExpression endExp : mappingBody.getEndSection()) {
            this.visitExpression(endExp);
        }
        this.callMergedMappings(currentMappingCalled, evalEnv);
        return result;
    }

    private void callMergedMappings(MappingOperation mappingOperation, QvtOperationalEvaluationEnv evalEnv) {
        for (MappingOperation extendedMapping : mappingOperation.getMerged()) {
            ImperativeOperation overridingOper = EvaluationUtil.getOverridingOperation(this.getOperationalEvaluationEnv(), extendedMapping);
            if (overridingOper instanceof MappingOperation) {
                extendedMapping = (MappingOperation)overridingOper;
            }
            this.executeImperativeOperation(extendedMapping, evalEnv.getOperationSelf(), evalEnv.getOperationArgs(), true);
        }
    }

    @Override
    public Object visitMappingCallExp(MappingCallExp mappingCallExp) {
        return this.visitOperationCallExp((OperationCallExp<EClassifier, EOperation>)mappingCallExp);
    }

    public Object visitOperationCallExp(OperationCallExp<EClassifier, EOperation> operationCallExp) {
        EObject oldIP = this.setCurrentEnvInstructionPointer((EObject)operationCallExp);
        Object result = this.doVisitOperationCallExp(operationCallExp);
        this.setCurrentEnvInstructionPointer(oldIP);
        return result;
    }

    protected Object doVisitOperationCallExp(OperationCallExp<EClassifier, EOperation> operationCallExp) {
        EOperation referredOperation = (EOperation)operationCallExp.getReferredOperation();
        boolean isImperative = QvtOperationalUtil.isImperativeOperation(referredOperation);
        if (isImperative && !CallHandler.Access.hasHandler(referredOperation)) {
            EOperation actualOperation;
            Object source = this.visitExpression(operationCallExp.getSource());
            if (((ImperativeOperation)referredOperation).getContext() != null) {
                source = this.doImplicitListCoercion(((ImperativeOperation)referredOperation).getContext().getEType(), source);
            }
            List<Object> args = this.makeArgs(operationCallExp);
            if (source == this.getInvalid()) {
                return source;
            }
            ImperativeOperation method = null;
            if (QvtOperationalParserUtil.isOverloadableMapping(referredOperation, this.getOperationalEnv()) && (actualOperation = this.findOperationByActualSourceType(source, referredOperation)) instanceof ImperativeOperation) {
                method = (ImperativeOperation)actualOperation;
            }
            if (method == null && referredOperation instanceof ImperativeOperation) {
                method = (ImperativeOperation)referredOperation;
            }
            if (method != null) {
                ImperativeOperation overridingOper;
                ImperativeCallExp imperativeCall;
                if (QvtOperationalParserUtil.isContextual(method) && source == null && QvtOperationalParserUtil.getContextualType(method) != this.getStandardLibrary().getOclVoid()) {
                    return this.getInvalid();
                }
                if (operationCallExp instanceof ImperativeCallExp && (imperativeCall = (ImperativeCallExp)operationCallExp).isIsVirtual() && (overridingOper = EvaluationUtil.getOverridingOperation(this.getOperationalEvaluationEnv(), method)) != null) {
                    method = overridingOper;
                }
                OperationCallResult opResult = this.executeImperativeOperation(method, source, args, false);
                if (operationCallExp instanceof MappingCallExp && opResult instanceof MappingCallResult && method instanceof MappingOperation) {
                    if (((MappingCallExp)operationCallExp).isIsStrict() && ((MappingCallResult)opResult).isPreconditionFailed()) {
                        this.throwQVTException(new QvtAssertionFailed(NLS.bind(EvaluationMessages.MappingPreconditionFailed, method.getName())));
                    }
                    this.retrieveOutArgs(operationCallExp, ((MappingCallResult)opResult).myEvalEnv.getOperationArgs(), (MappingOperation)method);
                }
                return this.doImplicitListCoercion(referredOperation.getEType(), opResult.myResult);
            }
        }
        Object result = null;
        try {
            result = super.visitOperationCallExp(operationCallExp);
        }
        catch (QvtRuntimeException e) {
            throw e;
        }
        catch (RuntimeException ex) {
            result = this.getInvalid();
        }
        return result;
    }

    private EOperation findOperationByActualSourceType(Object source, EOperation referredOperation) {
        EClassifier sourceEClass;
        EOperation actualOperation = referredOperation;
        IVirtualOperationTable vTable = this.getVirtualTable(referredOperation);
        if (vTable != null && (sourceEClass = (EClassifier)this.getEvaluationEnvironment().getType(source)) != null) {
            InternalEvaluationEnv internEnv = this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class);
            EOperation oper = vTable.lookupActualOperation(sourceEClass, (Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject>)this.getEnvironment(), internEnv);
            if (oper != null) {
                actualOperation = oper;
            }
        }
        return actualOperation;
    }

    private Object doImplicitListCoercion(EClassifier declaredType, Object actualValue) {
        if (declaredType instanceof CollectionType && actualValue instanceof Collection) {
            if (declaredType.eClass() == ImperativeOCLPackage.eINSTANCE.getListType() && !(actualValue instanceof MutableList)) {
                Collection newCollection = EvaluationUtil.createNewCollection((CollectionType<EClassifier, EOperation>)((CollectionType)declaredType));
                newCollection.addAll((Collection)actualValue);
                return newCollection;
            }
            if (declaredType.eClass() == EcorePackage.eINSTANCE.getSequenceType() && actualValue instanceof MutableList) {
                Collection newCollection = EvaluationUtil.createNewCollection((CollectionType<EClassifier, EOperation>)((CollectionType)declaredType));
                newCollection.addAll((Collection)actualValue);
                return newCollection;
            }
        }
        return actualValue;
    }

    public Object visitEnumLiteralExp(EnumLiteralExp<EClassifier, EEnumLiteral> el) {
        return ((EEnumLiteral)el.getReferredEnumLiteral()).getInstance();
    }

    @Override
    public Object visitMappingOperation(MappingOperation mappingOperation) {
        this.visitImperativeOperation(mappingOperation);
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        if (!this.isWhenPreconditionSatisfied(mappingOperation)) {
            return new MappingCallResult(null, evalEnv, 2);
        }
        MappingCallResult result = this.executeMappingBody(mappingOperation, evalEnv);
        if (!this.isWherePreconditionSatisfied(mappingOperation)) {
            this.throwQVTException(new QvtAssertionFailed(NLS.bind(EvaluationMessages.MappingPostconditionFailed, mappingOperation.getName())));
        }
        return result;
    }

    protected MappingCallResult executeMappingBody(MappingOperation mappingOperation, QvtOperationalEvaluationEnv evalEnv) {
        TraceRecord traceRecord = TraceUtil.getTraceRecord(evalEnv, mappingOperation);
        if (traceRecord != null) {
            return new MappingCallResult(TraceUtil.fetchResultFromTrace(evalEnv, traceRecord), evalEnv, 4);
        }
        if (!mappingOperation.getDisjunct().isEmpty()) {
            return this.dispatchDisjunctMapping(mappingOperation);
        }
        if (mappingOperation.isIsBlackbox()) {
            Object result = this.doVisitBlackboxOperation(mappingOperation);
            if (this.isUndefined(result)) {
                this.throwQVTException(new QvtRuntimeException(NLS.bind(EvaluationMessages.BlackboxMappingFailedToAssignResult, QvtOperationalParserUtil.safeGetMappingQualifiedName(this.getOperationalEnv(), mappingOperation))));
            }
            this.replaceInEnv("result", result, mappingOperation.getEType());
            TraceUtil.addTraceRecord(this.getOperationalEvaluationEnv(), mappingOperation);
            this.callMergedMappings(mappingOperation, evalEnv);
            return new MappingCallResult(result, evalEnv, 0);
        }
        return new MappingCallResult(((OperationBodyImpl)mappingOperation.getBody()).accept(this.getVisitor()), evalEnv, 0);
    }

    @Override
    public Object execute(OperationalTransformation transformation) throws QvtRuntimeException {
        try {
            Object object = this.doVisitTransformation(transformation);
            return object;
        }
        finally {
            IntermediatePropertyModelAdapter.cleanup(transformation);
            this.getOperationalEvaluationEnv().cleanup();
        }
    }

    @Override
    public Object visitModule(Module module) {
        if (!(module instanceof OperationalTransformation)) {
            throw new IllegalArgumentException(NLS.bind(EvaluationMessages.ExtendedOclEvaluatorVisitorImpl_ModuleNotExecutable, module.getName()));
        }
        try {
            Object object = this.doVisitTransformation((OperationalTransformation)module);
            return object;
        }
        catch (QvtRuntimeException e) {
            StringWriter strWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(strWriter);
            e.printQvtStackTrace(printWriter);
            Log logger = this.getContext().getLog();
            logger.log(EvaluationMessages.TerminatingExecution);
            logger.log(strWriter.getBuffer().toString());
            throw e;
        }
        finally {
            IntermediatePropertyModelAdapter.cleanup(module);
            this.getOperationalEvaluationEnv().cleanup();
        }
    }

    public Object executeHelperOperation(Helper method, Object self, List<Object> args) {
        Helper actualHelper = method;
        EOperation actualOperation = this.findOperationByActualSourceType(self, method);
        if (!(actualOperation instanceof Helper)) {
            return this.getEvaluationEnvironment().callOperation((Object)method, -1, self, args.toArray(new Object[args.size()]));
        }
        actualHelper = (Helper)actualOperation;
        OperationCallResult result = this.executeImperativeOperation(actualHelper, self, args, false);
        return result.myResult;
    }

    public Object visitInstantiationExp(InstantiationExp objectExp) {
        EClass _class = objectExp.getInstantiatedClass();
        if (_class instanceof OperationalTransformation) {
            EList formalArguments = objectExp.getArgument();
            ArrayList<ModelInstance> actualArguments = new ArrayList<ModelInstance>(formalArguments.size());
            for (org.eclipse.ocl.expressions.OCLExpression nextArg : formalArguments) {
                Object argVal = this.visitExpression(nextArg);
                if (!(argVal instanceof ModelInstance)) {
                    this.throwQVTException(new QvtRuntimeException(EvaluationMessages.QvtOperationalEvaluationVisitorImpl_UndefModelParamInTransf));
                }
                ModelInstance modelInstance = (ModelInstance)argVal;
                actualArguments.add(modelInstance);
            }
            OperationalTransformation targetTransf = (OperationalTransformation)_class;
            QvtOperationalEvaluationEnv currentEnv = this.getOperationalEvaluationEnv();
            Context nestedContext = EvaluationUtil.createAggregatedContext(currentEnv);
            QvtOperationalEnvFactory envFactory = this.getOperationalEnv().getFactory();
            QvtOperationalEvaluationEnv nestedEvalEnv = envFactory.createEvaluationEnvironment(nestedContext, null);
            Trace trace = currentEnv.getAdapter(InternalEvaluationEnv.class).getTraces();
            nestedEvalEnv.getAdapter(InternalEvaluationEnv.class).setTraces(trace);
            nestedEvalEnv.getOperationArgs().addAll(actualArguments);
            InternalEvaluator nestedVisitor = this.createNestedEvaluationVisitor(this, nestedEvalEnv);
            try {
                this.setOperationalEvaluationEnv(nestedEvalEnv);
                ModuleInstance moduleInstance = nestedVisitor.callTransformationImplicitConstructor(targetTransf, actualArguments);
                CallHandler handler = null;
                handler = targetTransf.isIsBlackbox() ? this.createBlackboxTransformationHandler(nestedVisitor) : QvtOperationalEvaluationVisitorImpl.createEntryOperationHandler(nestedVisitor);
                moduleInstance.getAdapter(TransformationInstance.InternalTransformation.class).setTransformationHandler(handler);
                ModuleInstance moduleInstance2 = moduleInstance;
                return moduleInstance2;
            }
            finally {
                this.setOperationalEvaluationEnv(currentEnv);
            }
        }
        Object owner = this.createInstance((EClassifier)objectExp.getType(), (ModelParameter)objectExp.getExtent());
        EList formalArguments = objectExp.getArgument();
        ArrayList<Object> actualArguments = new ArrayList<Object>(formalArguments.size());
        for (org.eclipse.ocl.expressions.OCLExpression nextArg : formalArguments) {
            Object argVal = this.visitExpression(nextArg);
            actualArguments.add(argVal);
        }
        Adapter adapter = EcoreUtil.getAdapter((List)objectExp.eAdapters(), ConstructorOperationAdapter.class);
        if (adapter != null) {
            Constructor constructorOp = ((ConstructorOperationAdapter)adapter).getReferredConstructor();
            int i = 0;
            int in = constructorOp.getEParameters().size();
            while (i < in) {
                actualArguments.set(i, this.doImplicitListCoercion(((EParameter)constructorOp.getEParameters().get(i)).getEType(), actualArguments.get(i)));
                ++i;
            }
            this.executeImperativeOperation(constructorOp, owner, actualArguments, false);
        } else if (!objectExp.getArgument().isEmpty()) {
            if (objectExp.getEType() instanceof CollectionType && owner instanceof Collection) {
                ((Collection)owner).addAll(actualArguments);
            } else {
                this.throwQVTException(new QvtRuntimeException("Undefined constructor is called"));
            }
        }
        return owner;
    }

    @Override
    public TransformationInstance callTransformationImplicitConstructor(OperationalTransformation transformation, List<ModelInstance> transfArgs) {
        ModuleInstanceFactory eFactory = (ModuleInstanceFactory)transformation.getEFactoryInstance();
        assert (eFactory != null) : "Module class must have factory";
        TransformationInstance instance = (TransformationInstance)eFactory.create(transformation);
        this.getEvaluationEnvironment().add("this", (Object)instance);
        ModelParameterHelper modelParameters = new ModelParameterHelper(transformation, transfArgs);
        this.initModule(instance, modelParameters);
        this.setCurrentEnvInstructionPointer((EObject)transformation);
        return instance;
    }

    private Object doVisitTransformation(OperationalTransformation transformation) {
        List<Object> args;
        CallHandler handler;
        QvtOperationalEvaluationEnv evaluationEnv = this.getOperationalEvaluationEnv();
        List<ModelInstance> modelArgs = EvaluationUtil.getTransfromationModelArguments(evaluationEnv, transformation);
        ModuleInstance moduleInstance = this.callTransformationImplicitConstructor(transformation, (List)modelArgs);
        if (transformation.isIsBlackbox()) {
            handler = this.createBlackboxTransformationHandler(this);
            args = Collections.emptyList();
        } else {
            ImperativeOperation entryPoint = QvtOperationalParserUtil.getMainOperation(transformation);
            if (entryPoint == null) {
                throw new IllegalArgumentException(NLS.bind(EvaluationMessages.ExtendedOclEvaluatorVisitorImpl_ModuleNotExecutable, transformation.getName()));
            }
            handler = QvtOperationalEvaluationVisitorImpl.createEntryOperationHandler(this);
            args = this.makeEntryOperationArgs(entryPoint, transformation);
        }
        TransformationInstance.InternalTransformation internTransf = moduleInstance.getAdapter(TransformationInstance.InternalTransformation.class);
        internTransf.setTransformationHandler(handler);
        OperationCallResult callResult = (OperationCallResult)handler.invoke(null, moduleInstance, args.toArray(), evaluationEnv);
        QvtEvaluationResult evalResult = EvaluationUtil.createEvaluationResult(callResult.myEvalEnv);
        if (evalResult.getModelExtents().isEmpty()) {
            if (callResult.myResult instanceof EObject) {
                ModelParameterExtent modelParameter = new ModelParameterExtent(Collections.singletonList((EObject)callResult.myResult), null, null);
                evaluationEnv.addModelExtent(modelParameter);
                evalResult.getModelExtents().add(modelParameter.getContents());
            } else {
                return callResult.myResult;
            }
        }
        return evalResult;
    }

    private static CallHandler createEntryOperationHandler(final InternalEvaluator evaluator) {
        return new CallHandler(){

            public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
                TransformationInstance transformation = (TransformationInstance)source;
                try {
                    OperationCallResult operationCallResult = evaluator.runMainEntry(transformation.getTransformation(), Arrays.asList(args));
                    return operationCallResult;
                }
                finally {
                    transformation.getAdapter(TransformationInstance.InternalTransformation.class).dispose();
                }
            }
        };
    }

    private CallHandler createBlackboxTransformationHandler(InternalEvaluator evaluator) {
        return new CallHandler(){

            public Object invoke(ModuleInstance module, Object source, Object[] args, QvtOperationalEvaluationEnv evalEnv) {
                Collection<CallHandler> handlers;
                TransformationInstance transformation = (TransformationInstance)source;
                EcoreEnvironment moduleEnv = ASTBindingHelper.resolveEnvironment(transformation.getTransformation());
                if (!(moduleEnv instanceof QvtOperationalModuleEnv)) {
                    moduleEnv = ASTBindingHelper.getEnvironment(transformation, QvtOperationalModuleEnv.class);
                }
                if ((handlers = BlackboxRegistry.INSTANCE.getBlackboxCallHandler(transformation.getTransformation(), (QvtOperationalModuleEnv)moduleEnv)).isEmpty()) {
                    QvtOperationalEvaluationVisitorImpl.this.throwQVTException(new QvtRuntimeException(NLS.bind(EvaluationMessages.NoBlackboxOperationFound, QvtOperationalParserUtil.safeGetQualifiedName(QvtOperationalEvaluationVisitorImpl.this.getOperationalEnv(), (EClassifier)transformation.getTransformation()))));
                }
                if (handlers.size() > 1) {
                    QvtOperationalEvaluationVisitorImpl.this.throwQVTException(new QvtRuntimeException(NLS.bind(EvaluationMessages.AmbiguousBlackboxOperationFound, QvtOperationalParserUtil.safeGetQualifiedName(QvtOperationalEvaluationVisitorImpl.this.getOperationalEnv(), (EClassifier)transformation.getTransformation()))));
                }
                QvtOperationalEvaluationVisitorImpl.this.evaluateModelParameterConditions(transformation.getTransformation());
                List actualArgs = QvtOperationalEvaluationVisitorImpl.this.makeBlackboxTransformationArgs(transformation, evalEnv);
                Object result = handlers.iterator().next().invoke(transformation, source, actualArgs.toArray(), evalEnv);
                return new OperationCallResult(result, evalEnv);
            }
        };
    }

    protected void processDeferredTasks() {
        InternalEvaluationEnv internalEvalEnv = this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class);
        internalEvalEnv.processDeferredTasks();
    }

    @Override
    public Object visitModuleImport(ModuleImport moduleImport) {
        return null;
    }

    @Override
    public Object visitObjectExp(ObjectExp objectExp) {
        InternalEvaluationEnv internEnv = this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class);
        internEnv.setCurrentIP((EObject)objectExp);
        Object owner = this.getOutOwner(objectExp);
        if (objectExp.getBody() != null) {
            EList<OCLExpression> contents = objectExp.getBody().getContent();
            for (org.eclipse.ocl.expressions.OCLExpression exp : contents) {
                this.visitExpression(exp);
            }
        }
        owner = this.getOutOwner(objectExp);
        if (this.getOperationalEnv().isTemporaryElement(objectExp.getName())) {
            this.getOperationalEvaluationEnv().remove(objectExp.getName());
        }
        return owner;
    }

    public Object visitReturnExp(ReturnExp returnExp) {
        EList<OCLExpression> content;
        OperationBody body;
        Object value = null;
        OCLExpression valueExp = returnExp.getValue();
        if (valueExp != null) {
            value = this.visitExpression((org.eclipse.ocl.expressions.OCLExpression)valueExp);
        }
        if ((body = QvtOperationalParserUtil.findParentElement(returnExp, OperationBody.class)) != null && !(content = body.getContent()).isEmpty() && content.get(content.size() - 1) == returnExp) {
            return value;
        }
        throw new ReturnExpEvent(value, this.getOperationalEvaluationEnv());
    }

    @Override
    public Object visitOperationBody(OperationBody operationBody) {
        Object result = null;
        for (org.eclipse.ocl.expressions.OCLExpression exp : operationBody.getContent()) {
            result = this.visitExpression(exp);
        }
        ImperativeOperation operation = operationBody.getOperation();
        if (operation.getEType() == this.getStandardLibrary().getOclVoid()) {
            result = null;
        }
        if (operation.getResult().size() > 1) {
            return this.createTupleResult(operation);
        }
        return result;
    }

    @Override
    public Object visitVarParameter(VarParameter varParameter) {
        return null;
    }

    public Object visitVariableInitExp(VariableInitExp variableInitExp) {
        Variable referredVariable = variableInitExp.getReferredVariable();
        org.eclipse.ocl.expressions.OCLExpression initExpression = referredVariable.getInitExpression();
        Object value = null;
        value = initExpression != null ? this.visitExpression(initExpression) : EvaluationUtil.createInitialValue((EClassifier)referredVariable.getType(), (OCLStandardLibrary<EClassifier>)this.getEnvironment().getOCLStandardLibrary(), this.getEvaluationEnvironment());
        this.replaceInEnv(referredVariable.getName(), value, (EClassifier)variableInitExp.getType());
        return variableInitExp.isWithResult() ? value : null;
    }

    public Object visitBlockExp(BlockExp blockExp) {
        return this.visitBlockExpImpl((EList<OCLExpression>)blockExp.getBody(), blockExp.eContainer() instanceof ImperativeOperation);
    }

    private Object visitBlockExpImpl(EList<OCLExpression> expList, boolean isInImperativeOper) {
        LinkedList<String> scopeVars = null;
        for (org.eclipse.ocl.expressions.OCLExpression exp : expList) {
            if (exp instanceof VariableInitExp && !isInImperativeOper) {
                if (scopeVars == null) {
                    scopeVars = new LinkedList<String>();
                }
                VariableInitExp varInitExp = (VariableInitExp)exp;
                scopeVars.add(varInitExp.getName());
            }
            this.visitExpression(exp);
        }
        if (scopeVars != null) {
            EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject> evalEnv = this.getEvaluationEnvironment();
            for (String varName : scopeVars) {
                evalEnv.remove(varName);
            }
        }
        return null;
    }

    public Object visitComputeExp(ComputeExp computeExp) {
        Variable returnedElement = computeExp.getReturnedElement();
        Object initExpressionValue = null;
        org.eclipse.ocl.expressions.OCLExpression initExpression = returnedElement.getInitExpression();
        if (initExpression != null) {
            initExpressionValue = this.visitExpression(initExpression);
        }
        this.replaceInEnv(returnedElement.getName(), initExpressionValue, (EClassifier)returnedElement.getType());
        this.visitExpression((org.eclipse.ocl.expressions.OCLExpression)computeExp.getBody());
        return this.getEvaluationEnvironment().remove(returnedElement.getName());
    }

    public Object visitWhileExp(WhileExp whileExp) {
        Object condition;
        while (Boolean.TRUE.equals(condition = this.visitExpression((org.eclipse.ocl.expressions.OCLExpression)whileExp.getCondition()))) {
            try {
                this.visitExpression((org.eclipse.ocl.expressions.OCLExpression)whileExp.getBody());
            }
            catch (QvtTransitionReachedException ex) {
                if (ex.getReason() == 1) break;
                if (ex.getReason() != 2) continue;
            }
        }
        return null;
    }

    public Object visitAltExp(AltExp switchAltExp) {
        SwitchAltExpResult result = new SwitchAltExpResult();
        result.myCondition = this.visitExpression((org.eclipse.ocl.expressions.OCLExpression)switchAltExp.getCondition());
        if (Boolean.TRUE.equals(result.myCondition)) {
            result.myResult = this.visitExpression((org.eclipse.ocl.expressions.OCLExpression)switchAltExp.getBody());
        }
        return result;
    }

    public Object visitSwitchExp(SwitchExp switchExp) {
        for (AltExp altExp : switchExp.getAlternativePart()) {
            Object altResult = this.visitExpression((org.eclipse.ocl.expressions.OCLExpression)altExp);
            if (altResult instanceof SwitchAltExpResult) {
                if (!Boolean.TRUE.equals(((SwitchAltExpResult)altResult).myCondition)) continue;
                return ((SwitchAltExpResult)altResult).myResult;
            }
            if (!Boolean.TRUE.equals(altResult)) continue;
            return null;
        }
        OCLExpression elsePart = switchExp.getElsePart();
        if (elsePart != null) {
            return this.visitExpression((org.eclipse.ocl.expressions.OCLExpression)elsePart);
        }
        return null;
    }

    @Override
    public Object visitResolveExp(ResolveExp resolveExp) {
        InternalEvaluationEnv internalEvalEnv;
        if (resolveExp.isIsDeferred() && !(internalEvalEnv = this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class)).isDeferredExecution()) {
            LateResolveTask lateResolveTask = new LateResolveTask(resolveExp, internalEvalEnv.getLastAssignmentLvalueEval(), (QvtOperationalEvaluationVisitor)this.getVisitor(), this.getOperationalEvaluationEnv(), this);
            internalEvalEnv.addDeferredTask(lateResolveTask);
            return null;
        }
        return QvtResolveUtil.resolveNow(resolveExp, this, this.getOperationalEvaluationEnv());
    }

    @Override
    public Object visitResolveInExp(ResolveInExp resolveInExp) {
        InternalEvaluationEnv internalEvalEnv;
        if (resolveInExp.isIsDeferred() && !(internalEvalEnv = this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class)).isDeferredExecution()) {
            LateResolveInTask lateResolveInTask = new LateResolveInTask(resolveInExp, internalEvalEnv.getLastAssignmentLvalueEval(), (QvtOperationalEvaluationVisitor)this.getVisitor(), this.getOperationalEvaluationEnv(), (DeferredAssignmentListener)this);
            internalEvalEnv.addDeferredTask(lateResolveInTask);
            return null;
        }
        return QvtResolveUtil.resolveInNow(resolveInExp, this, this.getOperationalEvaluationEnv());
    }

    @Override
    public Object visitModelType(ModelType modelType) {
        return null;
    }

    public Object visitLogExp(LogExp logExp) {
        this.doVisitLogExp(logExp, this.getContext().getLog(), null);
        return null;
    }

    private String doVisitLogExp(LogExp logExp, Log logger, String messagePrefix) {
        Object message;
        if (logExp.getCondition() != null && !Boolean.TRUE.equals(this.visitExpression((org.eclipse.ocl.expressions.OCLExpression)logExp.getCondition()))) {
            return null;
        }
        Object invalid = this.getInvalid();
        String invalidRepr = "<Invalid>";
        Integer level = null;
        EList args = logExp.getArgument();
        if (args.size() > 2) {
            Object levelObj = this.visitExpression((org.eclipse.ocl.expressions.OCLExpression)args.get(2));
            level = NumberConversions.strictConvertNumber(levelObj, Integer.class);
        }
        if ((message = this.visitExpression((org.eclipse.ocl.expressions.OCLExpression)args.get(0))) == null) {
            message = "<null>";
        } else if (message == invalid) {
            message = invalidRepr;
        }
        Object logEntry = message;
        if (messagePrefix != null) {
            logEntry = String.valueOf(messagePrefix) + " : " + message;
        }
        Object element = null;
        Object formatedElement = null;
        if (args.size() > 1) {
            element = this.visitExpression((org.eclipse.ocl.expressions.OCLExpression)args.get(1));
            formatedElement = element == invalid ? invalidRepr : EvaluationUtil.formatLoggedElement(element);
        }
        if (level == null) {
            if (element == null) {
                logger.log(String.valueOf(logEntry));
            } else {
                logger.log(String.valueOf(logEntry), formatedElement);
            }
        } else if (element == null) {
            logger.log(level, String.valueOf(logEntry));
        } else {
            logger.log(level, String.valueOf(logEntry), formatedElement);
        }
        return message.toString();
    }

    public Object visitAssertExp(AssertExp assertExp) {
        Object assertionValue = this.visitExpression((org.eclipse.ocl.expressions.OCLExpression)assertExp.getAssertion());
        if (!Boolean.TRUE.equals(assertionValue)) {
            InternalEvaluationEnv internEvalEnv = this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class);
            Module currentModule = internEvalEnv.getCurrentModule().getModule();
            IModuleSourceInfo moduleSource = ASTBindingHelper.getModuleSourceBinding(currentModule);
            String source = moduleSource != null ? moduleSource.getSourceURI().lastSegment() : EvaluationMessages.UknownSourceLabel;
            StringBuilder locationBuf = new StringBuilder(source);
            if (assertExp.getStartPosition() >= 0 && moduleSource != null) {
                int lineNum = moduleSource.getLineNumberProvider().getLineNumber(assertExp.getStartPosition());
                locationBuf.append(':').append(lineNum);
            }
            String message = NLS.bind(EvaluationMessages.AssertFailedMessage, assertExp.getSeverity(), locationBuf.toString());
            Log logger = this.getContext().getLog();
            String logMessage = null;
            if (assertExp.getLog() != null) {
                logMessage = this.doVisitLogExp(assertExp.getLog(), logger, message);
            } else {
                logger.log(message);
            }
            if (SeverityKind.FATAL.equals((Object)assertExp.getSeverity())) {
                String msg = logMessage == null ? EvaluationMessages.FatalAssertionFailed : logMessage;
                this.throwQVTException(new QvtAssertionFailed(msg));
            }
        }
        return null;
    }

    public Object visitImperativeLoopExp(ImperativeLoopExp imperativeLoopExp) {
        throw new UnsupportedOperationException();
    }

    public Object visitForExp(ForExp forExp) {
        Object sourceValue = this.visitExpression(forExp.getSource());
        if (!this.isUndefined(sourceValue)) {
            String resultName = QvtOperationalEvaluationVisitorImpl.generateName();
            this.getEvaluationEnvironment().add(resultName, null);
            Collection sourceCollection = (Collection)sourceValue;
            EList iterators = forExp.getIterator();
            OCLExpression condition = forExp.getCondition();
            org.eclipse.ocl.expressions.OCLExpression body = forExp.getBody();
            QvtIterationTemplateForExp.getInstance(this.getVisitor()).evaluate(sourceCollection, iterators, (org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)null, condition, body, resultName, "forOne".equals(forExp.getName()));
            this.getEvaluationEnvironment().remove(resultName);
        }
        return null;
    }

    public Object visitImperativeIterateExp(ImperativeIterateExp imperativeIterateExp) {
        EClassifier sourceType = (EClassifier)imperativeIterateExp.getSource().getType();
        if (sourceType instanceof PredefinedType) {
            Object sourceValue = this.visitExpression(imperativeIterateExp.getSource());
            if (this.isUndefined(sourceValue)) {
                return this.getInvalid();
            }
            CollectionType collType = (CollectionType)imperativeIterateExp.getSource().getType();
            Bag initResultVal = null;
            if (imperativeIterateExp.getName().equals("xselect")) {
                initResultVal = EvaluationUtil.createNewCollectionOfSameKind((Collection)sourceValue);
            } else if (imperativeIterateExp.getName().equals("xcollect") || imperativeIterateExp.getName().equals("collectselect")) {
                initResultVal = collType instanceof SetType || collType instanceof BagType ? CollectionUtil.createNewBag() : CollectionUtil.createNewSequence();
            }
            String resultName = QvtOperationalEvaluationVisitorImpl.generateName();
            this.getEvaluationEnvironment().add(resultName, (Object)initResultVal);
            Collection sourceCollection = (Collection)sourceValue;
            EList iterators = imperativeIterateExp.getIterator();
            Variable target = imperativeIterateExp.getTarget();
            OCLExpression condition = imperativeIterateExp.getCondition();
            org.eclipse.ocl.expressions.OCLExpression body = imperativeIterateExp.getBody();
            Object result = null;
            if ("xcollect".equals(imperativeIterateExp.getName())) {
                result = QvtIterationTemplateXCollect.getInstance(this.getVisitor()).evaluate(sourceCollection, iterators, (org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)target, condition, body, resultName, false);
            } else if ("xselect".equals(imperativeIterateExp.getName())) {
                result = QvtIterationTemplateXSelect.getInstance(this.getVisitor()).evaluate(sourceCollection, iterators, (org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)target, condition, body, resultName, false);
            } else if ("collectselect".equals(imperativeIterateExp.getName())) {
                result = QvtIterationTemplateCollectSelect.getInstance(this.getVisitor()).evaluate(sourceCollection, iterators, (org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)target, condition, body, resultName, false);
            } else if ("collectOne".equals(imperativeIterateExp.getName())) {
                result = QvtIterationTemplateXCollect.getInstance(this.getVisitor()).evaluate(sourceCollection, iterators, (org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)target, condition, body, resultName, true);
            } else if ("selectOne".equals(imperativeIterateExp.getName())) {
                result = QvtIterationTemplateXSelect.getInstance(this.getVisitor()).evaluate(sourceCollection, iterators, (org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)target, condition, body, resultName, true);
            } else if ("collectselectOne".equals(imperativeIterateExp.getName())) {
                result = QvtIterationTemplateCollectSelect.getInstance(this.getVisitor()).evaluate(sourceCollection, iterators, (org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)target, condition, body, resultName, true);
            }
            this.getEvaluationEnvironment().remove(resultName);
            return result;
        }
        String message = NLS.bind(EvaluationMessages.IteratorNotImpl, imperativeIterateExp.getName());
        throw new UnsupportedOperationException(message);
    }

    @Override
    public Object visitConstructor(Constructor constructor) {
        this.visitImperativeOperation(constructor);
        QvtOperationalEvaluationEnv env = this.getOperationalEvaluationEnv();
        if (constructor.isIsBlackbox()) {
            Object result = this.doVisitBlackboxOperation(constructor);
            return new OperationCallResult(result, env);
        }
        env.add("result", env.remove("self"));
        return new OperationCallResult(this.visitOperationBody(constructor.getBody()), env);
    }

    @Override
    public Object visitConstructorBody(ConstructorBody constructorBody) {
        return this.visitOperationBody(constructorBody);
    }

    public Object visitBreakExp(BreakExp astNode) {
        throw new QvtTransitionReachedException(1);
    }

    public Object visitCatchtExp(CatchExp astNode) {
        return null;
    }

    public Object visitContinueExp(ContinueExp astNode) {
        throw new QvtTransitionReachedException(2);
    }

    public Object visitDictLiteralPart(DictLiteralPart astNode) {
        return null;
    }

    public Object visitOrderedTupleLiteralExp(OrderedTupleLiteralExp astNode) {
        return null;
    }

    public Object visitOrderedTupleLiteralPart(OrderedTupleLiteralPart astNode) {
        return null;
    }

    public Object visitRaiseExp(RaiseExp raiseExp) {
        Object value = null;
        if (raiseExp.getArgument() != null) {
            value = this.visitExpression((org.eclipse.ocl.expressions.OCLExpression)raiseExp.getArgument());
        }
        String argument = value instanceof String ? (String)value : null;
        QvtException exception = new QvtException(argument, (EClass)raiseExp.getException());
        exception.setStackQvtTrace(new QvtStackTraceBuilder(this.getOperationalEvaluationEnv()).buildStackTrace());
        throw exception;
    }

    /*
     * Unable to fully structure code
     */
    public Object visitTryExp(TryExp tryExp) {
        try {
            return this.visitBlockExpImpl((EList<OCLExpression>)tryExp.getTryBody(), tryExp.eContainer() instanceof ImperativeOperation);
        }
        catch (QvtException exception) {
            processed = false;
            ** for (catchExp : tryExp.getExceptClause())
        }
lbl-1000:
        // 2 sources

        {
            for (EClassifier excType : catchExp.getException()) {
                if (!EmfUtil.isAssignableFrom((EClassifier)excType, (EClassifier)exception.getExceptionType())) continue;
                processed = this.processCatch(catchExp, exception);
                break block2;
            }
            if (!catchExp.getException().isEmpty()) continue;
            processed = this.processCatch(catchExp, exception);
            break;
        }
lbl13:
        // 3 sources

        if (!processed) {
            throw exception;
        }
        return null;
    }

    private boolean processCatch(CatchExp catchExp, QvtException exception) {
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        String varName = null;
        Variable catchVariable = ASTBindingHelper.getCatchVariable(catchExp);
        if (catchVariable != null) {
            ExceptionInstance excObject = null;
            if (exception.getExceptionType().getEPackage() == QvtOperationalStdLibrary.INSTANCE.getStdLibModule()) {
                excObject = QvtOperationalStdLibrary.INSTANCE.getStdlibFactory().createException(exception.getExceptionType(), exception.getMessage(), exception.getQvtStackTrace());
            } else {
                IntermediateClassFactory.ExceptionClassInstance exceptionImpl = (IntermediateClassFactory.ExceptionClassInstance)this.createInstance((EClassifier)exception.getExceptionType(), null);
                exceptionImpl.setArgument(exception.getMessage());
                exceptionImpl.setStackElements(exception.getQvtStackTrace());
                excObject = exceptionImpl;
            }
            varName = catchVariable.getName();
            evalEnv.add(varName, excObject);
        }
        this.visitBlockExpImpl((EList<OCLExpression>)catchExp.getBody(), catchExp.eContainer() instanceof ImperativeOperation);
        if (varName != null) {
            evalEnv.remove(varName);
        }
        return true;
    }

    public Object visitUnlinkExp(UnlinkExp astNode) {
        return null;
    }

    public Object visitUnpackExp(UnpackExp astNode) {
        return null;
    }

    private static synchronized String generateName() {
        return "__qvtresult__" + tempCounter++;
    }

    private void initModule(ModuleInstance moduleInstance, ModelParameterHelper modelParameters) {
        Module type = moduleInstance.getModule();
        QvtOperationalEnv env = (QvtOperationalEnv)this.getEnvironment();
        QvtOperationalEvaluationEnv currentEvalEnv = this.getOperationalEvaluationEnv();
        QvtOperationalEvaluationEnv nestedEvalEnv = (QvtOperationalEvaluationEnv)env.getFactory().createEvaluationEnvironment((EvaluationEnvironment<EClassifier, EOperation, EStructuralFeature, EClass, EObject>)this.getOperationalEvaluationEnv());
        nestedEvalEnv.add("this", moduleInstance);
        nestedEvalEnv.getOperationArgs().addAll(currentEvalEnv.getOperationArgs());
        nestedEvalEnv.getAdapter(InternalEvaluationEnv.class).setCurrentIP((EObject)type);
        try {
            this.setOperationalEvaluationEnv(nestedEvalEnv);
            this.pushedStack(nestedEvalEnv);
            EvaluationUtil.checkCurrentStackDepth(currentEvalEnv);
            this.doInitModelParams(moduleInstance, modelParameters);
            for (ModuleImport moduleImport : type.getModuleImport()) {
                ModuleInstance.Internal importedInternal;
                Module importedModule = moduleImport.getImportedModule();
                ModuleInstance importedInstance = moduleInstance.getThisInstanceOf(importedModule);
                if (importedInstance == null || (importedInternal = importedInstance.getAdapter(ModuleInstance.Internal.class)).isInitialized()) continue;
                this.initModule(importedInstance, modelParameters);
            }
            this.doInitModule(moduleInstance);
            moduleInstance.getAdapter(ModuleInstance.Internal.class).setInitialized();
        }
        finally {
            this.setOperationalEvaluationEnv(this.getOperationalEvaluationEnv().getParent());
            this.poppedStack();
        }
    }

    private void doInitModelParams(ModuleInstance moduleInstance, ModelParameterHelper modelParameters) {
        if (modelParameters != null && moduleInstance.getModule().eClass() == ExpressionsPackage.eINSTANCE.getOperationalTransformation()) {
            modelParameters.initModelParameters((TransformationInstance)moduleInstance);
        }
    }

    private void doInitModule(ModuleInstance moduleInstance) {
        Module module = moduleInstance.getModule();
        QvtOperationalEvaluationEnv env = this.getOperationalEvaluationEnv();
        for (EStructuralFeature feature : module.getConfigProperty()) {
            Object propValue = this.visitConfigProperty(feature);
            env.callSetter(moduleInstance, feature, propValue, this.isUndefined(propValue), true);
        }
        for (EStructuralFeature feature : module.getEStructuralFeatures()) {
            if (feature instanceof ContextualProperty || module.getConfigProperty().contains((Object)feature)) continue;
            this.setCurrentEnvInstructionPointer((EObject)feature);
            org.eclipse.ocl.expressions.OCLExpression<EClassifier> initExp = QvtOperationalParserUtil.getInitExpression(feature);
            Object propValue = null;
            propValue = initExp != null ? this.visitExpression(initExp) : EvaluationUtil.createInitialValue(feature.getEType(), (OCLStandardLibrary<EClassifier>)this.getEnvironment().getOCLStandardLibrary(), this.getEvaluationEnvironment());
            env.callSetter(moduleInstance, feature, propValue, this.isUndefined(propValue), true);
        }
    }

    private IVirtualOperationTable getVirtualTable(EOperation operation) {
        return IVirtualOperationTable.Access.INSTANCE.getVirtualTable(operation);
    }

    private Object createOrGetResult(MappingOperation mappingOperation) {
        Object result = null;
        for (VarParameter varParam : mappingOperation.getResult()) {
            result = this.getRuntimeValue(varParam.getName());
            if (!this.isUndefined(result) || varParam.getEType() instanceof VoidType) continue;
            result = this.createInstance(varParam.getEType(), ((MappingParameter)varParam).getExtent());
            this.replaceInEnv(varParam.getName(), result, varParam.getEType());
        }
        if (mappingOperation.getResult().size() > 1) {
            result = this.createTupleResult(mappingOperation);
            this.replaceInEnv("result", result, mappingOperation.getEType());
        } else {
            result = this.getRuntimeValue("result");
        }
        return result;
    }

    private void createOutParams(MappingOperation mappingOperation) {
        for (EParameter nextParam : mappingOperation.getEParameters()) {
            VarParameter param = (VarParameter)nextParam;
            Object paramValue = this.getRuntimeValue(param.getName());
            if (!this.isUndefined(paramValue) || param.getKind() != DirectionKind.OUT) continue;
            paramValue = this.createInstance((EClassifier)param.getType(), ((MappingParameter)param).getExtent());
            this.replaceInEnv(param.getName(), paramValue, (EClassifier)param.getType());
        }
    }

    private void createOutParamsDisjunct(MappingOperation operation, List<Object> argValues) {
        Iterator itParams = operation.getEParameters().iterator();
        Iterator<Object> itValue = argValues.iterator();
        while (itParams.hasNext()) {
            MappingParameter param = (MappingParameter)itParams.next();
            Object argValue = itValue.next();
            if (param.getKind() != DirectionKind.OUT) continue;
            this.replaceInEnv(param.getName(), argValue, (EClassifier)param.getType());
        }
    }

    private void setOutParamsValues(MappingOperation operation, List<Object> argValues) {
        Iterator itParams = operation.getEParameters().iterator();
        ListIterator<Object> itArgument = argValues.listIterator();
        while (itArgument.hasNext()) {
            MappingParameter mappingParam = (MappingParameter)itParams.next();
            itArgument.next();
            if (mappingParam.getKind() != DirectionKind.OUT) continue;
            itArgument.set(this.getRuntimeValue(mappingParam.getName()));
        }
    }

    /*
     * Exception decompiling
     */
    private OperationCallResult executeImperativeOperation(ImperativeOperation method, Object source, List<Object> args, boolean isReusingMappingCall) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private MappingCallResult dispatchDisjunctMapping(MappingOperation method) {
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        Object source = evalEnv.getOperationSelf();
        List<Object> args = evalEnv.getOperationArgs();
        for (MappingOperation nextDisjunct : method.getDisjunct()) {
            MappingCallResult result;
            EClassifier ctxType;
            ImperativeOperation overridingOper = EvaluationUtil.getOverridingOperation(this.getOperationalEvaluationEnv(), nextDisjunct);
            if (overridingOper instanceof MappingOperation) {
                nextDisjunct = (MappingOperation)overridingOper;
            }
            if ((ctxType = QvtOperationalParserUtil.getContextualType(nextDisjunct)) != null && !evalEnv.isKindOf(source, nextDisjunct.getContext().getEType()) || !this.dispatchDisjunctMappingArgumentsMatch(nextDisjunct) || (result = (MappingCallResult)this.executeImperativeOperation(nextDisjunct, source, args, false)).isPreconditionFailed()) continue;
            result.myStatus = 0;
            this.replaceInEnv("result", result.myResult, method.getEType());
            this.createOutParamsDisjunct(method, result.myEvalEnv.getOperationArgs());
            this.setOutParamsValues(method, args);
            TraceUtil.addTraceRecord(evalEnv, method);
            return result;
        }
        return new MappingCallResult(null, this.myEvalEnv, 8);
    }

    private boolean dispatchDisjunctMappingArgumentsMatch(MappingOperation disjunct) {
        EList params = disjunct.getEParameters();
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        List<Object> args = evalEnv.getOperationArgs();
        if (params.size() != args.size()) {
            return false;
        }
        int i = 0;
        while (i < args.size()) {
            Object nextArg = args.get(i);
            EClassifier nextParamType = ((EParameter)params.get(i)).getEType();
            if (nextArg != null && !evalEnv.isKindOf(nextArg, nextParamType)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected final void throwQVTException(QvtRuntimeException exception) throws QvtRuntimeException {
        this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class).throwQVTException(exception);
    }

    protected Object call(EOperation operation, org.eclipse.ocl.expressions.OCLExpression<EClassifier> body, Object target, Object[] args) {
        org.eclipse.ocl.expressions.OCLExpression<EClassifier> actualOperBody;
        EOperation actualOperation;
        EObject eTarget;
        if (target instanceof EObject && OCLAnnotationSupport.isDynamicInstance(eTarget = (EObject)target) && operation.eClass() != eTarget.eClass() && (actualOperation = this.getOCLAnnotationSupport().resolveDynamic(operation, eTarget)) != null && actualOperation != operation && (actualOperBody = this.getOperationBody(actualOperation)) != null) {
            EvaluationVisitor visitor;
            Environment myEnv = this.getEnvironment();
            EnvironmentFactory factory = myEnv.getFactory();
            EvaluationEnvironment nested = factory.createEvaluationEnvironment(this.getEvaluationEnvironment());
            nested.add("self", target);
            if (args.length > 0) {
                int i = 0;
                UMLReflection uml = myEnv.getUMLReflection();
                for (EParameter param : uml.getParameters((Object)operation)) {
                    nested.add(uml.getName((Object)param), args[i]);
                }
            }
            if ((visitor = factory.createEvaluationVisitor(myEnv, nested, this.getExtentMap())) instanceof QvtOperationalEvaluationVisitorImpl) {
                ((QvtOperationalEvaluationVisitorImpl)visitor).oclAnnotationSupport = this.getOCLAnnotationSupport();
            }
            return visitor.visitExpression(actualOperBody);
        }
        return super.call((Object)operation, body, target, args);
    }

    public Object visitCollectionLiteralExp(CollectionLiteralExp<EClassifier> cl) {
        if (cl.getType() instanceof ListType) {
            MutableListImpl<Object> result = new MutableListImpl<Object>();
            for (CollectionLiteralPart part : cl.getPart()) {
                if (part instanceof CollectionItem) {
                    CollectionItem item = (CollectionItem)part;
                    org.eclipse.ocl.expressions.OCLExpression itemExp = item.getItem();
                    Object itemVal = this.visitExpression(itemExp);
                    if (itemVal == this.getInvalid()) {
                        return this.getInvalid();
                    }
                    result.add(itemVal);
                    continue;
                }
                CollectionRange range = (CollectionRange)part;
                org.eclipse.ocl.expressions.OCLExpression first = range.getFirst();
                org.eclipse.ocl.expressions.OCLExpression last = range.getLast();
                Object firstVal = this.visitExpression(first);
                Object lastVal = this.visitExpression(last);
                if (firstVal == this.getInvalid() || lastVal == this.getInvalid()) {
                    return this.getInvalid();
                }
                if (!(firstVal instanceof Integer) || !(lastVal instanceof Integer)) continue;
                int firstInt = (Integer)firstVal;
                int lastInt = (Integer)lastVal;
                int i = firstInt;
                while (i <= lastInt) {
                    result.add(new Integer(i));
                    ++i;
                }
            }
            return result;
        }
        return super.visitCollectionLiteralExp(cl);
    }

    protected Object navigate(EStructuralFeature property, org.eclipse.ocl.expressions.OCLExpression<EClassifier> derivation, Object target) {
        Environment myEnv = this.getEnvironment();
        EnvironmentFactory factory = myEnv.getFactory();
        EvaluationEnvironment nested = factory.createEvaluationEnvironment(this.getEvaluationEnvironment());
        nested.add("self", target);
        EvaluationVisitor visitor = factory.createEvaluationVisitor(myEnv, nested, this.getExtentMap());
        if (visitor instanceof QvtOperationalEvaluationVisitorImpl) {
            ((QvtOperationalEvaluationVisitorImpl)visitor).oclAnnotationSupport = this.getOCLAnnotationSupport();
        }
        return visitor.visitExpression(derivation);
    }

    protected org.eclipse.ocl.expressions.OCLExpression<EClassifier> getPropertyBody(EStructuralFeature property) {
        if (OCLAnnotationSupport.isDynamicClassFeature(property)) {
            return this.getOCLAnnotationSupport().getDerivedProperty(property);
        }
        return super.getPropertyBody((Object)property);
    }

    protected org.eclipse.ocl.expressions.OCLExpression<EClassifier> getOperationBody(EOperation operation) {
        if (operation == null) {
            return null;
        }
        if (OCLAnnotationSupport.isDynamicClassOperation(operation)) {
            return this.getOCLAnnotationSupport().getBody(operation);
        }
        return super.getOperationBody((Object)operation);
    }

    private OCLAnnotationSupport getOCLAnnotationSupport() {
        if (this.oclAnnotationSupport == null) {
            this.oclAnnotationSupport = new OCLAnnotationSupport();
            this.oclAnnotationSupport.setErrorHandler(new OCLAnnotationSupport.ParseErrorHandler(){
                OCLExpression invalidBodyExpr = EcoreFactory.eINSTANCE.createInvalidLiteralExp();

                public OCLExpression handleError(ParserException parserException, EModelElement contextElement) {
                    QvtPlugin.error("Failed to parse OCL annotation :" + QvtOperationalEvaluationVisitorImpl.this.getUMLReflection().getQualifiedName((Object)contextElement), parserException);
                    return this.invalidBodyExpr;
                }
            });
        }
        return this.oclAnnotationSupport;
    }

    protected QvtOperationalEnv getOperationalEnv() {
        return (QvtOperationalEnv)this.getEnvironment();
    }

    @Override
    public QvtOperationalEvaluationEnv getOperationalEvaluationEnv() {
        return (QvtOperationalEvaluationEnv)this.getEvaluationEnvironment();
    }

    protected void addToEnv(String varName, Object value, EClassifier declaredType) {
        this.getOperationalEvaluationEnv().add(varName, value);
    }

    protected void replaceInEnv(String varName, Object value, EClassifier declaredType) {
        this.getOperationalEvaluationEnv().replace(varName, value);
    }

    private Object getRuntimeValue(String name) {
        return this.getEvaluationEnvironment().getValueOf(name);
    }

    private Object getOutOwner(ObjectExp objectExp) {
        Object owner = this.getRuntimeValue(objectExp.getName());
        if (owner != null) {
            if (!(objectExp.getType() instanceof CollectionType) && !this.oclIsKindOf(owner, objectExp.getType()).booleanValue()) {
                throw new RuntimeException(MessageFormat.format(EvaluationMessages.ExtendedOclEvaluatorVisitorImpl_InvalidObjectExpType, objectExp.getName(), owner, objectExp.getType()));
            }
        } else {
            owner = this.createInstance((EClassifier)objectExp.getType(), (ModelParameter)objectExp.getExtent());
            if (objectExp.getName() != null) {
                this.getOperationalEvaluationEnv().replace(objectExp.getName(), owner);
            }
        }
        return owner;
    }

    private Tuple<EOperation, EStructuralFeature> createTupleResult(ImperativeOperation operation) {
        boolean isMapping = operation.eClass() == ExpressionsPackage.eINSTANCE.getMappingOperation();
        QvtOperationalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv();
        EList<VarParameter> resultParams = operation.getResult();
        HashMap<EStructuralFeature, Object> values = new HashMap<EStructuralFeature, Object>(2);
        TupleType tupleType = (TupleType)operation.getEType();
        for (EStructuralFeature tupleProp : tupleType.oclProperties()) {
            Object propVal = evalEnv.getValueOf(tupleProp.getName());
            if (propVal == null && isMapping) {
                ModelParameter extent = null;
                for (VarParameter resultParam : resultParams) {
                    if (!tupleProp.getName().equals(resultParam.getName())) continue;
                    MappingParameter mappingParameter = (MappingParameter)resultParam;
                    extent = mappingParameter.getExtent();
                    break;
                }
                propVal = this.createInstance(tupleProp.getEType(), extent);
            }
            values.put(tupleProp, propVal);
            evalEnv.replace(tupleProp.getName(), propVal, tupleProp.getEType());
        }
        return evalEnv.createTuple(operation.getEType(), values);
    }

    private List<Object> makeArgs(OperationCallExp<EClassifier, EOperation> operationCallExp) {
        EOperation referredOperation = (EOperation)operationCallExp.getReferredOperation();
        Iterator iterParam = referredOperation.getEParameters().iterator();
        ArrayList<Object> argValues = new ArrayList<Object>();
        for (org.eclipse.ocl.expressions.OCLExpression arg : operationCallExp.getArgument()) {
            Object value = this.visitExpression(arg);
            EParameter param = (EParameter)iterParam.next();
            argValues.add(this.doImplicitListCoercion(param.getEType(), value));
        }
        return argValues;
    }

    private void retrieveOutArgs(OperationCallExp<EClassifier, EOperation> operationCallExp, List<Object> argValues, MappingOperation operation) {
        Iterator itArgument = operationCallExp.getArgument().iterator();
        Iterator itParams = operation.getEParameters().iterator();
        Iterator<Object> itValue = argValues.iterator();
        while (itArgument.hasNext()) {
            org.eclipse.ocl.expressions.OCLExpression arg = (org.eclipse.ocl.expressions.OCLExpression)itArgument.next();
            MappingParameter mappingParam = (MappingParameter)itParams.next();
            Object argValue = itValue.next();
            if (mappingParam.getKind() != DirectionKind.OUT) continue;
            if (arg instanceof VariableExp) {
                VariableExp varExp = (VariableExp)arg;
                org.eclipse.ocl.expressions.Variable referredVariable = varExp.getReferredVariable();
                if (referredVariable == null) continue;
                String varName = referredVariable.getName();
                EClassifier variableType = (EClassifier)arg.getType();
                this.replaceInEnv(varName, argValue, variableType);
                continue;
            }
            if (arg instanceof PropertyCallExp) {
                Object ownerObj = this.getAssignExpLValueOwner((org.eclipse.ocl.expressions.OCLExpression<EClassifier>)arg);
                if (!(ownerObj instanceof EObject)) continue;
                PropertyCallExp propCallExp = (PropertyCallExp)arg;
                QvtOperationalEvaluationEnv env = this.getOperationalEvaluationEnv();
                EObject oldIP = this.setCurrentEnvInstructionPointer((EObject)operationCallExp);
                env.callSetter((EObject)ownerObj, (EStructuralFeature)propCallExp.getReferredProperty(), argValue, this.isUndefined(argValue), true);
                this.setCurrentEnvInstructionPointer(oldIP);
                continue;
            }
            throw new UnsupportedOperationException("Unsupported LValue type: " + (arg == null ? null : (EClassifier)arg.getType()));
        }
    }

    private List<Object> makeEntryOperationArgs(ImperativeOperation entryPoint, OperationalTransformation module) {
        assert (!module.isIsBlackbox()) : "Non-blackbox module expected";
        ArrayList<Object> args = new ArrayList<Object>(entryPoint.getEParameters().size());
        int paramIndex = 0;
        for (EParameter param : entryPoint.getEParameters()) {
            int matchedIndex = paramIndex;
            MappingParameter mappingParam = (MappingParameter)param;
            if (mappingParam.getKind() == DirectionKind.OUT) {
                args.add(null);
                continue;
            }
            if (mappingParam.getExtent() != null) {
                int modelParamIndex = 0;
                for (ModelParameter modelParam : module.getModelParameter()) {
                    if (modelParam == mappingParam.getExtent()) {
                        matchedIndex = modelParamIndex;
                        break;
                    }
                    ++modelParamIndex;
                }
            }
            if (matchedIndex < this.getOperationalEvaluationEnv().getOperationArgs().size()) {
                Object envArg = this.getOperationalEvaluationEnv().getOperationArgs().get(matchedIndex);
                ModelInstance argModel = (ModelInstance)envArg;
                ModelParameterExtent argExtent = argModel.getExtent();
                List<EObject> initialObjects = argExtent.getInitialObjects();
                if (!initialObjects.isEmpty()) {
                    args.add(initialObjects.get(0));
                }
            } else {
                throw new IllegalArgumentException("entry operation arguments mismatch: no argument for " + mappingParam + " parameter");
            }
            ++paramIndex;
        }
        return args;
    }

    private List<Object> makeBlackboxTransformationArgs(TransformationInstance transformation, QvtOperationalEvaluationEnv evalEnv) {
        assert (transformation.getTransformation().isIsBlackbox()) : "Blackbox transformation expected";
        ArrayList<Object> actualArgs = new ArrayList<Object>();
        for (ETypedElement param : EvaluationUtil.getBlackboxSignature(transformation.getTransformation())) {
            Object arg = null;
            if (param instanceof ModelParameter) {
                ModelInstance modelInst = transformation.getModel((ModelParameter)param);
                arg = this.createJavaModelInstance(modelInst, evalEnv);
            } else if (param instanceof EStructuralFeature) {
                arg = evalEnv.navigateProperty((EStructuralFeature)param, Collections.EMPTY_LIST, transformation);
            }
            actualArgs.add(arg);
        }
        return actualArgs;
    }

    private JavaModelInstance createJavaModelInstance(ModelInstance modelInst, QvtOperationalEvaluationEnv evalEnv) {
        return new JavaModelInstance(modelInst){
            final JavaModelType modelType;
            final JavaModelExtent modelExtent;
            {
                this.modelType = new JavaModelType(){

                    @Override
                    public String getName() {
                        return modelInstance.getModelType().getName();
                    }

                    @Override
                    public List<EPackage> getMetamodels() {
                        return modelInstance.getModelType().getMetamodel();
                    }
                };
                this.modelExtent = new JavaModelExtent(){

                    @Override
                    public void removeObject(EObject obj) {
                        modelInstance.getExtent().removeElement(obj);
                    }

                    @Override
                    public List<EObject> getRootObjects() {
                        return modelInstance.getExtent().getRootObjects();
                    }

                    @Override
                    public List<Object> getAllObjects() {
                        return modelInstance.getExtent().getAllObjects();
                    }

                    @Override
                    public void addObject(EObject obj) {
                        modelInstance.getExtent().addObject(obj);
                    }
                };
            }

            public JavaModelType getType() {
                return this.modelType;
            }

            public JavaModelExtent getExtent() {
                return this.modelExtent;
            }
        };
    }

    protected Object createInstance(EClassifier type, ModelParameter extent) throws QvtRuntimeException {
        EObject newInstance = null;
        try {
            if (type instanceof CollectionType) {
                CollectionType collectionType = (CollectionType)type;
                newInstance = EvaluationUtil.createNewCollection((CollectionType<EClassifier, EOperation>)collectionType);
            } else {
                newInstance = this.getOperationalEvaluationEnv().createInstance(type, extent);
                EFactory eFactory = type.getEPackage().getEFactoryInstance();
                if (eFactory instanceof IntermediateClassFactory) {
                    IntermediateClassFactory intermFactory = (IntermediateClassFactory)eFactory;
                    intermFactory.doInstancePropertyInit(newInstance, this);
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.throwQVTException(new QvtRuntimeException(e));
        }
        return newInstance;
    }

    protected EObject setCurrentEnvInstructionPointer(EObject node) {
        InternalEvaluationEnv internEnv = this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class);
        if (node != null) {
            return internEnv.setCurrentIP(node);
        }
        return internEnv.getCurrentIP();
    }

    protected InternalEvaluator createInterruptibleVisitor() {
        IProgressMonitor monitor = this.getContext().getProgressMonitor();
        class InterruptVisitor
        extends QvtGenericVisitorDecorator.Any {
            private final /* synthetic */ IProgressMonitor val$monitor;

            public InterruptVisitor(IProgressMonitor iProgressMonitor) {
                this.val$monitor = iProgressMonitor;
                super(QvtOperationalEvaluationVisitorImpl.this);
            }

            protected Object genericVisitAny(Object object) {
                if (this.val$monitor != null && this.val$monitor.isCanceled()) {
                    QvtOperationalEvaluationVisitorImpl.this.throwQVTException(new QvtInterruptedExecutionException());
                }
                if (object instanceof EObject) {
                    InternalEvaluationEnv evalEnv = this.getOperationalEvaluationEnv().getAdapter(InternalEvaluationEnv.class);
                    evalEnv.setCurrentIP((EObject)object);
                }
                return null;
            }
        }
        return new InterruptVisitor(monitor);
    }

    @Override
    public OperationCallResult runMainEntry(OperationalTransformation transformation, List<Object> args) {
        ImperativeOperation entryOperation = QvtOperationalParserUtil.getMainOperation(transformation);
        this.evaluateModelParameterConditions(transformation);
        OperationCallResult result = this.executeImperativeOperation(entryOperation, null, args, false);
        this.processDeferredTasks();
        return result;
    }

    private void evaluateModelParameterConditions(OperationalTransformation transformation) {
        for (ModelParameter parameter : transformation.getModelParameter()) {
            if (!(parameter.getEType() instanceof ModelType) || parameter.getKind() == DirectionKind.OUT) continue;
            ModelType parameterType = (ModelType)parameter.getEType();
            for (org.eclipse.ocl.expressions.OCLExpression whereExpression : parameterType.getAdditionalCondition()) {
                this.myEvalEnv.add("self", parameter);
                boolean isConditionMet = Boolean.TRUE.equals(this.visitExpression(whereExpression));
                this.myEvalEnv.remove("self");
                if (isConditionMet) continue;
                this.throwQVTException(new QvtAssertionFailed(NLS.bind(EvaluationMessages.ModelTypeConstraintFailed, parameter.getName(), transformation.getName())));
            }
        }
    }

    private static class MappingCallResult
    extends OperationCallResult {
        static final int BODY_EXECUTED = 0;
        static final int PRECOND_FAILED = 2;
        static final int FETCHED_FROM_TRACE = 4;
        static final int NO_DISJUNCT_SELECTED = 8;
        int myStatus;

        private MappingCallResult(Object myResult, QvtOperationalEvaluationEnv myEvalEnv, int status) {
            super(myResult, myEvalEnv);
            this.myStatus = status;
        }

        boolean isBodyExecuted() {
            return this.myStatus == 0;
        }

        boolean isPreconditionFailed() {
            return (this.myStatus & 2) != 0;
        }
    }

    protected static class OperationCallResult {
        public Object myResult;
        public QvtOperationalEvaluationEnv myEvalEnv;

        OperationCallResult(Object myResult, QvtOperationalEvaluationEnv myEvalEnv) {
            this.myResult = myResult;
            this.myEvalEnv = myEvalEnv;
        }
    }

    private static class ReturnExpEvent
    extends QvtRuntimeException {
        private static final long serialVersionUID = 2971434369853642555L;
        private final OperationCallResult fResult;

        ReturnExpEvent(Object returnValue, QvtOperationalEvaluationEnv evalEnv) {
            this.fResult = new OperationCallResult(returnValue, evalEnv);
        }

        public OperationCallResult getResult() {
            return this.fResult;
        }
    }

    private static class SwitchAltExpResult {
        public Object myCondition;
        public Object myResult;

        private SwitchAltExpResult() {
        }
    }
}

