/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.qvt.oml.debug.core.vm;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.internal.qvt.oml.common.util.LineNumberProvider;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.qvt.oml.debug.core.vm.UnitManager;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMBreakpoint;
import org.eclipse.m2m.qvt.oml.debug.core.vm.ValidBreakpointLocator;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.BreakpointData;
import org.eclipse.m2m.qvt.oml.debug.core.vm.protocol.NewBreakpointData;
import org.eclipse.ocl.utilities.ASTNode;

public class VMBreakpointManager {
    private final Map<EObject, VMBreakpoint> fElement2Breakpoint;
    private final UnitManager fUnitManager;
    long fPrivateBreakpointID = 0L;

    public VMBreakpointManager(CompiledUnit mainUnit) {
        if (mainUnit == null) {
            throw new IllegalArgumentException("null main unit");
        }
        this.fUnitManager = new UnitManager(mainUnit);
        this.fElement2Breakpoint = new HashMap<EObject, VMBreakpoint>();
    }

    public UnitManager getUnitManager() {
        return this.fUnitManager;
    }

    public synchronized List<VMBreakpoint> getBreakpoints(ASTNode e) {
        VMBreakpoint breakpoint = this.fElement2Breakpoint.get(e);
        return breakpoint != null ? Collections.singletonList(breakpoint) : Collections.emptyList();
    }

    public synchronized VMBreakpoint createBreakpoint(NewBreakpointData data) {
        int line;
        ASTNode targetElement;
        URI uri = URI.createURI((String)data.targetURI);
        if (uri.isPlatformResource() && this.isPlatformDeployed()) {
            uri = URI.createPlatformPluginURI((String)uri.toPlatformString(true), (boolean)true);
        }
        if (this.fUnitManager.getCompiledModule(uri) == null) {
            uri = URI.createURI((String)URI.decode((String)uri.toString()));
        }
        if ((targetElement = this.getBreakpointableElement(uri, line = data.line)) == null) {
            return null;
        }
        VMBreakpoint vmBreakpoint = new VMBreakpoint(targetElement, data, false);
        this.fElement2Breakpoint.put((EObject)targetElement, vmBreakpoint);
        return vmBreakpoint;
    }

    public synchronized VMBreakpoint createVMPrivateBreakpoint(URI unitURI, ASTNode element, int line, boolean isTemporary) throws CoreException {
        NewBreakpointData bpData = new NewBreakpointData();
        bpData.ID = --this.fPrivateBreakpointID;
        bpData.targetURI = unitURI.toString();
        bpData.line = line;
        VMBreakpoint breakpoint = new VMBreakpoint(element, bpData, isTemporary);
        this.fElement2Breakpoint.put((EObject)element, breakpoint);
        return breakpoint;
    }

    public synchronized VMBreakpoint[] getAllBreakpoints() {
        return this.fElement2Breakpoint.values().toArray(new VMBreakpoint[this.fElement2Breakpoint.size()]);
    }

    public synchronized ASTNode getBreakpointableElement(URI targetURI, int lineNumber) {
        LineNumberProvider lineNumberProvider = this.fUnitManager.getLineNumberProvider(targetURI);
        if (lineNumberProvider == null) {
            return null;
        }
        CompiledUnit unit = this.fUnitManager.getCompiledModule(targetURI);
        List<ASTNode> elements = ValidBreakpointLocator.getBreakpointableElementsForLine(unit, lineNumberProvider, lineNumber);
        if (elements.isEmpty()) {
            return null;
        }
        return elements.get(0);
    }

    public boolean removeBreakpoint(VMBreakpoint breakpoint) {
        return this.removeBreakpoint(breakpoint.getID());
    }

    public synchronized boolean removeBreakpoint(long breakpointID) {
        for (Map.Entry<EObject, VMBreakpoint> entry : this.fElement2Breakpoint.entrySet()) {
            VMBreakpoint next = entry.getValue();
            if (breakpointID != next.getID()) continue;
            this.fElement2Breakpoint.remove(entry.getKey());
            return true;
        }
        return false;
    }

    public synchronized boolean changeBreakpoint(long breakpointID, BreakpointData data) {
        NewBreakpointData newBreakpointData = null;
        for (Map.Entry<EObject, VMBreakpoint> entry : this.fElement2Breakpoint.entrySet()) {
            VMBreakpoint next = entry.getValue();
            if (breakpointID != next.getID()) continue;
            this.fElement2Breakpoint.remove(entry.getKey());
            newBreakpointData = new NewBreakpointData(breakpointID, next.getLineNumber(), next.getUri(), data);
            break;
        }
        if (newBreakpointData != null) {
            this.createBreakpoint(newBreakpointData);
            return true;
        }
        return false;
    }

    private boolean isPlatformDeployed() {
        CompiledUnit mainUnit = this.getUnitManager().getMainUnit();
        return mainUnit.getURI().isPlatformPlugin();
    }
}

