/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.jdt.runtime.blackbox;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDECore;

public class ProjectClassLoader
extends URLClassLoader {
    private static Map<IJavaProject, ProjectClassLoader> loadersMap = new HashMap<IJavaProject, ProjectClassLoader>();

    ProjectClassLoader(IProject project) throws CoreException, MalformedURLException {
        this(JavaCore.create((IProject)project));
    }

    ProjectClassLoader(IJavaProject javaProject) throws CoreException, MalformedURLException {
        this(javaProject, new WorkspaceDependencyAnalyzer());
    }

    private ProjectClassLoader(IJavaProject javaProject, WorkspaceDependencyAnalyzer analyzer) throws CoreException, MalformedURLException {
        super(analyzer.getProjectClassPath(javaProject), analyzer.getParentClassLoader(javaProject));
        loadersMap.put(javaProject, this);
    }

    static synchronized boolean isProjectClassLoaderExisting(IJavaProject javaProject) {
        return loadersMap.containsKey(javaProject);
    }

    static synchronized ProjectClassLoader getProjectClassLoader(IProject project) throws CoreException, MalformedURLException {
        return ProjectClassLoader.getProjectClassLoader(JavaCore.create((IProject)project));
    }

    static synchronized ProjectClassLoader getProjectClassLoader(IJavaProject javaProject) throws CoreException, MalformedURLException {
        ProjectClassLoader loader = loadersMap.get(javaProject);
        if (loader == null) {
            loader = new ProjectClassLoader(javaProject);
        }
        return loader;
    }

    static synchronized void resetProjectClassLoader(IJavaProject javaProject) {
        ProjectClassLoader loader = loadersMap.get(javaProject);
        if (loader != null) {
            try {
                Method closeMethod = loader.getClass().getMethod("close", new Class[0]);
                closeMethod.invoke((Object)loader, new Object[0]);
            }
            catch (InvocationTargetException e) {
                Throwable targetException = e.getTargetException();
                if (targetException instanceof IOException) {
                    QvtPlugin.error((Throwable)e);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            loadersMap.remove(javaProject);
        }
    }

    static synchronized void resetAllProjectClassLoaders() {
        for (IJavaProject javaProject : loadersMap.keySet()) {
            ProjectClassLoader.resetProjectClassLoader(javaProject);
        }
    }

    private static List<String> getRequiredPluginLocations(IRuntimeClasspathEntry classPathEntry) throws CoreException {
        List<String> requiredPluginLocations;
        block3: {
            block2: {
                requiredPluginLocations = Collections.emptyList();
                IPath path = classPathEntry.getPath();
                if (path == null || !path.equals((Object)PDECore.REQUIRED_PLUGINS_CONTAINER_PATH)) break block2;
                IRuntimeClasspathEntry[] resolvedEntries = JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)classPathEntry, (IJavaProject)classPathEntry.getJavaProject());
                requiredPluginLocations = new ArrayList<String>(resolvedEntries.length);
                IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = resolvedEntries;
                int n = resolvedEntries.length;
                int n2 = 0;
                while (n2 < n) {
                    IRuntimeClasspathEntry resolvedEntry = iRuntimeClasspathEntryArray[n2];
                    String location = resolvedEntry.getLocation();
                    requiredPluginLocations.add(location);
                    ++n2;
                }
                break block3;
            }
            if (!(classPathEntry instanceof IRuntimeClasspathEntry2)) break block3;
            IRuntimeClasspathEntry2 compositeEntry = (IRuntimeClasspathEntry2)classPathEntry;
            IRuntimeClasspathEntry[] nestedEntries = compositeEntry.getRuntimeClasspathEntries(false);
            requiredPluginLocations = new ArrayList<String>();
            IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = nestedEntries;
            int n = nestedEntries.length;
            int n3 = 0;
            while (n3 < n) {
                IRuntimeClasspathEntry nestedEntry = iRuntimeClasspathEntryArray[n3];
                requiredPluginLocations.addAll(ProjectClassLoader.getRequiredPluginLocations(nestedEntry));
                ++n3;
            }
        }
        return requiredPluginLocations;
    }

    private static List<String> getRequiredPluginLocations(IJavaProject javaProject) throws CoreException {
        IRuntimeClasspathEntry[] entries;
        ArrayList<String> requiredPluginLocations = new ArrayList<String>();
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = entries = JavaRuntime.computeUnresolvedRuntimeClasspath((IJavaProject)javaProject);
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n2];
            requiredPluginLocations.addAll(ProjectClassLoader.getRequiredPluginLocations(entry));
            ++n2;
        }
        return requiredPluginLocations;
    }

    private static IProject getProject(URI uri) throws CoreException {
        IContainer[] containers;
        IContainer[] iContainerArray = containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(uri);
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer container = iContainerArray[n2];
            IProject project = container.getProject();
            if (project != null && project.isOpen() && project.hasNature("org.eclipse.jdt.core.javanature")) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    private static IPluginModelBase getPluginModel(String pluginLocation) {
        Path pluginPath = new Path(pluginLocation);
        IPluginModelBase[] iPluginModelBaseArray = PluginRegistry.getAllModels();
        int n = iPluginModelBaseArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPluginModelBase base = iPluginModelBaseArray[n2];
            Path basePath = new Path(base.getInstallLocation());
            if (basePath.isPrefixOf((IPath)pluginPath)) {
                return base;
            }
            ++n2;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Object object = this.getClassLoadingLock(name);
        synchronized (object) {
            Class<?> result = this.findLoadedClass(name);
            if (result == null) {
                try {
                    result = this.findClass(name);
                }
                catch (ClassNotFoundException e) {
                    result = this.getParent().loadClass(name);
                }
                catch (Throwable t) {
                    throw new ClassNotFoundException(name, t);
                }
            }
            if (resolve) {
                this.resolveClass(result);
            }
            return result;
        }
    }

    private static class WorkspaceDependencyAnalyzer {
        private final Map<String, Boolean> dependencyCache = new HashMap<String, Boolean>();

        private WorkspaceDependencyAnalyzer() {
        }

        private boolean hasWorkspaceDependency(IPluginModelBase pluginModel) throws CoreException {
            return this.hasWorkspaceDependency(pluginModel.getInstallLocation());
        }

        private boolean hasWorkspaceDependency(String pluginLocation) throws CoreException {
            if (this.dependencyCache.containsKey(pluginLocation)) {
                return this.dependencyCache.get(pluginLocation);
            }
            boolean result = false;
            URI uri = URIUtil.toURI((String)pluginLocation);
            IProject pluginProject = ProjectClassLoader.getProject(uri);
            if (pluginProject != null) {
                result = true;
            } else {
                IPluginModelBase pluginModel = ProjectClassLoader.getPluginModel(pluginLocation);
                if (pluginModel != null) {
                    IPluginImport[] imports;
                    IPluginImport[] iPluginImportArray = imports = pluginModel.getPluginBase().getImports();
                    int n = imports.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPluginImport i = iPluginImportArray[n2];
                        IPluginModelBase importedPlugin = PluginRegistry.findModel((String)i.getId());
                        if (importedPlugin != null && this.hasWorkspaceDependency(importedPlugin)) {
                            result = true;
                            break;
                        }
                        ++n2;
                    }
                }
            }
            this.dependencyCache.put(pluginLocation, result);
            return result;
        }

        URL[] getProjectClassPath(IJavaProject javaProject) throws CoreException, MalformedURLException {
            ArrayList<String> classPathEntries = new ArrayList<String>(Arrays.asList(JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)javaProject)));
            List requiredPluginLocations = ProjectClassLoader.getRequiredPluginLocations(javaProject);
            for (String pluginLocation : requiredPluginLocations) {
                if (this.hasWorkspaceDependency(pluginLocation)) continue;
                classPathEntries.remove(pluginLocation);
            }
            ArrayList<URL> urlList = new ArrayList<URL>(classPathEntries.size());
            for (String entry : classPathEntries) {
                URL url = new File(entry).toURI().toURL();
                urlList.add(url);
            }
            return urlList.toArray(new URL[0]);
        }

        ClassLoader getParentClassLoader(IJavaProject javaProject) {
            ClassLoader root = ProjectClassLoader.class.getClassLoader();
            IPluginModelBase pluginModel = PluginRegistry.findModel((IProject)javaProject.getProject());
            if (pluginModel == null) {
                return root;
            }
            IPluginImport[] imports = pluginModel.getPluginBase().getImports();
            final ArrayList<IPluginModelBase> importedPlugins = new ArrayList<IPluginModelBase>(imports.length);
            IPluginImport[] iPluginImportArray = imports;
            int n = imports.length;
            int n2 = 0;
            while (n2 < n) {
                IPluginImport i = iPluginImportArray[n2];
                IPluginModelBase importedPlugin = PluginRegistry.findModel((String)i.getId());
                if (importedPlugin != null) {
                    importedPlugins.add(importedPlugin);
                }
                ++n2;
            }
            if (importedPlugins.isEmpty()) {
                return root;
            }
            return new ClassLoader(){
                private Map<String, Class<?>> loadedClasses = new HashMap();
                private Map<String, Set<String>> package2plugins = new HashMap<String, Set<String>>();

                /*
                 * Unable to fully structure code
                 */
                private Set<String> getCandidateHostPlugins(String className) {
                    packageName = WorkspaceDependencyAnalyzer.access$0(className);
                    if (!this.package2plugins.containsKey(packageName)) ** GOTO lbl8
                    return this.package2plugins.get(packageName);
lbl-1000:
                    // 1 sources

                    {
                        pluginModel = PluginRegistry.findModel((String)packageName);
                        if (pluginModel != null && importedPlugins.contains(pluginModel)) {
                            return Collections.singleton(pluginModel.getPluginBase().getId());
                        }
                        packageName = WorkspaceDependencyAnalyzer.access$0(packageName);
lbl8:
                        // 2 sources

                        ** while (packageName != null)
                    }
lbl9:
                    // 1 sources

                    return Collections.emptySet();
                }

                private Class<?> loadClassFromPlugin(String name, boolean resolve, String pluginId) throws ClassNotFoundException {
                    Class result = CommonPlugin.loadClass((String)pluginId, (String)name);
                    if (resolve) {
                        this.resolveClass(result);
                    }
                    this.register(result, pluginId);
                    return result;
                }

                private void register(Class<?> c, String pluginId) {
                    this.loadedClasses.put(c.getName(), c);
                    Package p = c.getPackage();
                    if (p != null) {
                        String packageName = p.getName();
                        Set<String> plugins = this.package2plugins.get(packageName);
                        if (plugins == null) {
                            plugins = new LinkedHashSet<String>(1);
                            this.package2plugins.put(packageName, plugins);
                        }
                        if (!plugins.contains(pluginId)) {
                            plugins.add(pluginId);
                        }
                    }
                }

                @Override
                protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                    if (this.loadedClasses.containsKey(name)) {
                        Class<?> result = this.loadedClasses.get(name);
                        if (result == null) {
                            throw new ClassNotFoundException(name);
                        }
                        return result;
                    }
                    Set<String> candidateHosts = this.getCandidateHostPlugins(name);
                    for (String host : candidateHosts) {
                        try {
                            return this.loadClassFromPlugin(name, resolve, host);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    for (IPluginModelBase importedPlugin : importedPlugins) {
                        try {
                            String pluginId = importedPlugin.getPluginBase().getId();
                            if (candidateHosts.contains(pluginId)) continue;
                            return this.loadClassFromPlugin(name, resolve, pluginId);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            // empty catch block
                        }
                    }
                    this.loadedClasses.put(name, null);
                    throw new ClassNotFoundException(name);
                }
            };
        }

        private static String getPrefix(String fullyQualifiedName) {
            int lastIndex = fullyQualifiedName.lastIndexOf(46);
            if (lastIndex == -1) {
                return null;
            }
            return fullyQualifiedName.substring(0, lastIndex);
        }

        static /* synthetic */ String access$0(String string) {
            return WorkspaceDependencyAnalyzer.getPrefix(string);
        }
    }
}

