/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.m2m.internal.qvt.oml.QvtPlugin;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ProcessJob;
import org.eclipse.m2m.internal.qvt.oml.common.launch.StreamsProxy;
import org.eclipse.m2m.internal.qvt.oml.evaluator.QvtRuntimeException;
import org.eclipse.m2m.internal.qvt.oml.runtime.QvtRuntimePlugin;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchConfigurationDelegateBase;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtInterpretedTransformation;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.eclipse.m2m.qvt.oml.util.WriterLog;

public class QvtLaunchConfigurationDelegate
extends QvtLaunchConfigurationDelegateBase {
    public static final String LAUNCH_CONFIGURATION_TYPE_ID = "org.eclipse.m2m.qvt.oml.QvtTransformation";

    public void launch(final ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor launchMonitor) throws CoreException {
        final QvtInterpretedTransformation qvtTransformation = new QvtInterpretedTransformation(QvtLaunchConfigurationDelegate.getQvtModule(configuration));
        final StreamsProxy streamsProxy = new StreamsProxy();
        ProcessJob processJob = new ProcessJob(Messages.InMemoryQvtLaunchConfigurationDelegate_TransformationJobName, launch, (IStreamsProxy)streamsProxy){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    IStatus status = QvtLaunchConfigurationDelegateBase.validate(qvtTransformation, configuration);
                    if (status.getSeverity() > 2) {
                        throw new CoreException(status);
                    }
                    ExecutionContext context = QvtLaunchUtil.createContext(configuration, (Log)new WriterLog(streamsProxy.getOutputWriter()), monitor);
                    QvtLaunchUtil.doLaunch(qvtTransformation, configuration, context);
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                catch (QvtRuntimeException e) {
                    IStatus iStatus = BasicDiagnostic.toIStatus((Diagnostic)e.getDiagnostic());
                    return iStatus;
                }
                catch (Exception e) {
                    Status actualStatus = new Status(4, "org.eclipse.m2m.qvt.oml.runtime", QvtRuntimePlugin.LAUNCH_ERROR_STATUS.getCode(), e.getMessage(), (Throwable)(e.getMessage() == null ? e : null));
                    IStatusHandler statusHandler = DebugPlugin.getDefault().getStatusHandler(QvtRuntimePlugin.LAUNCH_ERROR_STATUS);
                    if (statusHandler != null) {
                        try {
                            statusHandler.handleStatus((IStatus)actualStatus, (Object)configuration);
                        }
                        catch (CoreException coreExc) {
                            actualStatus = coreExc.getStatus();
                            QvtPlugin.getDefault().log((Object)actualStatus);
                        }
                    }
                    QvtPlugin.error((String)Messages.InMemoryQvtLaunchConfigurationDelegate_TransformationJobName, (Throwable)e);
                    throw new CoreException((IStatus)actualStatus);
                }
                finally {
                    qvtTransformation.cleanup();
                }
            }
        };
        launch.addProcess((IProcess)processJob);
        processJob.schedule();
    }
}

