/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.tests.qvt.oml.debugger;

import java.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.m2m.internal.tests.qvt.oml.debugger.MarkedTransformation;
import org.eclipse.m2m.internal.tests.qvt.oml.debugger.Script;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOThread;
import org.eclipse.m2m.qvt.oml.debug.core.vm.VMLocation;

class DebugEventLogger
implements IDebugEventSetListener {
    private final Script myScript;
    private final Object myLock;
    private final ArrayList<LogRecord> myLog = new ArrayList();

    public DebugEventLogger(Object lock, Script script) {
        this.myLock = lock;
        this.myScript = script;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            switch (events[i].getKind()) {
                case 2: {
                    if (!(events[i].getSource() instanceof QVTOThread)) {
                        return;
                    }
                    QVTOThread thread = (QVTOThread)events[i].getSource();
                    Script.Command command = null;
                    if (this.myScript.hasNextCommand()) {
                        command = this.myScript.nextCommand();
                    }
                    try {
                        IWatchExpression expr;
                        try {
                            if (events[i].getData() instanceof VMLocation) {
                                VMLocation location = (VMLocation)events[i].getData();
                                int detail = events[i].getDetail();
                                int line = location.getLineNum();
                                this.myLog.add(new LogRecord(detail, line, command));
                            }
                        }
                        catch (Throwable throwable) {
                            if (command != null) {
                                expr = DebugPlugin.getDefault().getExpressionManager().newWatchExpression("100 = 1");
                                expr.setExpressionContext((IDebugElement)thread);
                                switch (command.code) {
                                    case 1: {
                                        thread.resume();
                                        break;
                                    }
                                    case 3: {
                                        thread.stepInto();
                                        break;
                                    }
                                    case 2: {
                                        thread.stepOver();
                                        break;
                                    }
                                    case 4: {
                                        thread.stepReturn();
                                    }
                                }
                            } else {
                                thread.resume();
                            }
                            throw throwable;
                        }
                        if (command != null) {
                            expr = DebugPlugin.getDefault().getExpressionManager().newWatchExpression("100 = 1");
                            expr.setExpressionContext((IDebugElement)thread);
                            switch (command.code) {
                                case 1: {
                                    thread.resume();
                                    break;
                                }
                                case 3: {
                                    thread.stepInto();
                                    break;
                                }
                                case 2: {
                                    thread.stepOver();
                                    break;
                                }
                                case 4: {
                                    thread.stepReturn();
                                }
                            }
                            break;
                        }
                        thread.resume();
                    }
                    catch (DebugException e) {
                        System.err.println((Object)e);
                    }
                    break;
                }
                case 8: {
                    Object object = this.myLock;
                    synchronized (object) {
                        this.myLock.notifyAll();
                        break;
                    }
                }
            }
            ++i;
        }
    }

    public ArrayList<LogRecord> getLog() {
        return this.myLog;
    }

    static class LogRecord {
        private final int eventDetail;
        private final int lineNumber;
        private final Script.Command command;
        private static final String BREAKPOINT_MESSAGE = "Breakpoint";
        private static final String STEP_INTO_MESSAGE = "Step into";
        private static final String STEP_OVER_MESSAGE = "Step over";
        private static final String RETURN_MESSAGE = "Return";
        private static final String LINE_PATTERN = " (name {0}, line {1})";
        private static final String NAME_NONE = "<unknown>";

        public LogRecord(int eventDetail, int line, Script.Command command) {
            this.eventDetail = eventDetail;
            this.lineNumber = line;
            this.command = command;
        }

        public static String eventDetailToString(int eventDetail) {
            String message;
            switch (eventDetail) {
                case 16: {
                    message = BREAKPOINT_MESSAGE;
                    break;
                }
                case 1: {
                    message = STEP_INTO_MESSAGE;
                    break;
                }
                case 2: {
                    message = STEP_OVER_MESSAGE;
                    break;
                }
                case 4: {
                    message = RETURN_MESSAGE;
                    break;
                }
                default: {
                    message = String.valueOf(eventDetail);
                }
            }
            return message;
        }

        public String toString(MarkedTransformation markedTrans) {
            MarkedTransformation.LineMarker marker = markedTrans.getLineMarker(this.lineNumber);
            String name = marker != null ? marker.name : NAME_NONE;
            return String.valueOf(LogRecord.eventDetailToString(this.eventDetail)) + MessageFormat.format(LINE_PATTERN, name, new Integer(this.lineNumber));
        }

        public Script.Command getCommand() {
            return this.command;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public int getEventDetail() {
            return this.eventDetail;
        }
    }
}

