/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.tests.qvt.oml.debugger;

import java.util.List;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.URI;
import org.eclipse.m2m.internal.tests.qvt.oml.debugger.DebuggerTransformation;
import org.eclipse.m2m.internal.tests.qvt.oml.debugger.TestQvtoDebugger;
import org.eclipse.m2m.tests.qvt.oml.transform.FileToFileData;
import org.eclipse.m2m.tests.qvt.oml.transform.ModelTestData;

public class DebuggerTests {
    public static TestSuite suite() {
        TestSuite suite = new TestSuite("QVTo debugger");
        suite.addTest((Test)DebuggerTests.transformSuite());
        suite.addTest((Test)DebuggerTests.executionSuite());
        return suite;
    }

    public static TestSuite transformSuite() {
        ModelTestData[] datas;
        TestSuite suite = new TestSuite("launching");
        ModelTestData[] modelTestDataArray = datas = DebuggerTests.createLaunchTestData();
        int n = datas.length;
        int n2 = 0;
        while (n2 < n) {
            ModelTestData data = modelTestDataArray[n2];
            suite.addTest((Test)new DebuggerTransformation(data));
            ++n2;
        }
        return suite;
    }

    public static TestSuite executionSuite() {
        ModelTestData[] datas;
        TestSuite suite = new TestSuite("execution");
        ModelTestData[] modelTestDataArray = datas = DebuggerTests.createExecTestData();
        int n = datas.length;
        int n2 = 0;
        while (n2 < n) {
            ModelTestData data = modelTestDataArray[n2];
            suite.addTest((Test)new TestQvtoDebugger(data));
            ++n2;
        }
        return suite;
    }

    private static ModelTestData[] createLaunchTestData() {
        return new ModelTestData[]{new DebugFileToFileData("numconversion", "in.xmi", "expected.pack").includeMetamodelFile("mm.ecore"), new DebugFileToFileData("oclannotation", "in.ecore", "expected.xmi").includeMetamodelFile("metamodel.ecore"), new DebugFileToFileData("FamilyXForm", "Family.xmi", "FamilyXForm.family").includeMetamodelFile("Family.ecore")};
    }

    private static ModelTestData[] createExecTestData() {
        return new ModelTestData[]{new SimpleDebugData("testSimple"), new SimpleDebugData("testBreakpointForEndSection"), new SimpleDebugData("testBreakpointForExplicitOutExp"), new SimpleDebugData("testBreakpointForExpressionStatement"), new SimpleDebugData("testBreakpointForOpCallSource"), new SimpleDebugData("testBreakpointForNestedTransf")};
    }

    private static class DebugFileToFileData
    extends FileToFileData {
        public DebugFileToFileData(String name, String fromFile, String expectedFile) {
            super(name, fromFile, expectedFile);
        }

        public String getTestDataFolder() {
            return "debuggerTestData";
        }

        public String getBundle() {
            return String.valueOf(super.getBundle()) + ".ui";
        }
    }

    private static class SimpleDebugData
    extends ModelTestData {
        public SimpleDebugData(String name) {
            super(name, null);
        }

        public List<URI> getIn(IProject project) {
            return null;
        }

        public List<URI> getExpected(IProject project) {
            return null;
        }

        public URI getTrace(IProject project) {
            return null;
        }
    }
}

