/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.tests.qvt.oml.debugger;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.emf.util.URIUtils;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.debug.core.launch.QVTODebugConfiguration;
import org.eclipse.m2m.qvt.oml.debug.core.srclookup.QVTOSourceLookupDirector;
import org.eclipse.m2m.tests.qvt.oml.transform.ModelTestData;
import org.eclipse.m2m.tests.qvt.oml.transform.TestTransformation;
import org.eclipse.swt.widgets.Display;

public class DebuggerTransformation
extends TestTransformation {
    private ILaunchConfigurationWorkingCopy myLaunchConfigurationWorkingCopy;

    public DebuggerTransformation(ModelTestData data) {
        super(data);
    }

    protected void runTest() throws Throwable {
        this.checkTransformation((TestTransformation.IChecker)new TestTransformation.TransformationChecker((TestTransformation.ITransformer)new DebuggerTransformer()));
    }

    public void runDebugger() throws CoreException, InterruptedException {
        ILaunchConfiguration config = this.myLaunchConfigurationWorkingCopy.doSave();
        QVTODebugConfiguration debugConfig = new QVTODebugConfiguration();
        Launch launch = new Launch(config, "debug", (ISourceLocator)new QVTOSourceLookupDirector());
        debugConfig.launch(config, "debug", (ILaunch)launch, (IProgressMonitor)new NullProgressMonitor());
        while (!launch.isTerminated()) {
            while (Display.getDefault().readAndDispatch()) {
            }
            Thread.sleep(10L);
        }
    }

    private class DebuggerTransformer
    implements TestTransformation.ITransformer {
        private DebuggerTransformer() {
        }

        public List<URI> transform(IFile transformation, List<URI> inUris, URI traceUri, ExecutionContext qvtContext) throws Exception {
            IResource resource;
            ILaunchConfigurationType type = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.m2m.qvt.oml.QvtTransformation");
            DebuggerTransformation.this.myLaunchConfigurationWorkingCopy = type.newInstance(null, "debugConfig");
            ArrayList<URI> resultUri = new ArrayList<URI>(2);
            int index = 1;
            for (URI uri : inUris) {
                resource = URIUtils.getResource((URI)uri);
                uri = URIUtils.getResourceURI((IResource)resource);
                QvtLaunchUtil.saveTargetUriData((ILaunchConfigurationWorkingCopy)DebuggerTransformation.this.myLaunchConfigurationWorkingCopy, (TargetUriData)new TargetUriData(TargetUriData.TargetType.EXISTING_CONTAINER, uri.toString(), null, false), (int)index);
                ++index;
            }
            for (URI uri : DebuggerTransformation.this.getData().getExpected(DebuggerTransformation.this.getProject())) {
                resource = URIUtils.getResource((URI)uri);
                uri = URIUtils.getResourceURI((IResource)resource).appendFileExtension("ecore");
                resultUri.add(uri);
                QvtLaunchUtil.saveTargetUriData((ILaunchConfigurationWorkingCopy)DebuggerTransformation.this.myLaunchConfigurationWorkingCopy, (TargetUriData)new TargetUriData(TargetUriData.TargetType.NEW_MODEL, uri.toString(), null, false), (int)index);
                ++index;
            }
            DebuggerTransformation.this.myLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.traceFile", traceUri.toString());
            if (new ResourceSetImpl().getURIConverter().exists(traceUri, Collections.emptyMap())) {
                DebuggerTransformation.this.myLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.isInrementalUpdate", true);
            }
            DebuggerTransformation.this.myLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.module", URIUtils.getResourceURI((IResource)transformation).toString());
            DebuggerTransformation.this.myLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.elemCount", index - 1);
            LinkedHashMap<String, String> configProps = new LinkedHashMap<String, String>();
            Iterator iterator = qvtContext.getConfigPropertyNames().iterator();
            while (iterator.hasNext()) {
                String property;
                Object value = qvtContext.getConfigProperty(property = (String)iterator.next());
                configProps.put(property, value == null ? null : String.valueOf(value));
            }
            DebuggerTransformation.this.myLaunchConfigurationWorkingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.configurationProperties", configProps);
            DebuggerTransformation.this.runDebugger();
            return resultUri;
        }
    }
}

