/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.resource;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.IntermediateClassFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QvtKeywords;
import org.eclipse.m2m.internal.qvt.oml.expressions.Constructor;
import org.eclipse.m2m.internal.qvt.oml.expressions.ConstructorBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.EntryOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Helper;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeCallExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImportKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.Library;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingCallExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.m2m.internal.qvt.oml.expressions.ObjectExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationBody;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.ResolveInExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.util.QVTOperationalVisitor;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AltExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AssertExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.AssignExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.BlockExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.BreakExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.CatchExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ComputeExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ContinueExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictLiteralExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictLiteralPart;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.DictionaryType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ForExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeExpression;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeIterateExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ImperativeLoopExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.InstantiationExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListLiteralExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ListType;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.LogExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.OrderedTupleLiteralExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.OrderedTupleLiteralPart;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.RaiseExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.ReturnExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.SeverityKind;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.SwitchExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.TryExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.UnlinkExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.UnpackExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.VariableInitExp;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.WhileExp;
import org.eclipse.ocl.ecore.AnyType;
import org.eclipse.ocl.ecore.AssociationClassCallExp;
import org.eclipse.ocl.ecore.BagType;
import org.eclipse.ocl.ecore.CallExp;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.CollectionLiteralExp;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EnumLiteralExp;
import org.eclipse.ocl.ecore.FeatureCallExp;
import org.eclipse.ocl.ecore.IfExp;
import org.eclipse.ocl.ecore.InvalidLiteralExp;
import org.eclipse.ocl.ecore.InvalidType;
import org.eclipse.ocl.ecore.IteratorExp;
import org.eclipse.ocl.ecore.LetExp;
import org.eclipse.ocl.ecore.LiteralExp;
import org.eclipse.ocl.ecore.LoopExp;
import org.eclipse.ocl.ecore.NavigationCallExp;
import org.eclipse.ocl.ecore.NullLiteralExp;
import org.eclipse.ocl.ecore.NumericLiteralExp;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.ecore.OppositePropertyCallExp;
import org.eclipse.ocl.ecore.OrderedSetType;
import org.eclipse.ocl.ecore.PrimitiveLiteralExp;
import org.eclipse.ocl.ecore.PrimitiveType;
import org.eclipse.ocl.ecore.PropertyCallExp;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.ecore.SequenceType;
import org.eclipse.ocl.ecore.SetType;
import org.eclipse.ocl.ecore.StringLiteralExp;
import org.eclipse.ocl.ecore.TemplateParameterType;
import org.eclipse.ocl.ecore.TupleLiteralExp;
import org.eclipse.ocl.ecore.TupleType;
import org.eclipse.ocl.ecore.TypeType;
import org.eclipse.ocl.ecore.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.ecore.Variable;
import org.eclipse.ocl.ecore.VoidType;
import org.eclipse.ocl.expressions.BooleanLiteralExp;
import org.eclipse.ocl.expressions.CollectionItem;
import org.eclipse.ocl.expressions.CollectionKind;
import org.eclipse.ocl.expressions.CollectionLiteralPart;
import org.eclipse.ocl.expressions.CollectionRange;
import org.eclipse.ocl.expressions.IntegerLiteralExp;
import org.eclipse.ocl.expressions.IterateExp;
import org.eclipse.ocl.expressions.MessageExp;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.RealLiteralExp;
import org.eclipse.ocl.expressions.StateExp;
import org.eclipse.ocl.expressions.TupleLiteralPart;
import org.eclipse.ocl.expressions.TypeExp;
import org.eclipse.ocl.expressions.UnspecifiedValueExp;
import org.eclipse.ocl.expressions.VariableExp;
import org.eclipse.ocl.utilities.ExpressionInOCL;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnparsingQVTOVisitor
implements QVTOperationalVisitor<Object> {
    private Set<String> importedLibraries = new HashSet<String>();
    private Set<String> importedTransformation = new HashSet<String>();
    private Map<EPackage, String> modelTypeMap = new HashMap<EPackage, String>();
    private List<String> lines = new ArrayList<String>();
    private StringBuilder currentLine = new StringBuilder(1024);
    private int indentationLevel = 0;
    private String[] indentation = new String[]{"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t", "\t\t\t\t\t\t", "\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t", "\t\t\t\t\t\t\t\t\t\t"};

    public void unparseModules(EList<Module> modules) {
        EList<ModuleImport> moduleImportList = this.getListOfModuleImports(modules);
        this.unparseModuleImportsForCompilationUnit(moduleImportList);
        EList<ModelType> modelTypeList = this.getListOfModelTypes(modules);
        this.unparseModelTypesForCompilationUnit(modelTypeList);
        for (Module module : modules) {
            this.unparseModule(module);
            this.addEmptyLine();
        }
    }

    private EList<ModuleImport> getListOfModuleImports(EList<Module> modules) {
        BasicEList moduleImportList = new BasicEList();
        for (Module module : modules) {
            for (ModuleImport moduleImport : module.getModuleImport()) {
                if (moduleImport == null || moduleImport.getImportedModule() == null || modules.contains((Object)moduleImport.getImportedModule()) || moduleImportList.contains((Object)moduleImport)) continue;
                moduleImportList.add((Object)moduleImport);
            }
        }
        return moduleImportList;
    }

    public Object visitModule(Module module) {
        this.unparseModule(module);
        return null;
    }

    public void unparseModule(Module module) {
        if (module instanceof OperationalTransformation) {
            this.unparseOperationalTransformation((OperationalTransformation)module);
        } else if (module instanceof Library) {
            this.unparseLibrary((Library)module);
        } else {
            this.addText("/*___unknownModuleType___*/");
        }
    }

    private void unparseOperationalTransformation(OperationalTransformation operationalTransformation) {
        this.unparseTags((Module)operationalTransformation);
        this.unparseOperationalTransformationSignature(operationalTransformation);
        this.unparseModuleImportsForSignature((Module)operationalTransformation);
        this.addText("{");
        this.addLineBreak();
        this.unparseIntermediateClasses(operationalTransformation);
        this.unparseModuleProperties((Module)operationalTransformation);
        this.unparseIntermediateProperties(operationalTransformation);
        this.unparseModuleOperations((Module)operationalTransformation);
        this.addText("}");
        this.addLineBreak();
    }

    public Object visitLibrary(Library library) {
        this.unparseLibrary(library);
        return null;
    }

    private void unparseLibrary(Library library) {
        this.unparseTags((Module)library);
        this.unparseLibrarySignature(library);
        this.unparseModuleImportsForSignature((Module)library);
        this.addText("{");
        this.addLineBreak();
        this.unparseModuleProperties((Module)library);
        this.unparseModuleOperations((Module)library);
        this.addText("}");
        this.addLineBreak();
    }

    private EList<ModelType> getListOfModelTypes(EList<Module> modules) {
        HashSet<String> handledMetamodels = new HashSet<String>();
        BasicEList modelTypeList = new BasicEList();
        for (Module module : modules) {
            EList usedModelTypes = module.getUsedModelType();
            for (ModelType modelType : usedModelTypes) {
                String modelTypeKey = String.valueOf(modelType.getName()) + ":" + ((EPackage)modelType.getMetamodel().get(0)).getNsURI();
                if (handledMetamodels.contains(modelTypeKey)) continue;
                modelTypeList.add((Object)modelType);
                handledMetamodels.add(modelTypeKey);
            }
        }
        return modelTypeList;
    }

    private void unparseModelTypesForCompilationUnit(EList<ModelType> usedModelTypes) {
        for (ModelType modelType : usedModelTypes) {
            this.unparseModelType(modelType);
        }
        if (usedModelTypes.size() > 0) {
            this.addLineBreak();
        }
    }

    public Object visitModelType(ModelType modelType) {
        this.unparseModelType(modelType);
        return null;
    }

    private void unparseModelType(ModelType modelType) {
        String instanceClassName = modelType.getInstanceClassName();
        if ("org.eclipse.m2m.internal.qvt.oml.evaluator.ModelInstance".equals(instanceClassName)) {
            String name = modelType.getName();
            String conformance = modelType.getConformanceKind();
            String conformanceText = conformance != null ? " \"" + conformance + "\"" : "";
            String nsURI = ((EPackage)modelType.getMetamodel().get(0)).getNsURI();
            this.addText("modeltype " + name + conformanceText + " uses \"" + nsURI + "\";");
            this.addLineBreak();
            this.modelTypeMap.put((EPackage)modelType.getMetamodel().get(0), name);
        } else {
            this.addText("/*___unknownModelType___*/");
            this.addLineBreak();
        }
    }

    private void unparseModuleImportsForCompilationUnit(EList<ModuleImport> moduleImportList) {
        for (ModuleImport moduleImport : moduleImportList) {
            Module importedModule = moduleImport.getImportedModule();
            if (importedModule instanceof Library) {
                this.unparseLibraryImport((Library)importedModule);
                continue;
            }
            if (importedModule instanceof OperationalTransformation) {
                this.unparseTransformationImport((OperationalTransformation)importedModule);
                continue;
            }
            this.addText("/*___importOfUnknowModuleType___*/");
            this.addLineBreak();
        }
        if (moduleImportList.size() > 0) {
            this.addLineBreak();
        }
    }

    public Object visitModuleImport(ModuleImport moduleImport) {
        return null;
    }

    private void unparseModuleImportsForSignature(Module module) {
        EList moduleImportList = module.getModuleImport();
        for (ModuleImport moduleImport : moduleImportList) {
            this.unparseModuleImportForSignature(moduleImport);
            this.addLineBreak();
        }
    }

    private void unparseModuleImportForSignature(ModuleImport moduleImport) {
        Module importedModule;
        ImportKind importKind = moduleImport.getKind();
        String kindToken = "imports";
        if (ImportKind.ACCESS.equals((Object)importKind)) {
            kindToken = "access";
        }
        if (ImportKind.EXTENSION.equals((Object)importKind)) {
            kindToken = "extends";
        }
        String libraryText = (importedModule = moduleImport.getImportedModule()) instanceof Library ? " library " : " ";
        String moduleName = importedModule.getName();
        moduleName = moduleName.replaceAll("\\.", "::");
        this.addText(String.valueOf(kindToken) + libraryText + moduleName);
        EList bindings = moduleImport.getBinding();
        if (bindings != null && bindings.size() > 0) {
            this.addText("(");
            Iterator modelTypeIterator = bindings.iterator();
            while (modelTypeIterator.hasNext()) {
                this.addText(((ModelType)modelTypeIterator.next()).getName());
                if (!modelTypeIterator.hasNext()) continue;
                this.addText(", ");
            }
            this.addText(")");
        }
    }

    private void unparseLibraryImport(Library library) {
        String libraryName = library.getName();
        Resource resource = library.eResource();
        String resourceURI = resource.getURI().toString();
        if (resourceURI.startsWith("qvto://blackbox/")) {
            String unitName;
            libraryName = unitName = resourceURI.replace("qvto://blackbox/", "");
        }
        if (!this.importedLibraries.contains(libraryName)) {
            this.addText("import library " + libraryName + ";");
            this.addLineBreak();
            this.importedLibraries.add(libraryName);
        }
    }

    private void unparseTransformationImport(OperationalTransformation transformation) {
        String transformationName = transformation.getName();
        Resource resource = transformation.eResource();
        String resourceURI = resource.getURI().toString();
        if (resourceURI.startsWith("qvto://blackbox/")) {
            String unitName;
            transformationName = unitName = resourceURI.replace("qvto://blackbox/", "");
        }
        if (!this.importedTransformation.contains(transformationName)) {
            this.addText("import " + transformationName + ";");
            this.addLineBreak();
            this.importedTransformation.add(transformationName);
        }
    }

    private void unparseTags(Module module) {
        EList ownedTags = module.getOwnedTag();
        for (EAnnotation eAnnotation : ownedTags) {
            this.unparseTag(eAnnotation);
        }
    }

    private void unparseTag(EAnnotation annotation) {
        String tagidText = (String)annotation.getDetails().keySet().toArray()[0];
        if (tagidText.equals("alias")) {
            this.unparseAliasTag(annotation);
        } else {
            this.defaultUnparseTag(annotation);
        }
    }

    private void unparseAliasTag(EAnnotation annotation) {
        String tagidText = (String)annotation.getDetails().keySet().toArray()[0];
        String newNameText = (String)annotation.getDetails().values().toArray()[0];
        EObject referencedObject = (EObject)annotation.getReferences().get(0);
        if (referencedObject instanceof EStructuralFeature) {
            EStructuralFeature referencedFeature = (EStructuralFeature)referencedObject;
            EClass referencedContainingClass = referencedFeature.getEContainingClass();
            String originalNameText = this.escapeKeywordName(referencedFeature.getName());
            String fqnText = this.constructFullyQualifiedType((EClassifier)referencedContainingClass);
            this.addText("tag ");
            this.addText("\"" + tagidText + "\" " + fqnText + "::" + originalNameText + " = '" + newNameText + "';");
            this.addLineBreak();
        }
    }

    private void defaultUnparseTag(EAnnotation annotation) {
        String tagidText = (String)annotation.getDetails().keySet().toArray()[0];
        String valueText = (String)annotation.getDetails().values().toArray()[0];
        EObject referencedObject = (EObject)annotation.getReferences().get(0);
        if (referencedObject instanceof EClassifier) {
            EClassifier referencedClassifier = (EClassifier)referencedObject;
            String fqnText = this.constructFullyQualifiedType(referencedClassifier);
            this.addText("tag ");
            this.addText("\"" + tagidText + "\" " + fqnText + " = '" + valueText + "';");
            this.addLineBreak();
        } else if (referencedObject instanceof EStructuralFeature) {
            EStructuralFeature referencedFeature = (EStructuralFeature)referencedObject;
            EClass referencedContainingClass = referencedFeature.getEContainingClass();
            String nameText = this.escapeKeywordName(referencedFeature.getName());
            String fqnClassText = this.constructFullyQualifiedType((EClassifier)referencedContainingClass);
            this.addText("tag ");
            this.addText("\"" + tagidText + "\" " + fqnClassText + "::" + nameText + " = '" + valueText + "';");
            this.addLineBreak();
        }
    }

    private void unparseType(EClassifier type) {
        if (type != null) {
            this.addText(this.constructFullyQualifiedType(type));
        }
    }

    private void unparseHelperContext(VarParameter helperContext) {
        if (helperContext != null) {
            String contextString = this.constructFullyQualifiedType((EClassifier)helperContext.getType());
            this.addText(String.valueOf(contextString) + "::");
        }
    }

    private String constructFullyQualifiedType(EClassifier type) {
        if (type instanceof AnyType) {
            return this.constructFullyQualifiedAnyType((AnyType)type);
        }
        if (type instanceof EClass) {
            return this.constructFullyQualifiedEClass((EClass)type);
        }
        if (type instanceof EDataType) {
            return this.constructFullyQualifiedEDataType((EDataType)type);
        }
        if (type instanceof InvalidType) {
            return this.constructFullyQualifiedInvalidType((InvalidType)type);
        }
        if (type instanceof TemplateParameterType) {
            return this.constructFullyQualifiedTemplateParameterType((TemplateParameterType)type);
        }
        if (type instanceof TypeType) {
            return this.constructFullyQualifiedTypeType((TypeType)type);
        }
        if (type instanceof VoidType) {
            return this.constructFullyQualifiedVoidType((VoidType)type);
        }
        return "/*___UnknownType___*/";
    }

    private String constructFullyQualifiedAnyType(AnyType type) {
        return "OclAny";
    }

    private String constructFullyQualifiedEClass(EClass type) {
        if (type instanceof TupleType) {
            return this.constructFullyQualifiedTupleType((TupleType)type);
        }
        if (IntermediateClassFactory.isIntermediateClass((EClassifier)type)) {
            return this.constructFullyQualifiedIntermediateClass((EClassifier)type);
        }
        return this.constructFullyQualifiedTypeAsPackagePrefixAndName((EClassifier)type);
    }

    private String constructFullyQualifiedEDataType(EDataType type) {
        if (type instanceof CollectionType) {
            return this.constructFullyQualifiedCollectionType((CollectionType)type);
        }
        if (type instanceof PrimitiveType) {
            return this.constructFullyQualifiedPrimitiveType((PrimitiveType)type);
        }
        if (type instanceof TupleType) {
            return this.constructFullyQualifiedTupleType((TupleType)type);
        }
        return this.constructFullyQualifiedTypeAsPackagePrefixAndName((EClassifier)type);
    }

    private String constructFullyQualifiedCollectionType(CollectionType collectionType) {
        if (collectionType instanceof DictionaryType) {
            return this.constructFullyQualifiedDictionaryType((DictionaryType)collectionType);
        }
        String collectionName = "Collection";
        if (collectionType instanceof ListType) {
            collectionName = "List";
        } else if (collectionType instanceof SequenceType) {
            collectionName = "Sequence";
        } else if (collectionType instanceof OrderedSetType) {
            collectionName = "OrderedSet";
        } else if (collectionType instanceof SetType) {
            collectionName = "Set";
        } else if (collectionType instanceof BagType) {
            collectionName = "Bag";
        }
        String elementTypeText = this.constructFullyQualifiedType((EClassifier)collectionType.getElementType());
        return String.valueOf(collectionName) + "(" + elementTypeText + ")";
    }

    private String constructFullyQualifiedDictionaryType(DictionaryType dictionaryType) {
        String keyTypeText = this.constructFullyQualifiedType(dictionaryType.getKeyType());
        String elementTypeText = this.constructFullyQualifiedType((EClassifier)dictionaryType.getElementType());
        return "Dict(" + keyTypeText + "," + elementTypeText + ")";
    }

    private String constructFullyQualifiedPrimitiveType(PrimitiveType primitiveType) {
        return primitiveType.getName();
    }

    private String constructFullyQualifiedTupleType(TupleType tupleType) {
        StringBuffer featuresText = new StringBuffer();
        EList tupleFeatures = tupleType.getEStructuralFeatures();
        Iterator featureIterator = tupleFeatures.iterator();
        while (featureIterator.hasNext()) {
            EStructuralFeature tupleFeature = (EStructuralFeature)featureIterator.next();
            String nameText = tupleFeature.getName();
            String fullTypeText = this.constructFullyQualifiedType(tupleFeature.getEType());
            featuresText.append(String.valueOf(nameText) + ":" + fullTypeText);
            if (!featureIterator.hasNext()) continue;
            featuresText.append(",");
        }
        return "Tuple(" + featuresText.toString() + ")";
    }

    private String constructFullyQualifiedInvalidType(InvalidType type) {
        return "OclInvalid";
    }

    private String constructFullyQualifiedTemplateParameterType(TemplateParameterType type) {
        return "/*___TemplateParameterType___*/";
    }

    private String constructFullyQualifiedTypeType(TypeType type) {
        return "/*___TypeType___*/";
    }

    private String constructFullyQualifiedVoidType(VoidType type) {
        return "OclVoid";
    }

    private String constructFullyQualifiedIntermediateClass(EClassifier intermediateClass) {
        return intermediateClass.getName();
    }

    private String constructFullyQualifiedTypeAsPackagePrefixAndName(EClassifier type) {
        String name = type.getName();
        String packagePrefix = this.constructPackagePrefix(type.getEPackage());
        return String.valueOf(packagePrefix) + name;
    }

    private String constructPackagePrefix(EPackage pakkage) {
        if (pakkage instanceof Library) {
            return this.constructPackagePrefixForLibrary((Library)pakkage);
        }
        String packagePrefix = "";
        while (pakkage != null) {
            if (pakkage.getESuperPackage() != null) {
                packagePrefix = String.valueOf(pakkage.getName()) + "::" + packagePrefix;
                pakkage = pakkage.getESuperPackage();
                continue;
            }
            String modelTypeName = this.modelTypeMap.get(pakkage);
            if (modelTypeName != null) {
                packagePrefix = String.valueOf(modelTypeName) + "::" + packagePrefix;
            }
            pakkage = null;
        }
        return packagePrefix;
    }

    private String constructPackagePrefixForLibrary(Library library) {
        String packagePrefix = String.valueOf(library.getName()) + "::";
        return packagePrefix;
    }

    private String constructContextString(VarParameter context) {
        String contextString = context == null ? "" : String.valueOf(this.constructFullyQualifiedType((EClassifier)context.getType())) + "::";
        return contextString;
    }

    private void unparseOperationalTransformationSignature(OperationalTransformation transformation) {
        if (transformation.isIsBlackbox()) {
            this.addText("blackbox ");
        }
        this.addText("transformation " + transformation.getName());
        EList<ModelParameter> modelParameterList = this.removeAutogenParameter((EList<ModelParameter>)transformation.getModelParameter());
        this.addText("(");
        Iterator modelParameterIterator = modelParameterList.iterator();
        while (modelParameterIterator.hasNext()) {
            this.unparseTransformationParameter((ModelParameter)modelParameterIterator.next());
            if (!modelParameterIterator.hasNext()) continue;
            this.addText(", ");
        }
        this.addText(")");
        this.addLineBreak();
    }

    private EList<ModelParameter> removeAutogenParameter(EList<ModelParameter> allModelParameter) {
        BasicEList modelParameterList = new BasicEList(allModelParameter);
        int i = 0;
        while (i < modelParameterList.size()) {
            ModelParameter modelParameter = (ModelParameter)modelParameterList.get(i);
            EAnnotation annotation = modelParameter.getEAnnotation("http://www.eclipse.org/m2m/1.0.0/QVT/autoModelParam");
            if (annotation != null) {
                modelParameterList.remove((Object)modelParameter);
                continue;
            }
            ++i;
        }
        return modelParameterList;
    }

    private void unparseTransformationParameter(ModelParameter modelParameter) {
        ModelType modelType;
        DirectionKind directionKind;
        String nameText = String.valueOf(modelParameter.getName()) + ":";
        if (modelParameter.getName().startsWith("$")) {
            nameText = "/*" + nameText + "*/";
        }
        String directionText = (directionKind = modelParameter.getKind()) != null ? directionKind.getName() : "/*___directionKindWasNull___*/";
        EParameter representedParameter = (EParameter)modelParameter.getRepresentedParameter();
        String modelTypeText = representedParameter == null ? ((modelType = (ModelType)modelParameter.getEType()) != null ? modelType.getName() : "/*___modelTypeWasNull___*/") : ((modelType = (ModelType)representedParameter.getEType()) != null ? modelType.getName() : "/*___modelTypeOfRepresentedParameterWasNull___*/");
        this.addText(String.valueOf(directionText) + " " + nameText + modelTypeText);
    }

    private void unparseIntermediateClasses(OperationalTransformation transformation) {
        EList intermediateClasses = transformation.getIntermediateClass();
        for (EClass eClass : intermediateClasses) {
            this.unparseIntermediateClassOrException(eClass);
        }
    }

    private void unparseIntermediateClassOrException(EClass clazz) {
        if (clazz == null) {
            return;
        }
        if (!this.checkIntermediateException(clazz)) {
            this.unparseIntermediateClass(clazz);
        } else {
            this.unparseIntermediateException(clazz);
        }
    }

    private boolean checkIntermediateException(EClass clazz) {
        if (clazz == null) {
            return false;
        }
        EList superTypes = clazz.getESuperTypes();
        if (superTypes == null || superTypes.size() == 0) {
            return false;
        }
        for (EClass eClass : superTypes) {
            if (!eClass.getName().equals("Exception") || !eClass.getEPackage().getName().equals("Stdlib")) continue;
            return true;
        }
        return false;
    }

    private void unparseIntermediateClass(EClass clazz) {
        if (clazz == null) {
            return;
        }
        this.addText("intermediate class " + clazz.getName());
        this.unparseIntermediateClassSupertypes((EList<EClass>)clazz.getESuperTypes());
        this.addLineBreak();
        this.addTextAndIndent("{");
        this.addLineBreak();
        this.unparseIntermediateClassProperties((EList<EAttribute>)clazz.getEAttributes());
        this.unparseIntermediateClassReferences((EList<EReference>)clazz.getEReferences());
        this.unindentAndAddText("}");
        this.addEmptyLine();
    }

    private void unparseIntermediateException(EClass exceptionClass) {
        if (exceptionClass == null) {
            return;
        }
        this.addText("exception " + exceptionClass.getName());
        this.unparseIntermediateClassSupertypesWithoutExceptionClass((EList<EClass>)exceptionClass.getESuperTypes());
        this.addText(" {}");
        this.addLineBreak();
    }

    private void unparseIntermediateClassSupertypesWithoutExceptionClass(EList<EClass> superTypes) {
        EList<EClass> filteredSuperTypes = this.removeExceptionClassFromClassList(superTypes);
        this.unparseIntermediateClassSupertypes(filteredSuperTypes);
    }

    private EList<EClass> removeExceptionClassFromClassList(EList<EClass> superTypes) {
        BasicEList filteredClassList = new BasicEList();
        for (EClass superType : superTypes) {
            if (superType.getName().equals("Exception") && superType.getEPackage().getName().equals("Stdlib")) continue;
            filteredClassList.add((Object)superType);
        }
        return filteredClassList;
    }

    private void unparseIntermediateClassSupertypes(EList<EClass> superTypes) {
        if (superTypes == null || superTypes.size() == 0) {
            return;
        }
        this.addText(" extends ");
        Iterator typesIterator = superTypes.iterator();
        while (typesIterator.hasNext()) {
            EClass eClass = (EClass)typesIterator.next();
            this.unparseType((EClassifier)eClass);
            if (!typesIterator.hasNext()) continue;
            this.addText(", ");
        }
    }

    private void unparseIntermediateClassProperties(EList<EAttribute> properties) {
        if (properties == null) {
            return;
        }
        for (EAttribute property : properties) {
            this.unparseIntermediateClassProperty(property);
        }
    }

    private void unparseIntermediateClassProperty(EAttribute property) {
        OCLExpression initExpression;
        String assignmentOp = " = ";
        String idText = property.isID() ? "<<id>> " : "";
        EAnnotation staticAnnotation = property.getEAnnotation("http://www.eclipse.org/m2m/1.0.0/QVT/static");
        String staticText = staticAnnotation != null ? "static " : "";
        String readonlyText = property.isChangeable() ? "" : "readonly ";
        String variableName = property.getName();
        this.addText(String.valueOf(idText) + staticText + readonlyText + variableName + " : ");
        this.unparseType(property.getEType());
        if (property.isMany()) {
            int lowerBound = property.getLowerBound();
            String lowerBoundText = lowerBound != 0 ? String.valueOf(String.valueOf(lowerBound)) + " .. " : "";
            int upperBound = property.getUpperBound();
            String upperBoundText = upperBound == -1 ? "*" : String.valueOf(upperBound);
            this.addText("[" + lowerBoundText + upperBoundText + "]");
        } else if (property.getLowerBound() == 1) {
            this.addText("[1]");
        }
        if (property.isOrdered()) {
            this.addText(" ordered");
        }
        if ((initExpression = QvtOperationalParserUtil.getInitExpression((EStructuralFeature)property)) != null) {
            this.addText(assignmentOp);
            this.unparseOCLExpression(initExpression);
        }
        this.addText(";");
        this.addLineBreak();
    }

    private void unparseIntermediateClassReferences(EList<EReference> references) {
        if (references == null) {
            return;
        }
        for (EReference reference : references) {
            this.unparseIntermediateClassReference(reference);
        }
    }

    private void unparseIntermediateClassReference(EReference reference) {
        OCLExpression initExpression;
        EReference opposite;
        String readonlyText;
        String assignmentOp = " = ";
        String variableName = reference.getName();
        EAnnotation staticAnnotation = reference.getEAnnotation("http://www.eclipse.org/m2m/1.0.0/QVT/static");
        String staticText = staticAnnotation != null ? "static " : "";
        String string = readonlyText = reference.isChangeable() ? "" : "readonly ";
        if (reference.isContainment()) {
            this.addText("composes ");
        } else {
            this.addText("references ");
        }
        this.addText(String.valueOf(staticText) + readonlyText + variableName + " : ");
        this.unparseType(reference.getEType());
        if (reference.isMany()) {
            this.addText("[*]");
        }
        if (reference.isOrdered()) {
            this.addText(" ordered");
        }
        if ((opposite = reference.getEOpposite()) != null) {
            this.addText(" opposites " + opposite.getName());
        }
        if ((initExpression = QvtOperationalParserUtil.getInitExpression((EStructuralFeature)reference)) != null) {
            this.addText(assignmentOp);
            this.unparseOCLExpression(initExpression);
        }
        this.addText(";");
        this.addLineBreak();
    }

    private void unparseLibrarySignature(Library library) {
        this.addText("library " + library.getName() + "(");
        this.addText(")");
        this.addLineBreak();
    }

    private void unparseModuleProperties(Module module) {
        EList configurationProperties = module.getConfigProperty();
        EList properties = module.getEStructuralFeatures();
        boolean hadProperty = false;
        for (EStructuralFeature structuralFeature : properties) {
            if (structuralFeature instanceof EAttribute) {
                EAttribute attribute = (EAttribute)structuralFeature;
                this.unparseProperty(attribute, configurationProperties.contains((Object)attribute));
                hadProperty = true;
                continue;
            }
            if (!(structuralFeature instanceof EReference)) continue;
            EReference reference = (EReference)structuralFeature;
            this.unparseProperty(reference, configurationProperties.contains((Object)reference));
            hadProperty = true;
        }
        if (hadProperty) {
            this.addLineBreak();
        }
    }

    private void unparseProperty(EAttribute property, boolean isConfigurationProperty) {
        String propertyName = property.getName();
        this.addText(String.valueOf(isConfigurationProperty ? "configuration " : "") + "property " + propertyName + ": ");
        this.unparseType(property.getEType());
        OCLExpression initExpression = QvtOperationalParserUtil.getInitExpression((EStructuralFeature)property);
        if (initExpression != null) {
            this.addText(" = ");
            this.unparseOCLExpression(initExpression);
        }
        this.addText(";");
        this.addLineBreak();
    }

    private void unparseProperty(EReference property, boolean isConfigurationProperty) {
        String propertyName = property.getName();
        this.addText(String.valueOf(isConfigurationProperty ? "configuration " : "") + "property " + propertyName + ": ");
        this.unparseType(property.getEType());
        OCLExpression initExpression = QvtOperationalParserUtil.getInitExpression((EStructuralFeature)property);
        if (initExpression != null) {
            this.addText(" = ");
            this.unparseOCLExpression(initExpression);
        }
        this.addText(";");
        this.addLineBreak();
    }

    private void unparseIntermediateProperties(OperationalTransformation transformation) {
        EList intermediateProperties = transformation.getIntermediateProperty();
        for (EStructuralFeature property : intermediateProperties) {
            this.unparseContextualProperty((ContextualProperty)property);
        }
        if (intermediateProperties.size() > 0) {
            this.addLineBreak();
        }
    }

    private void unparseModuleOperations(Module module) {
        for (EOperation operation : module.getEOperations()) {
            if (operation instanceof ImperativeOperation) {
                this.unparseImperativeOperation((ImperativeOperation)operation);
                continue;
            }
            this.addText("/*___notAnImperativeOperation:" + operation.getName() + "___*/");
        }
    }

    public Object visitImperativeOperation(ImperativeOperation operation) {
        this.unparseImperativeOperation(operation);
        return null;
    }

    private void unparseImperativeOperation(ImperativeOperation operation) {
        if (operation instanceof Constructor) {
            this.unparseConstructor((Constructor)operation);
        } else if (operation instanceof EntryOperation) {
            this.unparseEntryOperation((EntryOperation)operation);
        } else if (operation instanceof MappingOperation) {
            this.unparseMappingOperation((MappingOperation)operation);
        } else if (operation instanceof Helper) {
            this.unparseHelper((Helper)operation);
        } else {
            this.addText("/*___unknownTypeOfImperativeOperationFor:" + operation.getName() + "___*/");
        }
    }

    public Object visitConstructor(Constructor constructor) {
        this.unparseConstructor(constructor);
        return null;
    }

    private void unparseConstructor(Constructor constructor) {
        boolean isBlackbox = constructor.isIsBlackbox();
        if (isBlackbox) {
            this.addText("blackbox ");
        }
        this.addText("constructor ");
        this.unparseHelperContext(constructor.getContext());
        this.addText(String.valueOf(constructor.getName()) + "(");
        this.unparseMappingParameters((EList<EParameter>)constructor.getEParameters());
        this.addText(")");
        this.unparseVarParameters((EList<VarParameter>)constructor.getResult(), false);
        if (isBlackbox) {
            this.addText(";");
            this.addLineBreak();
        } else {
            this.unparseConstructorBody((ConstructorBody)constructor.getBody());
        }
        this.addEmptyLine();
    }

    public Object visitConstructorBody(ConstructorBody constructorBody) {
        this.unparseConstructorBody(constructorBody);
        return null;
    }

    private void unparseConstructorBody(ConstructorBody constructorBody) {
        if (constructorBody == null) {
            this.addText("/*___OperationBodyWasNull___*/");
        } else {
            this.indent();
            this.unparseOCLExpressionsLinebreakSeparatedInBraces(constructorBody.getContent(), true);
            this.unindent();
        }
    }

    public Object visitEntryOperation(EntryOperation entryOperation) {
        this.unparseEntryOperation(entryOperation);
        return null;
    }

    private void unparseEntryOperation(EntryOperation entryOperation) {
        if (entryOperation.getResult() != null && entryOperation.getResult().size() > 0) {
            this.addText("query ");
        }
        if (entryOperation.getContext() != null) {
            this.unparseVarParameter(entryOperation.getContext());
        }
        this.addText(String.valueOf(entryOperation.getName()) + "(");
        this.unparseMappingParameters((EList<EParameter>)entryOperation.getEParameters());
        this.addText(")");
        this.unparseVarParameters((EList<VarParameter>)entryOperation.getResult(), true);
        this.addLineBreak();
        this.unparseOperationBody(entryOperation.getBody());
        this.addLineBreak();
    }

    public Object visitOperationBody(OperationBody body) {
        this.unparseOperationBody(body);
        return null;
    }

    private void unparseOperationBody(OperationBody body) {
        if (body != null) {
            String sectionName = "";
            this.unparseBodySection(sectionName, (EList<org.eclipse.ocl.ecore.OCLExpression>)body.getContent());
        } else {
            this.addText("/*___OperationBodyWasNull___*/");
        }
    }

    public Object visitMappingOperation(MappingOperation operation) {
        this.unparseMappingOperation(operation);
        return null;
    }

    static boolean isAbstractOperation(ImperativeOperation operation) {
        EAnnotation annotation = operation.getEAnnotation("http://www.eclipse.org/m2m/1.0.0/QVT");
        if (annotation != null) {
            String value = (String)annotation.getDetails().get((Object)"abstract");
            return Boolean.valueOf(value);
        }
        return false;
    }

    private void unparseMappingOperation(MappingOperation operation) {
        VarParameter context;
        boolean isAbstract;
        boolean isBlackbox = operation.isIsBlackbox();
        if (isBlackbox) {
            this.addText("blackbox ");
        }
        if (isAbstract = UnparsingQVTOVisitor.isAbstractOperation((ImperativeOperation)operation)) {
            this.addText("abstract ");
        }
        String directionKindText = (context = operation.getContext()) != null && DirectionKind.INOUT.equals((Object)context.getKind()) ? "inout " : "";
        this.addText("mapping " + directionKindText + this.getFullOperationName((ImperativeOperation)operation) + "(");
        this.unparseMappingParameters((EList<EParameter>)operation.getEParameters());
        this.addText(")");
        this.unparseMappingResultParameters((EList<VarParameter>)operation.getResult());
        this.addText(" ");
        this.unparseMappingExtensions((EList<MappingOperation>)operation.getInherited(), (EList<MappingOperation>)operation.getMerged(), (EList<MappingOperation>)operation.getDisjunct());
        if (!isBlackbox) {
            this.unparseMappingRefinement(operation.getOverridden());
        }
        this.unparseMappingConditions((EList<org.eclipse.ocl.ecore.OCLExpression>)operation.getWhen(), operation.getWhere());
        if (isBlackbox) {
            this.addText(";");
            this.addLineBreak();
        } else {
            boolean needsInit = this.checkMappingNeedsInit(operation);
            this.unparseMappingBody((MappingBody)operation.getBody(), needsInit);
            this.addEmptyLine();
        }
    }

    private String getFullOperationName(ImperativeOperation operation) {
        String contextString = this.constructContextString(operation.getContext());
        String fullName = String.valueOf(contextString) + operation.getName();
        return fullName;
    }

    private void unparseMappingResultParameters(EList<VarParameter> resultParameters) {
        if (resultParameters == null || resultParameters.size() == 0) {
            return;
        }
        this.addText(" : ");
        boolean withName = resultParameters.size() != 1;
        Iterator iterator = resultParameters.iterator();
        while (iterator.hasNext()) {
            VarParameter parameter = (VarParameter)iterator.next();
            this.unparseMappingParameter(parameter, false, withName);
            if (!iterator.hasNext()) continue;
            this.addText(", ");
        }
    }

    private void unparseMappingParameters(EList<EParameter> eParameters) {
        Iterator iterator = eParameters.iterator();
        while (iterator.hasNext()) {
            EParameter parameter = (EParameter)iterator.next();
            this.unparseMappingParameter((VarParameter)parameter, true);
            if (!iterator.hasNext()) continue;
            this.addText(", ");
        }
    }

    private void unparseMappingParameter(VarParameter parameter, boolean withDirectionAndName) {
        this.unparseMappingParameter(parameter, withDirectionAndName, withDirectionAndName);
    }

    private void unparseMappingParameter(VarParameter parameter, boolean withDirection, boolean withName) {
        String directionText = withDirection ? parameter.getKind().getLiteral() : "";
        String separatorText = withDirection && withName ? " " : "";
        String nameText = withName ? parameter.getName() : "";
        String semicolonText = withDirection || withName ? " : " : "";
        this.addText(String.valueOf(directionText) + separatorText + nameText + semicolonText);
        this.unparseType((EClassifier)parameter.getType());
        if (parameter instanceof MappingParameter) {
            this.unparseExtentReference((Variable)((MappingParameter)parameter).getExtent());
        }
    }

    private void unparseMappingExtensions(EList<MappingOperation> inherited, EList<MappingOperation> merged, EList<MappingOperation> disjunct) {
        this.unparseMappingExtension("inherits", inherited);
        this.unparseMappingExtension("merges", merged);
        this.unparseMappingExtension("disjuncts", disjunct);
    }

    private void unparseMappingExtension(String relates, EList<MappingOperation> extendedOperations) {
        if (extendedOperations != null && extendedOperations.size() > 0) {
            this.addLineBreak();
            this.addText(String.valueOf(relates) + " ");
            Iterator operationIterator = extendedOperations.iterator();
            while (operationIterator.hasNext()) {
                this.addText(this.getFullOperationName((ImperativeOperation)operationIterator.next()));
                if (!operationIterator.hasNext()) continue;
                this.addText(",");
            }
        }
    }

    private void unparseMappingRefinement(ImperativeOperation refinedOperation) {
        if (refinedOperation != null) {
            this.addLineBreak();
            this.addText("refines ");
            this.addText(this.getFullOperationName(refinedOperation));
            this.addLineBreak();
        }
    }

    private void unparseMappingConditions(EList<org.eclipse.ocl.ecore.OCLExpression> when, org.eclipse.ocl.ecore.OCLExpression where) {
        this.unparseMappingConditionList("when", when);
        this.unparseMappingCondition("where", this.guaranteeBooleanExp(where));
    }

    private void unparseMappingConditionList(String preOrPost, EList<org.eclipse.ocl.ecore.OCLExpression> condition) {
        if (condition != null && condition.size() > 0) {
            this.addLineBreak();
            this.addText(String.valueOf(preOrPost) + " ");
            this.unparseOCLExpressions("{ ", condition, "; ", " }", false, false, false);
        }
    }

    private void unparseMappingCondition(String preOrPost, org.eclipse.ocl.ecore.OCLExpression oclExpression) {
        if (oclExpression != null) {
            BasicEList conditionList = new BasicEList();
            conditionList.add((Object)oclExpression);
            this.unparseMappingConditionList(preOrPost, (EList<org.eclipse.ocl.ecore.OCLExpression>)conditionList);
        }
    }

    private org.eclipse.ocl.ecore.OCLExpression guaranteeBooleanExp(org.eclipse.ocl.ecore.OCLExpression expression) {
        if (expression instanceof BlockExp) {
            BlockExp block = (BlockExp)expression;
            EList body = block.getBody();
            return (org.eclipse.ocl.ecore.OCLExpression)body.get(0);
        }
        return expression;
    }

    private boolean checkMappingNeedsInit(MappingOperation operation) {
        EList mappingParameters = operation.getEParameters();
        EList mappingResults = operation.getResult();
        BasicEList outParameters = new BasicEList();
        for (VarParameter mappingParameter : mappingParameters) {
            DirectionKind directionKind = mappingParameter.getKind();
            if (!directionKind.equals((Object)DirectionKind.INOUT) && !directionKind.equals((Object)DirectionKind.OUT)) continue;
            outParameters.add((Object)mappingParameter);
        }
        outParameters.addAll((Collection)mappingResults);
        for (VarParameter varParameter : outParameters) {
            EClassifier parameterType = (EClassifier)varParameter.getType();
            if (!(parameterType instanceof EClass) || !((EClass)parameterType).isAbstract()) continue;
            return true;
        }
        return false;
    }

    public Object visitMappingBody(MappingBody mappingBody) {
        this.unparseMappingBody(mappingBody, false);
        return null;
    }

    private void unparseMappingBody(MappingBody mappingBody, boolean needsInit) {
        boolean hasBody;
        boolean hasInit = mappingBody.getInitSection() != null && mappingBody.getInitSection().size() > 0;
        boolean hasPopulation = mappingBody.getContent() != null && mappingBody.getContent().size() > 0;
        boolean hasEnd = mappingBody.getEndSection() != null && mappingBody.getEndSection().size() > 0;
        boolean bl = hasBody = hasInit || hasPopulation || hasEnd;
        if (hasBody) {
            this.addLineBreak();
            this.addTextAndIndent("{");
            this.addLineBreak();
            if (hasInit || needsInit) {
                this.unparseBodySection("init", (EList<org.eclipse.ocl.ecore.OCLExpression>)mappingBody.getInitSection());
            }
            if (hasPopulation) {
                this.unparsePopulationSection((EList<org.eclipse.ocl.ecore.OCLExpression>)mappingBody.getContent());
            }
            if (hasEnd) {
                this.unparseBodySection("end", (EList<org.eclipse.ocl.ecore.OCLExpression>)mappingBody.getEndSection());
            }
            this.unindentAndAddText("}");
        } else {
            this.addText(";");
        }
    }

    private void unparsePopulationSection(EList<org.eclipse.ocl.ecore.OCLExpression> content) {
        ObjectExp objExp;
        Variable referredObject;
        if (content == null || content.size() == 0) {
            return;
        }
        if (content.size() == 1 && content.get(0) instanceof ObjectExp && (referredObject = (objExp = (ObjectExp)content.get(0)).getReferredObject()) != null && referredObject.getName() == "result") {
            ConstructorBody constructorBody = objExp.getBody();
            if (constructorBody == null) {
                return;
            }
            this.unparseOCLExpressionsLinebreakSeparated(constructorBody.getContent(), true);
            return;
        }
        this.unparseBodySection("population", content);
    }

    public Object visitHelper(Helper helper) {
        this.unparseHelper(helper);
        return null;
    }

    private void unparseHelper(Helper helper) {
        boolean isBlackbox = helper.isIsBlackbox();
        if (isBlackbox) {
            this.addText("blackbox ");
        }
        String keyword = helper.isIsQuery() ? "query " : "helper ";
        this.addText(keyword);
        this.unparseHelperContext(helper.getContext());
        this.addText(String.valueOf(helper.getName()) + "(");
        this.unparseMappingParameters((EList<EParameter>)helper.getEParameters());
        this.addText(")");
        this.unparseVarParameters((EList<VarParameter>)helper.getResult(), true);
        if (isBlackbox) {
            this.addText(";");
        } else {
            this.addLineBreak();
            this.unparseOperationBody(helper.getBody());
        }
        this.addLineBreak();
    }

    private void unparseBodySection(String sectionName, EList<org.eclipse.ocl.ecore.OCLExpression> content) {
        if (sectionName != null && sectionName.length() > 0) {
            this.addText(sectionName);
            this.addLineBreak();
        }
        this.unparseOCLExpressionsLinebreakSeparatedInBraces(content, true);
        this.addLineBreak();
    }

    private <T extends OCLExpression<EClassifier>> void unparseOCLExpressions(String head, EList<T> content, String separatorSuffix, String tail, boolean suffixAlways, boolean indented, boolean onSeperateLines) {
        if (head != null) {
            this.addText(head);
            if (onSeperateLines) {
                this.addLineBreak();
            }
        }
        if (indented) {
            this.indent();
        }
        Iterator expressionIterator = content.iterator();
        while (expressionIterator.hasNext()) {
            OCLExpression expression = (OCLExpression)expressionIterator.next();
            this.unparseOCLExpression(expression);
            if (expressionIterator.hasNext() || suffixAlways) {
                this.addText(separatorSuffix);
            }
            if (!onSeperateLines) continue;
            this.addLineBreak();
        }
        if (indented) {
            this.unindent();
        }
        if (tail != null) {
            this.addText(tail);
            if (onSeperateLines) {
                this.addLineBreak();
            }
        }
    }

    private <T extends OCLExpression<EClassifier>> void unparseOCLExpressionsCommaSeparatedInBrackets(EList<T> list) {
        this.unparseOCLExpressions("[", list, ",", "]", false, false, false);
    }

    private <T extends OCLExpression<EClassifier>> void unparseOCLExpressionsCommaSeparatedInParentheses(EList<T> list) {
        this.unparseOCLExpressions("(", list, ",", ")", false, false, false);
    }

    private <T extends OCLExpression<EClassifier>> void unparseOCLExpressionsSemicolonSeparatedInBraces(EList<T> list, boolean suffixAlways) {
        this.unparseOCLExpressions("{", list, ";", " }", suffixAlways, false, false);
    }

    private <T extends OCLExpression<EClassifier>> void unparseOCLExpressionsLinebreakSeparated(EList<T> list, boolean suffixAlways) {
        this.unparseOCLExpressions(null, list, ";", null, suffixAlways, false, true);
    }

    private <T extends OCLExpression<EClassifier>> void unparseOCLExpressionsLinebreakSeparatedInBraces(EList<T> list, boolean suffixAlways) {
        this.unparseOCLExpressions("{", list, ";", "}", suffixAlways, true, true);
    }

    private <T extends OCLExpression<EClassifier>> void unparseOCLExpression(T expression) {
        if (expression == null) {
            return;
        }
        if (expression instanceof CallExp) {
            this.unparseCallExpressions((CallExp)expression);
        } else if (expression instanceof IfExp) {
            this.unparseIfExp((org.eclipse.ocl.expressions.IfExp<EClassifier>)((IfExp)expression));
        } else if (expression instanceof ImperativeExpression) {
            this.unparseImperativeExpressions((ImperativeExpression)expression);
        } else if (expression instanceof LetExp) {
            this.unparseLetExp((org.eclipse.ocl.expressions.LetExp<EClassifier, EParameter>)((LetExp)expression));
        } else if (expression instanceof LiteralExp) {
            this.unparseLiteralExpressions((LiteralExp)expression);
        } else if (expression instanceof org.eclipse.ocl.ecore.MessageExp) {
            this.unparseMessageExp((MessageExp<EClassifier, CallOperationAction, SendSignalAction>)((org.eclipse.ocl.ecore.MessageExp)expression));
        } else if (expression instanceof org.eclipse.ocl.ecore.StateExp) {
            this.unparseStateExp((StateExp<EClassifier, EObject>)((org.eclipse.ocl.ecore.StateExp)expression));
        } else if (expression instanceof org.eclipse.ocl.ecore.TypeExp) {
            this.unparseTypeExp((TypeExp<EClassifier>)((org.eclipse.ocl.ecore.TypeExp)expression));
        } else if (expression instanceof org.eclipse.ocl.ecore.UnspecifiedValueExp) {
            this.unparseUnspecifiedValueExp((UnspecifiedValueExp<EClassifier>)((org.eclipse.ocl.ecore.UnspecifiedValueExp)expression));
        } else if (expression instanceof org.eclipse.ocl.ecore.VariableExp) {
            this.unparseVariableExp((VariableExp<EClassifier, EParameter>)((org.eclipse.ocl.ecore.VariableExp)expression));
        } else {
            this.addText("/*___unhandledOCLExpression:" + expression.getName() + "___*/");
        }
    }

    private void unparseCallExpressions(CallExp expression) {
        if (expression instanceof FeatureCallExp) {
            this.unparseFeatureCallExpressions((FeatureCallExp)expression);
        } else if (expression instanceof LoopExp) {
            this.unparseLoopExpressions((LoopExp)expression);
        } else if (expression instanceof ResolveExp) {
            this.unparseResolveExpressions((ResolveExp)expression);
        }
    }

    private void unparseFeatureCallExpressions(FeatureCallExp expression) {
        if (expression instanceof NavigationCallExp) {
            this.unparseNavigationCallExpressions((NavigationCallExp)expression);
        } else if (expression instanceof OperationCallExp) {
            this.unparseOperationCallExpressions((OperationCallExp)expression);
        }
    }

    private void unparseNavigationCallExpressions(NavigationCallExp expression) {
        if (expression instanceof AssociationClassCallExp) {
            this.unparseAssociationClassCallExp((org.eclipse.ocl.expressions.AssociationClassCallExp<EClassifier, EStructuralFeature>)((AssociationClassCallExp)expression));
        } else if (expression instanceof OppositePropertyCallExp) {
            this.unparseOppositePropertyCallExp((OppositePropertyCallExp)expression);
        } else if (expression instanceof PropertyCallExp) {
            this.unparsePropertyCallExp((org.eclipse.ocl.expressions.PropertyCallExp<EClassifier, EStructuralFeature>)((PropertyCallExp)expression));
        }
    }

    public Object visitAssociationClassCallExp(org.eclipse.ocl.expressions.AssociationClassCallExp<EClassifier, EStructuralFeature> call) {
        this.unparseAssociationClassCallExp(call);
        return null;
    }

    private void unparseAssociationClassCallExp(org.eclipse.ocl.expressions.AssociationClassCallExp<EClassifier, EStructuralFeature> call) {
        this.unparseOCLExpression(call.getSource());
        this.addText("." + ((EStructuralFeature)call.getNavigationSource()).getName());
        this.unparseOCLExpressionsCommaSeparatedInBrackets(call.getQualifier());
        if (call.isMarkedPre()) {
            this.addText("@pre");
        }
    }

    private void unparseOppositePropertyCallExp(OppositePropertyCallExp call) {
        this.unparseOCLExpression(call.getSource());
        this.addText("." + call.getReferredOppositeProperty().getName());
        this.unparseOCLExpressionsCommaSeparatedInBrackets(call.getQualifier());
        if (call.isMarkedPre()) {
            this.addText("@pre");
        }
    }

    public Object visitPropertyCallExp(org.eclipse.ocl.expressions.PropertyCallExp<EClassifier, EStructuralFeature> call) {
        this.unparsePropertyCallExp(call);
        return null;
    }

    private void unparsePropertyCallExp(org.eclipse.ocl.expressions.PropertyCallExp<EClassifier, EStructuralFeature> call) {
        OCLExpression source = call.getSource();
        if (source instanceof VariableExp && this.variableNameIsGeneratedTemp(((VariableExp)source).getReferredVariable().getName())) {
            this.addText("/* " + ((VariableExp)source).getReferredVariable().getName() + "*/");
        } else if (source != null) {
            if (source instanceof VariableExp) {
                boolean namePrinted = this.unparseVariableExp((VariableExp<EClassifier, EParameter>)((VariableExp)source));
                if (namePrinted) {
                    this.addText(".");
                }
            } else {
                this.unparseOCLExpression(source);
                this.addText(".");
            }
        } else {
            this.addText("/*___sourceIsNull___*/");
        }
        EStructuralFeature referredProperty = (EStructuralFeature)call.getReferredProperty();
        String propertyName = referredProperty.getName();
        String propertyText = this.escapeKeywordName(propertyName);
        this.addText(propertyText);
        EList qualifier = call.getQualifier();
        if (qualifier != null && qualifier.size() > 0) {
            this.unparseOCLExpressionsCommaSeparatedInBrackets(qualifier);
        }
        if (call.isMarkedPre()) {
            this.addText("@pre");
        }
    }

    private void unparseOperationCallExpressions(OperationCallExp expression) {
        if (expression instanceof ImperativeCallExp) {
            this.unparseImperativeCallExpressions((ImperativeCallExp)expression);
        } else if (expression instanceof LogExp) {
            this.unparseLogExp((LogExp)expression);
        } else {
            this.unparseOperationCallExp((org.eclipse.ocl.expressions.OperationCallExp<EClassifier, EOperation>)expression);
        }
    }

    private void unparseImperativeCallExpressions(ImperativeCallExp expression) {
        if (expression instanceof MappingCallExp) {
            this.unparseMappingCallExp((MappingCallExp)expression);
        } else {
            this.unparseImperativeCallExp(expression);
        }
    }

    public Object visitMappingCallExp(MappingCallExp expression) {
        this.unparseMappingCallExp(expression);
        return null;
    }

    private void unparseMappingCallExp(MappingCallExp expression) {
        this.unparseOperationCallExp((org.eclipse.ocl.expressions.OperationCallExp<EClassifier, EOperation>)expression);
    }

    private void unparseImperativeCallExp(ImperativeCallExp expression) {
        this.unparseOperationCallExp((org.eclipse.ocl.expressions.OperationCallExp<EClassifier, EOperation>)expression);
    }

    public Object visitLogExp(LogExp log) {
        this.unparseLogExp(log);
        return null;
    }

    private void unparseLogExp(LogExp log) {
        this.addText("log");
        this.unparseOCLExpressionsCommaSeparatedInParentheses(log.getArgument());
        org.eclipse.ocl.ecore.OCLExpression condition = log.getCondition();
        if (condition != null) {
            this.addText(" when ");
            this.unparseOCLExpression(condition);
        }
    }

    public Object visitOperationCallExp(org.eclipse.ocl.expressions.OperationCallExp<EClassifier, EOperation> expression) {
        this.unparseOperationCallExp(expression);
        return null;
    }

    private void unparseOperationCallExp(org.eclipse.ocl.expressions.OperationCallExp<EClassifier, EOperation> expression) {
        EList argumentList;
        EOperation referredOperation;
        String operationName;
        OCLExpression source = expression.getSource();
        String selector = "";
        boolean parenthesize = false;
        if (source != null) {
            boolean sourceIsCollection = source.getType() instanceof CollectionType;
            String string = selector = sourceIsCollection ? "->" : ".";
            if (source.getType() instanceof Library) {
                selector = "";
            }
        }
        String string = operationName = (referredOperation = (EOperation)expression.getReferredOperation()) != null ? referredOperation.getName() : "/*___referredOperationWasNull___*/";
        if (expression instanceof MappingCallExp) {
            String mappingCallText = ((MappingCallExp)expression).isIsStrict() ? "xmap " : "map ";
            operationName = String.valueOf(mappingCallText) + operationName;
        }
        if (operationName.equals("=") || operationName.equals("+") || operationName.equals("-") || operationName.equals("*") || operationName.equals("/") || operationName.equals("%") || operationName.equals(">") || operationName.equals("<")) {
            selector = "";
            parenthesize = true;
        } else if (operationName.equals("<>") || operationName.equals("!=")) {
            selector = "";
            operationName = " != ";
            parenthesize = true;
        } else if (operationName.equals("and")) {
            selector = "";
            operationName = " and ";
            parenthesize = true;
        } else if (operationName.equals("or")) {
            selector = "";
            operationName = " or ";
            parenthesize = true;
        }
        if (parenthesize) {
            this.addText("(");
        }
        boolean hasArguments = (argumentList = expression.getArgument()) != null & argumentList.size() > 0;
        if (operationName.equals("-") && !hasArguments) {
            this.addText(String.valueOf(selector) + operationName);
            this.unparseOCLExpression((org.eclipse.ocl.ecore.OCLExpression)source);
        } else {
            if (source instanceof VariableExp) {
                boolean isPrinted = this.unparseVariableExp((VariableExp<EClassifier, EParameter>)((VariableExp)source));
                selector = isPrinted ? selector : "";
            } else {
                this.unparseOCLExpression((org.eclipse.ocl.ecore.OCLExpression)source);
            }
            this.addText(String.valueOf(selector) + operationName);
            this.unparseArgumentList(argumentList);
        }
        if (parenthesize) {
            this.addText(")");
        }
    }

    private <T extends OCLExpression<EClassifier>> void unparseArgumentList(EList<T> argumentList) {
        this.addText("(");
        Iterator iterator = argumentList.iterator();
        while (iterator.hasNext()) {
            OCLExpression argument = (OCLExpression)iterator.next();
            this.unparseOCLExpression((org.eclipse.ocl.ecore.OCLExpression)argument);
            if (!iterator.hasNext()) continue;
            this.addText(", ");
        }
        this.addText(")");
    }

    private void unparseLoopExpressions(LoopExp expression) {
        if (expression instanceof ImperativeLoopExp) {
            this.unparseImperativeLoopExpressions((ImperativeLoopExp)expression);
        } else if (expression instanceof org.eclipse.ocl.ecore.IterateExp) {
            this.unparseIterateExp((IterateExp<EClassifier, EParameter>)((org.eclipse.ocl.ecore.IterateExp)expression));
        } else if (expression instanceof IteratorExp) {
            this.unparseIteratorExp((org.eclipse.ocl.expressions.IteratorExp<EClassifier, EParameter>)((IteratorExp)expression));
        }
    }

    private void unparseImperativeLoopExpressions(ImperativeLoopExp expression) {
        if (expression instanceof ForExp) {
            this.unparseForExp((ForExp)expression);
        } else if (expression instanceof ImperativeIterateExp) {
            this.unparseImperativeIterateExp((ImperativeIterateExp)expression);
        }
    }

    public Object visitForExp(ForExp expression) {
        this.unparseForExp(expression);
        return null;
    }

    private void unparseForExp(ForExp expression) {
        this.unparseOCLExpression((org.eclipse.ocl.ecore.OCLExpression)expression.getSource());
        this.addText("->" + expression.getName() + "(");
        this.unparseLoopExpIterator((EList<org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>>)expression.getIterator(), false);
        if (expression.getCondition() != null) {
            this.addText("|");
            this.unparseImperativeLoopExpCondition(expression.getCondition());
        }
        this.addText(")");
        this.unparseBlockExpBody((org.eclipse.ocl.ecore.OCLExpression)expression.getBody());
    }

    public Object visitImperativeIterateExp(ImperativeIterateExp expression) {
        this.unparseImperativeIterateExp(expression);
        return null;
    }

    private void unparseImperativeIterateExp(ImperativeIterateExp expression) {
        this.unparseOCLExpression((org.eclipse.ocl.ecore.OCLExpression)expression.getSource());
        this.addText("->" + expression.getName() + "(");
        this.unparseLoopExpIterator((EList<org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>>)expression.getIterator(), true);
        if (expression.getTarget() != null) {
            this.addText(";");
            this.unparseVariable((org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)expression.getTarget(), false);
            this.addText("=");
            this.unparseOCLExpression((org.eclipse.ocl.ecore.OCLExpression)expression.getBody());
            this.addText("|");
            this.unparseImperativeLoopExpCondition(expression.getCondition());
        } else {
            this.addText("|");
            this.unparseImperativeLoopExpBodyXorCondition((ImperativeLoopExp)expression);
        }
        this.addText(")");
    }

    private void unparseLoopExpIterator(EList<org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>> loopIteratorList, boolean withType) {
        if (loopIteratorList != null && loopIteratorList.size() > 0) {
            Iterator iterator = loopIteratorList.iterator();
            while (iterator.hasNext()) {
                org.eclipse.ocl.expressions.Variable loopIterator = (org.eclipse.ocl.expressions.Variable)iterator.next();
                this.unparseVariableNameType((org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)loopIterator, withType);
                if (!iterator.hasNext()) continue;
                this.addText(",");
            }
        }
    }

    private void unparseImperativeLoopExpBodyXorCondition(ImperativeLoopExp expression) {
        if (expression.getBody() != null && expression.getCondition() == null) {
            this.unparseLoopExpBody((org.eclipse.ocl.ecore.OCLExpression)expression.getBody());
        } else if (expression.getBody() == null && expression.getCondition() != null) {
            this.unparseImperativeLoopExpCondition(expression.getCondition());
        } else {
            this.addText("/*body:" + expression.getBody() + "; condition:" + expression.getCondition() + "*/");
        }
    }

    private void unparseLoopExpBody(org.eclipse.ocl.ecore.OCLExpression body) {
        this.unparseOCLExpression(body);
    }

    private void unparseImperativeLoopExpCondition(org.eclipse.ocl.ecore.OCLExpression condition) {
        if (condition instanceof org.eclipse.ocl.ecore.TypeExp) {
            this.unparseTypeExp((TypeExp<EClassifier>)((org.eclipse.ocl.ecore.TypeExp)condition));
        } else {
            this.unparseOCLExpression(condition);
        }
    }

    public Object visitIterateExp(IterateExp<EClassifier, EParameter> iterateExp) {
        this.unparseIterateExp(iterateExp);
        return null;
    }

    private void unparseIterateExp(IterateExp<EClassifier, EParameter> iterateExp) {
        this.unparseOCLExpression((org.eclipse.ocl.ecore.OCLExpression)iterateExp.getSource());
        this.addText("->iterate(");
        this.unparseVariablesCommaSeparated((EList<org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>>)iterateExp.getIterator());
        this.addText(";");
        this.unparseVariable((org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)iterateExp.getResult(), true);
        this.addText("|");
        this.unparseOCLExpression(iterateExp.getBody());
        this.addText(")");
    }

    public Object visitIteratorExp(org.eclipse.ocl.expressions.IteratorExp<EClassifier, EParameter> expression) {
        this.unparseIteratorExp(expression);
        return null;
    }

    private void unparseIteratorExp(org.eclipse.ocl.expressions.IteratorExp<EClassifier, EParameter> expression) {
        this.unparseOCLExpression((org.eclipse.ocl.ecore.OCLExpression)expression.getSource());
        this.addText("->" + expression.getName() + "(");
        this.unparseLoopExpIterator((EList<org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>>)expression.getIterator(), true);
        this.addText("|");
        this.unparseLoopExpBody((org.eclipse.ocl.ecore.OCLExpression)expression.getBody());
        this.addText(")");
    }

    private void unparseResolveExpressions(ResolveExp expression) {
        if (expression instanceof ResolveInExp) {
            this.unparseResolveInExp((ResolveInExp)expression);
        } else {
            this.unparseResolveExp(expression);
        }
    }

    public Object visitResolveExp(ResolveExp expression) {
        this.unparseResolveExp(expression);
        return null;
    }

    public Object visitResolveInExp(ResolveInExp expression) {
        this.unparseResolveInExp(expression);
        return null;
    }

    private void unparseResolveExp(ResolveExp expression) {
        this.unparseSource((OCLExpression<EClassifier>)expression.getSource());
        String resolveKindText = this.constructResolveKindText(expression);
        this.addText(String.valueOf(resolveKindText) + "(");
        Variable target = expression.getTarget();
        if (target != null) {
            boolean hasCondition = expression.getCondition() != null;
            String targetNameText = hasCondition ? String.valueOf(target.getName()) + " : " : "";
            this.addText(targetNameText);
            this.unparseType((EClassifier)target.getType());
        }
        this.unparseResolveExpCondition(expression.getCondition());
        this.addText(")");
    }

    private void unparseResolveInExp(ResolveInExp expression) {
        this.unparseSource((OCLExpression<EClassifier>)expression.getSource());
        String resolveInKindText = this.constructResolveKindText((ResolveExp)expression);
        resolveInKindText = String.valueOf(resolveInKindText) + "In";
        this.addText(String.valueOf(resolveInKindText) + "(");
        MappingOperation inMapping = expression.getInMapping();
        String inMappingText = inMapping != null ? this.getFullOperationName((ImperativeOperation)inMapping) : "/*___InMappingWasNull___*/";
        this.addText(inMappingText);
        Variable target = expression.getTarget();
        if (target != null) {
            boolean hasCondition = expression.getCondition() != null;
            String targetNameText = hasCondition ? String.valueOf(target.getName()) + " : " : "";
            this.addText(", " + targetNameText);
            this.unparseType((EClassifier)target.getType());
        }
        this.unparseResolveExpCondition(expression.getCondition());
        this.addText(")");
    }

    private void unparseSource(OCLExpression<EClassifier> source) {
        if (source != null) {
            if (source instanceof VariableExp) {
                boolean isPrinted = this.unparseVariableExp((VariableExp<EClassifier, EParameter>)((VariableExp)source));
                this.addText(isPrinted ? "." : "");
            } else {
                this.unparseOCLExpression((org.eclipse.ocl.ecore.OCLExpression)source);
                this.addText(".");
            }
        }
    }

    private String constructResolveKindText(ResolveExp expression) {
        String resolveInKindText = "resolve";
        resolveInKindText = expression.isIsInverse() ? "inv" + resolveInKindText : resolveInKindText;
        resolveInKindText = String.valueOf(resolveInKindText) + (expression.isOne() ? "one" : "");
        resolveInKindText = expression.isIsDeferred() ? "late " + resolveInKindText : resolveInKindText;
        return resolveInKindText;
    }

    private void unparseResolveExpCondition(org.eclipse.ocl.ecore.OCLExpression resolveCondition) {
        if (resolveCondition != null) {
            this.addText(" | ");
            this.unparseImperativeLoopExpCondition(resolveCondition);
        }
    }

    public Object visitIfExp(org.eclipse.ocl.expressions.IfExp<EClassifier> expression) {
        this.unparseIfExp(expression);
        return null;
    }

    private void unparseIfExp(org.eclipse.ocl.expressions.IfExp<EClassifier> expression) {
        this.addText("if (");
        this.unparseOCLExpression((org.eclipse.ocl.ecore.OCLExpression)expression.getCondition());
        this.addText(")");
        this.indent();
        this.addLineBreak();
        this.addTextAndIndent("then ");
        this.unparseOCLExpression((org.eclipse.ocl.ecore.OCLExpression)expression.getThenExpression());
        if (expression.getElseExpression() != null) {
            this.addLineBreak();
            this.unindentAndAddText("else ");
            this.indent();
            this.unparseOCLExpression((org.eclipse.ocl.ecore.OCLExpression)expression.getElseExpression());
        }
        this.addLineBreak();
        this.unindentAndAddText("endif ");
        this.unindent();
    }

    private void unparseImperativeExpressions(ImperativeExpression expression) {
        if (expression instanceof AltExp) {
            this.unparseAltExp((AltExp)expression);
        } else if (expression instanceof AssertExp) {
            this.unparseAssertExp((AssertExp)expression);
        } else if (expression instanceof AssignExp) {
            this.unparseAssignExp((AssignExp)expression);
        } else if (expression instanceof BlockExp) {
            this.unparseBlockExp((BlockExp)expression, true, false);
        } else if (expression instanceof BreakExp) {
            this.unparseBreakExp((BreakExp)expression);
        } else if (expression instanceof CatchExp) {
            this.unparseCatchExp((CatchExp)expression);
        } else if (expression instanceof ComputeExp) {
            this.unparseComputeExp((ComputeExp)expression);
        } else if (expression instanceof ContinueExp) {
            this.unparseContinueExp((ContinueExp)expression);
        } else if (expression instanceof InstantiationExp) {
            this.unparseInstantiationExpressions((InstantiationExp)expression);
        } else if (expression instanceof RaiseExp) {
            this.unparseRaiseExp((RaiseExp)expression);
        } else if (expression instanceof ReturnExp) {
            this.unparseReturnExp((ReturnExp)expression);
        } else if (expression instanceof SwitchExp) {
            this.unparseSwitchExp((SwitchExp)expression);
        } else if (expression instanceof TryExp) {
            this.unparseTryExp((TryExp)expression);
        } else if (expression instanceof UnlinkExp) {
            this.unparseUnlinkExp((UnlinkExp)expression);
        } else if (expression instanceof UnpackExp) {
            this.unparseUnpackExp((UnpackExp)expression);
        } else if (expression instanceof VariableInitExp) {
            this.unparseVariableInitExp((VariableInitExp)expression);
        } else if (expression instanceof WhileExp) {
            this.unparseWhileExp((WhileExp)expression);
        }
    }

    public Object visitAltExp(AltExp astNode) {
        this.unparseAltExp(astNode);
        return null;
    }

    private void unparseAltExp(AltExp astNode) {
        this.addText("AltExp");
    }

    public Object visitAssertExp(AssertExp assertExpression) {
        this.unparseAssertExp(assertExpression);
        return null;
    }

    private void unparseAssertExp(AssertExp assertExpression) {
        this.addText("assert ");
        SeverityKind severity = assertExpression.getSeverity();
        if (severity != null) {
            this.addText(String.valueOf(severity.getLiteral()) + " ");
        }
        this.addText("(");
        this.unparseOCLExpression(assertExpression.getAssertion());
        this.addText(")");
        LogExp logExpression = assertExpression.getLog();
        if (logExpression != null) {
            this.addText(" with ");
            this.unparseLogExp(logExpression);
        }
    }

    public Object visitAssignExp(AssignExp assignment) {
        this.unparseAssignExp(assignment);
        return null;
    }

    private void unparseAssignExp(AssignExp assignment) {
        this.unparseOCLExpression(assignment.getLeft());
        String operatorText = assignment.isIsReset() ? " := " : " += ";
        this.addText(operatorText);
        if (assignment.getValue().size() == 1) {
            this.unparseOCLExpression((org.eclipse.ocl.ecore.OCLExpression)assignment.getValue().get(0));
        } else {
            this.unparseOCLExpressionsSemicolonSeparatedInBraces(assignment.getValue(), false);
        }
    }

    public Object visitBlockExp(BlockExp block) {
        this.unparseBlockExp(block, true, false);
        return null;
    }

    private void unparseBlockExp(BlockExp block, boolean printDo, boolean suffixAlways) {
        if (printDo) {
            this.addText("do ");
        }
        this.unparseOCLExpressionsSemicolonSeparatedInBraces(block.getBody(), suffixAlways);
    }

    public Object visitBreakExp(BreakExp expression) {
        this.unparseBreakExp(expression);
        return null;
    }

    private void unparseBreakExp(BreakExp expression) {
        this.addText("break");
    }

    public Object visitCatchtExp(CatchExp expression) {
        this.unparseCatchExp(expression);
        return null;
    }

    private void unparseCatchExpressions(EList<CatchExp> catchExpressions) {
        for (CatchExp catchExpression : catchExpressions) {
            this.unparseCatchExp(catchExpression);
        }
    }

    private void unparseCatchExp(CatchExp expression) {
        this.addText("except (");
        EAnnotation catchVarAnnotation = expression.getEAnnotation("http://www.eclipse.org/m2m/1.0.0/QVT/catchVar");
        if (catchVarAnnotation != null) {
            this.unparseCatchVarAnnotation(catchVarAnnotation);
        }
        this.unparseCatchExpExceptions((EList<EClassifier>)expression.getException());
        this.addText(") ");
        this.unparseTryBody((EList<org.eclipse.ocl.ecore.OCLExpression>)expression.getBody());
    }

    private void unparseCatchVarAnnotation(EAnnotation catchVarAnnotation) {
        EObject exceptionObject;
        EList contents = catchVarAnnotation.getContents();
        if (contents != null && contents.size() > 0 && (exceptionObject = (EObject)contents.get(0)) instanceof org.eclipse.ocl.expressions.Variable) {
            org.eclipse.ocl.expressions.Variable catchVariable = (org.eclipse.ocl.expressions.Variable)exceptionObject;
            this.addText(String.valueOf(catchVariable.getName()) + ":");
        }
    }

    private void unparseCatchExpExceptions(EList<EClassifier> exceptions) {
        if (exceptions == null) {
            return;
        }
        Iterator iterator = exceptions.iterator();
        while (iterator.hasNext()) {
            EClassifier exception = (EClassifier)iterator.next();
            this.addText(exception.getName());
            if (!iterator.hasNext()) continue;
            this.addText(",");
        }
    }

    public Object visitComputeExp(ComputeExp expression) {
        this.unparseComputeExp(expression);
        return null;
    }

    private void unparseComputeExp(ComputeExp expression) {
        Variable variable = expression.getReturnedElement();
        org.eclipse.ocl.ecore.OCLExpression body = expression.getBody();
        if (body instanceof WhileExp) {
            WhileExp whileExp = (WhileExp)body;
            this.addText("while (");
            this.unparseVariable((org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)variable, true);
            this.addText(";");
            this.unparseOCLExpression(whileExp.getCondition());
            this.addText(")");
            this.unparseBlockExpBody(whileExp.getBody());
        } else {
            this.addText("compute (");
            this.unparseVariable((org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)variable, true);
            this.addText(")");
            this.unparseBlockExpBody(body);
        }
    }

    public Object visitContinueExp(ContinueExp expression) {
        this.unparseContinueExp(expression);
        return null;
    }

    private void unparseContinueExp(ContinueExp expression) {
        this.addText("continue");
    }

    private void unparseInstantiationExpressions(InstantiationExp expression) {
        if (expression instanceof ObjectExp) {
            this.unparseObjectExp((ObjectExp)expression);
        } else {
            this.unparseInstantiationExp(expression);
        }
    }

    public Object visitObjectExp(ObjectExp expression) {
        this.unparseObjectExp(expression);
        return null;
    }

    private void unparseObjectExp(ObjectExp expression) {
        this.addText("object ");
        if (expression.getReferredObject() != null) {
            this.unparseVariableNameType((org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)expression.getReferredObject());
        }
        this.unparseExtentReference(expression.getExtent());
        this.addText(" ");
        this.unparseConstructorBody(expression.getBody());
    }

    private void unparseExtentReference(Variable extent) {
        if (extent != null && !extent.getName().startsWith("$")) {
            this.addText("@" + extent.getName());
        }
    }

    public Object visitInstantiationExp(InstantiationExp expression) {
        this.unparseInstantiationExp(expression);
        return null;
    }

    private void unparseInstantiationExp(InstantiationExp expression) {
        this.addText("new ");
        this.unparseType((EClassifier)expression.getType());
        this.unparseExtentReference(expression.getExtent());
        this.unparseArgumentList(expression.getArgument());
    }

    public Object visitRaiseExp(RaiseExp raise) {
        this.unparseRaiseExp(raise);
        return null;
    }

    private void unparseRaiseExp(RaiseExp raise) {
        raise.getArgument();
        raise.getException();
        this.addText("raise ");
        this.unparseType(raise.getException());
        if (raise.getArgument() != null) {
            this.addText("(");
            this.unparseOCLExpression(raise.getArgument());
            this.addText(")");
        }
    }

    public Object visitReturnExp(ReturnExp expression) {
        this.unparseReturnExp(expression);
        return null;
    }

    private void unparseReturnExp(ReturnExp expression) {
        this.addText("return");
        if (expression.getValue() != null) {
            this.addText(" ");
            this.unparseOCLExpression(expression.getValue());
        }
    }

    public Object visitSwitchExp(SwitchExp svvitch) {
        this.unparseSwitchExp(svvitch);
        return null;
    }

    private void unparseSwitchExp(SwitchExp svvitch) {
        svvitch.getElsePart();
        this.addTextAndIndent("switch {");
        this.addLineBreak();
        EList altExpList = svvitch.getAlternativePart();
        for (AltExp altExp : altExpList) {
            this.addText("case (");
            this.unparseOCLExpression(altExp.getCondition());
            this.addText(") ");
            this.unparseOCLExpression(altExp.getBody());
            this.addText(";");
            this.addLineBreak();
        }
        if (svvitch.getElsePart() != null) {
            this.addText("else ");
            this.unparseOCLExpression(svvitch.getElsePart());
            this.addText(";");
            this.addLineBreak();
        }
        this.unindentAndAddText("}");
    }

    public Object visitTryExp(TryExp expression) {
        this.unparseTryExp(expression);
        return null;
    }

    private void unparseTryExp(TryExp expression) {
        this.addText("try ");
        EList tryBody = expression.getTryBody();
        this.unparseTryBody((EList<org.eclipse.ocl.ecore.OCLExpression>)tryBody);
        this.unparseCatchExpressions((EList<CatchExp>)expression.getExceptClause());
    }

    private void unparseTryBody(EList<org.eclipse.ocl.ecore.OCLExpression> tryBody) {
        EList unparseBody = tryBody;
        if (unparseBody.size() == 1 && unparseBody.get(0) instanceof BlockExp) {
            BlockExp block = (BlockExp)unparseBody.get(0);
            unparseBody = block.getBody();
        }
        this.unparseOCLExpressionsLinebreakSeparatedInBraces(unparseBody, true);
        this.addLineBreak();
    }

    public Object visitUnlinkExp(UnlinkExp unlink) {
        this.unparseUnlinkExp(unlink);
        return null;
    }

    private void unparseUnlinkExp(UnlinkExp unlink) {
        this.unparseOCLExpression(unlink.getTarget());
        this.addText(".unlink(");
        this.unparseOCLExpression(unlink.getItem());
        this.addText(")");
    }

    public Object visitUnpackExp(UnpackExp unpack) {
        this.unparseUnpackExp(unpack);
        return null;
    }

    private void unparseUnpackExp(UnpackExp unpack) {
        this.addText("var ");
        this.unparseOCLVariablesCommaSeparated((EList<Variable>)unpack.getTargetVariable());
        this.addText(" := ");
        this.unparseOCLExpression(unpack.getSource());
    }

    private void unparseOCLVariablesCommaSeparated(EList<Variable> list) {
        this.unparseOCLVariables("", "", list, ",", "");
    }

    private void unparseOCLVariables(String head, String prefix, EList<Variable> list, String separatorSuffix, String tail) {
        this.addText(head);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Variable variable = (Variable)iterator.next();
            this.addText(prefix);
            this.unparseVariable((org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)variable, false);
            if (!iterator.hasNext()) continue;
            this.addText(separatorSuffix);
        }
        this.addText(tail);
    }

    private void unparseVariablesCommaSeparated(EList<org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>> list) {
        this.unparseVariables("", "", list, ",", "");
    }

    private void unparseVariables(String head, String prefix, EList<org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>> list, String separatorSuffix, String tail) {
        this.addText(head);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            org.eclipse.ocl.expressions.Variable variable = (org.eclipse.ocl.expressions.Variable)iterator.next();
            this.addText(prefix);
            this.unparseVariable((org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)variable, false);
            if (!iterator.hasNext()) continue;
            this.addText(separatorSuffix);
        }
        this.addText(tail);
    }

    public Object visitVariableInitExp(VariableInitExp variableInit) {
        this.unparseVariableInitExp(variableInit);
        return null;
    }

    private void unparseVariableInitExp(VariableInitExp variableInit) {
        Variable variable = variableInit.getReferredVariable();
        String assignmentOp = variableInit.isWithResult() ? " ::= " : " := ";
        this.addText("var ");
        this.unparseVariable((org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)variable, false);
        org.eclipse.ocl.ecore.OCLExpression initExpression = (org.eclipse.ocl.ecore.OCLExpression)variable.getInitExpression();
        if (initExpression != null) {
            this.addText(assignmentOp);
            this.unparseOCLExpression(initExpression);
        }
    }

    public Object visitWhileExp(WhileExp vvhile) {
        this.unparseWhileExp(vvhile);
        return null;
    }

    private void unparseWhileExp(WhileExp vvhile) {
        this.addText("while ( ");
        this.unparseOCLExpression(vvhile.getCondition());
        this.addText(" )");
        this.unparseBlockExpBody(vvhile.getBody());
    }

    private void unparseBlockExpBody(org.eclipse.ocl.ecore.OCLExpression body) {
        if (body instanceof BlockExp) {
            BlockExp block = (BlockExp)body;
            this.unparseBlockExp(block, false, false);
        } else {
            this.addText("{ ");
            this.unparseOCLExpression(body);
            this.addText(" }");
        }
    }

    public Object visitLetExp(org.eclipse.ocl.expressions.LetExp<EClassifier, EParameter> letExp) {
        this.unparseLetExp(letExp);
        return null;
    }

    private void unparseLetExp(org.eclipse.ocl.expressions.LetExp<EClassifier, EParameter> letExp) {
        this.addText("let ");
        this.unparseVariable((org.eclipse.ocl.expressions.Variable<EClassifier, EParameter>)letExp.getVariable(), true);
        this.addText(" in ");
        this.unparseOCLExpression(letExp.getIn());
    }

    private void unparseLiteralExpressions(LiteralExp expression) {
        if (expression instanceof CollectionLiteralExp) {
            this.unparseCollectionLiteralExp((org.eclipse.ocl.expressions.CollectionLiteralExp<EClassifier>)((CollectionLiteralExp)expression));
        } else if (expression instanceof DictLiteralExp) {
            this.unparseDictLiteralExp((DictLiteralExp)expression);
        } else if (expression instanceof EnumLiteralExp) {
            this.unparseEnumLiteralExp((org.eclipse.ocl.expressions.EnumLiteralExp<EClassifier, EEnumLiteral>)((EnumLiteralExp)expression));
        } else if (expression instanceof InvalidLiteralExp) {
            this.unparseInvalidLiteralExp((org.eclipse.ocl.expressions.InvalidLiteralExp<EClassifier>)((InvalidLiteralExp)expression));
        } else if (expression instanceof ListLiteralExp) {
            this.unparseListLiteralExp((ListLiteralExp)expression);
        } else if (expression instanceof NullLiteralExp) {
            this.unparseNullLiteralExp((org.eclipse.ocl.expressions.NullLiteralExp<EClassifier>)((NullLiteralExp)expression));
        } else if (expression instanceof OrderedTupleLiteralExp) {
            this.unparseOrderedTupleLiteralExp((OrderedTupleLiteralExp)expression);
        } else if (expression instanceof PrimitiveLiteralExp) {
            this.unparsePrimitiveLiteralExpressions((PrimitiveLiteralExp)expression);
        } else if (expression instanceof TupleLiteralExp) {
            this.unparseTupleLiteralExp((org.eclipse.ocl.expressions.TupleLiteralExp<EClassifier, EStructuralFeature>)((TupleLiteralExp)expression));
        }
    }

    public Object visitCollectionLiteralExp(org.eclipse.ocl.expressions.CollectionLiteralExp<EClassifier> literalExp) {
        this.unparseCollectionLiteralExp(literalExp);
        return null;
    }

    private void unparseCollectionLiteralExp(org.eclipse.ocl.expressions.CollectionLiteralExp<EClassifier> literalExp) {
        if (literalExp.getKind().equals((Object)CollectionKind.SEQUENCE_LITERAL) && literalExp.getType() instanceof ListType) {
            this.unparseCollectionLiteralAsListLiteral(literalExp);
            return;
        }
        String collectionTypeText = literalExp.getKind().getName();
        EList partList = literalExp.getPart();
        this.unparseCollectionLiteralExp_TypeAndParts(collectionTypeText, (EList<CollectionLiteralPart<EClassifier>>)partList);
    }

    private void unparseCollectionLiteralExp_TypeAndParts(String collectionTypeText, EList<CollectionLiteralPart<EClassifier>> partList) {
        this.addText(String.valueOf(collectionTypeText) + " {");
        this.unparseCollectionLiteralParts(partList);
        this.addText("}");
    }

    private void unparseCollectionLiteralParts(EList<CollectionLiteralPart<EClassifier>> collectionLiteralPartList) {
        Iterator partItor = collectionLiteralPartList.iterator();
        while (partItor.hasNext()) {
            this.unparseCollectionLiteralPart((CollectionLiteralPart<EClassifier>)((CollectionLiteralPart)partItor.next()));
            if (!partItor.hasNext()) continue;
            this.addText(",");
        }
    }

    private void unparseCollectionLiteralPart(CollectionLiteralPart<EClassifier> collectionLiteralPart) {
        if (collectionLiteralPart instanceof CollectionItem) {
            this.unparseCollectionItem((CollectionItem<EClassifier>)((CollectionItem)collectionLiteralPart));
        } else if (collectionLiteralPart instanceof CollectionRange) {
            this.unparseCollectionRange((CollectionRange<EClassifier>)((CollectionRange)collectionLiteralPart));
        } else {
            this.addText("/*CollectionLiteralPart*/");
        }
    }

    public Object visitDictLiteralExp(DictLiteralExp dictLiteral) {
        this.unparseDictLiteralExp(dictLiteral);
        return null;
    }

    private void unparseDictLiteralExp(DictLiteralExp dictLiteral) {
        this.addText("Dict {");
        this.unparseDictLiteralParts((EList<DictLiteralPart>)dictLiteral.getPart());
        this.addText("}");
    }

    private void unparseDictLiteralParts(EList<DictLiteralPart> dictLiteralPartList) {
        Iterator partItor = dictLiteralPartList.iterator();
        while (partItor.hasNext()) {
            this.unparseDictLiteralPart((DictLiteralPart)partItor.next());
            if (!partItor.hasNext()) continue;
            this.addText(",");
        }
    }

    public Object visitDictLiteralPart(DictLiteralPart dictLiteralPart) {
        this.unparseDictLiteralPart(dictLiteralPart);
        return null;
    }

    private void unparseDictLiteralPart(DictLiteralPart dictLiteralPart) {
        this.unparseOCLExpression(dictLiteralPart.getKey());
        this.addText(" = ");
        this.unparseOCLExpression(dictLiteralPart.getValue());
    }

    public Object visitEnumLiteralExp(org.eclipse.ocl.expressions.EnumLiteralExp<EClassifier, EEnumLiteral> enumLiteral) {
        this.unparseEnumLiteralExp(enumLiteral);
        return null;
    }

    private void unparseEnumLiteralExp(org.eclipse.ocl.expressions.EnumLiteralExp<EClassifier, EEnumLiteral> enumLiteral) {
        EEnumLiteral referredEnumLiteral = (EEnumLiteral)enumLiteral.getReferredEnumLiteral();
        EClassifier enumType = (EClassifier)enumLiteral.getType();
        this.unparseType(enumType);
        String enumName = enumLiteral.getName();
        if (referredEnumLiteral != null) {
            enumName = referredEnumLiteral.getLiteral();
        }
        enumName = this.escapeKeywordName(enumName);
        this.addText("::" + enumName);
    }

    public Object visitInvalidLiteralExp(org.eclipse.ocl.expressions.InvalidLiteralExp<EClassifier> invalidLiteral) {
        this.unparseInvalidLiteralExp(invalidLiteral);
        return null;
    }

    private void unparseInvalidLiteralExp(org.eclipse.ocl.expressions.InvalidLiteralExp<EClassifier> invalidLiteral) {
        this.addText("invalid/*___InvalidLiteralExp___*/");
    }

    private void unparseListLiteralExp(ListLiteralExp listLiteral) {
        this.addText("List ");
        this.unparseOCLExpressionsSemicolonSeparatedInBraces(listLiteral.getElement(), false);
    }

    private void unparseCollectionLiteralAsListLiteral(org.eclipse.ocl.expressions.CollectionLiteralExp<EClassifier> collectionLiteral) {
        this.unparseCollectionLiteralExp_TypeAndParts("List", (EList<CollectionLiteralPart<EClassifier>>)collectionLiteral.getPart());
    }

    public Object visitNullLiteralExp(org.eclipse.ocl.expressions.NullLiteralExp<EClassifier> literalExp) {
        this.unparseNullLiteralExp(literalExp);
        return null;
    }

    private void unparseNullLiteralExp(org.eclipse.ocl.expressions.NullLiteralExp<EClassifier> literalExp) {
        this.addText("null");
    }

    public Object visitOrderedTupleLiteralExp(OrderedTupleLiteralExp tuple) {
        this.unparseOrderedTupleLiteralExp(tuple);
        return null;
    }

    private void unparseOrderedTupleLiteralExp(OrderedTupleLiteralExp tuple) {
        this.addText("Tuple {");
        this.unparseOrderedTupleLiteralParts((EList<OrderedTupleLiteralPart>)tuple.getPart());
        this.addText("}");
    }

    private void unparseOrderedTupleLiteralParts(EList<OrderedTupleLiteralPart> partList) {
        Iterator partItor = partList.iterator();
        while (partItor.hasNext()) {
            this.unparseOrderedTupleLiteralPart((OrderedTupleLiteralPart)partItor.next());
            if (!partItor.hasNext()) continue;
            this.addText(",");
        }
    }

    public Object visitOrderedTupleLiteralPart(OrderedTupleLiteralPart part) {
        this.unparseOrderedTupleLiteralPart(part);
        return null;
    }

    private void unparseOrderedTupleLiteralPart(OrderedTupleLiteralPart part) {
        this.unparseOCLExpression(part.getValue());
    }

    private void unparsePrimitiveLiteralExpressions(PrimitiveLiteralExp expression) {
        if (expression instanceof org.eclipse.ocl.ecore.BooleanLiteralExp) {
            this.unparseBooleanLiteralExp((BooleanLiteralExp<EClassifier>)((org.eclipse.ocl.ecore.BooleanLiteralExp)expression));
        } else if (expression instanceof NumericLiteralExp) {
            this.unparseNumericLiteralExp((NumericLiteralExp)expression);
        } else if (expression instanceof StringLiteralExp) {
            this.unparseStringLiteralExp((org.eclipse.ocl.expressions.StringLiteralExp<EClassifier>)((StringLiteralExp)expression));
        }
    }

    public Object visitBooleanLiteralExp(BooleanLiteralExp<EClassifier> literal) {
        this.unparseBooleanLiteralExp(literal);
        return null;
    }

    private void unparseBooleanLiteralExp(BooleanLiteralExp<EClassifier> literal) {
        this.addText(literal.getBooleanSymbol().toString());
    }

    private void unparseNumericLiteralExp(NumericLiteralExp expression) {
        if (expression instanceof org.eclipse.ocl.ecore.IntegerLiteralExp) {
            this.unparseIntegerLiteralExp((IntegerLiteralExp<EClassifier>)((org.eclipse.ocl.ecore.IntegerLiteralExp)expression));
        } else if (expression instanceof org.eclipse.ocl.ecore.RealLiteralExp) {
            this.unparseRealLiteralExp((RealLiteralExp<EClassifier>)((org.eclipse.ocl.ecore.RealLiteralExp)expression));
        } else if (expression instanceof UnlimitedNaturalLiteralExp) {
            this.unparseUnlimitedNaturalLiteralExp((org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp<EClassifier>)((UnlimitedNaturalLiteralExp)expression));
        }
    }

    public Object visitIntegerLiteralExp(IntegerLiteralExp<EClassifier> literal) {
        this.unparseIntegerLiteralExp(literal);
        return null;
    }

    private void unparseIntegerLiteralExp(IntegerLiteralExp<EClassifier> literal) {
        this.addText(literal.getIntegerSymbol().toString());
    }

    public Object visitRealLiteralExp(RealLiteralExp<EClassifier> literal) {
        this.unparseRealLiteralExp(literal);
        return null;
    }

    private void unparseRealLiteralExp(RealLiteralExp<EClassifier> literal) {
        this.addText(literal.getRealSymbol().toString());
    }

    public Object visitUnlimitedNaturalLiteralExp(org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp<EClassifier> literal) {
        this.unparseUnlimitedNaturalLiteralExp(literal);
        return null;
    }

    private void unparseUnlimitedNaturalLiteralExp(org.eclipse.ocl.expressions.UnlimitedNaturalLiteralExp<EClassifier> literal) {
        this.addText(literal.toString());
    }

    public Object visitStringLiteralExp(org.eclipse.ocl.expressions.StringLiteralExp<EClassifier> literal) {
        this.unparseStringLiteralExp(literal);
        return null;
    }

    private void unparseStringLiteralExp(org.eclipse.ocl.expressions.StringLiteralExp<EClassifier> literal) {
        String stringText = literal.getStringSymbol();
        stringText = stringText.replace("\\", "\\\\");
        stringText = stringText.replace("'", "\\'");
        stringText = stringText.replace("\r", "\\r");
        stringText = stringText.replace("\n", "\\n");
        stringText = stringText.replace("\t", "\\t");
        this.addText("'" + stringText + "'");
    }

    public Object visitTupleLiteralExp(org.eclipse.ocl.expressions.TupleLiteralExp<EClassifier, EStructuralFeature> tuple) {
        this.unparseTupleLiteralExp(tuple);
        return null;
    }

    private void unparseTupleLiteralExp(org.eclipse.ocl.expressions.TupleLiteralExp<EClassifier, EStructuralFeature> tuple) {
        this.addText("Tuple {");
        this.unparseTupleLiteralParts((EList<TupleLiteralPart<EClassifier, EStructuralFeature>>)tuple.getPart());
        this.addText("}");
    }

    private void unparseTupleLiteralParts(EList<TupleLiteralPart<EClassifier, EStructuralFeature>> tupleLiteralPartList) {
        Iterator partItor = tupleLiteralPartList.iterator();
        while (partItor.hasNext()) {
            this.unparseTupleLiteralPart((TupleLiteralPart<EClassifier, EStructuralFeature>)((TupleLiteralPart)partItor.next()));
            if (!partItor.hasNext()) continue;
            this.addText(",");
        }
    }

    public Object visitTupleLiteralPart(TupleLiteralPart<EClassifier, EStructuralFeature> part) {
        this.unparseTupleLiteralPart(part);
        return null;
    }

    private void unparseTupleLiteralPart(TupleLiteralPart<EClassifier, EStructuralFeature> part) {
        this.addText(String.valueOf(part.getName()) + ":");
        this.unparseType((EClassifier)part.getType());
        this.addText(" = ");
        this.unparseOCLExpression(part.getValue());
    }

    public Object visitMessageExp(MessageExp<EClassifier, CallOperationAction, SendSignalAction> message) {
        this.unparseMessageExp(message);
        return null;
    }

    private void unparseMessageExp(MessageExp<EClassifier, CallOperationAction, SendSignalAction> message) {
        this.unparseOCLExpression(message.getTarget());
        if (message.getCalledOperation() != null) {
            this.addText("^^" + ((CallOperationAction)message.getCalledOperation()).getOperation().getName());
        } else {
            this.addText("^^" + ((SendSignalAction)message.getSentSignal()).getSignal().getName());
        }
        this.unparseOCLExpressionsCommaSeparatedInParentheses(message.getArgument());
    }

    public Object visitStateExp(StateExp<EClassifier, EObject> state) {
        this.unparseStateExp(state);
        return null;
    }

    private void unparseStateExp(StateExp<EClassifier, EObject> state) {
        this.addText("oclIsInState(" + state.getReferredState() + ")");
    }

    public Object visitTypeExp(TypeExp<EClassifier> expression) {
        this.unparseTypeExp(expression);
        return null;
    }

    private void unparseTypeExp(TypeExp<EClassifier> expression) {
        this.unparseType((EClassifier)expression.getReferredType());
    }

    public Object visitUnspecifiedValueExp(UnspecifiedValueExp<EClassifier> unspecExp) {
        this.unparseUnspecifiedValueExp(unspecExp);
        return null;
    }

    private void unparseUnspecifiedValueExp(UnspecifiedValueExp<EClassifier> unspecExp) {
        this.addText("unspecified");
    }

    public Object visitVariableExp(VariableExp<EClassifier, EParameter> variableExp) {
        this.unparseVariableExp(variableExp);
        return null;
    }

    private boolean unparseVariableExp(VariableExp<EClassifier, EParameter> variableExp) {
        String variableName = variableExp.getName();
        EClassifier variableType = (EClassifier)variableExp.getType();
        org.eclipse.ocl.expressions.Variable referredVariable = variableExp.getReferredVariable();
        if (referredVariable == null) {
            this.addText("/*noReferredVariable*/");
            this.addText(variableName);
            return true;
        }
        if (variableType instanceof Library) {
            String libraryName = variableType.getName();
            this.addText("/*" + libraryName + "." + variableName + "*/");
            return false;
        }
        if (variableType instanceof OperationalTransformation) {
            String transformationName = variableType.getName();
            if (variableName.equals("this")) {
                this.addText("/*" + transformationName + "." + variableName + "*/");
                return false;
            }
            this.addText(variableName);
            return true;
        }
        this.addText(variableName);
        return true;
    }

    public Object visitCollectionItem(CollectionItem<EClassifier> collectionItem) {
        this.unparseCollectionItem(collectionItem);
        return null;
    }

    private void unparseCollectionItem(CollectionItem<EClassifier> collectionItem) {
        this.unparseOCLExpression(collectionItem.getItem());
    }

    public Object visitCollectionRange(CollectionRange<EClassifier> range) {
        this.unparseCollectionRange(range);
        return null;
    }

    private void unparseCollectionRange(CollectionRange<EClassifier> range) {
        this.unparseOCLExpression(range.getFirst());
        this.addText("..");
        this.unparseOCLExpression(range.getLast());
    }

    public Object visitVariable(org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> variable) {
        this.unparseVariable(variable, false);
        return null;
    }

    private void unparseVariable(org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> variable, boolean withInitExpression) {
        OCLExpression initExpression;
        if (variable == null) {
            return;
        }
        this.unparseVariableNameType(variable);
        if (withInitExpression && (initExpression = variable.getInitExpression()) != null) {
            this.addText(" = ");
            this.unparseOCLExpression(initExpression);
        }
    }

    private void unparseVariableNameType(org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> variable) {
        this.unparseVariableNameType(variable, true);
    }

    private void unparseVariableNameType(org.eclipse.ocl.expressions.Variable<EClassifier, EParameter> variable, boolean withType) {
        boolean variableNameIsNotGenerated;
        String variableName = variable.getName();
        boolean bl = variableNameIsNotGenerated = !this.variableNameIsGeneratedTemp(variableName);
        if (variableNameIsNotGenerated) {
            this.addText(variableName);
        } else {
            this.addText("/*" + variableName + "*/");
        }
        if (withType) {
            if (variableNameIsNotGenerated) {
                this.addText(":");
            }
            this.unparseType((EClassifier)variable.getType());
        }
    }

    private boolean variableNameIsGeneratedTemp(String variableName) {
        boolean isGeneratedTemp = variableName.startsWith("$temp");
        return isGeneratedTemp;
    }

    public Object visitExpressionInOCL(ExpressionInOCL<EClassifier, EParameter> expression) {
        this.unparseExpressionInOCL(expression);
        return null;
    }

    private void unparseExpressionInOCL(ExpressionInOCL<EClassifier, EParameter> expression) {
        this.addText("[TODO]");
    }

    public Object visitConstraint(Constraint constraint) {
        this.unparseConstraint(constraint);
        return null;
    }

    private void unparseConstraint(Constraint constraint) {
        this.addText("[TODO]");
        constraint.getConstrainedElements();
        constraint.getSpecification();
        constraint.getStereotype();
    }

    public Object visitContextualProperty(ContextualProperty contextualProperty) {
        this.unparseContextualProperty(contextualProperty);
        return null;
    }

    private void unparseContextualProperty(ContextualProperty contextualProperty) {
        String readonlyText = contextualProperty.isChangeable() ? "" : "readonly ";
        EClass contextClass = contextualProperty.getContext();
        String contextClassText = this.constructFullyQualifiedType((EClassifier)contextClass);
        String propertyName = contextualProperty.getName();
        this.addText("intermediate " + readonlyText + "property " + contextClassText + "::" + propertyName + ": ");
        this.unparseType(contextualProperty.getEType());
        org.eclipse.ocl.ecore.OCLExpression initExpression = contextualProperty.getInitExpression();
        if (initExpression != null) {
            this.addText(" = ");
            this.unparseOCLExpression(initExpression);
        }
        this.addText(";");
        this.addLineBreak();
    }

    public Object visitVarParameter(VarParameter parameter) {
        this.unparseVarParameter(parameter);
        return null;
    }

    private void unparseVarParameter(VarParameter parameter) {
        if (parameter instanceof MappingParameter) {
            this.unparseMappingParameter((VarParameter)((MappingParameter)parameter), true);
        } else {
            this.unparseVarParameter(parameter, true);
        }
    }

    private void unparseVarParameter(VarParameter parameter, boolean withDirectionAndName) {
        String direction = parameter.getKind().getLiteral();
        String name = parameter.getName();
        String directionAndName = withDirectionAndName ? direction + " " + name + " : " : "";
        this.addText(directionAndName);
        this.unparseVarParameterType((EClassifier)parameter.getType());
    }

    private void unparseVarParameterType(EClassifier parameterType) {
        if (parameterType instanceof CollectionType) {
            this.unparseVarParameterCollectionType((CollectionType)parameterType);
        } else {
            this.unparseType(parameterType);
        }
    }

    private void unparseVarParameterCollectionType(CollectionType collectionType) {
        if (collectionType instanceof ListType) {
            this.addText("List (");
        } else if (collectionType instanceof SequenceType) {
            this.addText("Sequence (");
        } else if (collectionType instanceof OrderedSetType) {
            this.addText("OrderedSet (");
        } else if (collectionType instanceof SetType) {
            this.addText("Set (");
        } else if (collectionType instanceof BagType) {
            this.addText("Bag (");
        } else if (collectionType instanceof DictionaryType) {
            this.addText("Dict (");
            DictionaryType dictionaryType = (DictionaryType)collectionType;
            this.unparseVarParameterType(dictionaryType.getKeyType());
            this.addText(",");
        } else {
            this.addText("Collection (");
        }
        this.unparseVarParameterType((EClassifier)collectionType.getElementType());
        this.addText(")");
    }

    private void unparseVarParameters(EList<VarParameter> parameters, boolean withDirectionAndName) {
        if (parameters == null || parameters.size() == 0) {
            return;
        }
        this.addText(" : ");
        if (parameters.size() == 1) {
            withDirectionAndName = false;
        }
        Iterator iterator = parameters.iterator();
        while (iterator.hasNext()) {
            VarParameter parameter = (VarParameter)iterator.next();
            this.unparseVarParameter(parameter, withDirectionAndName);
            if (!iterator.hasNext()) continue;
            this.addText(", ");
        }
    }

    private String escapeKeywordName(String name) {
        if (QvtKeywords.KEYWORDS.contains(name)) {
            return "_" + name;
        }
        return name;
    }

    private void indent() {
        ++this.indentationLevel;
    }

    private void unindent() {
        if (this.indentationLevel > 0) {
            --this.indentationLevel;
        }
    }

    public List<String> getLines() {
        if (this.currentLine.length() > 0) {
            this.addLineBreak();
        }
        return this.lines;
    }

    private void addText(String text) {
        if (text == null || text.length() == 0) {
            return;
        }
        if (this.currentLine.length() == 0) {
            this.currentLine.append(this.indentation[this.indentationLevel]);
        }
        this.currentLine.append(text);
    }

    private void addTextAndIndent(String text) {
        this.addText(text);
        this.indent();
    }

    private void unindentAndAddText(String text) {
        this.unindent();
        this.addText(text);
    }

    private void addLineBreak() {
        this.lines.add(this.currentLine.toString());
        this.currentLine.setLength(0);
    }

    private void addEmptyLine() {
        if (this.currentLine.length() > 0) {
            this.addLineBreak();
        }
        this.addLineBreak();
    }
}

