/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ast.parser;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalTypesUtil;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.ValidationMessages;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingDeclarationCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingMethodCS;
import org.eclipse.m2m.internal.qvt.oml.cst.ModulePropertyCS;
import org.eclipse.m2m.internal.qvt.oml.cst.TransformationHeaderCS;
import org.eclipse.m2m.internal.qvt.oml.cst.temp.ScopedNameCS;
import org.eclipse.m2m.internal.qvt.oml.evaluator.GraphWalker;
import org.eclipse.m2m.internal.qvt.oml.expressions.ContextualProperty;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.MappingOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModuleImport;
import org.eclipse.m2m.internal.qvt.oml.expressions.PackageRef;
import org.eclipse.m2m.internal.qvt.oml.expressions.Property;
import org.eclipse.m2m.internal.qvt.oml.expressions.ReturnExp;
import org.eclipse.m2m.internal.qvt.oml.expressions.VarParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.VariableInitExp;
import org.eclipse.m2m.internal.qvt.oml.ocl.transformations.Library;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.CollectionTypeCS;
import org.eclipse.ocl.cst.PathNameCS;
import org.eclipse.ocl.cst.PrimitiveTypeCS;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.cst.TupleTypeCS;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.ocl.cst.VariableCS;
import org.eclipse.ocl.ecore.CollectionType;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.types.BagType;
import org.eclipse.ocl.types.OrderedSetType;
import org.eclipse.ocl.types.PrimitiveType;
import org.eclipse.ocl.types.SequenceType;
import org.eclipse.ocl.types.SetType;
import org.eclipse.ocl.util.TypeUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtOperationalParserUtil {
    private static final String NAMESPACE_SEPARATOR = ".";
    private static final String QVT_NAMESPACE_URI = "http://www.eclipse.org/m2m/1.0.0/QVT";
    private static final String QVT_IS_ABSTACT = "isAbstract";
    private static final String QVT_IS_STATIC = "isStatic";
    private static final String QVT_LOCAL_PROPERTY_AST_URI = "http://www.eclipse.org/m2m/1.0.0/QVT/localProperty";
    private static final GraphWalker.NodeProvider IMPORT_NODE_PROVIDER = new GraphWalker.NodeProvider(){

        public Object[] getLinkedNodes(Object node) {
            Module module = (Module)node;
            if (module.getModuleImport().isEmpty()) {
                return new Module[0];
            }
            ArrayList<Module> importedModules = new ArrayList<Module>();
            ListIterator impIt = module.getModuleImport().listIterator(module.getModuleImport().size());
            while (impIt.hasPrevious()) {
                ModuleImport importedModule = (ModuleImport)impIt.previous();
                importedModules.add(importedModule.getImportedModule());
            }
            return importedModules.toArray(new Module[0]);
        }
    };

    private QvtOperationalParserUtil() {
    }

    public static EClassifier getContextualType(ImperativeOperation operation) {
        VarParameter context = operation.getContext();
        return context != null ? context.getEType() : null;
    }

    public static boolean isContextual(ImperativeOperation operation) {
        return QvtOperationalParserUtil.getContextualType(operation) != null;
    }

    public static String getMappingStringRepresentation(MappingMethodCS operationCS) {
        MappingDeclarationCS mappingDeclarationCS = operationCS.getMappingDeclarationCS();
        if (mappingDeclarationCS != null) {
            StringBuilder buf = new StringBuilder();
            if (mappingDeclarationCS.getContextType() != null) {
                buf.append(QvtOperationalParserUtil.getStringRepresentation(mappingDeclarationCS.getContextType()));
                buf.append("::");
            }
            if (mappingDeclarationCS.getSimpleNameCS() != null) {
                buf.append(mappingDeclarationCS.getSimpleNameCS().getValue());
            }
            return buf.toString();
        }
        return "";
    }

    public static String getStringRepresentation(PathNameCS pathName, String pathSeparator) {
        StringBuffer buffer = null;
        for (String element : pathName.getSequenceOfNames()) {
            if (buffer != null) {
                buffer.append(pathSeparator);
            } else {
                buffer = new StringBuffer();
            }
            buffer.append(element);
        }
        return buffer == null ? "" : buffer.toString();
    }

    public static String getStringRepresentation(ScopedNameCS scopedNameCS) {
        StringBuilder buf = new StringBuilder();
        if (scopedNameCS.getTypeCS() != null) {
            buf.append(QvtOperationalParserUtil.getStringRepresentation(scopedNameCS.getTypeCS()));
            buf.append("::");
        }
        if (scopedNameCS.getName() != null) {
            buf.append(scopedNameCS.getName());
        }
        return buf.toString();
    }

    public static String getStringRepresentation(TypeCS typeCS) {
        if (typeCS instanceof PrimitiveTypeCS) {
            return ((PrimitiveTypeCS)typeCS).getValue();
        }
        if (typeCS instanceof PathNameCS) {
            return QvtOperationalParserUtil.getStringRepresentation((PathNameCS)typeCS, "::");
        }
        if (typeCS instanceof CollectionTypeCS) {
            return String.valueOf(((CollectionTypeCS)typeCS).getCollectionTypeIdentifier().getName()) + "(" + QvtOperationalParserUtil.getStringRepresentation(((CollectionTypeCS)typeCS).getTypeCS()) + ")";
        }
        if (typeCS instanceof TupleTypeCS) {
            String name = "Tuple(";
            for (VariableCS var : ((TupleTypeCS)typeCS).getVariables()) {
                name = String.valueOf(name) + var.getName();
                name = String.valueOf(name) + ",";
            }
            name = String.valueOf(name) + ")";
            return name;
        }
        return "";
    }

    public static Set<String> getLibMetamodels(Library lib) {
        LinkedHashSet<String> metamodels = new LinkedHashSet<String>();
        metamodels.addAll((Collection)Arrays.asList(lib.getInMetamodels()));
        metamodels.addAll((Collection)Arrays.asList(lib.getOutMetamodels()));
        return metamodels;
    }

    public static void addLocalPropertyAST(EStructuralFeature moduleFeature, Property propertyAST) {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource(QVT_LOCAL_PROPERTY_AST_URI);
        annotation.getContents().add((Object)propertyAST);
        moduleFeature.getEAnnotations().add((Object)annotation);
    }

    public static Property getLocalPropertyAST(EStructuralFeature feature) {
        EAnnotation annotation = feature.getEAnnotation(QVT_LOCAL_PROPERTY_AST_URI);
        if (annotation != null) {
            for (EObject referredObj : annotation.getContents()) {
                if (!(referredObj instanceof Property)) continue;
                return (Property)referredObj;
            }
        }
        return null;
    }

    public static Module getOwningModule(ImperativeOperation operation) {
        if (operation.getEContainingClass() instanceof Module) {
            return (Module)operation.getEContainingClass();
        }
        return null;
    }

    public static List<EOperation> getOwnedOperations(Module module) {
        ArrayList<EOperation> result = new ArrayList<EOperation>(module.getEOperations().size());
        for (EOperation operation : module.getEOperations()) {
            if (!(operation instanceof ImperativeOperation)) continue;
            result.add(operation);
        }
        return result;
    }

    public static void collectAllImports(Module module, Set<Module> result) {
        for (ModuleImport imp : module.getModuleImport()) {
            if (imp == null || imp.getImportedModule() == null) continue;
            if (!result.contains(imp.getImportedModule())) {
                QvtOperationalParserUtil.collectAllImports(imp.getImportedModule(), result);
            }
            result.add(imp.getImportedModule());
        }
    }

    public static boolean validateNameClashing(String name, EClassifier returnType, EClassifier contextType, QvtOperationalEnv env, CSTNode cstNode) {
        env.lookupProperty(returnType, name);
        if (contextType != null && env.lookupProperty(contextType, name) != null) {
            env.reportError(NLS.bind((String)ValidationMessages.SemanticUtil_13, (Object[])new Object[]{name, QvtOperationalTypesUtil.getTypeFullName(contextType)}), cstNode);
            return false;
        }
        return true;
    }

    public static boolean validateInitVariable(VariableInitExp varInit, QvtOperationalEnv env) {
        if (env.lookupLocal(varInit.getName()) != null) {
            env.reportError(NLS.bind((String)ValidationMessages.SemanticUtil_15, (Object[])new Object[]{varInit.getName()}), varInit.getStartPosition(), varInit.getEndPosition());
            return false;
        }
        if (varInit.getType() == null) {
            varInit.setType((EClassifier)varInit.getValue().getType());
        }
        EClassifier realType = (EClassifier)varInit.getValue().getType();
        EClassifier declaredType = (EClassifier)varInit.getType();
        if (!QvtOperationalParserUtil.isAssignableToFrom(env, declaredType, realType)) {
            env.reportError(NLS.bind((String)ValidationMessages.SemanticUtil_17, (Object[])new Object[]{QvtOperationalTypesUtil.getTypeFullName(declaredType), QvtOperationalTypesUtil.getTypeFullName(realType)}), varInit.getStartPosition(), varInit.getEndPosition());
        }
        return true;
    }

    public static boolean isAssignableToFrom(QvtOperationalEnv env, EClassifier variableType, EClassifier initialiserType) {
        if (variableType == null) {
            return false;
        }
        if (initialiserType == null) {
            return false;
        }
        if (variableType == env.getOCLStandardLibrary().getUnlimitedNatural() && initialiserType == env.getOCLStandardLibrary().getInteger()) {
            return true;
        }
        return (TypeUtil.getRelationship((Environment)env, (Object)variableType, (Object)initialiserType) & 5) != 0;
    }

    public static boolean isAssignableElementToFrom(EClassifier variableType, EClassifier initialiserType) {
        if (variableType == null) {
            return false;
        }
        if (initialiserType == null) {
            return false;
        }
        if (variableType == initialiserType) {
            return true;
        }
        return initialiserType instanceof EClass && variableType instanceof EClass && ((EClass)variableType).isSuperTypeOf((EClass)initialiserType);
    }

    public static String getMappingModuleSimpleName(TransformationHeaderCS headerCS) {
        EList moduleName = headerCS.getPathNameCS().getSequenceOfNames();
        if (moduleName.isEmpty()) {
            return "";
        }
        return (String)moduleName.get(moduleName.size() - 1);
    }

    public static boolean hasSimpleName(TransformationHeaderCS headerCS) {
        if (headerCS.getPathNameCS() != null) {
            return headerCS.getPathNameCS().getSequenceOfNames().size() <= 1;
        }
        return false;
    }

    public static String getMappingModuleQualifiedName(TransformationHeaderCS headerCS) {
        String namespace = QvtOperationalParserUtil.getMappingModuleNamespace(headerCS);
        if (namespace == null || namespace.length() == 0) {
            return QvtOperationalParserUtil.getMappingModuleSimpleName(headerCS);
        }
        return String.valueOf(namespace) + NAMESPACE_SEPARATOR + QvtOperationalParserUtil.getMappingModuleSimpleName(headerCS);
    }

    public static String getMappingModuleNamespace(TransformationHeaderCS headerCS) {
        StringBuilder unitNamespace = new StringBuilder();
        EList moduleName = headerCS.getPathNameCS().getSequenceOfNames();
        if (moduleName.size() > 1) {
            int i = 0;
            int sz = moduleName.size();
            while (i < sz - 1) {
                if (i > 0) {
                    unitNamespace.append(NAMESPACE_SEPARATOR);
                }
                unitNamespace.append((String)moduleName.get(i));
                ++i;
            }
        }
        return unitNamespace.toString();
    }

    public static boolean isTypeCast(EOperation operation) {
        if (operation != null) {
            return "oclAsType".equals(operation.getName());
        }
        return false;
    }

    public static boolean isIncorrectCast(EClassifier sourceType, EClassifier targetType) {
        if (sourceType == null || targetType == null) {
            return false;
        }
        if (sourceType instanceof PrimitiveType && "Real".equals(((PrimitiveType)sourceType).getName())) {
            return targetType instanceof PrimitiveType && "Integer".equals(((PrimitiveType)targetType).getName());
        }
        if (sourceType instanceof SetType) {
            return !(targetType instanceof SetType);
        }
        if (sourceType instanceof BagType) {
            return !(targetType instanceof BagType);
        }
        if (sourceType instanceof SequenceType) {
            return !(targetType instanceof SequenceType);
        }
        if (sourceType instanceof OrderedSetType) {
            return !(targetType instanceof OrderedSetType) && !(targetType instanceof SetType);
        }
        return false;
    }

    public static boolean validateAssignment(String leftName, EClassifier leftType, OCLExpression<EClassifier> right, boolean isIncremental, CSTNode cstNode, QvtOperationalEnv env) {
        if (isIncremental) {
            if (!(leftType instanceof CollectionType)) {
                env.reportError(NLS.bind((String)ValidationMessages.SemanticUtil_3, (Object[])new Object[]{leftName}), cstNode);
                return false;
            }
            EClassifier baseType = (EClassifier)((CollectionType)leftType).getElementType();
            EClassifier actualType = (EClassifier)right.getType();
            if (actualType instanceof CollectionType) {
                actualType = (EClassifier)((CollectionType)actualType).getElementType();
            }
            if (!QvtOperationalParserUtil.isAssignableToFrom(env, baseType, actualType)) {
                env.reportError(NLS.bind((String)ValidationMessages.SemanticUtil_5, (Object[])new Object[]{leftName, QvtOperationalTypesUtil.getTypeFullName(baseType), QvtOperationalTypesUtil.getTypeFullName(actualType)}), cstNode);
                return false;
            }
        } else {
            EClassifier actualType = (EClassifier)right.getType();
            if (!QvtOperationalParserUtil.isAssignableToFrom(env, leftType, actualType)) {
                env.reportError(NLS.bind((String)ValidationMessages.SemanticUtil_8, (Object[])new Object[]{leftName, QvtOperationalTypesUtil.getTypeFullName(leftType), QvtOperationalTypesUtil.getTypeFullName(actualType)}), cstNode);
                return false;
            }
        }
        return true;
    }

    public static boolean validateVariableModification(Variable<EClassifier, EParameter> variable, PathNameCS varPathNameNodeCS, EStructuralFeature varPathNamePropertyASTopt, QvtOperationalEnv env) {
        EParameter representedParameter = (EParameter)variable.getRepresentedParameter();
        if (representedParameter instanceof VarParameter) {
            VarParameter parameter = (VarParameter)representedParameter;
            boolean isDirectInoutModification = parameter.getKind() == DirectionKind.INOUT && varPathNameNodeCS.getSequenceOfNames().size() == 1;
            boolean isContextualPropertyAccessed = varPathNamePropertyASTopt instanceof ContextualProperty;
            if (isDirectInoutModification) {
                env.reportError(NLS.bind((String)ValidationMessages.QvtOperationalParserUtil_inoutParamAssignmentError, (Object)parameter.getName()), (CSTNode)varPathNameNodeCS);
                return false;
            }
            if (parameter.getKind() != DirectionKind.OUT && parameter.getKind() != DirectionKind.INOUT && !isContextualPropertyAccessed) {
                env.reportError(NLS.bind((String)ValidationMessages.inputParameterModificationError, (Object)variable.getName()), (CSTNode)varPathNameNodeCS);
                return false;
            }
        }
        if (representedParameter instanceof Property) {
            env.reportError(NLS.bind((String)ValidationMessages.readOnlyPropertyModificationError, (Object)variable.getName()), (CSTNode)varPathNameNodeCS);
            return false;
        }
        return true;
    }

    public static EOperation getMainMethod(Module module) {
        block0: for (ImperativeOperation method : module.getEOperations()) {
            if (!"main".equals(method.getName())) continue;
            for (EParameter param : method.getEParameters()) {
                if (param.getEType() == null) continue block0;
            }
            if (method.getContext() != null && method.getContext().getEType() == null) continue;
            return method;
        }
        return null;
    }

    public static PackageRef[] getRequiredMetamodelIds(Module module) {
        LinkedHashSet<PackageRef> ids = new LinkedHashSet<PackageRef>();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Traverser {
            Traverser() {
            }

            void getMetamodelIds(Module module, Set<PackageRef> ids) {
                for (ModelType modelType : module.getUsedModelType()) {
                    ids.addAll((Collection<PackageRef>)modelType.getMetamodel());
                }
                for (ModuleImport importedModule : module.getModuleImport()) {
                    this.getMetamodelIds(importedModule.getImportedModule(), ids);
                }
            }
        }
        new Traverser().getMetamodelIds(module, ids);
        return ids.toArray(new PackageRef[ids.size()]);
    }

    public static boolean isOverloadableMapping(EOperation op, QvtOperationalEnv env) {
        EObject context = op.eContainer();
        if (env.getUMLReflection().getOwningClassifier((Object)op) instanceof Module) {
            return false;
        }
        return context instanceof EClass;
    }

    public static boolean isTypeEquals(QvtOperationalEnv env, EClassifier type, EClassifier otherType) {
        return QvtOperationalParserUtil.isAssignableToFrom(env, type, otherType) && QvtOperationalParserUtil.isAssignableToFrom(env, otherType, type);
    }

    private static boolean isOperationEquals(ImperativeOperation imperativeOp, EOperation otherOp, EClassifier context, QvtOperationalEnv env) {
        if (!imperativeOp.getName().equals(otherOp.getName())) {
            return false;
        }
        EList parameters1 = imperativeOp.getEParameters();
        EList parameters2 = otherOp.getEParameters();
        if (parameters1.size() != parameters2.size()) {
            return false;
        }
        int i = 0;
        while (i < parameters1.size()) {
            EClassifier otherType;
            EClassifier type = ((EParameter)parameters1.get(i)).getEType();
            if (!QvtOperationalParserUtil.isTypeEquals(env, type, otherType = ((EParameter)parameters2.get(i)).getEType())) {
                return false;
            }
            ++i;
        }
        EClassifier contextType = QvtOperationalParserUtil.getContextualType(imperativeOp);
        if (contextType == null) {
            return contextType == context;
        }
        return QvtOperationalParserUtil.isTypeEquals(env, contextType, context);
    }

    public static Module getOutermostDefiningModule(Module module, final EOperation ctxOp, final EClassifier context, final QvtOperationalEnv env) {
        final Module[] result = new Module[1];
        GraphWalker.VertexProcessor processor = new GraphWalker.VertexProcessor(){

            public boolean process(Object node) {
                Module module = (Module)node;
                if (QvtOperationalParserUtil.findMappingMethod(module, ctxOp, context, env) != null) {
                    result[0] = module;
                    return true;
                }
                return false;
            }
        };
        new GraphWalker(IMPORT_NODE_PROVIDER).walkBreadthFirst(module, processor);
        return result[0];
    }

    public static Module getInnermostDefiningModule(Module module, final EOperation ctxOp, final EClassifier context, final QvtOperationalEnv env) {
        final Module[] result = new Module[1];
        GraphWalker.VertexProcessor processor = new GraphWalker.VertexProcessor(){

            public boolean process(Object node) {
                Module mod = (Module)node;
                if (QvtOperationalParserUtil.findMappingMethod(mod, ctxOp, context, env) != null) {
                    result[0] = mod;
                }
                return false;
            }
        };
        new GraphWalker(IMPORT_NODE_PROVIDER).walkBreadthFirst(module, processor);
        return result[0];
    }

    public static ImperativeOperation findMappingMethod(Module module, EOperation signature, EClassifier context, QvtOperationalEnv env) {
        for (EOperation op : QvtOperationalParserUtil.getOwnedOperations(module)) {
            ImperativeOperation cur;
            if (!(op instanceof ImperativeOperation) || !QvtOperationalParserUtil.isOperationEquals(cur = (ImperativeOperation)op, signature, context, env)) continue;
            return cur;
        }
        return null;
    }

    public static String safeGetMappingQualifiedName(QvtOperationalEnv env, MappingOperation mappingOperation) {
        if (mappingOperation != null) {
            StringBuilder buf = new StringBuilder();
            EClassifier ctxType = QvtOperationalParserUtil.getContextualType(mappingOperation);
            if (ctxType != null) {
                buf.append(QvtOperationalParserUtil.safeGetQualifiedName(env, ctxType));
                buf.append("::");
            }
            if (mappingOperation.getName() != null) {
                buf.append(mappingOperation.getName());
            }
            return buf.toString();
        }
        return "";
    }

    public static String safeGetQualifiedName(QvtOperationalEnv env, EClassifier type, String defaultValue) {
        if (type == null) {
            return defaultValue;
        }
        String result = defaultValue;
        if (type.getEPackage() == null) {
            result = env.getUMLReflection().getName((Object)type);
        } else {
            try {
                result = env.getUMLReflection().getQualifiedName((Object)type);
            }
            catch (RuntimeException runtimeException) {
                result = env.getUMLReflection().getName((Object)type);
            }
        }
        return result != null ? result : defaultValue;
    }

    public static String safeGetQualifiedName(QvtOperationalEnv env, EClassifier type) {
        return QvtOperationalParserUtil.safeGetQualifiedName(env, type, "");
    }

    public static <T> T findParentElement(ReturnExp returnExp, Class<T> type) {
        T result = null;
        EObject parent = returnExp.eContainer();
        while (parent != null) {
            if (type.isInstance(parent)) {
                result = type.cast(parent);
                break;
            }
            parent = parent.eContainer();
        }
        return result;
    }

    public static void markAsAbstractMappingOperation(MappingOperation mappingOperation) {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource(QVT_NAMESPACE_URI);
        annotation.getDetails().put((Object)QVT_IS_ABSTACT, (Object)Boolean.toString(true));
        mappingOperation.getEAnnotations().add((Object)annotation);
    }

    public static boolean isAbstractMappingOperation(MappingOperation mappingOperation) {
        EAnnotation annotation = mappingOperation.getEAnnotation(QVT_NAMESPACE_URI);
        if (annotation != null) {
            String value = (String)annotation.getDetails().get((Object)QVT_IS_ABSTACT);
            return Boolean.valueOf(value);
        }
        return false;
    }

    public static void markAsStaticOperation(EOperation operation) {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource(QVT_NAMESPACE_URI);
        annotation.getDetails().put((Object)QVT_IS_STATIC, (Object)Boolean.toString(true));
        operation.getEAnnotations().add((Object)annotation);
    }

    public static boolean isStaticOperation(EOperation operation) {
        EAnnotation annotation = operation.getEAnnotation(QVT_NAMESPACE_URI);
        if (annotation != null) {
            String value = (String)annotation.getDetails().get((Object)QVT_IS_STATIC);
            return Boolean.valueOf(value);
        }
        return false;
    }

    public static CSTNode getPropertyProblemNode(Property propertyAST, QvtOperationalEnv env) {
        SimpleNameCS nameCS;
        CSTNode cstNode = env.getASTMapping(propertyAST);
        if (cstNode instanceof ModulePropertyCS && (nameCS = ((ModulePropertyCS)cstNode).getSimpleNameCS()) != null) {
            cstNode = nameCS;
        }
        return cstNode;
    }

    public static CSTNode getImperativeOperationProblemNode(MappingMethodCS methodCS) {
        MappingDeclarationCS mappingDeclCS = methodCS.getMappingDeclarationCS();
        if (mappingDeclCS != null) {
            if (mappingDeclCS.getSimpleNameCS() != null) {
                return mappingDeclCS.getSimpleNameCS();
            }
            if (mappingDeclCS.getContextType() != null) {
                return mappingDeclCS.getContextType();
            }
        }
        return methodCS;
    }

    public static <T> Collection<T> selectDuplicateQualifiers(List<T> elements) {
        Set result = null;
        for (T nextQualifier : elements) {
            if (Collections.frequency(elements, nextQualifier) <= 1) continue;
            if (result == null) {
                result = new HashSet(2);
            }
            result.add(nextQualifier);
        }
        return result != null ? result : Collections.emptySet();
    }
}

