/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.adt.ui.text;

import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.m2m.atl.adt.ui.text.AtlTextTools;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractScanner
extends RuleBasedScanner {
    private String[] propertyNamesBold;
    private String[] propertyNamesColor;
    private String[] propertyNamesItalic;
    private AtlTextTools textTools;
    private HashMap tokenMap = new HashMap();

    public AbstractScanner(AtlTextTools texttools) {
        this.textTools = texttools;
        this.initialize();
        this.setDefaultReturnToken((IToken)this.getToken("Atl.Syntax.Default.Color"));
    }

    private void adaptToColorChange(Token token, PropertyChangeEvent event) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            String property = event.getProperty();
            this.getTextTools().getColorManager().unbindColor(property);
            this.getTextTools().getColorManager().bindColor(property, rgb);
            Object data = token.getData();
            if (data instanceof TextAttribute) {
                TextAttribute oldAttr = (TextAttribute)data;
                token.setData((Object)new TextAttribute(this.getTextTools().getColorManager().getColor(property), oldAttr.getBackground(), oldAttr.getStyle()));
            }
        }
    }

    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        String p = event.getProperty();
        int index = this.indexOf(p);
        Token token = this.getToken(this.getPropertyNamesColor()[index]);
        if (this.getPropertyNamesColor()[index].equals(p)) {
            this.adaptToColorChange(token, event);
        } else if (this.getPropertyNamesBold()[index].equals(p)) {
            this.adaptToStyleChange(token, event, 1);
        } else if (this.getPropertyNamesItalic()[index].equals(p)) {
            this.adaptToStyleChange(token, event, 2);
        }
    }

    private void adaptToStyleChange(Token token, PropertyChangeEvent event, int styleAttribute) {
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        Object data = token.getData();
        if (data instanceof TextAttribute) {
            boolean activeValue;
            TextAttribute oldAttr = (TextAttribute)data;
            boolean bl = activeValue = (oldAttr.getStyle() & styleAttribute) == styleAttribute;
            if (activeValue != eventValue) {
                token.setData((Object)new TextAttribute(oldAttr.getForeground(), oldAttr.getBackground(), eventValue ? oldAttr.getStyle() | styleAttribute : oldAttr.getStyle() & ~styleAttribute));
            }
        }
    }

    private void addToken(String color, String boldKey, String italicKey) {
        int style;
        this.getTextTools().getColorManager().add(color, PreferenceConverter.getColor((IPreferenceStore)this.getTextTools().getPreferenceStore(), (String)color));
        int n = style = this.getTextTools().getPreferenceStore().getBoolean(boldKey) ? 1 : 0;
        if (this.getTextTools().getPreferenceStore().getBoolean(italicKey)) {
            style |= 2;
        }
        this.tokenMap.put(color, new Token((Object)new TextAttribute(this.getTextTools().getColorManager().getColor(color), null, style)));
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        return this.indexOf(event.getProperty()) >= 0;
    }

    protected abstract List createRules();

    protected abstract String[] getPropertyNames();

    private String[] getPropertyNamesBold() {
        if (this.propertyNamesBold == null) {
            int length = this.getPropertyNames().length;
            this.propertyNamesBold = new String[length];
            int i = 0;
            while (i < length) {
                this.propertyNamesBold[i] = String.valueOf(this.getPropertyNames()[i]) + ".Bold";
                ++i;
            }
        }
        return this.propertyNamesBold;
    }

    private String[] getPropertyNamesColor() {
        if (this.propertyNamesColor == null) {
            int length = this.getPropertyNames().length;
            this.propertyNamesColor = new String[length];
            int i = 0;
            while (i < length) {
                this.propertyNamesColor[i] = String.valueOf(this.getPropertyNames()[i]) + ".Color";
                ++i;
            }
        }
        return this.propertyNamesColor;
    }

    private String[] getPropertyNamesItalic() {
        if (this.propertyNamesItalic == null) {
            int length = this.getPropertyNames().length;
            this.propertyNamesItalic = new String[length];
            int i = 0;
            while (i < length) {
                this.propertyNamesItalic[i] = String.valueOf(this.getPropertyNames()[i]) + ".Italic";
                ++i;
            }
        }
        return this.propertyNamesItalic;
    }

    protected AtlTextTools getTextTools() {
        return this.textTools;
    }

    protected Token getToken(String color) {
        return (Token)this.tokenMap.get(color);
    }

    private int indexOf(String property) {
        if (property != null) {
            int length = this.getPropertyNamesColor().length;
            int i = 0;
            while (i < length) {
                if (property.equals(this.getPropertyNamesColor()[i]) || property.equals(this.getPropertyNamesBold()[i]) || property.equals(this.getPropertyNamesItalic()[i])) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public final void initialize() {
        int i = 0;
        while (i < this.getPropertyNames().length) {
            this.addToken(this.getPropertyNamesColor()[i], this.getPropertyNamesBold()[i], this.getPropertyNamesItalic()[i]);
            ++i;
        }
        List rules = this.createRules();
        if (rules != null) {
            IRule[] result = new IRule[rules.size()];
            rules.toArray(result);
            this.setRules(result);
        }
    }
}

