/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.engine.emfvm.lib;

import org.eclipse.m2m.atl.engine.emfvm.lib.ASMModule;
import org.eclipse.m2m.atl.engine.emfvm.lib.ExecEnv;
import org.eclipse.m2m.atl.engine.emfvm.lib.Operation;

public abstract class AbstractStackFrame {
    protected ExecEnv execEnv;
    protected AbstractStackFrame caller;
    protected Operation operation;
    protected Object[] localVars;
    private ASMModule asmModule;

    public AbstractStackFrame(ExecEnv execEnv, ASMModule asmModule, Operation operation) {
        this(null, operation);
        this.execEnv = execEnv;
        this.asmModule = asmModule;
        this.localVars[0] = asmModule;
    }

    protected AbstractStackFrame(AbstractStackFrame caller, Operation frameOperation) {
        this.caller = caller;
        this.operation = frameOperation;
        if (caller != null) {
            this.execEnv = caller.execEnv;
            this.asmModule = caller.asmModule;
        }
        this.localVars = new Object[frameOperation.getMaxLocals()];
    }

    protected AbstractStackFrame(ExecEnv execEnv) {
        this.execEnv = execEnv;
    }

    public abstract AbstractStackFrame newFrame(Operation var1);

    public ASMModule getAsmModule() {
        return this.asmModule;
    }

    public Object[] getLocalVars() {
        return this.localVars;
    }

    public void setLocalVars(Object[] localVars) {
        this.localVars = localVars;
    }

    public ExecEnv getExecEnv() {
        return this.execEnv;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public AbstractStackFrame getCaller() {
        return this.caller;
    }
}

