/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.qvtd.compiler.internal.qvtm2qvts.QVTm2QVTs;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.AbstractSimplePartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.BasicPartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.MappingPartitioner;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.utilities.ReachabilityForest;
import org.eclipse.qvtd.pivot.qvtschedule.BasicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.RuleRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class SpeculatedPartitionFactory
extends AbstractSimplePartitionFactory {
    private final @NonNull Set<@NonNull Node> tracedInputNodes = new HashSet<Node>();

    public SpeculatedPartitionFactory(@NonNull MappingPartitioner mappingPartitioner) {
        super(mappingPartitioner);
    }

    @Override
    public @NonNull BasicPartitionAnalysis createPartitionAnalysis(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis) {
        ReachabilityForest reachabilityForest = this.createReachabilityForest();
        String name = this.computeName("speculated");
        Node traceNode = this.mappingPartitioner.getTraceNode();
        List<@NonNull Node> headNodes = this.mappingPartitioner.getTraceNodes();
        BasicPartition partition = this.createBasicPartition(name, headNodes);
        int partitionNumber = ((RuleRegion)this.region).getNextPartitionNumber();
        BasicPartitionAnalysis basicPartitionAnalysis = new BasicPartitionAnalysis(partitionedTransformationAnalysis, partition, reachabilityForest, "\u00abspeculated\u00bb", "_p" + partitionNumber);
        this.initializePartition(basicPartitionAnalysis, traceNode);
        if (QVTm2QVTs.DEBUG_GRAPHS.isActive()) {
            this.scheduleManager.writeDebugGraphs((Graphable)partition, null);
        }
        return basicPartitionAnalysis;
    }

    protected void initializePartition(@NonNull BasicPartitionAnalysis partitionAnalysis, @NonNull Node traceNode) {
        BasicPartition partition = (BasicPartition)partitionAnalysis.getPartition();
        this.resolveTraceNodes(partition, traceNode);
        this.resolveRealizedOutputNodes(partition);
        this.resolveRealizedEdges(partition);
        this.resolvePrecedingNodes(partitionAnalysis);
        this.resolveDisambiguations(partition);
        this.resolveEdges(partitionAnalysis);
    }

    @Override
    protected @Nullable Role resolveEdgeRole(@NonNull Role sourceNodeRole, @NonNull Edge edge, @NonNull Role targetNodeRole) {
        Object edgeRole = QVTscheduleUtil.getEdgeRole((Edge)edge);
        if (edgeRole == Role.REALIZED && this.mappingPartitioner.hasRealizedEdge(edge)) {
            edgeRole = edge.isSuccess() ? Role.PREDICATED : (edge.getEdgeTarget().isConstant() ? null : Role.PREDICATED);
        }
        return edgeRole;
    }

    protected void resolveRealizedEdges(@NonNull BasicPartition partition) {
        for (NavigableEdge edge : this.mappingPartitioner.getRealizedEdges()) {
            Node targetNode;
            Node sourceNode;
            if (this.mappingPartitioner.hasRealizedEdge((Edge)edge) || this.mappingPartitioner.getCorollaryOf(edge) != null || (sourceNode = edge.getEdgeSource()).isPredicated() && !this.mappingPartitioner.hasCheckedNode(sourceNode) || (targetNode = edge.getEdgeTarget()).isPredicated() && !this.mappingPartitioner.hasCheckedNode(targetNode)) continue;
            if (!partition.hasNode(sourceNode)) {
                this.addNode(partition, sourceNode, QVTscheduleUtil.getNodeRole((Node)sourceNode));
            }
            if (partition.hasNode(targetNode)) continue;
            this.addNode(partition, targetNode, QVTscheduleUtil.getNodeRole((Node)targetNode));
        }
    }

    protected void resolveRealizedOutputNodes(@NonNull BasicPartition partition) {
        for (Node node : this.mappingPartitioner.getRegionAnalysis().getCorollaryNodes()) {
            if (partition.hasNode(node) || node.isSuccess()) continue;
            this.addNode(partition, node);
        }
    }

    protected void resolveTraceNodes(@NonNull BasicPartition partition, @NonNull Node traceNode) {
        assert (traceNode.isMatched() && traceNode.isClass() && traceNode.isPattern());
        this.addNode(partition, traceNode, Role.PREDICATED);
        if (this.scheduleManager.useActivators()) {
            Node localSuccessNode = this.mappingPartitioner.basicGetLocalSuccessNode(traceNode);
            if (localSuccessNode != null) {
                this.addNode(partition, localSuccessNode, Role.CONSTANT_SUCCESS_TRUE);
            }
            Node globalSuccessNode = this.mappingPartitioner.getGlobalSuccessNode(traceNode);
            this.addNode(partition, globalSuccessNode, Role.CONSTANT_SUCCESS_TRUE);
        }
        for (NavigableEdge edge : traceNode.getNavigableEdges()) {
            if (!this.mappingPartitioner.hasRealizedEdge((Edge)edge)) continue;
            this.tracedInputNodes.add(edge.getEdgeTarget());
        }
    }
}

