/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.HeadNodeGroup;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.RuleAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Element2MiddleProperty;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Rule2TraceGroup;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.TracedHeadAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Transformation2TracePackage;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationNameGenerator;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.AbstractTracingStrategy;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2DispatchClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2InvocationClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2TraceInterface;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.TracingStrategy;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;

public class Relation2TraceGroup
extends Rule2TraceGroup {
    protected final @NonNull Relation2TraceGroup baseRelation2traceGroup;
    protected final @Nullable Relation2TraceClass relation2traceClass;
    protected final @Nullable Relation2TraceInterface relation2traceInterface;
    protected final @Nullable Relation2InvocationClass relation2invocationClass;
    protected final @Nullable Relation2DispatchClass relation2dispatchClass;
    private final @NonNull List<@NonNull TracingStrategy> tracingStrategies = new ArrayList<TracingStrategy>();

    public Relation2TraceGroup(@NonNull Transformation2TracePackage transformation2tracePackage, @NonNull Relation relation) {
        super(transformation2tracePackage, (Rule)relation);
        QVTrelationNameGenerator nameGenerator = this.getNameGenerator();
        String traceClassName = null;
        String traceInterfaceName = null;
        String invocationClassName = null;
        String dispatchClassName = null;
        Rule baseRelation = QVTrelationUtil.basicGetBaseRule((Rule)relation);
        this.baseRelation2traceGroup = baseRelation != null && baseRelation != relation ? (Relation2TraceGroup)transformation2tracePackage.getRule2TraceGroup(baseRelation) : this;
        boolean hasOverrides = QVTrelationUtil.hasOverrides((Relation)relation);
        boolean isAbstract = QVTrelationUtil.isAbstract((Relation)relation);
        boolean topLevel = relation.isIsTopLevel();
        if (!isAbstract) {
            traceClassName = nameGenerator.createTraceClassName((Rule)relation);
        }
        if (hasOverrides && baseRelation == relation) {
            traceInterfaceName = nameGenerator.createTraceInterfaceName((Rule)relation);
        }
        if (hasOverrides) {
            if (!topLevel && !isAbstract) {
                invocationClassName = nameGenerator.createInvocationClassName((Rule)relation);
            }
            if (baseRelation == relation) {
                dispatchClassName = nameGenerator.createDispatchClassName((Rule)relation);
            }
        }
        Relation2TraceClass relation2TraceClass = this.relation2traceClass = traceClassName != null ? new Relation2TraceClass(this, traceClassName) : null;
        if (traceInterfaceName != null) {
            this.relation2traceInterface = new Relation2TraceInterface(this, traceInterfaceName);
            this.addTracingStrategy(AbstractTracingStrategy.HasInterfaceTracingStrategy.INSTANCE);
        } else {
            this.relation2traceInterface = null;
        }
        if (dispatchClassName != null) {
            this.relation2dispatchClass = new Relation2DispatchClass(this, dispatchClassName);
            this.addTracingStrategy(AbstractTracingStrategy.HasDispatcherTracingStrategy.INSTANCE);
        } else {
            this.relation2dispatchClass = null;
        }
        this.relation2invocationClass = invocationClassName != null ? new Relation2InvocationClass(this, invocationClassName) : null;
        Relation2TraceClass relation2traceClass2 = this.relation2traceClass;
        if (relation2traceClass2 != null) {
            Variable traceVariable = QVTrelationUtil.getTraceVariable((Relation)relation);
            traceVariable.setType((Type)relation2traceClass2.getMiddleClass());
        }
    }

    public void addTracingStrategy(@NonNull TracingStrategy tracingStrategy) {
        this.tracingStrategies.add(tracingStrategy);
    }

    @Override
    public void analyzeTraceElements(@NonNull RuleAnalysis ruleAnalysis) throws CompilerChainException {
        Relation2InvocationClass relation2invocationClass2;
        Relation2DispatchClass relation2invocationInterface2;
        Relation2TraceClass relation2traceClass2;
        RelationAnalysis relationAnalysis = (RelationAnalysis)ruleAnalysis;
        List<@NonNull HeadNodeGroup> headNodeGroups = TracedHeadAnalysis.computeTraceHeadGroupNodes((MappingRegion)relationAnalysis.getRegion());
        Relation2TraceInterface relation2traceInterface2 = this.relation2traceInterface;
        if (relation2traceInterface2 != null) {
            relation2traceInterface2.analyzeTraceElements(headNodeGroups, relationAnalysis);
        }
        if ((relation2traceClass2 = this.relation2traceClass) != null) {
            relation2traceClass2.analyzeTraceElements(headNodeGroups, relationAnalysis);
        }
        if ((relation2invocationInterface2 = this.relation2dispatchClass) != null) {
            relation2invocationInterface2.analyzeTraceElements(headNodeGroups, relationAnalysis);
        }
        if ((relation2invocationClass2 = this.relation2invocationClass) != null) {
            relation2invocationClass2.analyzeTraceElements(headNodeGroups, relationAnalysis);
        }
    }

    @Override
    public @Nullable Element2MiddleProperty basicGetRelation2GlobalSuccessProperty() {
        return this.relation2traceClass != null ? this.relation2traceClass.basicGetRelation2GlobalSuccessProperty() : null;
    }

    @Override
    public @Nullable Element2MiddleProperty basicGetRelation2LocalSuccessProperty() {
        return this.relation2traceClass != null ? this.relation2traceClass.basicGetRelation2LocalSuccessProperty() : null;
    }

    public @Nullable Relation2InvocationClass basicGetRule2InvocationClass() {
        return this.relation2invocationClass;
    }

    public @Nullable Relation2DispatchClass basicGetRule2InvocationInterface() {
        return this.relation2dispatchClass;
    }

    public @Nullable Relation2TraceInterface basicGetRule2TraceInterface() {
        return this.relation2traceInterface;
    }

    public @NonNull Relation2TraceGroup getBaseRelation2TraceGroup() {
        return this.baseRelation2traceGroup;
    }

    public @NonNull Class getInvocationClass() {
        if (this.relation2dispatchClass != null) {
            return this.relation2dispatchClass.getMiddleClass();
        }
        return this.getRule2TraceClass().getMiddleClass();
    }

    public @NonNull Class getInvocationInterface() {
        return this.getRule2InvocationInterface().getMiddleClass();
    }

    public @NonNull QVTrelationNameGenerator getNameGenerator() {
        return (QVTrelationNameGenerator)this.scheduleManager.getNameGenerator();
    }

    public @NonNull Relation getRule() {
        return (Relation)this.rule;
    }

    public @NonNull Relation2DispatchClass getRule2DispatchClass() {
        return (Relation2DispatchClass)ClassUtil.nonNullState((Object)this.relation2dispatchClass);
    }

    public @NonNull Relation2MiddleType getRule2InvocationInterface() {
        if (this.relation2dispatchClass != null) {
            return this.relation2dispatchClass;
        }
        if (this.relation2invocationClass != null) {
            return this.relation2invocationClass;
        }
        return this.getRule2TraceInterface();
    }

    public @NonNull Relation2TraceClass getRule2TraceClass() {
        return (Relation2TraceClass)ClassUtil.nonNullState((Object)this.relation2traceClass);
    }

    public @NonNull Relation2MiddleType getRule2TraceInterface() {
        if (this.relation2traceInterface != null) {
            return this.relation2traceInterface;
        }
        return this.getRule2TraceClass();
    }

    @Override
    public @NonNull Class getTraceClass() {
        return this.getRule2TraceClass().getMiddleClass();
    }

    public @NonNull Class getTraceInterface() {
        return this.getRule2TraceInterface().getMiddleClass();
    }

    public @NonNull Iterable<@NonNull TracingStrategy> getTracingStrategies() {
        return this.tracingStrategies;
    }

    @Override
    public void synthesizeTraceModel(@NonNull RuleAnalysis ruleAnalysis) {
        if (this.relation2traceInterface != null) {
            this.relation2traceInterface.synthesizeTraceModel(ruleAnalysis);
        }
        if (this.relation2traceClass != null) {
            this.relation2traceClass.synthesizeTraceModel(ruleAnalysis);
        }
        if (this.relation2dispatchClass != null) {
            this.relation2dispatchClass.synthesizeTraceModel(ruleAnalysis);
        }
        if (this.relation2invocationClass != null) {
            this.relation2invocationClass.synthesizeTraceModel(ruleAnalysis);
        }
    }

    public @NonNull String toString() {
        return this.getName();
    }
}

