/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.core.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TextUtil {
    private static final Pattern STRIP_TAG_PATTERN = Pattern.compile("</?[a-zA-Z]+[0-6]?(\\s+[a-zA-Z]+\\s*=\\s*((('|\")[^>]*?\\4)|(\\S+)))*\\s*/?>", 8);

    public static String stripHtmlMarkup(String text) {
        if (text == null) {
            return null;
        }
        String result = "";
        int lastOffset = 0;
        Matcher matcher = STRIP_TAG_PATTERN.matcher(text);
        while (matcher.find()) {
            int start = matcher.start();
            if (start > lastOffset) {
                result = String.valueOf(result) + text.substring(lastOffset, start);
            }
            lastOffset = matcher.end();
        }
        if (lastOffset < text.length()) {
            result = String.valueOf(result) + text.substring(lastOffset);
        }
        return result;
    }

    public static String cleanInformalHtmlMarkup(String text) {
        if (text == null) {
            return null;
        }
        text = Pattern.compile("(?<!>)\\s*?((\\r\\n)|\\n|\\r){2,}\\s*(?!<)").matcher(text).replaceAll("<p>");
        return text;
    }

    public static String escapeText(String text) {
        if (text == null) {
            return null;
        }
        text = text.replace("&", "&&");
        return text;
    }
}

