/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.mpc.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.epp.internal.mpc.ui.MarketplaceClientUiPlugin;
import org.eclipse.epp.internal.mpc.ui.Messages;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MarketplaceClientUi {
    private static final String DOT_FEATURE_DOT_GROUP = ".feature.group";
    public static final String BUNDLE_ID = "org.eclipse.epp.mpc.ui";

    public static ILog getLog() {
        return Platform.getLog((Bundle)Platform.getBundle((String)BUNDLE_ID));
    }

    public static void error(String message, Throwable exception) {
        if (message == null) {
            message = NLS.bind((String)Messages.MarketplaceClientUi_unexpectedException_reason, (Object)exception.getMessage());
        }
        MarketplaceClientUi.getLog().log((IStatus)new Status(4, BUNDLE_ID, 4, message, exception));
    }

    public static void error(Throwable exception) {
        MarketplaceClientUi.error(null, exception);
    }

    public static IStatus computeStatus(InvocationTargetException e, String message) {
        Throwable cause = e.getCause();
        Object statusCause = cause instanceof CoreException ? ((CoreException)cause).getStatus() : new Status(4, BUNDLE_ID, cause.getMessage(), cause);
        if (statusCause.getMessage() != null) {
            message = NLS.bind((String)Messages.MarketplaceClientUi_message_message2, (Object)message, (Object)statusCause.getMessage());
        }
        MultiStatus status = new MultiStatus(BUNDLE_ID, 0, new IStatus[]{statusCause}, message, cause);
        return status;
    }

    public static BundleContext getBundleContext() {
        return MarketplaceClientUiPlugin.getInstance().getBundle().getBundleContext();
    }

    public static Map<String, IInstallableUnit> computeInstalledIUsById(IProgressMonitor monitor) {
        HashMap<String, IInstallableUnit> iUs = new HashMap<String, IInstallableUnit>();
        BundleContext bundleContext = MarketplaceClientUi.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(IProvisioningAgent.SERVICE_NAME);
        if (serviceReference != null) {
            IProvisioningAgent agent = (IProvisioningAgent)bundleContext.getService(serviceReference);
            try {
                IProfile profile;
                IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
                if (profileRegistry != null && (profile = profileRegistry.getProfile(ProvisioningUI.getDefaultUI().getProfileId())) != null) {
                    IQueryResult result = profile.available(QueryUtil.createIUGroupQuery(), monitor);
                    for (IInstallableUnit unit : result) {
                        iUs.put(unit.getId(), unit);
                    }
                }
            }
            finally {
                bundleContext.ungetService(serviceReference);
            }
        }
        return iUs;
    }

    public static Set<String> computeInstalledFeatures(IProgressMonitor monitor) {
        HashSet<String> features = new HashSet<String>();
        BundleContext bundleContext = MarketplaceClientUi.getBundleContext();
        ServiceReference serviceReference = bundleContext.getServiceReference(IProvisioningAgent.SERVICE_NAME);
        if (serviceReference != null) {
            IProvisioningAgent agent = (IProvisioningAgent)bundleContext.getService(serviceReference);
            try {
                IProfile profile;
                IProfileRegistry profileRegistry = (IProfileRegistry)agent.getService(IProfileRegistry.SERVICE_NAME);
                if (profileRegistry != null && (profile = profileRegistry.getProfile(ProvisioningUI.getDefaultUI().getProfileId())) != null) {
                    IQueryResult result = profile.available(QueryUtil.createIUGroupQuery(), monitor);
                    for (IInstallableUnit unit : result) {
                        features.add(unit.getId());
                    }
                }
            }
            finally {
                bundleContext.ungetService(serviceReference);
            }
        }
        if (features.isEmpty()) {
            IBundleGroupProvider[] bundleGroupProviders;
            IBundleGroupProvider[] iBundleGroupProviderArray = bundleGroupProviders = Platform.getBundleGroupProviders();
            int n = bundleGroupProviders.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleGroup[] bundleGroups;
                IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
                if (monitor.isCanceled()) break;
                IBundleGroup[] iBundleGroupArray = bundleGroups = provider.getBundleGroups();
                int n3 = bundleGroups.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBundleGroup group = iBundleGroupArray[n4];
                    String identifier = group.getIdentifier();
                    if (!identifier.endsWith(DOT_FEATURE_DOT_GROUP)) {
                        identifier = String.valueOf(identifier) + DOT_FEATURE_DOT_GROUP;
                    }
                    features.add(identifier);
                    ++n4;
                }
                ++n2;
            }
        }
        return features;
    }

    public static void setDefaultHelp(Control control) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "org.eclipse.epp.mpc.help.ui.userGuide");
    }
}

