/*
 * Copyright (c) 2014, 2015 Eike Stepper (Loehne, Germany) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *    Eike Stepper - initial API and implementation
 */
package org.eclipse.oomph.p2;

import org.eclipse.emf.common.util.Enumerator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Version Segment</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.oomph.p2.P2Package#getVersionSegment()
 * @model
 * @generated
 */
public enum VersionSegment implements Enumerator
{
  /**
   * The '<em><b>Major</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #MAJOR_VALUE
   * @generated
   * @ordered
   */
  MAJOR(0, "Major", "Major"), //$NON-NLS-1$ //$NON-NLS-2$

  /**
   * The '<em><b>Minor</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #MINOR_VALUE
   * @generated
   * @ordered
   */
  MINOR(0, "Minor", "Minor"), //$NON-NLS-1$ //$NON-NLS-2$

  /**
   * The '<em><b>Micro</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #MICRO_VALUE
   * @generated
   * @ordered
   */
  MICRO(0, "Micro", "Micro"), //$NON-NLS-1$ //$NON-NLS-2$

  /**
   * The '<em><b>Qualifier</b></em>' literal object.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #QUALIFIER_VALUE
   * @generated
   * @ordered
   */
  QUALIFIER(0, "Qualifier", "Qualifier"); //$NON-NLS-1$ //$NON-NLS-2$

  /**
   * The '<em><b>Major</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #MAJOR
   * @model name="Major"
   * @generated
   * @ordered
   */
  public static final int MAJOR_VALUE = 0;

  /**
   * The '<em><b>Minor</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #MINOR
   * @model name="Minor"
   * @generated
   * @ordered
   */
  public static final int MINOR_VALUE = 0;

  /**
   * The '<em><b>Micro</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #MICRO
   * @model name="Micro"
   * @generated
   * @ordered
   */
  public static final int MICRO_VALUE = 0;

  /**
   * The '<em><b>Qualifier</b></em>' literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @see #QUALIFIER
   * @model name="Qualifier"
   * @generated
   * @ordered
   */
  public static final int QUALIFIER_VALUE = 0;

  /**
   * An array of all the '<em><b>Version Segment</b></em>' enumerators.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private static final VersionSegment[] VALUES_ARRAY = new VersionSegment[] { MAJOR, MINOR, MICRO, QUALIFIER, };

  /**
   * A public read-only list of all the '<em><b>Version Segment</b></em>' enumerators.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  public static final List<VersionSegment> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

  /**
   * Returns the '<em><b>Version Segment</b></em>' literal with the specified literal value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param literal the literal.
   * @return the matching enumerator or <code>null</code>.
   * @generated
   */
  public static VersionSegment get(String literal)
  {
    for (int i = 0; i < VALUES_ARRAY.length; ++i)
    {
      VersionSegment result = VALUES_ARRAY[i];
      if (result.toString().equals(literal))
      {
        return result;
      }
    }
    return null;
  }

  /**
   * Returns the '<em><b>Version Segment</b></em>' literal with the specified name.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param name the name.
   * @return the matching enumerator or <code>null</code>.
   * @generated
   */
  public static VersionSegment getByName(String name)
  {
    for (int i = 0; i < VALUES_ARRAY.length; ++i)
    {
      VersionSegment result = VALUES_ARRAY[i];
      if (result.getName().equals(name))
      {
        return result;
      }
    }
    return null;
  }

  /**
   * Returns the '<em><b>Version Segment</b></em>' literal with the specified integer value.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @param value the integer value.
   * @return the matching enumerator or <code>null</code>.
   * @generated
   */
  public static VersionSegment get(int value)
  {
    switch (value)
    {
      case MAJOR_VALUE:
        return MAJOR;
    }
    return null;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private final int value;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private final String name;

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private final String literal;

  /**
   * Only this class can construct instances.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  private VersionSegment(int value, String name, String literal)
  {
    this.value = value;
    this.name = name;
    this.literal = literal;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public int getValue()
  {
    return value;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public String getName()
  {
    return name;
  }

  /**
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public String getLiteral()
  {
    return literal;
  }

  /**
   * Returns the literal value of the enumerator, which is its string representation.
   * <!-- begin-user-doc -->
   * <!-- end-user-doc -->
   * @generated
   */
  @Override
  public String toString()
  {
    return literal;
  }

} // VersionSegment
