/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILog;
import org.eclipse.e4.core.services.contributions.IContributionFactory;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class DynamicMenuContributionItem
extends ContributionItem {
    private final IConfigurationElement dynamicAddition;
    private final IServiceLocator locator;
    private boolean alreadyFailed;
    private ContributionItem loadedDynamicContribution;
    private IContributionFactory factory;

    public DynamicMenuContributionItem(String id, IServiceLocator locator, IConfigurationElement dynamicAddition) {
        super(id);
        this.locator = locator;
        this.dynamicAddition = dynamicAddition;
        this.factory = locator.getService(IContributionFactory.class);
    }

    public boolean isDynamic() {
        if (this.loadedDynamicContribution != null) {
            try {
                return this.loadedDynamicContribution.isDynamic();
            }
            catch (RuntimeException e) {
                DynamicMenuContributionItem.reportErrorForContribution((IContributionItem)this.loadedDynamicContribution, e);
            }
        }
        return true;
    }

    public boolean isDirty() {
        if (this.loadedDynamicContribution != null) {
            try {
                return this.loadedDynamicContribution.isDirty();
            }
            catch (RuntimeException e) {
                DynamicMenuContributionItem.reportErrorForContribution((IContributionItem)this.loadedDynamicContribution, e);
            }
        }
        return super.isDirty();
    }

    public boolean isEnabled() {
        if (this.loadedDynamicContribution != null) {
            try {
                return this.loadedDynamicContribution.isEnabled();
            }
            catch (RuntimeException e) {
                DynamicMenuContributionItem.reportErrorForContribution((IContributionItem)this.loadedDynamicContribution, e);
            }
        }
        return super.isEnabled();
    }

    public boolean isGroupMarker() {
        if (this.loadedDynamicContribution != null) {
            try {
                return this.loadedDynamicContribution.isGroupMarker();
            }
            catch (RuntimeException e) {
                DynamicMenuContributionItem.reportErrorForContribution((IContributionItem)this.loadedDynamicContribution, e);
            }
        }
        return super.isGroupMarker();
    }

    public boolean isSeparator() {
        if (this.loadedDynamicContribution != null) {
            try {
                return this.loadedDynamicContribution.isSeparator();
            }
            catch (RuntimeException e) {
                DynamicMenuContributionItem.reportErrorForContribution((IContributionItem)this.loadedDynamicContribution, e);
            }
        }
        return super.isSeparator();
    }

    public boolean isVisible() {
        if (this.loadedDynamicContribution != null) {
            try {
                return this.loadedDynamicContribution.isVisible();
            }
            catch (RuntimeException e) {
                DynamicMenuContributionItem.reportErrorForContribution((IContributionItem)this.loadedDynamicContribution, e);
            }
        }
        if (this.factory != null && !this.factory.isEnabled(this.getId())) {
            return false;
        }
        return super.isVisible();
    }

    public void saveWidgetState() {
        if (this.loadedDynamicContribution != null) {
            try {
                this.loadedDynamicContribution.saveWidgetState();
            }
            catch (RuntimeException e) {
                DynamicMenuContributionItem.reportErrorForContribution((IContributionItem)this.loadedDynamicContribution, e);
            }
        }
        super.saveWidgetState();
    }

    public void setVisible(boolean visible) {
        if (this.loadedDynamicContribution != null) {
            try {
                this.loadedDynamicContribution.setVisible(visible);
            }
            catch (RuntimeException e) {
                DynamicMenuContributionItem.reportErrorForContribution((IContributionItem)this.loadedDynamicContribution, e);
            }
        }
        super.setVisible(visible);
    }

    public void fill(Composite parent) {
        IContributionItem contributionItem = this.getContributionItem();
        if (contributionItem != null) {
            try {
                contributionItem.fill(parent);
            }
            catch (RuntimeException e) {
                DynamicMenuContributionItem.reportErrorForContribution(contributionItem, e);
            }
        }
    }

    public void fill(CoolBar parent, int index) {
        IContributionItem contributionItem = this.getContributionItem();
        if (contributionItem != null) {
            try {
                contributionItem.fill(parent, index);
            }
            catch (RuntimeException e) {
                DynamicMenuContributionItem.reportErrorForContribution(contributionItem, e);
            }
        }
    }

    public void fill(Menu menu, int index) {
        IContributionItem contributionItem = this.getContributionItem();
        if (contributionItem != null) {
            try {
                contributionItem.fill(menu, index);
            }
            catch (RuntimeException e) {
                DynamicMenuContributionItem.reportErrorForContribution(contributionItem, e);
            }
        }
    }

    public void fill(ToolBar parent, int index) {
        IContributionItem contributionItem = this.getContributionItem();
        if (contributionItem != null) {
            try {
                contributionItem.fill(parent, index);
            }
            catch (RuntimeException e) {
                DynamicMenuContributionItem.reportErrorForContribution(contributionItem, e);
            }
        }
    }

    private IContributionItem getContributionItem() {
        if (this.loadedDynamicContribution == null && !this.alreadyFailed) {
            this.createContributionItem();
        }
        return this.loadedDynamicContribution;
    }

    private void createContributionItem() {
        this.loadedDynamicContribution = (ContributionItem)Util.safeLoadExecutableExtension(this.dynamicAddition, "class", ContributionItem.class);
        if (this.loadedDynamicContribution == null) {
            this.alreadyFailed = true;
            return;
        }
        this.loadedDynamicContribution.setId(this.getId());
        this.loadedDynamicContribution.setParent(this.getParent());
        if (this.loadedDynamicContribution instanceof IWorkbenchContribution) {
            ((IWorkbenchContribution)this.loadedDynamicContribution).initialize(this.locator);
        }
    }

    public void dispose() {
        if (this.loadedDynamicContribution != null) {
            try {
                this.loadedDynamicContribution.dispose();
            }
            catch (RuntimeException e) {
                DynamicMenuContributionItem.reportErrorForContribution((IContributionItem)this.loadedDynamicContribution, e);
            }
            this.loadedDynamicContribution = null;
        }
        super.dispose();
    }

    public void update() {
        if (this.loadedDynamicContribution != null) {
            try {
                this.loadedDynamicContribution.update();
            }
            catch (RuntimeException e) {
                DynamicMenuContributionItem.reportErrorForContribution((IContributionItem)this.loadedDynamicContribution, e);
            }
        }
    }

    public void update(String id) {
        if (this.loadedDynamicContribution != null) {
            try {
                this.loadedDynamicContribution.update(id);
            }
            catch (RuntimeException e) {
                DynamicMenuContributionItem.reportErrorForContribution((IContributionItem)this.loadedDynamicContribution, e);
            }
        }
    }

    public void setParent(IContributionManager parent) {
        super.setParent(parent);
        if (this.loadedDynamicContribution != null) {
            try {
                this.loadedDynamicContribution.setParent(parent);
            }
            catch (RuntimeException e) {
                DynamicMenuContributionItem.reportErrorForContribution((IContributionItem)this.loadedDynamicContribution, e);
            }
        }
    }

    private static void reportErrorForContribution(IContributionItem contributionItem, RuntimeException e) {
        String message = String.format("Dynamic menu contribution '%s' threw an unexpected exception", contributionItem);
        ILog.get().error(message, (Throwable)e);
    }
}

