/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.wizards.datatransfer;

import java.io.File;
import java.io.FileFilter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;

public class WizardExternalProjectImportPage
extends WizardPage {
    private FileFilter projectFilter = pathName -> pathName.getName().equals(".project");
    private static String previouslyBrowsedDirectory = "";
    private Text projectNameField;
    private Text locationPathField;
    private Button browseButton;
    private IProjectDescription description;
    private Listener locationModifyListener = e -> this.setPageComplete(this.validatePage());
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;

    public WizardExternalProjectImportPage() {
        super("wizardExternalProjectPage");
        this.setPageComplete(false);
        this.setTitle(DataTransferMessages.WizardExternalProjectImportPage_title);
        this.setDescription(DataTransferMessages.WizardExternalProjectImportPage_description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.ui.ide.new_project_wizard_page_context");
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(parent.getFont());
        this.createProjectNameGroup(composite);
        this.createProjectLocationGroup(composite);
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)composite);
    }

    private final void createProjectLocationGroup(Composite parent) {
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        projectGroup.setFont(parent.getFont());
        Label projectContentsLabel = new Label(projectGroup, 0);
        projectContentsLabel.setText(DataTransferMessages.WizardExternalProjectImportPage_projectContentsLabel);
        projectContentsLabel.setFont(parent.getFont());
        this.createUserSpecifiedProjectLocationGroup(projectGroup);
    }

    private final void createProjectNameGroup(Composite parent) {
        Font dialogFont = parent.getFont();
        Composite projectGroup = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        projectGroup.setFont(dialogFont);
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label projectLabel = new Label(projectGroup, 0);
        projectLabel.setText(DataTransferMessages.WizardExternalProjectImportPage_nameLabel);
        projectLabel.setFont(dialogFont);
        this.projectNameField = new Text(projectGroup, 2056);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.projectNameField.setLayoutData((Object)data);
        this.projectNameField.setFont(dialogFont);
        this.projectNameField.setBackground(parent.getDisplay().getSystemColor(22));
    }

    private void createUserSpecifiedProjectLocationGroup(Composite projectGroup) {
        Font dialogFont = projectGroup.getFont();
        this.locationPathField = new Text(projectGroup, 2048);
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.locationPathField.setLayoutData((Object)data);
        this.locationPathField.setFont(dialogFont);
        this.browseButton = new Button(projectGroup, 8);
        this.browseButton.setText(DataTransferMessages.DataTransfer_browse);
        this.browseButton.setFont(dialogFont);
        this.setButtonLayoutData(this.browseButton);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                WizardExternalProjectImportPage.this.handleLocationBrowseButtonPressed();
            }
        });
        this.locationPathField.addListener(24, this.locationModifyListener);
    }

    public IPath getLocationPath() {
        return IPath.fromOSString((String)this.getProjectLocationFieldValue());
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public String getProjectName() {
        return this.getProjectNameFieldValue();
    }

    private String getProjectNameFieldValue() {
        if (this.projectNameField == null) {
            return "";
        }
        return this.projectNameField.getText().trim();
    }

    private String getProjectLocationFieldValue() {
        return this.locationPathField.getText().trim();
    }

    private void handleLocationBrowseButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.locationPathField.getShell(), 0x10000000);
        dialog.setMessage(DataTransferMessages.WizardExternalProjectImportPage_directoryLabel);
        String dirName = this.getProjectLocationFieldValue();
        if (dirName.isEmpty()) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.isEmpty()) {
            dialog.setFilterPath(this.getWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(IPath.fromOSString((String)dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.locationPathField.setText(previouslyBrowsedDirectory);
            this.setProjectName(this.projectFile(previouslyBrowsedDirectory));
        }
    }

    private boolean validatePage() {
        String locationFieldContents = this.getProjectLocationFieldValue();
        if (locationFieldContents.isEmpty()) {
            this.setErrorMessage(null);
            this.setMessage(DataTransferMessages.WizardExternalProjectImportPage_projectLocationEmpty);
            return false;
        }
        IPath path = IPath.fromOSString((String)"");
        if (!path.isValidPath(locationFieldContents)) {
            this.setErrorMessage(DataTransferMessages.WizardExternalProjectImportPage_locationError);
            return false;
        }
        File projectFile = this.projectFile(locationFieldContents);
        if (projectFile == null) {
            this.setErrorMessage(NLS.bind((String)DataTransferMessages.WizardExternalProjectImportPage_notAProject, (Object)locationFieldContents));
            return false;
        }
        this.setProjectName(projectFile);
        if (this.getProjectHandle().exists()) {
            this.setErrorMessage(DataTransferMessages.WizardExternalProjectImportPage_projectExistsMessage);
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }

    private IWorkspace getWorkspace() {
        return IDEWorkbenchPlugin.getPluginWorkspace();
    }

    private boolean isPrefixOfRoot(IPath locationPath) {
        return Platform.getLocation().isPrefixOf(locationPath);
    }

    private void setProjectName(File projectFile) {
        if (projectFile == null) {
            return;
        }
        IPath path = IPath.fromOSString((String)projectFile.getPath());
        IProjectDescription newDescription = null;
        try {
            newDescription = this.getWorkspace().loadProjectDescription(path);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (newDescription == null) {
            this.description = null;
            this.projectNameField.setText("");
        } else {
            this.description = newDescription;
            this.projectNameField.setText(this.description.getName());
        }
    }

    private File projectFile(String locationFieldContents) {
        File directory = new File(locationFieldContents);
        if (directory.isFile()) {
            return null;
        }
        File[] files = directory.listFiles(this.projectFilter);
        if (files != null && files.length == 1) {
            return files[0];
        }
        return null;
    }

    IProject createExistingProject() {
        String projectName = this.projectNameField.getText();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(projectName);
        if (this.description == null) {
            this.description = workspace.newProjectDescription(projectName);
            IPath locationPath = this.getLocationPath();
            if (this.isPrefixOfRoot(locationPath)) {
                this.description.setLocation(null);
            } else {
                this.description.setLocation(locationPath);
            }
        } else {
            this.description.setName(projectName);
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            @Override
            protected void execute(IProgressMonitor monitor) throws CoreException {
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
                project.create(WizardExternalProjectImportPage.this.description, (IProgressMonitor)subMonitor.split(50));
                project.open(128, (IProgressMonitor)subMonitor.split(50));
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.open((int)1, (Shell)this.getShell(), (String)DataTransferMessages.WizardExternalProjectImportPage_errorMessage, (String)NLS.bind((String)DataTransferMessages.WizardExternalProjectImportPage_caseVariantExistsError, (Object)projectName), (int)0x10000000);
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)DataTransferMessages.WizardExternalProjectImportPage_errorMessage, null, (IStatus)((CoreException)t).getStatus());
                }
            }
            return null;
        }
        return project;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.locationPathField.setFocus();
        }
    }
}

