/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.ui.internal.pde;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.oomph.ui.internal.pde.Messages;
import org.eclipse.oomph.ui.internal.pde.Target;
import org.eclipse.oomph.ui.internal.pde.TargetElement;
import org.eclipse.oomph.ui.internal.pde.TargetManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.TargetBundle;
import org.eclipse.pde.core.target.TargetFeature;

public final class TargetSnapshot
implements Comparable<TargetSnapshot> {
    private static final TargetElement[] NO_ELEMENTS = new TargetElement[0];
    private final Target target;
    private final int number;
    private final long timeStamp;
    private final String xml;
    private State state = State.Resolving;
    private IStatus resolutionStatus;
    private Set<TargetElement> elements = new HashSet<TargetElement>();
    private TargetElement[] sortedElements = NO_ELEMENTS;

    TargetSnapshot(Target target, int number, String xml) {
        this.target = Objects.requireNonNull(target);
        this.number = number;
        this.xml = xml;
        this.timeStamp = System.currentTimeMillis();
    }

    public Target getTarget() {
        return this.target;
    }

    public int getNumber() {
        return this.number;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public String getXML() {
        return this.xml;
    }

    public State getState() {
        return this.state;
    }

    public IStatus getResolutionStatus() {
        return this.resolutionStatus;
    }

    public TargetElement[] getElements() {
        return this.sortedElements;
    }

    public boolean restore() {
        TargetManager manager = this.getTarget().getManager();
        return manager.restoreSnapshot(this);
    }

    public Delta createDelta(TargetSnapshot previous) {
        return new Delta(this, previous);
    }

    public Delta createDelta() {
        TargetSnapshot previous = this.target.getPreviousSnapshot(this);
        if (previous == null) {
            return null;
        }
        return new Delta(this, previous);
    }

    @Override
    public int compareTo(TargetSnapshot o) {
        return -Integer.compare(this.number, o.number);
    }

    public String toString() {
        return "TargetSnapshot[" + String.valueOf(this.target) + ", " + this.number + "]";
    }

    void setResolving() {
        this.resolutionStatus = null;
        this.state = State.fromResolutionStatus(this.resolutionStatus);
    }

    boolean update(ITargetDefinition definition) {
        if (definition.isResolved()) {
            this.doUpdate(definition);
            return true;
        }
        Job.createSystem((String)NLS.bind((String)Messages.TargetSnapshot_ResolveJob_name0, (Object)this.target.getName()), monitor -> {
            TargetManager manager = this.target.getManager();
            manager.snapshotResolutionStarted(this, definition);
            try {
                definition.resolve(monitor);
            }
            catch (Exception exception) {
                // empty catch block
            }
            manager.snapshotResolutionFinished(this, definition);
            return Status.OK_STATUS;
        }).schedule();
        return false;
    }

    void doUpdate(ITargetDefinition definition) {
        this.resolutionStatus = definition.getStatus();
        this.state = State.fromResolutionStatus(this.resolutionStatus);
        this.elements = new HashSet<TargetElement>();
        if (this.state == State.Resolved) {
            TargetFeature[] targetFeatureArray = definition.getAllFeatures();
            int n = targetFeatureArray.length;
            int n2 = 0;
            while (n2 < n) {
                TargetFeature targetFeature = targetFeatureArray[n2];
                this.elements.add(TargetElement.fromFeature(this, targetFeature));
                ++n2;
            }
            targetFeatureArray = definition.getAllBundles();
            n = targetFeatureArray.length;
            n2 = 0;
            while (n2 < n) {
                TargetFeature targetBundle = targetFeatureArray[n2];
                this.elements.add(TargetElement.fromBundle(this, (TargetBundle)targetBundle));
                ++n2;
            }
            this.sortedElements = this.elements.toArray(new TargetElement[this.elements.size()]);
            Arrays.sort(this.sortedElements);
        } else {
            this.sortedElements = new TargetElement[0];
        }
    }

    public static final class Delta {
        private final TargetSnapshot snapshot;
        private final TargetSnapshot previous;
        private final Set<TargetElement> removedElements = new LinkedHashSet<TargetElement>();
        private final Set<TargetElement> addedElements = new LinkedHashSet<TargetElement>();
        private final Change[] changes;

        private Delta(TargetSnapshot snapshot, TargetSnapshot previous) {
            this.snapshot = Objects.requireNonNull(snapshot);
            this.previous = Objects.requireNonNull(previous);
            ArrayList<Change> list = new ArrayList<Change>();
            this.compare(snapshot, previous, this.removedElements, list, Change.Kind.Removal);
            this.compare(previous, snapshot, this.addedElements, list, Change.Kind.Addition);
            list.sort(null);
            this.changes = list.toArray(new Change[list.size()]);
        }

        public TargetSnapshot getSnapshot() {
            return this.snapshot;
        }

        public TargetSnapshot getPrevious() {
            return this.previous;
        }

        public Set<TargetElement> getRemovedElements() {
            return Collections.unmodifiableSet(this.removedElements);
        }

        public Set<TargetElement> getAddedElements() {
            return Collections.unmodifiableSet(this.addedElements);
        }

        public Change[] getChanges() {
            return this.changes;
        }

        private void compare(TargetSnapshot snapshot, TargetSnapshot previous, Set<TargetElement> elements, List<Change> changes, Change.Kind changeKind) {
            TargetElement[] targetElementArray = previous.sortedElements;
            int n = previous.sortedElements.length;
            int n2 = 0;
            while (n2 < n) {
                TargetElement previousElement = targetElementArray[n2];
                if (!snapshot.elements.contains(previousElement)) {
                    elements.add(previousElement);
                    changes.add(new Change(this, previousElement, changeKind));
                }
                ++n2;
            }
        }

        public static final class Change
        implements Comparable<Change> {
            private final Delta delta;
            private final TargetElement element;
            private final Kind kind;

            private Change(Delta delta, TargetElement element, Kind kind) {
                this.delta = Objects.requireNonNull(delta);
                this.element = Objects.requireNonNull(element);
                this.kind = Objects.requireNonNull(kind);
                TargetSnapshot snapshot = element.getSnapshot();
                if (snapshot != delta.getSnapshot() && snapshot != delta.getPrevious()) {
                    throw new IllegalArgumentException();
                }
            }

            public Delta getDelta() {
                return this.delta;
            }

            public TargetElement getElement() {
                return this.element;
            }

            public Kind getKind() {
                return this.kind;
            }

            @Override
            public int compareTo(Change o) {
                return this.element.compareTo(o.element);
            }

            public String toString() {
                return String.valueOf((Object)this.kind) + "[" + String.valueOf(this.element) + "]";
            }

            public static enum Kind {
                Removal,
                Addition;

            }
        }
    }

    public static enum State {
        Resolving,
        Canceled,
        Resolved,
        Error;


        public static State fromResolutionStatus(IStatus status) {
            if (status == null) {
                return Resolving;
            }
            int severity = status.getSeverity();
            switch (severity) {
                case 8: {
                    return Canceled;
                }
                case 0: {
                    return Resolved;
                }
            }
            return Error;
        }
    }
}

