/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.jsvg.nodes.container;

import com.github.weisj.jsvg.nodes.AbstractSVGNode;
import com.github.weisj.jsvg.nodes.SVGNode;
import com.github.weisj.jsvg.nodes.prototype.Container;
import com.github.weisj.jsvg.nodes.prototype.spec.Category;
import com.github.weisj.jsvg.nodes.prototype.spec.PermittedContent;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseContainerNode<E>
extends AbstractSVGNode
implements Container<E> {
    private static final boolean EXHAUSTIVE_CHECK = true;
    private static final Logger LOGGER = Logger.getLogger(BaseContainerNode.class.getName());

    @Override
    public final void addChild(@Nullable String id, @NotNull SVGNode node) {
        if (this.isAcceptableType(node) && this.acceptChild(id, node)) {
            this.doAdd(node);
        }
    }

    protected abstract void doAdd(@NotNull SVGNode var1);

    protected boolean acceptChild(@Nullable String id, @NotNull SVGNode node) {
        return true;
    }

    protected boolean isAcceptableType(@NotNull SVGNode node) {
        PermittedContent allowedNodes = this.getClass().getAnnotation(PermittedContent.class);
        if (allowedNodes == null) {
            throw new IllegalStateException(String.format("Element <%s> doesn't specify permitted content information", this.tagName()));
        }
        if (allowedNodes.any()) {
            return true;
        }
        Category[] categories = Category.categoriesOf(node);
        Class<?> nodeType = node.getClass();
        CategoryCheckResult result = this.doIntersect(allowedNodes.categories(), categories);
        if (result == CategoryCheckResult.Allowed) {
            return true;
        }
        for (Class<? extends SVGNode> type : allowedNodes.anyOf()) {
            if (!type.isAssignableFrom(nodeType)) continue;
            return true;
        }
        if (result != CategoryCheckResult.Excluded) {
            LOGGER.warning(() -> String.format("Element <%s> not allowed in <%s> (or not implemented)", node.tagName(), this.tagName()));
        }
        return false;
    }

    private CategoryCheckResult doIntersect(Category[] requested, Category[] provided) {
        CategoryCheckResult result = CategoryCheckResult.Denied;
        for (Category request : requested) {
            boolean effectivelyAllowed = request.isEffectivelyAllowed();
            if (!effectivelyAllowed) {
                // empty if block
            }
            for (Category category : provided) {
                if (request != category) continue;
                if (effectivelyAllowed) {
                    return CategoryCheckResult.Allowed;
                }
                result = CategoryCheckResult.Excluded;
            }
        }
        return result;
    }

    private static enum CategoryCheckResult {
        Allowed,
        Denied,
        Excluded;

    }
}

