/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.swt.properties.css2;

import org.eclipse.e4.ui.css.core.dom.properties.css2.AbstractCSSPropertyTextHandler;
import org.eclipse.e4.ui.css.core.dom.properties.css2.ICSSPropertyTextHandler;
import org.eclipse.e4.ui.css.core.engine.CSSEngine;
import org.eclipse.e4.ui.css.swt.helpers.CSSSWTColorHelper;
import org.eclipse.e4.ui.css.swt.helpers.SWTElementHelpers;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.w3c.dom.css.CSSValue;

public class CSSPropertyTextSWTHandler
extends AbstractCSSPropertyTextHandler {
    public static final ICSSPropertyTextHandler INSTANCE = new CSSPropertyTextSWTHandler();

    public boolean applyCSSProperty(Object element, String property, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        if (widget != null) {
            return super.applyCSSProperty((Object)widget, property, value, pseudo, engine);
        }
        return false;
    }

    public String retrieveCSSProperty(Object element, String property, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = SWTElementHelpers.getWidget(element);
        if (widget != null) {
            return super.retrieveCSSProperty((Object)widget, property, pseudo, engine);
        }
        return null;
    }

    public void applyCSSPropertyColor(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = (Widget)element;
        Color newColor = (Color)engine.convert(value, Color.class, (Object)widget.getDisplay());
        if (newColor != null && newColor.isDisposed() || value.getCssValueType() != 1) {
            return;
        }
        if (widget instanceof CTabItem) {
            CTabFolder folder = ((CTabItem)widget).getParent();
            if ("selected".equals(pseudo)) {
                CSSSWTColorHelper.setSelectionForeground(folder, newColor);
            } else {
                CSSSWTColorHelper.setForeground((Control)folder, newColor);
            }
        } else if (widget instanceof Control) {
            CSSSWTColorHelper.setForeground((Control)widget, newColor);
        }
    }

    public void applyCSSPropertyTextTransform(Object element, CSSValue value, String pseudo, CSSEngine engine) throws Exception {
        String newText;
        Text text;
        String oldText;
        Widget widget = (Widget)element;
        String defaultText = (String)widget.getData("org.eclipse.e4.ui.css.swt.TEXT_KEY");
        if (element instanceof Text && !(oldText = (text = (Text)widget).getText()).equals(newText = this.getTextTransform(text.getText(), value, defaultText))) {
            text.setText(newText);
        }
        if (element instanceof Label) {
            Label label = (Label)element;
            label.setText(this.getTextTransform(label.getText(), value, defaultText));
            return;
        }
        if (element instanceof Button) {
            Button button = (Button)element;
            button.setText(this.getTextTransform(button.getText(), value, defaultText));
            return;
        }
    }

    public String retrieveCSSPropertyColor(Object element, String pseudo, CSSEngine engine) throws Exception {
        Widget widget = (Widget)element;
        Color color = null;
        if (widget instanceof CTabItem) {
            color = "selected".equals(pseudo) ? ((CTabItem)widget).getParent().getSelectionForeground() : ((CTabItem)widget).getParent().getForeground();
        } else if (widget instanceof Control) {
            color = ((Control)widget).getForeground();
        }
        return engine.convert((Object)color, Color.class, null);
    }

    public String retrieveCSSPropertyTextTransform(Object element, String pseudo, CSSEngine engine) throws Exception {
        String text = null;
        Widget widget = (Widget)element;
        if (widget instanceof Label) {
            text = ((Label)element).getText();
            if (text != null) {
                widget.setData("org.eclipse.e4.ui.css.swt.TEXT_KEY", (Object)text);
            }
        } else if (widget instanceof Button && (text = ((Button)element).getText()) != null) {
            widget.setData("org.eclipse.e4.ui.css.swt.TEXT_KEY", (Object)text);
        }
        return "none";
    }
}

