/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.viewers;

import java.security.cert.X509Certificate;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.eclipse.equinox.internal.provisional.security.ui.X500PrincipalHelper;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeNode;
import org.eclipse.swt.graphics.Image;

public class CertificateLabelProvider
implements ILabelProvider {
    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof TreeNode) {
            Object o = ((TreeNode)element).getValue();
            if (o instanceof X509Certificate) {
                X509Certificate cert = (X509Certificate)o;
                X500PrincipalHelper principalHelper = new X500PrincipalHelper(cert.getSubjectX500Principal());
                return String.valueOf(principalHelper.getCN()) + "; " + principalHelper.getOU() + "; " + principalHelper.getO();
            }
            if (o instanceof PGPPublicKey) {
                return this.userFriendlyFingerPrint((PGPPublicKey)o);
            }
        }
        return "";
    }

    private String userFriendlyFingerPrint(PGPPublicKey key) {
        if (key == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        boolean spaceSuffix = false;
        byte[] byArray = key.getFingerprint();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            builder.append(String.format("%02X", Byte.toUnsignedInt(b)));
            if (spaceSuffix) {
                builder.append(' ');
            }
            spaceSuffix = !spaceSuffix;
            ++n2;
        }
        builder.deleteCharAt(builder.length() - 1);
        return builder.toString();
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

