/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.decorators;

import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.WorkbenchMessages;

class DecorationReference {
    private final Object element;
    private final Object adaptedElement;
    private volatile String undecoratedText;
    private volatile boolean forceUpdate = false;
    private final Set<IDecorationContext> contexts = ConcurrentHashMap.newKeySet();

    DecorationReference(Object object, Object adaptedObject, IDecorationContext context) {
        Assert.isNotNull((Object)object);
        this.element = object;
        this.adaptedElement = adaptedObject;
        this.addContext(context);
    }

    Object getAdaptedElement() {
        return this.adaptedElement;
    }

    Object getElement() {
        return this.element;
    }

    boolean shouldForceUpdate() {
        return this.forceUpdate;
    }

    void setForceUpdate(boolean forceUpdate) {
        this.forceUpdate = forceUpdate;
    }

    void setUndecoratedText(String text) {
        this.undecoratedText = text;
    }

    String getSubTask() {
        if (this.undecoratedText == null) {
            return WorkbenchMessages.DecorationReference_EmptyReference;
        }
        return NLS.bind((String)WorkbenchMessages.DecorationScheduler_DecoratingSubtask, (Object)this.undecoratedText);
    }

    Collection<IDecorationContext> getContexts() {
        return this.contexts;
    }

    void addContext(IDecorationContext context) {
        this.contexts.add(context);
    }
}

