/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.internal.installer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Platform;
import org.eclipse.oomph.setup.internal.installer.DesktopSupport;
import org.eclipse.oomph.setup.internal.installer.FreeDesktopSupport;
import org.eclipse.oomph.setup.internal.installer.Messages;
import org.eclipse.oomph.setup.internal.installer.SetupInstallerPlugin;
import org.eclipse.oomph.setup.internal.installer.WindowsPowerShell;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.OomphPlugin;
import org.eclipse.oomph.util.PropertiesUtil;

public final class KeepInstallerUtil {
    public static final String KEEP_INSTALLER_DESCRIPTION = Messages.KeepInstallerUtil_Keep_message;
    private static final OomphPlugin.Preference PREF_KEPT = SetupInstallerPlugin.INSTANCE.getConfigurationPreference("kept");
    private static DesktopSupport desktopSupport;

    private KeepInstallerUtil() {
    }

    private static void createShortCut(DesktopSupport.ShortcutType type, File target) {
        KeepInstallerUtil.createShortCut(type, null, target, PropertiesUtil.getProductName(), null, PropertiesUtil.getProductID());
    }

    public static void createShortCut(DesktopSupport.ShortcutType type, String groupName, File target, String shortcutName, String description, String id) {
        try {
            DesktopSupport desktopSupport = KeepInstallerUtil.getDesktopSupport();
            if (desktopSupport != null) {
                desktopSupport.createShortCut(type, groupName, target, shortcutName, description, id);
            }
        }
        catch (IOException ex) {
            SetupInstallerPlugin.INSTANCE.log(ex);
        }
    }

    public static void pinToTaskBar(String location, String launcherName) {
        try {
            DesktopSupport desktopSupport = KeepInstallerUtil.getDesktopSupport();
            if (desktopSupport != null) {
                desktopSupport.pinToTaskBar(location, launcherName);
            }
        }
        catch (IOException ex) {
            SetupInstallerPlugin.INSTANCE.log(ex);
        }
    }

    public static boolean canKeepInstaller() {
        return !KeepInstallerUtil.isInstallerKept() && KeepInstallerUtil.isTransientInstaller();
    }

    public static boolean isTransientInstaller() {
        if (OS.INSTANCE.isWin()) {
            String launcher = OS.getCurrentLauncher((boolean)false);
            return launcher != null && launcher.startsWith(PropertiesUtil.getTmpDir());
        }
        return false;
    }

    public static DesktopSupport getDesktopSupport() {
        block8: {
            if (desktopSupport == null) {
                try {
                    if (OS.INSTANCE.isWin()) {
                        File[] versions;
                        File powerShellFolder;
                        File system32;
                        String systemRoot = System.getenv("SystemRoot");
                        if (systemRoot == null || !(system32 = new File(systemRoot, "system32")).isDirectory() || !(powerShellFolder = new File(system32, "WindowsPowerShell")).isDirectory() || (versions = powerShellFolder.listFiles()) == null) break block8;
                        File[] fileArray = versions;
                        int n = versions.length;
                        int n2 = 0;
                        while (n2 < n) {
                            block9: {
                                File version = fileArray[n2];
                                try {
                                    File executable = new File(version, "powershell.exe");
                                    if (!executable.isFile()) break block9;
                                    desktopSupport = new WindowsPowerShell(executable.getAbsolutePath());
                                    break block8;
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                            ++n2;
                        }
                        break block8;
                    }
                    if (OS.INSTANCE.isLinux()) {
                        desktopSupport = new FreeDesktopSupport();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return desktopSupport;
    }

    public static void keepInstaller(String targetLocation, boolean startPermanentInstaller, String launcher, boolean startMenu, boolean desktop, boolean quickLaunch) {
        File source = new File(launcher).getParentFile();
        File target = new File(targetLocation);
        IOUtil.copyTree((File)source, (File)target, (boolean)true);
        String launcherName = new File(launcher).getName();
        File permanentLauncher = new File(target, launcherName);
        if (startPermanentInstaller) {
            ArrayList<String> command = new ArrayList<String>();
            command.add(permanentLauncher.getAbsolutePath());
            command.addAll(Arrays.asList(Platform.getApplicationArgs()));
            try {
                Runtime.getRuntime().exec(command.toArray(new String[command.size()]));
            }
            catch (Exception ex) {
                SetupInstallerPlugin.INSTANCE.log(ex);
            }
        } else {
            String url = target.toURI().toString();
            OS.INSTANCE.openSystemBrowser(url);
        }
        if (startMenu) {
            KeepInstallerUtil.createShortCut(DesktopSupport.ShortcutType.START_MENU, permanentLauncher);
        }
        if (desktop) {
            KeepInstallerUtil.createShortCut(DesktopSupport.ShortcutType.DESKTOP, permanentLauncher);
        }
        if (quickLaunch) {
            KeepInstallerUtil.pinToTaskBar(targetLocation, launcherName);
        }
        KeepInstallerUtil.setKeepInstaller(true);
    }

    public static boolean isInstallerKept() {
        return PREF_KEPT.get(false);
    }

    public static void setKeepInstaller(boolean keep) {
        PREF_KEPT.set(keep);
    }
}

