/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;

public class TabsToSpacesConverter
implements IAutoEditStrategy {
    private int fTabRatio;
    private boolean fDeleteSpacesAsTab;
    private ILineTracker fLineTracker;

    public void setNumberOfSpacesPerTab(int ratio) {
        this.fTabRatio = ratio;
    }

    public void setDeleteSpacesAsTab(boolean enabled) {
        this.fDeleteSpacesAsTab = enabled;
    }

    public void setLineTracker(ILineTracker lineTracker) {
        this.fLineTracker = lineTracker;
    }

    private int insertTabString(StringBuilder buffer, int offsetInLine) {
        if (this.fTabRatio == 0) {
            return 0;
        }
        int remainder = offsetInLine % this.fTabRatio;
        remainder = this.fTabRatio - remainder;
        int i = 0;
        while (i < remainder) {
            buffer.append(' ');
            ++i;
        }
        return remainder;
    }

    @Override
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        String text = command.text;
        if (text == null) {
            return;
        }
        if (text.isEmpty()) {
            this.replaceDeleteSpaceByDeleteTab(document, command);
        } else if (text.indexOf(9) > -1) {
            StringBuilder buffer = new StringBuilder();
            this.fLineTracker.set(command.text);
            int lines = this.fLineTracker.getNumberOfLines();
            try {
                int i = 0;
                while (i < lines) {
                    int offset = this.fLineTracker.getLineOffset(i);
                    int endOffset = offset + this.fLineTracker.getLineLength(i);
                    String line = text.substring(offset, endOffset);
                    int position = 0;
                    if (i == 0) {
                        IRegion firstLine = document.getLineInformationOfOffset(command.offset);
                        position = command.offset - firstLine.getOffset();
                    }
                    int length = line.length();
                    int j = 0;
                    while (j < length) {
                        char c = line.charAt(j);
                        if (c == '\t') {
                            position += this.insertTabString(buffer, position);
                        } else {
                            buffer.append(c);
                            ++position;
                        }
                        ++j;
                    }
                    ++i;
                }
                command.text = buffer.toString();
            }
            catch (BadLocationException x) {
                throw new IllegalArgumentException("should never happen", x);
            }
        }
    }

    private void replaceDeleteSpaceByDeleteTab(IDocument document, DocumentCommand command) {
        if (!this.fDeleteSpacesAsTab || this.fTabRatio == 0 || command.length != 1) {
            return;
        }
        ITextSelection selection = command.fSelection;
        if (selection == null || selection.getLength() != 0) {
            return;
        }
        try {
            boolean isDeleteKey;
            if (document.getChar(command.offset) != ' ') {
                return;
            }
            IRegion line = document.getLineInformationOfOffset(command.offset);
            int offsetInLine = command.offset - line.getOffset();
            boolean bl = isDeleteKey = selection.getOffset() == command.offset;
            if (isDeleteKey) {
                int spacesToRemove = this.fTabRatio - offsetInLine % this.fTabRatio - 1;
                while (spacesToRemove-- > 0 && document.getChar(command.offset + command.length) == ' ') {
                    ++command.length;
                }
            } else {
                int spacesToRemove = offsetInLine % this.fTabRatio;
                while (spacesToRemove-- > 0 && document.getChar(command.offset - 1) == ' ') {
                    --command.offset;
                    ++command.length;
                }
            }
        }
        catch (BadLocationException e) {
            throw new IllegalArgumentException("should never happen", e);
        }
    }
}

