/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.themes;

import org.eclipse.e4.ui.internal.css.swt.definition.IFontDefinitionOverridable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.themes.ICategorizedThemeElementDefinition;
import org.eclipse.ui.internal.themes.IEditable;
import org.eclipse.ui.internal.themes.IHierarchalThemeElementDefinition;
import org.eclipse.ui.internal.themes.ThemeElementDefinition;

public class FontDefinition
extends ThemeElementDefinition
implements IHierarchalThemeElementDefinition,
ICategorizedThemeElementDefinition,
IEditable,
IFontDefinitionOverridable {
    private String defaultsTo;
    private String value;
    private String defaultValue;
    private boolean isEditable;
    private FontData[] parsedValue;

    public FontDefinition(String fontName, String uniqueId, String defaultsId, String value, String categoryId, boolean isEditable, String fontDescription) {
        super(uniqueId, fontName, fontDescription, categoryId);
        this.defaultsTo = defaultsId;
        this.value = value;
        this.isEditable = isEditable;
    }

    public FontDefinition(FontDefinition originalFont, FontData[] datas) {
        super(originalFont.getId(), originalFont.getName(), originalFont.getDescription(), originalFont.getCategoryId());
        this.isEditable = originalFont.isEditable();
        this.parsedValue = datas;
    }

    @Override
    public String getDefaultsTo() {
        return this.defaultsTo;
    }

    public FontData[] getValue() {
        if (this.value == null) {
            return null;
        }
        if (this.parsedValue == null) {
            this.parsedValue = JFaceResources.getFontRegistry().filterData(StringConverter.asFontDataArray((String)this.value), PlatformUI.getWorkbench().getDisplay());
        }
        return this.parsedValue;
    }

    @Override
    public void resetToDefaultValue() {
        this.value = this.defaultValue;
        this.parsedValue = null;
        super.resetToDefaultValue();
    }

    @Override
    public boolean isEditable() {
        return this.isEditable;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FontDefinition) {
            return this.getId().equals(((FontDefinition)obj).getId());
        }
        return false;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public void setValue(FontData[] data) {
        if (data != null && data.length > 0) {
            if (this.defaultValue == null) {
                this.defaultValue = this.value;
            }
            this.value = data[0].getName();
            this.parsedValue = data;
            this.appendState(1);
        }
    }
}

