/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text;

import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.AbstractHoverInformationControlManager;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension5;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.IWidgetTokenKeeperExtension;
import org.eclipse.jface.text.IWidgetTokenOwner;
import org.eclipse.jface.text.JFaceTextUtil;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

class TextViewerHoverManager
extends AbstractHoverInformationControlManager
implements IWidgetTokenKeeper,
IWidgetTokenKeeperExtension {
    public static final int WIDGET_PRIORITY = 0;
    private TextViewer fTextViewer;
    private Thread fThread;
    private ITextListener fStopper;
    private Object fMutex = new Object();
    private volatile ITextHover fTextHover;
    private boolean fProcessMouseHoverEvent = true;
    private MouseMoveListener fMouseMoveListener;
    private IViewportListener fViewportListener;

    public TextViewerHoverManager(TextViewer textViewer, IInformationControlCreator creator) {
        super(creator);
        this.fTextViewer = textViewer;
        this.fStopper = event -> {
            Object object = this.fMutex;
            synchronized (object) {
                if (this.fThread != null) {
                    this.fThread.interrupt();
                    this.fThread = null;
                }
            }
        };
        this.fViewportListener = verticalOffset -> {
            boolean bl = this.fProcessMouseHoverEvent = false;
        };
        this.fTextViewer.addViewportListener(this.fViewportListener);
        this.fMouseMoveListener = event -> {
            boolean bl = this.fProcessMouseHoverEvent = true;
        };
        this.fTextViewer.getTextWidget().addMouseMoveListener(this.fMouseMoveListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void computeInformation() {
        if (!this.fProcessMouseHoverEvent) {
            this.setInformation(null, null);
            return;
        }
        Point location = this.getHoverEventLocation();
        int offset = this.computeOffsetAtLocation(location.x, location.y);
        if (offset == -1) {
            this.setInformation(null, null);
            return;
        }
        final ITextHover hover = this.fTextViewer.getTextHover(offset, this.getHoverEventStateMask());
        if (hover == null) {
            this.setInformation(null, null);
            return;
        }
        final IRegion region = hover.getHoverRegion(this.fTextViewer, offset);
        if (region == null) {
            this.setInformation(null, null);
            return;
        }
        final Rectangle area = JFaceTextUtil.computeArea(region, this.fTextViewer);
        if (area == null || area.isEmpty()) {
            this.setInformation(null, null);
            return;
        }
        if (this.fThread != null) {
            this.setInformation(null, null);
            return;
        }
        this.fThread = new Thread("Text Viewer Hover Presenter"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block33: {
                    boolean hasFinished = false;
                    try {
                        if (TextViewerHoverManager.this.fThread != null) {
                            Object information;
                            try {
                                information = hover instanceof ITextHoverExtension2 ? ((ITextHoverExtension2)((Object)hover)).getHoverInfo2(TextViewerHoverManager.this.fTextViewer, region) : hover.getHoverInfo(TextViewerHoverManager.this.fTextViewer, region);
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                information = null;
                            }
                            if (hover instanceof ITextHoverExtension) {
                                TextViewerHoverManager.this.setCustomInformationControlCreator(((ITextHoverExtension)((Object)hover)).getHoverControlCreator());
                            } else {
                                TextViewerHoverManager.this.setCustomInformationControlCreator(null);
                            }
                            TextViewerHoverManager.this.setInformation(information, area);
                            if (information != null) {
                                TextViewerHoverManager.this.fTextHover = hover;
                            }
                        } else {
                            TextViewerHoverManager.this.setInformation(null, null);
                        }
                        hasFinished = true;
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        Object object = TextViewerHoverManager.this.fMutex;
                        synchronized (object) {
                            if (TextViewerHoverManager.this.fTextViewer != null) {
                                TextViewerHoverManager.this.fTextViewer.removeTextListener(TextViewerHoverManager.this.fStopper);
                            }
                            TextViewerHoverManager.this.fThread = null;
                            if (!hasFinished) {
                                TextViewerHoverManager.this.setInformation(null, null);
                            }
                            break block33;
                        }
                    }
                    catch (RuntimeException ex) {
                        Object object;
                        try {
                            String PLUGIN_ID = "org.eclipse.jface.text";
                            ILog log = Platform.getLog((Bundle)Platform.getBundle((String)PLUGIN_ID));
                            log.log((IStatus)new Status(4, PLUGIN_ID, 0, "Unexpected runtime error while computing a text hover", (Throwable)ex));
                            object = TextViewerHoverManager.this.fMutex;
                        }
                        catch (Throwable throwable) {
                            Object object2 = TextViewerHoverManager.this.fMutex;
                            synchronized (object2) {
                                if (TextViewerHoverManager.this.fTextViewer != null) {
                                    TextViewerHoverManager.this.fTextViewer.removeTextListener(TextViewerHoverManager.this.fStopper);
                                }
                                TextViewerHoverManager.this.fThread = null;
                                if (!hasFinished) {
                                    TextViewerHoverManager.this.setInformation(null, null);
                                }
                            }
                            throw throwable;
                        }
                        synchronized (object) {
                            if (TextViewerHoverManager.this.fTextViewer != null) {
                                TextViewerHoverManager.this.fTextViewer.removeTextListener(TextViewerHoverManager.this.fStopper);
                            }
                            TextViewerHoverManager.this.fThread = null;
                            if (!hasFinished) {
                                TextViewerHoverManager.this.setInformation(null, null);
                            }
                            break block33;
                        }
                    }
                    Object object = TextViewerHoverManager.this.fMutex;
                    synchronized (object) {
                        if (TextViewerHoverManager.this.fTextViewer != null) {
                            TextViewerHoverManager.this.fTextViewer.removeTextListener(TextViewerHoverManager.this.fStopper);
                        }
                        TextViewerHoverManager.this.fThread = null;
                        if (!hasFinished) {
                            TextViewerHoverManager.this.setInformation(null, null);
                        }
                    }
                }
            }
        };
        this.fThread.setDaemon(true);
        this.fThread.setPriority(1);
        Object object = this.fMutex;
        synchronized (object) {
            this.fTextViewer.addTextListener(this.fStopper);
            this.fThread.start();
        }
    }

    @Override
    protected void presentInformation() {
        if (this.fTextViewer == null) {
            return;
        }
        StyledText textWidget = this.fTextViewer.getTextWidget();
        if (textWidget != null && !textWidget.isDisposed()) {
            Display display = textWidget.getDisplay();
            if (display == null) {
                return;
            }
            display.asyncExec(() -> {
                if (!textWidget.isDisposed()) {
                    this.doPresentInformation();
                }
            });
        }
    }

    protected void doPresentInformation() {
        super.presentInformation();
    }

    private int computeOffsetAtLocation(int x, int y) {
        int widgetOffset;
        StyledText styledText;
        block5: {
            try {
                styledText = this.fTextViewer.getTextWidget();
                widgetOffset = styledText.getOffsetAtPoint(new Point(x, y));
                if (widgetOffset != -1) break block5;
                return -1;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return -1;
            }
        }
        Point p = styledText.getLocationAtOffset(widgetOffset);
        if (p.x > x) {
            --widgetOffset;
        }
        if (this.fTextViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)((Object)this.fTextViewer);
            return extension.widgetOffset2ModelOffset(widgetOffset);
        }
        return widgetOffset + this.fTextViewer._getVisibleRegionOffset();
    }

    @Override
    protected void showInformationControl(Rectangle subjectArea) {
        if (this.fTextViewer != null && this.fTextViewer.requestWidgetToken(this, 0)) {
            super.showInformationControl(subjectArea);
        } else if (DEBUG) {
            System.out.println("TextViewerHoverManager#showInformationControl(..) did not get widget token");
        }
    }

    @Override
    protected void hideInformationControl() {
        try {
            this.fTextHover = null;
            super.hideInformationControl();
        }
        finally {
            if (this.fTextViewer != null) {
                this.fTextViewer.releaseWidgetToken(this);
            }
        }
    }

    @Override
    void replaceInformationControl(boolean takeFocus) {
        if (this.fTextViewer != null) {
            this.fTextViewer.releaseWidgetToken(this);
        }
        super.replaceInformationControl(takeFocus);
    }

    @Override
    protected void handleInformationControlDisposed() {
        try {
            super.handleInformationControlDisposed();
        }
        finally {
            if (this.fTextViewer != null) {
                this.fTextViewer.releaseWidgetToken(this);
            }
        }
    }

    @Override
    public boolean requestWidgetToken(IWidgetTokenOwner owner) {
        this.fTextHover = null;
        super.hideInformationControl();
        return true;
    }

    @Override
    public boolean requestWidgetToken(IWidgetTokenOwner owner, int priority) {
        if (priority > 0) {
            this.fTextHover = null;
            super.hideInformationControl();
            return true;
        }
        return false;
    }

    @Override
    public boolean setFocus(IWidgetTokenOwner owner) {
        if (!this.hasInformationControlReplacer()) {
            return false;
        }
        IInformationControl iControl = this.getCurrentInformationControl();
        if (this.canReplace(iControl)) {
            if (this.cancelReplacingDelay()) {
                this.replaceInformationControl(true);
            }
            return true;
        }
        return iControl instanceof IInformationControlExtension5;
    }

    protected ITextHover getCurrentTextHover() {
        return this.fTextHover;
    }

    @Override
    public void dispose() {
        if (this.fTextViewer != null) {
            this.fTextViewer.removeViewportListener(this.fViewportListener);
            this.fViewportListener = null;
            StyledText st = this.fTextViewer.getTextWidget();
            if (st != null && !st.isDisposed()) {
                st.removeMouseMoveListener(this.fMouseMoveListener);
            }
            this.fMouseMoveListener = null;
        }
        super.dispose();
    }
}

