/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.IOException;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;

public class BcKeyFingerprintCalculator
implements KeyFingerPrintCalculator {
    @Override
    public byte[] calculateFingerprint(PublicKeyPacket publicKeyPacket) throws PGPException {
        MD5Digest mD5Digest;
        Object object;
        BCPGKey bCPGKey = publicKeyPacket.getKey();
        if (publicKeyPacket.getVersion() <= 3) {
            object = (RSAPublicBCPGKey)bCPGKey;
            try {
                mD5Digest = new MD5Digest();
                byte[] byArray = new MPInteger(((RSAPublicBCPGKey)object).getModulus()).getEncoded();
                mD5Digest.update(byArray, 2, byArray.length - 2);
                byArray = new MPInteger(((RSAPublicBCPGKey)object).getPublicExponent()).getEncoded();
                mD5Digest.update(byArray, 2, byArray.length - 2);
            }
            catch (IOException iOException) {
                throw new PGPException("can't encode key components: " + iOException.getMessage(), iOException);
            }
        }
        try {
            object = publicKeyPacket.getEncodedContents();
            mD5Digest = new SHA1Digest();
            mD5Digest.update((byte)-103);
            mD5Digest.update((byte)(((Object)object).length >> 8));
            mD5Digest.update((byte)((Object)object).length);
            mD5Digest.update((byte[])object, 0, ((Object)object).length);
        }
        catch (IOException iOException) {
            throw new PGPException("can't encode key components: " + iOException.getMessage(), iOException);
        }
        object = new byte[mD5Digest.getDigestSize()];
        mD5Digest.doFinal((byte[])object, 0);
        return object;
    }
}

