/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.cwt.svg;

import org.eclipse.nebula.cwt.svg.SvgContainer;
import org.eclipse.nebula.cwt.svg.SvgFill;
import org.eclipse.nebula.cwt.svg.SvgGraphic;
import org.eclipse.nebula.cwt.svg.SvgStroke;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.PathData;
import org.eclipse.swt.graphics.Transform;

public class SvgShape
extends SvgGraphic {
    private Path path;
    PathData pathData;

    SvgShape(SvgContainer container, String id) {
        super(container, id);
    }

    private void doApply(GC gc) {
        gc.setAntialias(1);
        SvgFill derivedFill = this.getFill();
        SvgStroke derivedStroke = this.getStroke();
        Transform derivedTransform = this.getTransform(gc);
        Transform bak = null;
        if (!derivedTransform.isIdentity()) {
            bak = new Transform(gc.getDevice());
            gc.getTransform(bak);
            gc.setTransform(derivedTransform);
        }
        if (derivedFill.isPaintable()) {
            derivedFill.create(gc);
            derivedFill.apply();
            this.doFill(gc);
            derivedFill.dispose();
        }
        if (derivedStroke.isPaintable()) {
            derivedStroke.create(gc);
            derivedStroke.apply();
            this.doStroke(gc);
            derivedStroke.dispose();
        }
        if (bak != null) {
            gc.setTransform(bak);
        }
        derivedTransform.dispose();
    }

    @Override
    public void apply(GC gc) {
        if (this.pathData.types != null) {
            this.path = new Path(gc.getDevice(), this.pathData);
        }
        this.doApply(gc);
        if (this.path != null) {
            this.path.dispose();
            this.path = null;
        }
    }

    public boolean contains(float x, float y, GC gc, boolean outline) {
        Transform t = new Transform(gc.getDevice());
        gc.getTransform(t);
        t.invert();
        float[] pts = new float[]{x, y};
        t.transform(pts);
        t.dispose();
        return this.path.contains(pts[0], pts[1], gc, outline);
    }

    private void doFill(GC gc) {
        if (this.path != null) {
            gc.fillPath(this.path);
        } else if (this.pathData.points.length == 4) {
            int w = (int)(2.0f * this.pathData.points[2]);
            int h = (int)(2.0f * this.pathData.points[3]);
            if (w > 0 && h > 0) {
                int x = (int)(this.pathData.points[0] - this.pathData.points[2]);
                int y = (int)(this.pathData.points[1] - this.pathData.points[3]);
                gc.fillOval(x, y, w, h);
            }
        } else if (this.pathData.points.length == 6) {
            int w = (int)this.pathData.points[2];
            int h = (int)this.pathData.points[3];
            if (w > 0 && h > 0) {
                int x = (int)this.pathData.points[0];
                int y = (int)this.pathData.points[1];
                int rx = (int)this.pathData.points[4];
                int ry = (int)this.pathData.points[5];
                if (rx > 0 || ry > 0) {
                    gc.fillRoundRectangle(x, y, w, h, this.getRadiusX(), this.getRadiusY());
                } else {
                    gc.fillRectangle(x, y, w, h);
                }
            }
        }
    }

    private void doStroke(GC gc) {
        if (this.path != null) {
            gc.drawPath(this.path);
        } else if (this.pathData.points.length == 4) {
            int w = (int)(2.0f * this.pathData.points[2]);
            int h = (int)(2.0f * this.pathData.points[3]);
            if (w > 0 && h > 0) {
                int x = (int)(this.pathData.points[0] - this.pathData.points[2]);
                int y = (int)(this.pathData.points[1] - this.pathData.points[3]);
                gc.drawOval(x, y, w, h);
            }
        } else if (this.pathData.points.length == 6) {
            int w = (int)this.pathData.points[2];
            int h = (int)this.pathData.points[3];
            if (w > 0 && h > 0) {
                int x = (int)this.pathData.points[0];
                int y = (int)this.pathData.points[1];
                int rx = (int)this.pathData.points[4];
                int ry = (int)this.pathData.points[5];
                if (rx > 0 || ry > 0) {
                    gc.drawRoundRectangle(x, y, w, h, this.getRadiusX(), this.getRadiusY());
                } else {
                    gc.drawRectangle(x, y, w, h);
                }
            }
        }
    }

    float[] getBounds() {
        if (this.path != null) {
            float minx = Float.POSITIVE_INFINITY;
            float miny = Float.POSITIVE_INFINITY;
            float maxx = Float.NEGATIVE_INFINITY;
            float maxy = Float.NEGATIVE_INFINITY;
            int i = 0;
            while (i < this.pathData.points.length - 1) {
                minx = Math.min(minx, this.pathData.points[i]);
                maxx = Math.max(maxx, this.pathData.points[i]);
                miny = Math.min(miny, this.pathData.points[++i]);
                maxy = Math.max(maxy, this.pathData.points[i]);
                ++i;
            }
            return new float[]{minx, miny, Math.abs(maxx - minx), Math.abs(maxy - miny)};
        }
        if (this.pathData.points.length == 4) {
            int x = (int)(this.pathData.points[0] - this.pathData.points[2]);
            int y = (int)(this.pathData.points[1] - this.pathData.points[3]);
            int w = (int)(2.0f * this.pathData.points[2]);
            int h = (int)(2.0f * this.pathData.points[3]);
            return new float[]{x, y, w, h};
        }
        if (this.pathData.points.length == 6) {
            int x = (int)this.pathData.points[0];
            int y = (int)this.pathData.points[1];
            int w = (int)this.pathData.points[2];
            int h = (int)this.pathData.points[3];
            return new float[]{x, y, w, h};
        }
        throw new UnsupportedOperationException();
    }

    private int getRadiusX() {
        if (this.pathData.points[4] > 0.0f) {
            return (int)(2.0f * this.pathData.points[4]);
        }
        if (this.pathData.points[5] > 0.0f) {
            return this.getRadiusY();
        }
        return 0;
    }

    private int getRadiusY() {
        if (this.pathData.points[5] > 0.0f) {
            return (int)(2.0f * this.pathData.points[5]);
        }
        if (this.pathData.points[4] > 0.0f) {
            return this.getRadiusX();
        }
        return 0;
    }
}

