/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.hyperlink;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.AbstractHyperlinkDetector;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.URLHyperlink;

public class URLHyperlinkDetector
extends AbstractHyperlinkDetector {
    private static final String STOP_CHARACTERS = " \t\n\r\f<>";

    public URLHyperlinkDetector() {
    }

    @Deprecated
    public URLHyperlinkDetector(ITextViewer textViewer) {
    }

    @Override
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String line;
        IRegion lineInfo;
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        int offset = region.getOffset();
        String urlString = null;
        if (document == null) {
            return null;
        }
        try {
            lineInfo = document.getLineInformationOfOffset(offset);
            line = document.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException ex) {
            return null;
        }
        int offsetInLine = offset - lineInfo.getOffset();
        char quote = '\u0000';
        int urlOffsetInLine = 0;
        int urlLength = 0;
        int lineEnd = line.length();
        int urlSeparatorOffset = line.indexOf("://");
        while (urlSeparatorOffset >= 0) {
            int afterSeparator;
            char ch;
            urlOffsetInLine = urlSeparatorOffset;
            do {
                ch = ' ';
                if (--urlOffsetInLine > -1) {
                    ch = line.charAt(urlOffsetInLine);
                }
                if (ch != '\"' && ch != 39) continue;
                quote = ch;
            } while (Character.isUnicodeIdentifierStart(ch));
            ++urlOffsetInLine;
            if (ch == ':') {
                int i = urlOffsetInLine - 1;
                while (i >= 0) {
                    if ((ch = line.charAt(i--)) == '\"' || ch == '\'') {
                        quote = ch;
                        break;
                    }
                    if (ch != ':' && !Character.isUnicodeIdentifierStart(ch)) break;
                }
            }
            int end = afterSeparator = urlSeparatorOffset + 3;
            while (end < lineEnd && STOP_CHARACTERS.indexOf(line.charAt(end)) < 0) {
                ++end;
            }
            while (end > afterSeparator && line.charAt(end - 1) == '.') {
                --end;
            }
            if (end > afterSeparator) {
                urlLength = end - urlOffsetInLine;
                if (offsetInLine >= urlOffsetInLine && offsetInLine <= urlOffsetInLine + urlLength) break;
            }
            urlSeparatorOffset = line.indexOf("://", afterSeparator);
        }
        if (urlSeparatorOffset < 0) {
            return null;
        }
        if (quote != '\u0000') {
            int endOffset = -1;
            int nextQuote = line.indexOf(quote, urlOffsetInLine);
            int nextWhitespace = line.indexOf(32, urlOffsetInLine);
            if (nextQuote != -1 && nextWhitespace != -1) {
                endOffset = Math.min(nextQuote, nextWhitespace);
            } else if (nextQuote != -1) {
                endOffset = nextQuote;
            } else if (nextWhitespace != -1) {
                endOffset = nextWhitespace;
            }
            if (endOffset != -1) {
                urlLength = endOffset - urlOffsetInLine;
            }
        }
        if (urlOffsetInLine + urlLength == urlSeparatorOffset + 3) {
            return null;
        }
        try {
            urlString = line.substring(urlOffsetInLine, urlOffsetInLine + urlLength);
            URL endOffset = new URL(urlString);
        }
        catch (MalformedURLException ex) {
            urlString = null;
            return null;
        }
        Region urlRegion = new Region(lineInfo.getOffset() + urlOffsetInLine, urlLength);
        return new IHyperlink[]{new URLHyperlink((IRegion)urlRegion, urlString)};
    }
}

