/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.security.ui.storage.view;

import org.eclipse.equinox.internal.security.ui.nls.SecUIMessages;
import org.eclipse.equinox.internal.security.ui.storage.view.NodesView;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewValueDialog
extends TitleAreaDialog {
    private static final String HELP_ID = "org.eclipse.equinox.security.ui.NewValueDialog";
    private static final ImageDescriptor dlgImageDescriptor = ImageDescriptor.createFromFile(NodesView.class, (String)"/icons/storage/new_value_wiz.png");
    private final String[] existingKeys;
    protected Text keyText;
    protected Text valueText;
    protected Button encryptButton;
    protected Button okButton;
    protected String key;
    protected String value;
    protected boolean encrypt;
    private Image dlgTitleImage = null;

    public NewValueDialog(String[] existingKeys, Shell parentShell) {
        super(parentShell);
        this.existingKeys = existingKeys;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(SecUIMessages.generalTitle);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, HELP_ID);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, SecUIMessages.addValueOK, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, SecUIMessages.addValueCancel, false);
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        this.setTitle(SecUIMessages.addValueTitle);
        this.setMessage(SecUIMessages.addValueMsg);
        this.dlgTitleImage = dlgImageDescriptor.createImage();
        this.setTitleImage(this.dlgTitleImage);
        return contents;
    }

    protected Control createDialogArea(Composite parent) {
        Composite compositeTop = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(compositeTop, 0);
        new Label(composite, 16384).setText(SecUIMessages.addValueKeyLabel);
        this.keyText = new Text(composite, 18432);
        this.keyText.addModifyListener(event -> this.okButton.setEnabled(this.validName()));
        new Label(composite, 16384).setText(SecUIMessages.addValueValueLabel);
        this.valueText = new Text(composite, 18432);
        this.encryptButton = new Button(composite, 32);
        this.encryptButton.setText(SecUIMessages.addValueEncryptLabel);
        this.encryptButton.setSelection(true);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayoutFactory.swtDefaults().generateLayout(composite);
        return composite;
    }

    protected boolean validName() {
        boolean valid;
        String tmp = this.keyText.getText();
        if (tmp == null || tmp.length() == 0) {
            valid = false;
        } else {
            valid = true;
            String[] stringArray = this.existingKeys;
            int n = this.existingKeys.length;
            int n2 = 0;
            while (n2 < n) {
                String existingKey = stringArray[n2];
                if (existingKey.equals(tmp)) {
                    valid = false;
                    break;
                }
                ++n2;
            }
            boolean bl = valid = tmp.indexOf(47) == -1;
        }
        if (valid) {
            this.setMessage(SecUIMessages.addValueMsg, 0);
        } else {
            this.setMessage(SecUIMessages.addValueInvalid, 3);
        }
        return valid;
    }

    protected void okPressed() {
        this.key = this.keyText.getText();
        this.value = this.valueText.getText();
        this.encrypt = this.encryptButton.getSelection();
        super.okPressed();
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public boolean encrypt() {
        return this.encrypt;
    }
}

