/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.viewers;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositories;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.p2.ui.model.RemoteQueriedElement;
import org.eclipse.equinox.internal.p2.ui.viewers.DeferredQueryTreeContentManager;
import org.eclipse.equinox.internal.p2.ui.viewers.IDeferredQueryTreeListener;
import org.eclipse.equinox.internal.p2.ui.viewers.IInputChangeListener;
import org.eclipse.equinox.internal.p2.ui.viewers.ProvElementContentProvider;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class DeferredQueryContentProvider
extends ProvElementContentProvider {
    private DeferredQueryTreeContentManager manager;
    private Object currentInput;
    private HashMap<Object, Object> alreadyQueried = new HashMap();
    private HashSet<Object> queryCompleted = new HashSet();
    private final ListenerList<IInputChangeListener> listeners = new ListenerList();
    private boolean synchronous = false;
    private IDeferredQueryTreeListener onFetchingActionListener;

    public void addListener(IInputChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeListener(IInputChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void addOnFetchingActionListener(IDeferredQueryTreeListener listener) {
        this.onFetchingActionListener = listener;
    }

    @Override
    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        super.inputChanged(v, oldInput, newInput);
        if (this.manager != null) {
            this.manager.cancel(oldInput);
        }
        if (v instanceof AbstractTreeViewer) {
            AbstractTreeViewer atv = (AbstractTreeViewer)v;
            this.manager = new DeferredQueryTreeContentManager(atv);
            this.manager.addListener(this.onFetchingActionListener);
            this.manager.addListener(new IDeferredQueryTreeListener(){

                @Override
                public void fetchingDeferredChildren(Object parent, Object placeholder) {
                    DeferredQueryContentProvider.this.alreadyQueried.put(parent, placeholder);
                }

                @Override
                public void finishedFetchingDeferredChildren(Object parent, Object placeholder) {
                    DeferredQueryContentProvider.this.queryCompleted.add(parent);
                }
            });
        }
        this.alreadyQueried = new HashMap();
        this.queryCompleted = new HashSet();
        this.currentInput = newInput;
        for (IInputChangeListener listener : this.listeners) {
            listener.inputChanged(v, oldInput, newInput);
        }
    }

    @Override
    public Object[] getElements(Object input) {
        if (input instanceof QueriedElement) {
            return this.getChildren(input);
        }
        return super.getElements(input);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.manager != null) {
            this.manager.cancel(this.currentInput);
        }
    }

    @Override
    public boolean hasChildren(Object element) {
        if (this.manager != null && this.manager.isDeferredAdapter(element)) {
            return this.manager.mayHaveChildren(element);
        }
        return super.hasChildren(element);
    }

    @Override
    public Object[] getChildren(Object parent) {
        if (parent instanceof RemoteQueriedElement) {
            RemoteQueriedElement element = (RemoteQueriedElement)parent;
            if (this.manager != null && !this.synchronous && (element instanceof MetadataRepositoryElement || element instanceof MetadataRepositories)) {
                if (element.getCachedChildren().length == 0) {
                    return this.manager.getChildren(element);
                }
                return element.getChildren(element);
            }
            if (element.hasQueryable()) {
                return element.getChildren(element);
            }
        }
        return super.getChildren(parent);
    }

    public void setSynchronous(boolean sync) {
        if (sync && this.manager != null) {
            this.manager.cancel(this.currentInput);
        }
        this.synchronous = sync;
    }

    public boolean getSynchronous() {
        return this.synchronous;
    }
}

