/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader.sources;

import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import org.eclipse.osgi.internal.loader.BundleLoader;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.internal.loader.sources.PackageSource;

public class SingleSourcePackage
extends PackageSource {
    private final BundleLoader supplier;

    public SingleSourcePackage(String id, BundleLoader supplier) {
        super(id);
        this.supplier = supplier;
    }

    @Override
    public SingleSourcePackage[] getSuppliers() {
        return new SingleSourcePackage[]{this};
    }

    public BundleLoader getLoader() {
        return this.supplier;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.supplier.findLocalClass(name);
    }

    @Override
    public URL getResource(String name) {
        return this.supplier.findLocalResource(name);
    }

    @Override
    public Enumeration<URL> getResources(String name) {
        return this.supplier.findLocalResources(name);
    }

    public boolean equals(Object source) {
        if (this == source) {
            return true;
        }
        if (!(source instanceof SingleSourcePackage)) {
            return false;
        }
        SingleSourcePackage singleSource = (SingleSourcePackage)source;
        return this.supplier == singleSource.supplier && this.id == singleSource.getId();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.supplier.hashCode();
        return result;
    }

    @Override
    public Collection<String> listResources(String path, String filePattern) {
        ModuleClassLoader mcl = this.supplier.getModuleClassLoader();
        return mcl.listLocalResources(path, filePattern, 0);
    }
}

